/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.eb;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.util.QFBuilder;

public class EBDimensionHelper {
    public static DimMemberInfo findMemberByNumber(Long modelId, String dimNumber, String memberNumber) {
        DimMemberInfo memberInfo = null;
        List<DimensionInfo> allDim = new ModelStrategyEx(modelId, DisModelTypeEnum.EB.getType()).getDim().getDimList(false);
        DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(allDim, dimNumber);
        if (dimensionInfo == null) {
            return memberInfo;
        }
        DynamicObject memberDy = EBDimensionHelper.getDimMemberByNumber(modelId, dimensionInfo.getEntityName(), memberNumber);
        if (memberDy == null) {
            return memberInfo;
        }
        memberInfo = new DimMemberInfo();
        memberInfo.setId(memberDy.getLong("id"));
        memberInfo.setNumber(memberDy.getString("number"));
        memberInfo.setName(memberDy.getString("name"));
        return memberInfo;
    }

    public static DimMemberInfo getDimMemberById(Long modelId, String entityNumber, Long memberId) {
        String selectFields = "id,number,name";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fnumber = new QFilter("id", "=", (Object)memberId);
        QFilter[] filters = new QFilter[]{fmodelid, fnumber};
        DynamicObject memberDy = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)selectFields, (QFilter[])filters);
        DimMemberInfo memberInfo = new DimMemberInfo();
        memberInfo.setId(memberDy.getLong("id"));
        memberInfo.setNumber(memberDy.getString("number"));
        memberInfo.setName(memberDy.getString("name"));
        return memberInfo;
    }

    public static DynamicObject getDimMemberByNumber(Long modelId, String entity, String number) {
        String selectFields = "id,number,name";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter fnumber = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{fmodelid, fnumber};
        DynamicObject member = BusinessDataServiceHelper.loadSingle((String)entity, (String)selectFields, (QFilter[])filters);
        return member;
    }

    public static Map<Integer, String> getDimSortKey(Long modelId) {
        String entityName = "epm_dimension";
        QFilter dimFilter = new QFilter("model", "=", (Object)modelId);
        String selectField = "dseq,number";
        DynamicObjectCollection dimDseq = QueryServiceHelper.query((String)entityName, (String)selectField, (QFilter[])new QFilter[]{dimFilter}, (String)"dseq");
        LinkedHashMap<Integer, String> dimNumberSortByDseq = new LinkedHashMap<Integer, String>(16);
        for (DynamicObject dim : dimDseq) {
            if (!"Scenario".equals(dim.getString("number"))) continue;
            dimNumberSortByDseq.put(dim.getInt("dseq"), dim.getString("number"));
            break;
        }
        for (DynamicObject dim : dimDseq) {
            if ("Scenario".equals(dim.getString("number"))) continue;
            dimNumberSortByDseq.put(dim.getInt("dseq"), dim.getString("number"));
        }
        return dimNumberSortByDseq;
    }

    public static DynamicObject getEbDimInfoByModelIdAndDimId(long modelId, long dimId, String dataSet) {
        return (DynamicObject)ThreadCache.get((Object)(CacheKey.PrefixString + "getEbDimInfoByModelIdAndDimId" + modelId + dimId + dataSet), () -> {
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)modelId);
            builder.add("number", "=", (Object)dataSet);
            builder.add("entryentity.datasetdim.id", "=", (Object)dimId);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"entryentity.datasetdim.id as id,entryentity.datasetdim.number as number,entryentity.datasetdim.name as name,entryentity.datasetdim.membermodel as membermodel,entryentity.datasetdim.shortnumber as shortnumber", (QFilter[])builder.toArray());
            builder = new QFBuilder();
            builder.add("model", "=", (Object)modelId);
            builder.add("id", "=", (Object)dimId);
            if (Objects.isNull(dynamicObject)) {
                dynamicObject = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id,number,name,membermodel,shortnumber", (QFilter[])builder.toArray());
            }
            return dynamicObject;
        });
    }

    public static Map<String, DynamicObject> getBudgetDyoByModelId(long modelId, String dataSet, String shortNumber) {
        return (Map)ThreadCache.get((Object)(CacheKey.PrefixString + "getBudgetDyoByModelId" + modelId + dataSet + shortNumber), () -> {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)modelId);
            builder.add("number", "=", (Object)dataSet);
            if (!StringUtils.isBlank((String)shortNumber)) {
                builder.add("entryentity.datasetdim.shortnumber", "=", (Object)shortNumber);
            }
            QueryServiceHelper.query((String)"eb_dataset", (String)"entryentity.datasetdim.id as id,entryentity.datasetdim.number as number,entryentity.datasetdim.name as name,entryentity.datasetdim.membermodel as membermodel,entryentity.datasetdim.issysdimension as issysdimension,entryentity.datasetdim.shortnumber as shortnumber,entryentity.datasetdim.dseq as dseq", (QFilter[])builder.toArray(), (String)"entryentity.datasetdim.dseq").forEach(e -> map.put(e.getString("number"), e));
            builder = new QFBuilder();
            builder.add("model", "=", (Object)modelId);
            if (!StringUtils.isBlank((String)shortNumber)) {
                builder.add("shortnumber", "=", (Object)shortNumber);
            } else {
                builder.add("shortnumber", "=", (Object)"A");
            }
            QueryServiceHelper.query((String)"epm_dimension", (String)"id,number,name,membermodel,issysdimension,shortnumber,dseq", (QFilter[])builder.toArray(), (String)"dseq").forEach(e -> map.put(e.getString("number"), e));
            Map sortedMap = map.entrySet().stream().sorted(Comparator.comparing(e -> ((DynamicObject)e.getValue()).get("dseq").toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
            return sortedMap;
        });
    }
}

