/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.eb;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.eb.dto.EbBatchMember;
import kd.epm.far.business.eb.dto.EbDataset;
import kd.epm.far.business.eb.dto.EbDim;
import kd.epm.far.business.eb.dto.EbMember;
import kd.epm.far.business.eb.dto.EbRptSectionExecMsResult;
import kd.epm.far.business.eb.dto.EbRptSectionExecParam;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.apache.commons.lang.StringUtils;

public class EbServiceHelper {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, EbServiceHelper.class);
    private static final String GET_EB_DATASET_CACHE_KEY = "get_eb_dataset_cache_key";
    private static final String GET_EB_DIM_CACHE_KEY = "get_eb_dim_cache_key";
    private static final String GET_EB_MEMBER_CACHE_KEY = "get_eb_member_cache_key";
    private static final String GET_EB_BATCH_MEMBER_CACHE_KEY = "get_eb_batch_member_cache_key";
    private static final String GEET_EB_MODEL = "get_eb_model";

    public static List<EbDataset> getDataset(String modelNum) {
        return (List)ThreadCache.get((Object)(CacheKey.PrefixString + GET_EB_DATASET_CACHE_KEY + modelNum), () -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("modelNumber", modelNum);
            try {
                Object returnValue = DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"DataSetService", (String)"query", (Object[])new Object[]{map});
                return (List)JSON.parseObject((String)JSON.toJSONString((Object)returnValue), (TypeReference)new TypeReference<List<EbDataset>>(){}, (Feature[])new Feature[0]);
            }
            catch (KDBizException e) {
                throw new KDBizException(e.getMessage());
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9884\u7b97\u6570\u636e\u96c6\u5f02\u5e38", (String)"EbServiceHelper_01", (String)"epm-far-business", (Object[])new Object[0]));
            }
        });
    }

    public static List<EbDim> getDim(Long modelId, String datasetNum) {
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
        if (Objects.isNull(model)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9884\u7b97\u7ef4\u5ea6\u5f02\u5e38", (String)"EbServiceHelper_02", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return EbServiceHelper.getDim(model.getString("shownumber"), datasetNum);
    }

    public static List<EbDim> getDim(String modelNum, String datasetNum) {
        return (List)ThreadCache.get((Object)(CacheKey.PrefixString + GET_EB_DIM_CACHE_KEY + modelNum + datasetNum), () -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("modelNumber", modelNum);
            map.put("datasetNumber", datasetNum);
            try {
                Object returnValue = DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"DimensionService", (String)"query", (Object[])new Object[]{map});
                return (List)JSON.parseObject((String)JSON.toJSONString((Object)returnValue), (TypeReference)new TypeReference<List<EbDim>>(){}, (Feature[])new Feature[0]);
            }
            catch (KDBizException e) {
                throw new KDBizException(e.getMessage());
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9884\u7b97\u7ef4\u5ea6\u5f02\u5e38", (String)"EbServiceHelper_02", (String)"epm-far-business", (Object[])new Object[0]));
            }
        });
    }

    public static List<EbMember> getMember(String modelNum, String datasetNum, String dimNum, String memberNumber, RangeEnum rangeEnum) {
        return (List)ThreadCache.get((Object)(CacheKey.PrefixString + GET_EB_MEMBER_CACHE_KEY + modelNum + datasetNum + dimNum + memberNumber + rangeEnum.getValue()), () -> {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("modelNumber", modelNum);
            map.put("datasetNumber", datasetNum);
            if (!Objects.equals(datasetNum, memberNumber)) {
                map.put("memberNumber", memberNumber);
            }
            map.put("dimNumber", dimNum);
            map.put("range", rangeEnum.getValue());
            try {
                Object returnValue = DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberService", (String)"queryByDataset", (Object[])new Object[]{map});
                return (List)JSON.parseObject((String)JSON.toJSONString((Object)returnValue), (TypeReference)new TypeReference<List<EbMember>>(){}, (Feature[])new Feature[0]);
            }
            catch (KDBizException e) {
                throw new KDBizException(e.getMessage());
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9884\u7b97\u7ef4\u5ea6\u6210\u5458\u5f02\u5e38", (String)"EbServiceHelper_03", (String)"epm-far-business", (Object[])new Object[0]));
            }
        });
    }

    public static String stringToMD5(String plainText) {
        byte[] secretBytes;
        try {
            secretBytes = MessageDigest.getInstance("md5").digest(plainText.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8fd9\u4e2amd5\u7b97\u6cd5\u3002", (String)"StringUtilst_0", (String)"fi-bcm-common", (Object[])new Object[0]));
        }
        StringBuilder md5code = new StringBuilder(new BigInteger(1, secretBytes).toString(16));
        for (int i = 0; i < 32 - md5code.length(); ++i) {
            md5code.insert(0, "0");
        }
        return md5code.toString();
    }

    public static EbBatchMember batchGetMembers(String modelNum, String datasetNum, List<Map<String, String>> members) {
        StringBuilder sb = new StringBuilder();
        sb.append(GET_EB_BATCH_MEMBER_CACHE_KEY).append("#").append(modelNum).append("#").append(datasetNum).append("#");
        members.forEach(memberMap -> sb.append((String)memberMap.get("dimNumber")).append((String)memberMap.get("memberNumber")).append((String)memberMap.get("range")).append("#"));
        String md5Key = EbServiceHelper.stringToMD5(sb.toString());
        return (EbBatchMember)ThreadCache.get((Object)(CacheKey.PrefixString + md5Key), () -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("modelNumber", modelNum);
            params.put("datasetNumber", datasetNum);
            params.put("isCheckMain", "1");
            params.put("isShortNumber", "1");
            params.put("isToMainMessage", "1");
            params.put("members", members);
            try {
                Object returnValue = DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberService", (String)"batchQueryByDataset", (Object[])new Object[]{params});
                EbBatchMember ebBatchMember = (EbBatchMember)JSON.parseObject((String)JSON.toJSONString((Object)returnValue), (TypeReference)new TypeReference<EbBatchMember>(){}, (Feature[])new Feature[0]);
                if (StringUtils.isNotBlank((String)ebBatchMember.getMessage())) {
                    throw new KDBizException(ebBatchMember.getMessage());
                }
                return ebBatchMember;
            }
            catch (KDBizException e) {
                throw new KDBizException(e.getMessage());
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6821\u9a8c\u9884\u7b97\u7ef4\u5ea6\u6210\u5458\u5f02\u5e38", (String)"EbServiceHelper_05", (String)"epm-far-business", (Object[])new Object[0]));
            }
        });
    }

    public static Object getReslut(String modelNumber, String dataSetNumber, Map<String, List<String>> dimMemberMap) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelNumber", modelNumber);
        params.put("datasetNumber", dataSetNumber);
        params.put("data", dimMemberMap);
        try {
            Object o = DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"ShrekService", (String)"queryData", (Object[])new Object[]{params});
            log.info("eb dataset result: " + JSON.toJSONString((Object)o));
            return o;
        }
        catch (KDBizException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (Exception e) {
            log.error("eb dataset result: " + e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9884\u7b97\u6570\u636e\u7ed3\u679c\u5f02\u5e38", (String)"EbServiceHelper_04", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static EbRptSectionExecMsResult execRptSection(EbRptSectionExecParam execParam) {
        try {
            Object result = DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"RptSectionService", (String)"execRptSection", (Object[])new Object[]{SerializationUtils.toJsonString((Object)execParam)});
            log.error("eb execRptSection result: " + result == null ? "" : result.toString());
            if (result == null) {
                return null;
            }
            return (EbRptSectionExecMsResult)SerializationUtils.fromJsonString((String)result.toString(), EbRptSectionExecMsResult.class);
        }
        catch (KDBizException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (Exception e) {
            log.error("eb execRptSection result: " + e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9884\u7b97\u62a5\u8868\u5207\u7247\u8ba1\u7b97\u7ed3\u679c\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"EbServiceHelper_07", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static String getRefDimParams(List<Long> rptSectionIds) {
        try {
            Object result = DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"RptSectionService", (String)"getRefDimParams", (Object[])new Object[]{rptSectionIds});
            log.error("eb execRptSection result: " + result == null ? "" : result.toString());
            if (result == null) {
                return null;
            }
            return result.toString();
        }
        catch (KDBizException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (Exception e) {
            log.error("eb getRefDimParams result: " + e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9884\u7b97\u62a5\u8868\u5207\u7247\u7ef4\u5ea6\u76f8\u5173\u4fe1\u606f\u5931\u8d25\u3002", (String)"EbServiceHelper_08", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static DynamicObject getModel(Long modelId) {
        return (DynamicObject)ThreadCache.get((Object)(CacheKey.PrefixString + GEET_EB_MODEL + modelId), () -> {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
            if (Objects.isNull(dynamicObject)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7b97\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"EbServiceHelper_09", (String)"epm-far-business", (Object[])new Object[0]));
            }
            return dynamicObject;
        });
    }
}

