/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epm;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.mservice.EPDMDataRequest;
import kd.epm.epbs.business.mservice.EPDMDataResponse;
import kd.epm.epbs.business.mservice.EPDMFilter;
import kd.epm.far.business.common.dataset.dto.DatasetFilterVo;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.epm.dto.EPMVoucherFieldVo;
import kd.epm.far.business.epm.dto.EPMVoucherQueryVo;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class EPMServiceHelper {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, EbServiceHelper.class);
    private static final int SUCCESS_CODE = 200;

    public static List<Map<String, Object>> queryResult(String number, List<DatasetPropertyVo> properties) {
        try {
            EPMVoucherQueryVo queryResult = EPMServiceHelper.getQueryId(number, properties);
            Long queryId = queryResult.getQueryId();
            EPDMDataResponse response = EPMServiceHelper.queryData(queryId);
            if (Objects.isNull(response)) {
                return Collections.emptyList();
            }
            EPDMDataResponse.Pager pager = response.getPager();
            if (Objects.isNull(pager)) {
                return EPMServiceHelper.returnData(response);
            }
            if (pager.getPage() == pager.getLast()) {
                return EPMServiceHelper.returnData(response);
            }
            ArrayList returnList = Lists.newArrayListWithExpectedSize((int)pager.getTotal());
            returnList.addAll((Collection)response.getData());
            for (int i = pager.getPage() + 1; i <= pager.getLast(); ++i) {
                response = (EPDMDataResponse)DispatchServiceHelper.invokeBizService((String)"epm", (String)"epdm", (String)"DataModelService", (String)"queryData", (Object[])new Object[]{queryId});
                if (Objects.isNull(response)) {
                    return returnList;
                }
                if (!Objects.nonNull(response.getData())) {
                    log.error(response.getMessage());
                    log.error("epm curPage:" + i);
                    return returnList;
                }
                returnList.addAll((Collection)response.getData());
            }
            return returnList;
        }
        catch (KDBizException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (Throwable e) {
            log.error("epm getResult error: " + e.getMessage());
            log.error(e.getMessage(), e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u51ed\u8bc1\u6c60\u6570\u636e\u5f02\u5e38\u3002", (String)"EpmServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    private static List<Map<String, Object>> returnData(EPDMDataResponse<List<Map<String, Object>>> response) {
        if (Objects.nonNull(response.getData())) {
            return (List)response.getData();
        }
        return Collections.emptyList();
    }

    private static EPMVoucherQueryVo getQueryId(String number, List<DatasetPropertyVo> properties) {
        int size = 1000;
        String paramJson = "";
        try {
            ArrayList filterVos = Lists.newArrayListWithExpectedSize((int)16);
            ArrayList selectFields = Lists.newArrayListWithExpectedSize((int)properties.size());
            for (DatasetPropertyVo property : properties) {
                String field = property.getNumber();
                selectFields.add(field);
                if (!CollectionUtils.isNotEmpty(property.getFilters())) continue;
                EPDMFilter filterVo = new EPDMFilter();
                for (int i = 0; i < property.getFilters().size(); ++i) {
                    DatasetFilterVo vo = property.getFilters().get(i);
                    if (i == 0) {
                        filterVo.setField(field);
                        filterVo.setQcp(vo.getCondition());
                        if (StringUtils.equals((String)"in", (String)filterVo.getQcp())) {
                            filterVo.setValue((Object)vo.getValue().replace(";", ","));
                            continue;
                        }
                        filterVo.setValue((Object)property.getFilters().get(i).getValue());
                        continue;
                    }
                    EPDMFilter orFilterVo = new EPDMFilter();
                    orFilterVo.setField(field);
                    orFilterVo.setQcp(vo.getCondition());
                    if (StringUtils.equals((String)"in", (String)filterVo.getQcp())) {
                        orFilterVo.setValue((Object)vo.getValue().replace(";", ","));
                    } else {
                        orFilterVo.setValue((Object)property.getFilters().get(i).getValue());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)filterVo.getOr())) {
                        filterVo.getOr().add(orFilterVo);
                        continue;
                    }
                    filterVo.setOr((List)Lists.newArrayList((Object[])new EPDMFilter[]{orFilterVo}));
                }
                filterVos.add(filterVo);
            }
            EPDMDataRequest request = new EPDMDataRequest();
            request.setModel(number);
            request.setSize(size);
            request.setApp("far");
            request.setSelectFields((List)selectFields);
            request.setFilters((List)filterVos);
            paramJson = JSON.toJSONString((Object)request);
            EPDMDataResponse result = (EPDMDataResponse)DispatchServiceHelper.invokeBizService((String)"epm", (String)"epdm", (String)"DataModelService", (String)"getQueryId", (Object[])new Object[]{request});
            if (Objects.isNull(result)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u63a5\u53e3,\u672a\u83b7\u53d6\u5230\u7ed3\u679c\u3002", (String)"EpmServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]), "getQueryId"));
            }
            if (!Objects.equals(200, result.getCode())) {
                throw new KDBizException(result.getMessage());
            }
            EPMVoucherQueryVo returnVo = new EPMVoucherQueryVo();
            returnVo.setQueryId(LongUtil.toLong(((Map)result.getData()).get("qid")));
            return returnVo;
        }
        catch (KDBizException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (Throwable e) {
            log.error("epm getQueryId error: " + paramJson);
            log.error(e.getMessage(), e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u51ed\u8bc1\u6c60\u67e5\u8be2ID\u5f02\u5e38\u3002", (String)"EpmServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    private static EPDMDataResponse<List<Map<String, Object>>> queryData(Long queryId) {
        try {
            EPDMDataResponse result = (EPDMDataResponse)DispatchServiceHelper.invokeBizService((String)"epm", (String)"epdm", (String)"DataModelService", (String)"queryData", (Object[])new Object[]{queryId});
            if (Objects.isNull(result)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u63a5\u53e3,\u672a\u83b7\u53d6\u5230\u7ed3\u679c\u3002", (String)"EpmServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]), "queryData"));
            }
            if (!Objects.equals(200, result.getCode())) {
                throw new KDBizException(result.getMessage());
            }
            List datas = (List)result.getData();
            if (CollectionUtils.isEmpty((Collection)datas)) {
                return null;
            }
            if (Objects.isNull(result.getPager())) {
                return result;
            }
            return result;
        }
        catch (Throwable e) {
            log.error("epm queryData error: " + queryId);
            log.error(e.getMessage(), e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u51ed\u8bc1\u6c60\u6570\u636e\u5f02\u5e38\u3002", (String)"EpmServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static List<EPMVoucherFieldVo> getField(Long id) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("id", id.toString());
        try {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epdm_dm", (String)"number,type.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (Objects.isNull(dynamicObject)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u63a5\u53e3,\u672a\u83b7\u53d6\u5230\u7ed3\u679c\u3002", (String)"EpmServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]), "query_epdm_dm" + id));
            }
            params.put("number", dynamicObject.getString("number"));
            params.put("type", dynamicObject.getString("type.number"));
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"epm", (String)"epdm", (String)"DataModelService", (String)"query", (Object[])new Object[]{params});
            if (Objects.isNull(result)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u63a5\u53e3,\u672a\u83b7\u53d6\u5230\u7ed3\u679c\u3002", (String)"EpmServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]), "query"));
            }
            if (Objects.isNull(result.get("details"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u63a5\u53e3,\u672a\u83b7\u53d6\u5230\u7ed3\u679c\u3002", (String)"EpmServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]), "query"));
            }
            List details = (List)result.get("details");
            ArrayList returnList = Lists.newArrayListWithExpectedSize((int)details.size());
            for (Map detail : details) {
                EPMVoucherFieldVo EPMVoucherFieldVo2 = new EPMVoucherFieldVo();
                EPMVoucherFieldVo2.setNumber(detail.get("field").toString());
                EPMVoucherFieldVo2.setName(detail.get("label").toString());
                EPMVoucherFieldVo2.setType(detail.get("data_type").toString());
                returnList.add(EPMVoucherFieldVo2);
            }
            return returnList;
        }
        catch (KDBizException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (Throwable e) {
            log.error("epm getField error: " + id);
            log.error(e.getMessage(), e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u51ed\u8bc1\u6c60\u6a21\u578b\u5b57\u6bb5\u5f02\u5e38\u3002", (String)"EpmServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }
}

