/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.org.model.EnableEnum;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ChapterComeFromEnum;
import kd.epm.far.business.common.enums.ChapterCommitStatusEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.util.FarNumberRule;
import kd.epm.far.business.common.util.PlatUtil;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.epmclient.EpmModuleServiceHelper;
import kd.epm.far.business.epmclient.dto.EpmApiOutput;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.chapter.ChapterServiceHelper;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.chapter.DisclosureCopyHelper;
import kd.epm.far.business.fidm.design.preview.DisclosurePreviewHelper;
import kd.epm.far.business.fidm.design.preview.DisclosurePreviewSelectHelper;
import kd.epm.far.business.fidm.report.DisclosureGenerateModuleHelper;
import kd.epm.far.business.fidm.report.dto.GenerateInputFormular;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class EpmChapterServiceHelper {
    private static final String FIELD_MODEL = "model";
    private static final String FIELD_SEQUENCE = "sequence";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_ENTRYENTITY = "entryentity";
    private static final String FIELD_ENABLE = "enable";
    private static final String FIELD_COMMITSTATUS = "commitstatus";
    private static final String FIELD_PERMCLASS = "permclass";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_MODIFYTIME = "modifytime";
    private static final String FIELD_MODIFIER = "modifier";
    private static final String FIELD_TEMPLATE = "template";
    private static final String FIELD_URL = "url";
    private static final String FIELD_PREVIEWURL = "previewurl";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_GROUP = "group";
    private static final String FIELD_CREATOR = "creator";
    private static final String FIELD_CREATETIME = "createtime";
    private static final String FIELD_MASTERID = "masterid";
    private static final String FIELD_SAVEWORDTYPE = "savewordtype";
    private static final String FIELD_COMEFROM = "comefrom";

    private EpmChapterServiceHelper() {
    }

    public static void saveTemplateChapterDoc(long modelId, long templateId, DynamicObject chapter, String moduleJson, String docBytes) {
        JSONArray itemList = JSON.parseArray((String)moduleJson);
        DynamicObjectCollection chapterModules = chapter.getDynamicObjectCollection(FIELD_ENTRYENTITY);
        List oldModuleIds = chapterModules.stream().map(e -> e.getLong("module.id")).filter(e -> !e.equals(0L)).distinct().collect(Collectors.toList());
        int seq = 1;
        chapterModules.clear();
        ArrayList<DynamicObject> modules = new ArrayList<DynamicObject>(itemList.size());
        for (Object item : itemList) {
            JSONObject itemObject = (JSONObject)item;
            DynamicObject module = EpmModuleServiceHelper.createModule(modelId, templateId, GlobalIdUtil.genGlobalLongId(), itemObject);
            modules.add(module);
            String key = DisclosureJsonHelper.getValue(itemObject, "Key", "");
            DynamicObject dyn = new DynamicObject(chapterModules.getDynamicObjectType());
            dyn.set("module", (Object)module.getLong("id"));
            dyn.set("key", (Object)key);
            dyn.set("seq", (Object)seq++);
            dyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            chapterModules.add((Object)dyn);
        }
        String url = DisclosureFileHelper.upload("fidm_webdesign", chapter.getLong("id"), chapter.getString(FIELD_NAME), docBytes);
        chapter.set(FIELD_URL, (Object)url);
        chapter.set(FIELD_SAVEWORDTYPE, (Object)OpenWordEnum.EPMCLIENT.getTypeToInt());
        chapter.set(FIELD_COMEFROM, (Object)OpenWordEnum.getComefromByType(OpenWordEnum.EPMCLIENT.getType()).getType());
        chapter.set(FIELD_MODIFYTIME, (Object)TimeServiceHelper.now());
        PlatUtil.executeWithTXNew(tx -> {
            if (!oldModuleIds.isEmpty()) {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
                qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
                qFilters.add(new QFilter(FIELD_TEMPLATE, "=", (Object)templateId));
                qFilters.add(new QFilter("id", "in", (Object)oldModuleIds));
                DeleteServiceHelper.delete((String)"fidm_modulerepository", (QFilter[])qFilters.toArray(new QFilter[0]));
            }
            SaveServiceHelper.save((DynamicObject[])modules.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
            DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)chapter.getLong("template.id"), (String)"fidm_template");
            template.set(FIELD_MODIFYTIME, (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{template});
        });
    }

    public static EpmApiOutput copyChapter(long modelId, long templateId, long chapterId) {
        Date now = TimeServiceHelper.now();
        long userId = RequestContext.get().getCurrUserId();
        if (!ChapterServiceHelper.hasWritePermissionForTempalte(modelId, chapterId)) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterServiceHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter(FIELD_TEMPLATE, "=", (Object)templateId));
        qFilters.add(new QFilter("id", "=", (Object)chapterId));
        DynamicObject oldChapter = BusinessDataServiceHelper.loadSingle((String)"fidm_chapter", (QFilter[])qFilters.toArray(new QFilter[0]));
        Pair<String, String> pair = EpmChapterServiceHelper.getCopyChapterNumberName(modelId, templateId, oldChapter.getString(FIELD_NUMBER), oldChapter.getString(FIELD_NAME));
        if (((String)pair.p1).length() > 30) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u590d\u5236\u540e\u7684\u7ae0\u8282\u7f16\u7801\u957f\u5ea6\u8d85\u8fc7\u4e8630\u3002", (String)"ChapterServiceHelper_20", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (((String)pair.p2).length() > 50) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u590d\u5236\u540e\u7684\u7ae0\u8282\u540d\u79f0\u957f\u5ea6\u8d85\u8fc7\u4e8650\u3002", (String)"ChapterServiceHelper_21", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObject newChapter = EpmChapterServiceHelper.copyChapter(oldChapter, userId, now);
        newChapter.set(FIELD_NUMBER, pair.p1);
        newChapter.set(FIELD_NAME, pair.p2);
        newChapter.set(FIELD_SEQUENCE, (Object)EpmChapterServiceHelper.getMaxDesq(modelId, templateId));
        long newChapterId = newChapter.getLong("id");
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)userId);
        List<DynamicObject> saveNewModules = EpmModuleServiceHelper.copyModules(modelId, oldChapter, newChapter, null);
        EpmChapterServiceHelper.copyChapterFile(modelId, templateId, oldChapter, newChapter, null, null, false);
        PlatUtil.executeWithTXNew(tx -> {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newChapter});
            CloneUtils cloneUtils = new CloneUtils(true, true);
            DisclosureCopyHelper.copyVariable(cloneUtils, chapterId, newChapterId, user, now);
            DisclosureCopyHelper.copyDataSet(cloneUtils, chapterId, newChapterId, user, now);
            if (!saveNewModules.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])saveNewModules.toArray(new DynamicObject[0]));
            }
            PermissionHelper.savePermClassEntity(modelId, newChapterId, "fidm_chapter", newChapter.getLong(FIELD_PERMCLASS), OperationStatus.ADDNEW);
        });
        return new EpmApiOutput(newChapterId);
    }

    public static EpmApiOutput saveChapterByRepository(long modelId, long templateId, long chapterId, String number, String name, long permClassId, String description) {
        Date now = TimeServiceHelper.now();
        long userId = RequestContext.get().getCurrUserId();
        String reportPerm = PermClassEntityHelper.getSingleFIDMPermission("fidm_template", templateId, modelId, userId, "fidmmodel");
        if (!reportPerm.equals(DataTypeEnum.WRITEIN.getIndex())) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u6a21\u677f\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterServiceHelper_16", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String msg = EpmChapterServiceHelper.saveCheck(modelId, templateId, number, name, description);
        if (StringUtils.isNotEmpty((String)msg)) {
            return new EpmApiOutput(false, msg);
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter(FIELD_TEMPLATE, "=", (Object)0L));
        qFilters.add(new QFilter("id", "=", (Object)chapterId));
        DynamicObject oldChapter = BusinessDataServiceHelper.loadSingle((String)"fidm_chapter", (QFilter[])qFilters.toArray(new QFilter[0]));
        DynamicObject newChapter = EpmChapterServiceHelper.copyChapter(oldChapter, userId, now);
        newChapter.set(FIELD_TEMPLATE, (Object)templateId);
        newChapter.set(FIELD_NUMBER, (Object)number);
        newChapter.set(FIELD_NAME, (Object)name);
        newChapter.set(FIELD_PERMCLASS, (Object)permClassId);
        newChapter.set(FIELD_DESCRIPTION, (Object)description);
        newChapter.set(FIELD_SEQUENCE, (Object)EpmChapterServiceHelper.getMaxDesq(modelId, templateId));
        long newChapterId = newChapter.getLong("id");
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)userId);
        List<DynamicObject> saveNewModules = EpmModuleServiceHelper.copyModules(modelId, oldChapter, newChapter, null);
        EpmChapterServiceHelper.copyChapterFile(modelId, templateId, oldChapter, newChapter, null, null, false);
        PlatUtil.executeWithTXNew(tx -> {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newChapter});
            CloneUtils cloneUtils = new CloneUtils(true, true);
            DisclosureCopyHelper.copyVariable(cloneUtils, chapterId, newChapterId, user, now);
            DisclosureCopyHelper.copyDataSet(cloneUtils, chapterId, newChapterId, user, now);
            if (!saveNewModules.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])saveNewModules.toArray(new DynamicObject[0]));
            }
            PermissionHelper.savePermClassEntity(modelId, newChapterId, "fidm_chapter", newChapter.getLong(FIELD_PERMCLASS), OperationStatus.ADDNEW);
        });
        return new EpmApiOutput(newChapterId);
    }

    private static Pair<String, String> getCopyChapterNumberName(long modelId, long templateId, String number, String name) {
        String newNumber = number + "copy";
        String newName = name + "copy";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter(FIELD_TEMPLATE, "=", (Object)templateId));
        DynamicObjectCollection chapterRows = QueryServiceHelper.query((String)"fidm_chapter", (String)"number,name", (QFilter[])qFilters.toArray(new QFilter[0]));
        for (int i = 0; i < chapterRows.size(); ++i) {
            String finalNewNumber = newNumber;
            String finalNewName = newName;
            if (chapterRows.stream().anyMatch(chapter -> chapter.getString(FIELD_NUMBER).equals(finalNewNumber))) {
                newNumber = number + "copy" + StringUtils.getStringValue((Object)(i + 1));
            }
            if (!chapterRows.stream().anyMatch(chapter -> chapter.getString(FIELD_NAME).equals(finalNewName))) continue;
            newName = name + "copy(" + (i + 1) + ")";
        }
        return new Pair((Object)newNumber, (Object)newName);
    }

    public static Pair<String, String> getDefaultChapterNumberName(long modelId, long templateId) {
        String number = "ChapterNumber";
        String name = ResManager.loadKDString((String)"\u7ae0\u8282\u540d\u79f0", (String)"ChapterServiceHelper_0", (String)"epm-far-business", (Object[])new Object[0]);
        String newNumber = number;
        String newName = name;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter(FIELD_TEMPLATE, "=", (Object)templateId));
        DynamicObjectCollection chapterRows = QueryServiceHelper.query((String)"fidm_chapter", (String)"number,name", (QFilter[])qFilters.toArray(new QFilter[0]));
        for (int i = 0; i < chapterRows.size(); ++i) {
            String finalNewNumber = newNumber;
            String finalNewName = newName;
            if (chapterRows.stream().anyMatch(chapter -> chapter.getString(FIELD_NUMBER).equals(finalNewNumber))) {
                newNumber = number + StringUtils.getStringValue((Object)(i + 1));
            }
            if (!chapterRows.stream().anyMatch(chapter -> chapter.getString(FIELD_NAME).equals(finalNewName))) continue;
            newName = name + "copy(" + (i + 1) + ")";
        }
        return new Pair((Object)newNumber, (Object)newName);
    }

    private static int getMaxDesq(long modelId, long templateId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter(FIELD_TEMPLATE, "=", (Object)templateId));
        qFilters.add(new QFilter(FIELD_GROUP, "=", (Object)0L));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_chapter", (String)FIELD_SEQUENCE, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"sequence desc", (int)1);
        if (dys != null && !dys.isEmpty()) {
            return ((DynamicObject)dys.get(0)).getInt(FIELD_SEQUENCE) + 1;
        }
        return 1;
    }

    private static String saveCheck(long modelId, long templateId, String number, String name, String description) {
        if (StringUtils.isEmpty((String)number)) {
            return ResManager.loadKDString((String)"\u7ae0\u8282\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChapterServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)name)) {
            return ResManager.loadKDString((String)"\u7ae0\u8282\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChapterServiceHelper_8", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (EpmChapterServiceHelper.existsChapter(modelId, templateId, number)) {
            return ResManager.loadKDString((String)"\u7ae0\u8282\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"ChapterServiceHelper_6", (String)"epm-far-business", (Object[])new Object[0]);
        }
        ResultInfo resultInfo = FarNumberRule.checkChapterNumber(number);
        if (Boolean.FALSE.equals(resultInfo.isSuccess())) {
            return resultInfo.getMessage();
        }
        if (number.length() > 30) {
            return ResManager.loadKDString((String)"\u7ae0\u8282\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u3002", (String)"ChapterServiceHelper_18", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (name.length() > 50) {
            return ResManager.loadKDString((String)"\u7ae0\u8282\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"ChapterServiceHelper_19", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)description) && description.length() > 200) {
            return ResManager.loadKDString((String)"\u7ae0\u8282\u63cf\u8ff0\u8bf4\u660e\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7200\u3002", (String)"ChapterServiceHelper_22", (String)"epm-far-business", (Object[])new Object[0]);
        }
        return StringUtils.getEmpty();
    }

    private static boolean existsChapter(long modelId, long templateId, String number) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter(FIELD_TEMPLATE, "=", (Object)templateId));
        qFilters.add(new QFilter(FIELD_NUMBER, "=", (Object)number));
        if (templateId == 0L) {
            qFilters.add(new QFilter(FIELD_GROUP, ">", (Object)0));
        }
        return QueryServiceHelper.exists((String)"fidm_chapter", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public static DynamicObject copyChapter(DynamicObject oldChapter, long userId, Date now) {
        DynamicObject newChapter = BusinessDataServiceHelper.newDynamicObject((String)"fidm_chapter");
        long newChapterId = GlobalIdUtil.genGlobalLongId();
        newChapter.set("id", (Object)newChapterId);
        newChapter.set(FIELD_MASTERID, (Object)newChapterId);
        newChapter.set(FIELD_MODEL, (Object)oldChapter.getLong("model.id"));
        newChapter.set(FIELD_NUMBER, (Object)oldChapter.getString(FIELD_NUMBER));
        newChapter.set(FIELD_NAME, (Object)oldChapter.getString(FIELD_NAME));
        newChapter.set(FIELD_DESCRIPTION, (Object)oldChapter.getString(FIELD_DESCRIPTION));
        newChapter.set(FIELD_PERMCLASS, (Object)oldChapter.getLong(FIELD_PERMCLASS));
        newChapter.set(FIELD_SEQUENCE, (Object)oldChapter.getInt(FIELD_SEQUENCE));
        newChapter.set(FIELD_TEMPLATE, (Object)oldChapter.getLong("template.id"));
        newChapter.set(FIELD_URL, null);
        newChapter.set(FIELD_PREVIEWURL, null);
        newChapter.set(FIELD_GROUP, (Object)0L);
        newChapter.set(FIELD_CREATOR, (Object)userId);
        newChapter.set(FIELD_CREATETIME, (Object)now);
        newChapter.set(FIELD_MODIFIER, (Object)userId);
        newChapter.set(FIELD_MODIFYTIME, (Object)now);
        newChapter.set(FIELD_STATUS, (Object)StatusEnum.TempSave);
        newChapter.set(FIELD_ENABLE, (Object)EnableEnum.Enable);
        newChapter.set(FIELD_COMMITSTATUS, (Object)ChapterCommitStatusEnum.INIT.getType());
        newChapter.set("commitor", null);
        newChapter.set("committime", null);
        newChapter.set("sendbacker", null);
        newChapter.set("sendbacktime", null);
        newChapter.set(FIELD_SAVEWORDTYPE, (Object)OpenWordEnum.EPMCLIENT.getType());
        newChapter.set(FIELD_COMEFROM, (Object)ChapterComeFromEnum.EPMC.getType());
        return newChapter;
    }

    public static Map<String, Long> getChapterDefaultDimMembers(long modelId, long chapterId) {
        List<DimensionInfo> selectDims = DisclosureChapterHelper.getPreviewVars(modelId, chapterId);
        ArrayList<Long> chapterIds = new ArrayList<Long>(1);
        chapterIds.add(chapterId);
        List<DimensionInfo> dimensionInfos = DisclosurePreviewSelectHelper.getDefaultAndRecentMembers(modelId, chapterIds);
        if (dimensionInfos != null) {
            for (DimensionInfo dimensionInfo : dimensionInfos) {
                if (dimensionInfo.getMembers().isEmpty()) continue;
                selectDims.stream().filter(x -> x.getNumber().equalsIgnoreCase(dimensionInfo.getNumber())).findAny().ifPresent(find -> find.setMembers(dimensionInfo.getMembers()));
            }
        }
        HashMap<String, Long> dimMembers = new HashMap<String, Long>(selectDims.size());
        for (DimensionInfo dimensionInfo : selectDims) {
            if (dimensionInfo.getMembers().isEmpty()) continue;
            dimMembers.put(dimensionInfo.getNumber(), dimensionInfo.getMembers().get(0).getId());
        }
        return dimMembers;
    }

    public static void copyChapterFile(long modelId, long templateId, DynamicObject oldChapter, DynamicObject newChapter, GenerateInputFormular generateInputFormular, Map<String, Long> previewDimMemb, boolean isCreateReport) {
        long oldChapterId = oldChapter.getLong("id");
        long newChapterId = newChapter.getLong("id");
        if (OpenWordEnum.EPMCLIENT.getType().equals(oldChapter.getString(FIELD_SAVEWORDTYPE))) {
            String url = "";
            if (StringUtils.isNotEmpty((String)oldChapter.getString(FIELD_URL))) {
                try (InputStream inputStream = DisclosureFileHelper.getFileInputStream(oldChapter.getString(FIELD_URL), false);){
                    String fileName = isCreateReport ? newChapter.getString(FIELD_NAME) + "preivew" : newChapter.getString(FIELD_NAME);
                    url = DisclosureFileHelper.saveAsNew(inputStream, "fidm", "fidm_webdesign", newChapterId, fileName);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ResManager.loadKDString((String)"\u52a0\u8f7d\u6587\u4ef6\u5931\u8d25\u3002", (String)"ReportGenerateService_0", (String)"epm-far-business", (Object[])new Object[0]), ex);
                }
            }
            if (isCreateReport) {
                newChapter.set(FIELD_URL, (Object)"");
                newChapter.set(FIELD_PREVIEWURL, (Object)url);
            } else {
                newChapter.set(FIELD_URL, (Object)url);
            }
        } else {
            String url;
            Map<String, Long> dimMembers = EpmChapterServiceHelper.getChapterDefaultDimMembers(modelId, oldChapterId);
            if (null != previewDimMemb) {
                for (Map.Entry<String, Long> entry : previewDimMemb.entrySet()) {
                    dimMembers.put(entry.getKey(), entry.getValue());
                }
            }
            DynamicObject chapter = DisclosurePreviewHelper.getChapter(oldChapterId);
            List<JSONObject> moduleList = DisclosurePreviewHelper.getModuleList(modelId, chapter);
            if (null != generateInputFormular) {
                for (JSONObject module : moduleList) {
                    DisclosureGenerateModuleHelper.resetModuleProperty(generateInputFormular, module);
                }
            }
            if (StringUtils.isNotEmpty((String)(url = ChapterServiceHelper.getChapterPreviewFile(modelId, templateId, oldChapterId, moduleList, oldChapter.getString(FIELD_SAVEWORDTYPE), dimMembers, true)))) {
                try (InputStream inputStream = DisclosureFileHelper.getFileInputStream(url, true);){
                    String fileName = isCreateReport ? newChapter.getString(FIELD_NAME) + "preivew" : newChapter.getString(FIELD_NAME);
                    url = DisclosureFileHelper.saveAsNew(inputStream, "fidm", "fidm_webdesign", newChapterId, fileName);
                    if (isCreateReport) {
                        newChapter.set(FIELD_URL, (Object)"");
                        newChapter.set(FIELD_PREVIEWURL, (Object)url);
                    } else {
                        newChapter.set(FIELD_URL, (Object)url);
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ResManager.loadKDString((String)"\u52a0\u8f7d\u6587\u4ef6\u5931\u8d25\u3002", (String)"ReportGenerateService_0", (String)"epm-far-business", (Object[])new Object[0]), ex);
                }
            }
        }
    }
}

