/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.dto.DataSet;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.module.dto.Module;
import kd.epm.far.business.common.variable.dto.Variable;
import kd.epm.far.business.epmclient.EpmTemplateServiceHelper;
import kd.epm.far.business.epmclient.dto.Report;
import kd.epm.far.business.fidm.chapter.dto.Chapter;
import kd.epm.far.business.fidm.chapter.dto.ChapterCatalog;
import kd.epm.far.business.fidm.report.DisclosureReportHelper;
import kd.epm.far.business.fidm.template.TemplateCatalogHelper;
import kd.epm.far.business.fidm.template.dto.TempCatalog;
import kd.epm.far.business.fidm.template.dto.Template;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;

public class EpmClientLogHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(EpmClientLogHelper.class);
    private static final String ClientAppId = "epmc";
    private static final String FIELD_MODEL = "model";

    public static void writeDataSetsById(OperationResult result, OperationName operationName, Long modelId, List<Long> dataSetIds) {
        try {
            List<DataSet> dataSets = DatasetServiceHelper.getDataSets(modelId, dataSetIds);
            if (dataSets.isEmpty()) {
                return;
            }
            EpmClientLogHelper.writeDataSets(result, operationName, modelId, dataSets);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeDataSets(OperationResult result, OperationName operationName, Long modelId, List<DataSet> dataSets) {
        try {
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            ArrayList formatParamsList = Lists.newArrayListWithCapacity((int)1);
            for (DataSet dataSet : dataSets) {
                formatParamsList.add(new Object[]{modelInfo.getNumber(), dataSet.getNumber()});
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.DATASET).buildOpName(operationName).buildFormNumber("fidm_dataset").buildAppId(AppMetadataCache.getAppInfo((String)ClientAppId).getId()).buildFormatParamsList((List)formatParamsList).buildOpResult(result);
            AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeTemplatesById(OperationResult result, OperationName operationName, Long modelId, List<Long> templateIds) {
        try {
            List<Template> templates = EpmTemplateServiceHelper.getTemplates(modelId, templateIds, 0L);
            if (templates.size() == 0) {
                return;
            }
            EpmClientLogHelper.writeTemplates(result, operationName, modelId, templates);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeTemplates(OperationResult result, OperationName operationName, Long modelId, List<Template> templates) {
        try {
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            ArrayList formatParamsList = Lists.newArrayListWithCapacity((int)1);
            for (Template template : templates) {
                formatParamsList.add(new Object[]{modelInfo.getNumber(), template.getNumber()});
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.TEMPLATE).buildOpName(operationName).buildFormNumber("fidm_template").buildAppId(AppMetadataCache.getAppInfo((String)ClientAppId).getId()).buildFormatParamsList((List)formatParamsList).buildOpResult(result);
            AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeTemplateCatlogs(OperationResult result, OperationName operationName, Long modelId, List<TempCatalog> templateCatalos) {
        try {
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            ArrayList formatParamsList = Lists.newArrayListWithCapacity((int)1);
            for (TempCatalog catalog : templateCatalos) {
                formatParamsList.add(new Object[]{modelInfo.getNumber(), catalog.getNumber()});
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.TEMPLATE).buildOpName(operationName).buildFormNumber("fidm_tmplcatalog").buildAppId(AppMetadataCache.getAppInfo((String)ClientAppId).getId()).buildFormatParamsList((List)formatParamsList).buildOpResult(result);
            AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeTemplateCatlogsById(OperationResult result, OperationName operationName, Long modelId, List<Long> ids) {
        try {
            List<TempCatalog> catalogs = TemplateCatalogHelper.getCatalogs(modelId, ids, false);
            if (catalogs.isEmpty()) {
                return;
            }
            EpmClientLogHelper.writeTemplateCatlogs(result, operationName, modelId, catalogs);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeCreateReport(OperationResult result, long modelId, String templateNumber, String yearNumber, String periodNumber, String entityNumber, String rptName) {
        try {
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            ArrayList formatParamsList = Lists.newArrayListWithCapacity((int)1);
            formatParamsList.add(new Object[]{modelInfo.getNumber(), templateNumber, yearNumber, periodNumber, entityNumber, TypeUtils.toPinYinString(rptName)});
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.TEMPLATE).buildOpName(OperationName.GENERALMYREPORT).buildFormNumber("fidm_template").buildAppId(AppMetadataCache.getAppInfo((String)ClientAppId).getId()).buildFormatParamsList((List)formatParamsList).buildOpResult(result);
            AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeChapters(OperationResult result, OperationName operationName, boolean isReport, Long modelId, List<Chapter> chapters) {
        try {
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            ArrayList formatParamsList = Lists.newArrayListWithCapacity((int)1);
            for (Chapter chapter : chapters) {
                DynamicObject template;
                String rptOrTempName = "";
                String rptOrTempNumber = "";
                if (isReport) {
                    DynamicObject report;
                    if (chapter.getReportId() != 0L && null != (report = BusinessDataServiceHelper.loadSingle((Object)chapter.getReportId(), (String)"fidm_report"))) {
                        rptOrTempNumber = report.getString("number");
                    }
                } else if (chapter.getTemplateId() != 0L && null != (template = BusinessDataServiceHelper.loadSingle((Object)chapter.getTemplateId(), (String)"fidm_template"))) {
                    rptOrTempNumber = template.getString("number");
                }
                formatParamsList.add(new Object[]{modelInfo.getNumber(), rptOrTempNumber, chapter.getNumber()});
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(isReport ? OperationCategory.REPORT : OperationCategory.TEMPLATECHAPTER).buildOpName(operationName).buildFormNumber(isReport ? "fidm_webreport_edit" : "fidm_chapter").buildAppId(AppMetadataCache.getAppInfo((String)ClientAppId).getId()).buildFormatParamsList((List)formatParamsList).buildOpResult(result);
            AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeChaptersById(OperationResult result, OperationName operationName, boolean isReport, Long modelId, List<Long> chapterId, long rptOrTempId) {
        try {
            QFilter filter = new QFilter("id", "in", chapterId).and(FIELD_MODEL, "=", (Object)modelId);
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)"fidm_chapter", (String)"number,name,id,template.id", (QFilter[])new QFilter[]{filter});
            if (dyns.size() == 0) {
                return;
            }
            ArrayList<Chapter> chapters = new ArrayList<Chapter>(1);
            for (DynamicObject dyn : dyns) {
                Chapter chapter = new Chapter();
                chapter.setNumber(dyn.getString("number"));
                chapter.setName(dyn.getString("name"));
                if (isReport) {
                    chapter.setReportId(rptOrTempId);
                } else if (rptOrTempId == 0L) {
                    chapter.setTemplateId(dyn.getLong("template.id"));
                } else {
                    chapter.setTemplateId(rptOrTempId);
                }
                chapters.add(chapter);
            }
            EpmClientLogHelper.writeChapters(result, operationName, isReport, modelId, chapters);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeRepositoryChapters(OperationResult result, OperationName operationName, Long modelId, List<Chapter> chapters) {
        try {
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            ArrayList formatParamsList = Lists.newArrayListWithCapacity((int)1);
            for (Chapter chapter : chapters) {
                formatParamsList.add(new Object[]{modelInfo.getNumber(), chapter.getNumber()});
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.CHAPTEREPOSITORY).buildOpName(operationName).buildFormNumber("fidm_chapterepositorylist").buildAppId(AppMetadataCache.getAppInfo((String)ClientAppId).getId()).buildFormatParamsList((List)formatParamsList).buildOpResult(result);
            AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeRepositoryChaptersById(OperationResult result, OperationName operationName, Long modelId, List<Long> chapterId) {
        try {
            QFilter filter = new QFilter("id", "in", chapterId).and(FIELD_MODEL, "=", (Object)modelId);
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)"fidm_chapter", (String)"number,name,id,template.id", (QFilter[])new QFilter[]{filter});
            if (dyns.size() == 0) {
                return;
            }
            ArrayList<Chapter> chapters = new ArrayList<Chapter>(1);
            for (DynamicObject dyn : dyns) {
                Chapter chapter = new Chapter();
                chapter.setNumber(dyn.getString("number"));
                chapter.setName(dyn.getString("name"));
                chapters.add(chapter);
            }
            EpmClientLogHelper.writeRepositoryChapters(result, operationName, modelId, chapters);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeChapterCatalogs(OperationResult result, OperationName operationName, Long modelId, List<ChapterCatalog> catalogs) {
        try {
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            ArrayList formatParamsList = Lists.newArrayListWithCapacity((int)1);
            for (ChapterCatalog catalog : catalogs) {
                formatParamsList.add(new Object[]{modelInfo.getNumber(), catalog.getNumber()});
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.CHAPTEREPOSITORY).buildOpName(operationName).buildFormNumber("fidm_chaptergroup").buildAppId(AppMetadataCache.getAppInfo((String)ClientAppId).getId()).buildFormatParamsList((List)formatParamsList).buildOpResult(result);
            AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeChapterCatalogsById(OperationResult result, OperationName operationName, Long modelId, List<Long> catalogIds) {
        try {
            QFilter filter = new QFilter("id", "in", catalogIds).and(FIELD_MODEL, "=", (Object)modelId);
            DynamicObjectCollection catalogDatas = QueryServiceHelper.query((String)"fidm_chaptergroup", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
            if (catalogDatas.size() == 0) {
                return;
            }
            ArrayList<ChapterCatalog> catalogs = new ArrayList<ChapterCatalog>(1);
            for (DynamicObject dyn : catalogDatas) {
                ChapterCatalog catalog = new ChapterCatalog();
                catalog.setNumber(dyn.getString("number"));
                catalog.setName(dyn.getString("name"));
                catalogs.add(catalog);
            }
            EpmClientLogHelper.writeChapterCatalogs(result, operationName, modelId, catalogs);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeModules(OperationResult result, OperationName operationName, Long modelId, List<Module> modules) {
        try {
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            ArrayList formatParamsList = Lists.newArrayListWithCapacity((int)1);
            for (Module module : modules) {
                formatParamsList.add(new Object[]{modelInfo.getNumber(), module.getNumber()});
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.COMPONENT_GALLERY).buildOpName(operationName).buildFormNumber("fidm_webdesign").buildAppId(AppMetadataCache.getAppInfo((String)ClientAppId).getId()).buildFormatParamsList((List)formatParamsList).buildOpResult(result);
            AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeModulesById(OperationResult result, OperationName operationName, Long modelId, List<Long> moduleIds) {
        try {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
            qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
            qFilters.add(new QFilter("id", "in", moduleIds));
            DynamicObjectCollection moduleDatas = QueryServiceHelper.query((String)"fidm_modulerepository", (String)"id,number,name", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (moduleDatas.size() == 0) {
                return;
            }
            ArrayList<Module> modules = new ArrayList<Module>(1);
            for (DynamicObject dyn : moduleDatas) {
                Module module = new Module();
                module.setNumber(dyn.getString("number"));
                module.setName(dyn.getString("name"));
                modules.add(module);
            }
            EpmClientLogHelper.writeModules(result, operationName, modelId, modules);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeReports(OperationResult result, OperationName operationName, Long modelId, List<Report> reports) {
        try {
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            ArrayList formatParamsList = Lists.newArrayListWithCapacity((int)1);
            for (Report report : reports) {
                formatParamsList.add(new Object[]{modelInfo.getNumber(), TypeUtils.toPinYinString(report.getName())});
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.REPORT).buildOpName(operationName).buildFormNumber("fidm_report").buildAppId(AppMetadataCache.getAppInfo((String)ClientAppId).getId()).buildFormatParamsList((List)formatParamsList).buildOpResult(result);
            AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeReportsById(OperationResult result, OperationName operationName, Long modelId, List<Long> reportIds) {
        try {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
            qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
            qFilters.add(new QFilter("id", "in", reportIds));
            DynamicObjectCollection reportDys = QueryServiceHelper.query((String)"fidm_report", (String)"id,name", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (reportDys.size() == 0) {
                return;
            }
            ArrayList<Report> reports = new ArrayList<Report>(1);
            for (DynamicObject dyn : reportDys) {
                Report report = new Report();
                report.setName(dyn.getString("name"));
                reports.add(report);
            }
            EpmClientLogHelper.writeReports(result, operationName, modelId, reports);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeReportOper(OperationResult result, Long modelId, long reportId, OperationName operName) {
        try {
            String org;
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            if (modelInfo == null) {
                return;
            }
            DynamicObject report = DisclosureReportHelper.getReport(reportId);
            String reportName = null == report ? "" : report.getString("name");
            String year = null == report ? "" : report.getString("year.number");
            String period = null == report ? "" : report.getString("period.number");
            String string = org = null == report ? "" : report.getString("bcmentity.number");
            if (StringUtils.isEmpty((String)period)) {
                String string2 = period = null == report ? "" : report.getString("budgetperiod.number");
            }
            if (StringUtils.isEmpty((String)org)) {
                org = null == report ? "" : report.getString("epmentity.number");
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.REPORT).buildOpName(operName).buildFormNumber("fidm_webreport_edit").buildAppId(ClientAppId).buildFormatParams(new Object[]{modelInfo.getNumber(), year, period, org, TypeUtils.toPinYinString(reportName)}).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeVars(OperationResult result, OperationName operationName, Long modelId, List<Variable> variables) {
        try {
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            ArrayList formatParamsList = Lists.newArrayListWithCapacity((int)1);
            for (Variable variable : variables) {
                formatParamsList.add(new Object[]{modelInfo.getNumber(), variable.getNumber()});
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.GLOBAL_VAR).buildOpName(operationName).buildFormNumber("fidm_disc_variable_list").buildAppId(AppMetadataCache.getAppInfo((String)ClientAppId).getId()).buildFormatParamsList((List)formatParamsList).buildOpResult(result);
            AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }
}

