/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.dto.MemberRange;
import kd.epm.far.business.bcm.dto.MemberRangeInput;
import kd.epm.far.business.bcm.dto.MemberRangeResult;
import kd.epm.far.business.common.dataset.FidmDataSet;
import kd.epm.far.business.common.dataset.dto.DataSet;
import kd.epm.far.business.common.dataset.dto.DatasetVarAndDim;
import kd.epm.far.business.common.dataset.filter.DatasetFilterHelper;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.expression.dto.calc.DataSetCaclColumn;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.epmclient.dto.EpmApiOutput;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import org.apache.commons.collections.CollectionUtils;

public class EpmDataSetServiceHelper {
    private EpmDataSetServiceHelper() {
    }

    public static EpmApiOutput getColumnAndFilter(long modelId, long chapterId, long dataSetId, long dataSetFormulaId) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        DatasetVarAndDim filter = DatasetServiceHelper.getVarAndDimVar(modelId, dataSetId, chapterId, true);
        result.put("filters", filter);
        DataSet dataSet = DatasetServiceHelper.getDataSet(modelId, dataSetId);
        if (dataSet != null && DataSetTypeEnum.MULTIPLE_ROW.getType().equals(dataSet.getType())) {
            List<Map<String, Object>> colunmMapList = DatasetFilterHelper.invokeDatasetFilterColumn(modelId, dataSetId);
            ArrayList<DataSetCaclColumn> columns = new ArrayList<DataSetCaclColumn>(colunmMapList.size());
            for (Map<String, Object> columnMap : colunmMapList) {
                DataSetCaclColumn column = new DataSetCaclColumn();
                column.setId(columnMap.get("number").toString());
                column.setNumber(columnMap.get("number").toString());
                column.setName(columnMap.get("name").toString());
                column.setType(columnMap.get("type").toString());
                column.setCol_type(columnMap.get("col_type").toString());
                if (columnMap.containsKey("member")) {
                    column.setMember((ArrayList)columnMap.get("member"));
                }
                columns.add(column);
            }
            result.put("columns", columns);
        }
        return new EpmApiOutput(result);
    }

    public static EpmApiOutput getPreviewData(long modelId, long chapterId, long dataSetId, long dataSetFormulaId, List<Map<String, Object>> dimMembers, Map<String, Object> varParams) {
        EpmApiOutput output = new EpmApiOutput();
        Object result = null;
        try {
            DatasetExpressionHelper.checkExpression(modelId, dataSetId);
            List<DimensionInfo> dims = EpmDataSetServiceHelper.getDimensionInfos(dataSetId, dataSetFormulaId, dimMembers);
            FidmDataSet fidmDataSet = new FidmDataSet(chapterId, dataSetId, dims, varParams, true);
            result = fidmDataSet.getResult();
        }
        catch (KDException ex) {
            output.setMessage(ex.getMessage());
            return output;
        }
        if (result == null) {
            output.setMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u7ed3\u679c\u3002", (String)"DatasetServiceHelper_16", (String)"epm-far-business", (Object[])new Object[0]));
        } else if (result instanceof RuntimeException) {
            output.setMessage(((RuntimeException)result).getMessage());
        } else if (result instanceof Exception) {
            output.setMessage(((Exception)result).getMessage());
        } else {
            output.setData(result);
            output.setSuccess(true);
        }
        return output;
    }

    private static List<DimensionInfo> getDimensionInfos(long dataSetId, long dataSetFormulaId, List<Map<String, Object>> dimMembers) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        Map dataSets = BusinessDataServiceHelper.loadFromCache((String)"fidm_dataset_single", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (dataSets == null || dataSets.isEmpty()) {
            ArrayList<QFilter> qFilters1 = new ArrayList<QFilter>(2);
            qFilters1.add(new QFilter("dataset", "=", (Object)dataSetId));
            qFilters1.add(new QFilter("single", ">", (Object)0L));
            Map dataSetMultis = BusinessDataServiceHelper.loadFromCache((String)"fidm_dataset_multivalue", (QFilter[])qFilters1.toArray(new QFilter[0]));
            List dataSetIds = dataSetMultis.values().stream().map(d -> d.getLong("single.id")).collect(Collectors.toList());
            if (!dataSetIds.isEmpty()) {
                ArrayList<QFilter> qFilters2 = new ArrayList<QFilter>(2);
                qFilters2.add(new QFilter("id", "in", dataSetIds));
                dataSets = BusinessDataServiceHelper.loadFromCache((String)"fidm_dataset_single", (QFilter[])qFilters2.toArray(new QFilter[0]));
            }
        }
        if (dataSets == null || dataSets.isEmpty()) {
            return new ArrayList<DimensionInfo>(0);
        }
        long dataSetModelId = ((DynamicObject)dataSets.values().stream().findFirst().orElse(null)).getLong("datasrcid");
        ArrayList<DimensionInfo> dims = new ArrayList<DimensionInfo>(dimMembers.size());
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dataSetModelId);
        List<DimensionInfo> allDims = modelStrategyEx.getDim().getDimList(true);
        for (Map<String, Object> dimMember : dimMembers) {
            long dimensionId = LongUtil.toLong((Object)dimMember.get("DimensionId"));
            long schemeId = LongUtil.toLong((Object)dimMember.get("SchemeId"));
            boolean isProperty = (Boolean)dimMember.get("IsProperty");
            List members = (List)dimMember.get("Members");
            DimensionInfo dimensionInfo = DimensionUtils.getDimById(allDims, dimensionId);
            ArrayList<MemberRange> memberList = new ArrayList<MemberRange>(members.size());
            for (Map member : members) {
                MemberRange memberRange = new MemberRange();
                memberRange.setId(LongUtil.toLong(member.get("MemberId")));
                memberRange.setRange(Integer.parseInt(StringUtils.getStringValue(member.get("Range"))));
                memberList.add(memberRange);
            }
            List<MemberRangeResult> memberRangeResults = null;
            if (DisModelTypeEnum.CM.getType().equals(modelStrategyEx.getModel().getModelInfo().getModelType()) || DisModelTypeEnum.RPT.getType().equals(modelStrategyEx.getModel().getModelInfo().getModelType())) {
                MemberRangeInput memberRangeInput = new MemberRangeInput();
                memberRangeInput.setModelId(dataSetModelId);
                memberRangeInput.setEntityName(dimensionInfo.getEntityName());
                memberRangeInput.setMembers(memberList);
                memberRangeInput.setProperty(isProperty);
                memberRangeInput.setSchemeId(schemeId);
                memberRangeResults = BCMMsServiceHelper.batchGetMembersByIds(memberRangeInput);
            } else if (DisModelTypeEnum.EB.getType().equals(modelStrategyEx.getModel().getModelInfo().getModelType())) {
                String modelNumber = modelStrategyEx.getModel().getModelInfo().getNumber();
                String dimNumber = dimensionInfo.getNumber();
                ArrayList<DimMemberInfo> memberInfos = new ArrayList<DimMemberInfo>(memberList.size());
                for (MemberRange memberRange : memberList) {
                    DimMemberInfo member = modelStrategyEx.getDimMember().findMemberById(dimensionInfo.getEntityName(), memberRange.getId());
                    if (member == null) continue;
                    memberInfos.add(member);
                }
                dimensionInfo.setMembers(memberInfos);
            }
            if (memberRangeResults != null) {
                ArrayList<DimMemberInfo> memberInfos = new ArrayList<DimMemberInfo>(memberRangeResults.size());
                if (CollectionUtils.isNotEmpty(memberRangeResults)) {
                    for (MemberRangeResult memberRangeResult : memberRangeResults) {
                        DimMemberInfo memberInfo = new DimMemberInfo();
                        memberInfo.setId(LongUtil.toLong((Object)memberRangeResult.getId()));
                        memberInfo.setNumber(memberRangeResult.getNumber());
                        memberInfo.setName(memberRangeResult.getName());
                        memberInfo.setRange(10);
                        memberInfos.add(memberInfo);
                    }
                }
                dimensionInfo.setMembers(memberInfos);
            }
            dims.add(dimensionInfo);
        }
        return dims;
    }
}

