/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.org.model.EnableEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.permission.cache.UserHasPermDimObjCache;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.epmclient.dto.Model;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;

public class EpmModelServiceHelper {
    private EpmModelServiceHelper() {
    }

    public static List<Model> getModels(String modelType) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
        if (StringUtils.isNotEmpty((String)modelType) && !"0".equals(modelType)) {
            qFilters.add(new QFilter("modeltype", "=", (Object)modelType));
        }
        qFilters.add(new QFilter("status", "=", (Object)EnableEnum.Enable.toString()));
        qFilters.add(new QFilter("apptype", "in", Arrays.asList("1", "3")));
        HasPermDimObjResult result = EpmModelServiceHelper.getHasPermModelIds();
        if (result != null && !result.hasAllDimObjPerm()) {
            qFilters.add(new QFilter("id", "in", (Object)result.getHasPermDimObjs()));
        }
        DynamicObjectCollection dyModels = QueryServiceHelper.query((String)"fidm_model", (String)"id,number,name,modeltype,model,status,apptype,modelsourcetype,iscurrent,modifytime,adminname", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc");
        ArrayList<Model> models = new ArrayList<Model>(dyModels.size());
        for (DynamicObject dy : dyModels) {
            ResultInfo resultInfo = new ModelStrategyEx(dy.getLong("id")).getModel().checkModel();
            if (Boolean.FALSE.equals(resultInfo.isSuccess())) continue;
            Model model = new Model();
            model.setId(dy.getLong("id"));
            model.setNumber("CUBE" + dy.getString("number") + dy.getString("id"));
            model.setShowNumber(dy.getString("number"));
            model.setName(dy.getString("name"));
            model.setModelType(dy.getInt("modeltype"));
            model.setModelId(dy.getLong("model"));
            model.setStatus(dy.getBoolean("status"));
            model.setAppType(dy.getInt("apptype"));
            model.setModelSourceType(dy.getString("modelsourcetype"));
            model.setIsCurrent(dy.getString("iscurrent"));
            model.setModifyTime(dy.getDate("modifytime"));
            model.setIsAdmin(MemberPermHelper.isDiscModelAdmin(dy.getLong("id"), "fidm"));
            models.add(model);
        }
        return models;
    }

    private static HasPermDimObjResult getHasPermModelIds() {
        HasPermDimObjResult result;
        long userId = RequestContext.get().getCurrUserId();
        try {
            Class<?> version = Class.forName("kd.bos.permission.cache.UserHasPermDimObjCache");
            Method newVersionMethod = version.getDeclaredMethod("getUserHasPermDimObjs", Long.TYPE, String.class, String.class);
            result = (HasPermDimObjResult)newVersionMethod.invoke((Object)new UserHasPermDimObjCache(), userId, ApplicationTypeEnum.FIDM.getAppnum(), "fidm_model");
        }
        catch (NoSuchMethodException exc) {
            result = PermissionServiceHelper.getUserHasPermDimObjs((long)userId, (String)"fidm_model");
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }

    public static boolean hasPerm(long modelId) {
        HasPermDimObjResult result = EpmModelServiceHelper.getHasPermModelIds();
        if (result != null && (result.hasAllDimObjPerm() || result.getHasPermDimObjs().contains(modelId))) {
            return QueryServiceHelper.exists((String)"fidm_model", (Object)modelId);
        }
        return false;
    }
}

