/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.enums.ComeFromEnum;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.module.ModuleMiddleHelper;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.common.module.dto.Module;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.base.MiddleModuleResult;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.epmclient.dto.EpmApiOutput;
import kd.epm.far.business.epmclient.module.dto.DataPointModule;
import kd.epm.far.business.epmclient.module.dto.ReportSectionModule;
import kd.epm.far.business.epmclient.module.dto.TableModule;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.design.DisclosurePreviewService;
import kd.epm.far.business.fidm.design.dto.ChapterPreviewResult;
import kd.epm.far.business.fidm.module.DisclosureOldModuleHelper;
import kd.epm.far.business.fidm.module.calculate.ReportSectionCalculate;
import kd.epm.far.business.fidm.report.dto.GenerateInputFormular;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class EpmModuleServiceHelper {
    EpmModuleServiceHelper() {
    }

    public static EpmApiOutput saveAsModule(long modelId, String number, String name, long catalogId, long permClassId, String description, String moduleJson, String chartTemplateData) {
        ResultInfo checkResult = ModuleServiceHelper.checkModule(modelId, number, name, catalogId, description, moduleJson);
        if (Boolean.FALSE.equals(checkResult.isSuccess())) {
            return new EpmApiOutput(false, checkResult.getMessage());
        }
        JSONObject json = JSON.parseObject((String)moduleJson);
        long id = GlobalIdUtil.genGlobalLongId();
        json.put("Name", (Object)name);
        DynamicObject module = EpmModuleServiceHelper.createModule(modelId, 0L, id, json);
        module.set("number", (Object)number);
        module.set("catalog", (Object)catalogId);
        module.set("permclass", (Object)permClassId);
        module.set("description", (Object)description);
        module.set("properties", (Object)json.toJSONString());
        module.set("charttemplatedata", (Object)chartTemplateData);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{module});
        if (permClassId > 0L) {
            PermClassEntityHelper.saveDiscPermClass(module, "fidmmodel", AppCatalogTypeEnum.FIDM_CATALOG.getAppId());
        }
        return new EpmApiOutput(id);
    }

    public static DynamicObject createModule(long modelId, long templateId, long moduleId, JSONObject itemObject) {
        long dataSetId = DisclosureJsonHelper.getValue(itemObject, "DataSet", "Id", 0L);
        long copyFromId = DisclosureJsonHelper.getValue(itemObject, "CopyFrom", 0L);
        int type = DisclosureJsonHelper.getValue(itemObject, "Type", 0);
        String name = DisclosureJsonHelper.getValue(itemObject, "Name", "");
        DynamicObject module = BusinessDataServiceHelper.newDynamicObject((String)"fidm_modulerepository");
        module.set("id", (Object)moduleId);
        module.set("model", (Object)modelId);
        module.set("template", (Object)templateId);
        module.set("creator", (Object)RequestContext.get().getCurrUserId());
        module.set("createtime", (Object)TimeServiceHelper.now());
        module.set("modifier", (Object)RequestContext.get().getCurrUserId());
        module.set("modifytime", (Object)TimeServiceHelper.now());
        module.set("number", (Object)"");
        module.set("name", (Object)name);
        module.set("type", (Object)type);
        module.set("applytype", (Object)ModuleServiceHelper.getModuleApplyType(StringUtils.getStringValue((Object)type)));
        module.set("scope", (Object)"1");
        module.set("status", (Object)"1");
        module.set("copyfrom", (Object)copyFromId);
        module.set("datasetid", (Object)dataSetId);
        module.set("comefrom", (Object)ComeFromEnum.EPMC.getType());
        module.set("properties", (Object)itemObject.toJSONString());
        return module;
    }

    public static void setModuleFileByte(long modelId, Module module, Map<String, Long> dimMembers) {
        if (dimMembers == null) {
            return;
        }
        if (StringUtils.isEmpty((String)module.getProperties())) {
            return;
        }
        if (ComeFromEnum.EPMC.getType().equals(module.getComeFrom()) && !module.getProperties().startsWith("{\"border") && !module.getProperties().startsWith("{\"number")) {
            return;
        }
        if (ComeFromEnum.FAR.getType().equals(module.getComeFrom())) {
            return;
        }
        HashMap<String, Object> moduleMap = new HashMap<String, Object>(2);
        moduleMap.put("id", module.getId());
        moduleMap.put("name", module.getName());
        moduleMap.put("number", module.getNumber());
        moduleMap.put("type", module.getType());
        moduleMap.put("properties", module.getProperties());
        JSONObject moduleProperties = DisclosureOldModuleHelper.converToNewVersion(modelId, 0L, moduleMap);
        moduleProperties.put("id", (Object)module.getId());
        String userName = RequestContext.get().getUserName();
        HashMap<String, DimMemberInfo> memberMap = new HashMap<String, DimMemberInfo>(dimMembers.size());
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        List<DimensionInfo> dimensions = modelStrategyEx.getDim().getDimList();
        for (Map.Entry<String, Long> dimMember : dimMembers.entrySet()) {
            DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(dimensions, dimMember.getKey());
            DimMemberInfo member = modelStrategyEx.getDimMember().findMemberById(dimensionInfo.getEntityName(), dimMember.getValue());
            memberMap.put(dimMember.getKey(), member);
        }
        ChapterPreviewResult result = DisclosurePreviewService.modulePreview(modelId, moduleProperties, memberMap, userName, true, "", OpenWordEnum.WPSPLUGIN.getType(), null);
        try (InputStream inputStream = DisclosureFileHelper.getFileInputStream(result.getPreviewUrl(), true);
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            if (inputStream != null) {
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                byte[] inputBytes = outputStream.toByteArray();
                module.setChartTemplateData(Base64.getEncoder().encodeToString(inputBytes));
            }
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u52a0\u8f7d\u6587\u4ef6\u5931\u8d25\u3002", (String)"ReportGenerateService_0", (String)"epm-far-business", (Object[])new Object[0]), e);
        }
    }

    public static List<DynamicObject> copyModules(long modelId, DynamicObject fromChapter, DynamicObject toChapter, GenerateInputFormular generateInputFormular) {
        DynamicObject[] fromModuleList;
        ArrayList<DynamicObject> saveNewModules = new ArrayList<DynamicObject>(10);
        DynamicObjectCollection toModules = toChapter.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection fromModules = fromChapter.getDynamicObjectCollection("entryentity");
        toModules.clear();
        String comefrom = fromChapter.getString("comefrom");
        List moduleIds = fromModules.stream().map(e -> e.getLong("module_id")).filter(e -> !e.equals(0L)).distinct().collect(Collectors.toList());
        for (DynamicObject fromModule : fromModuleList = BusinessDataServiceHelper.load((Object[])moduleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fidm_modulerepository"))) {
            DynamicObject toModule = BusinessDataServiceHelper.newDynamicObject((String)"fidm_modulerepository");
            long newId = GlobalIdUtil.genGlobalLongId();
            toModule.set("id", (Object)newId);
            toModule.set("creator", (Object)toChapter.getLong("creator"));
            toModule.set("createtime", (Object)toChapter.getDate("createtime"));
            toModule.set("modifier", (Object)toChapter.getLong("modifier"));
            toModule.set("modifytime", (Object)toChapter.getDate("modifytime"));
            toModule.set("properties", (Object)EpmModuleServiceHelper.convertToEpmModuleProperties(modelId, fromModule.getLong("id"), comefrom, generateInputFormular));
            toModule.set("model", (Object)fromModule.getLong("model.id"));
            toModule.set("template", (Object)fromModule.getLong("template.id"));
            toModule.set("permclass", (Object)fromModule.getLong("permclass.id"));
            toModule.set("description", (Object)fromModule.getString("description"));
            toModule.set("number", (Object)fromModule.getString("number"));
            toModule.set("name", (Object)fromModule.getString("name"));
            toModule.set("scope", (Object)fromModule.getString("scope"));
            toModule.set("status", (Object)fromModule.getString("status"));
            toModule.set("copyfrom", (Object)fromModule.getLong("copyfrom.id"));
            toModule.set("datasetid", (Object)fromModule.getLong("datasetid.id"));
            toModule.set("comefrom", (Object)ComeFromEnum.EPMC.getType());
            toModule.set("catalog", (Object)fromModule.getLong("catalog.id"));
            toModule.set("type", (Object)fromModule.getString("type"));
            toModule.set("applytype", (Object)fromModule.getString("applytype"));
            toModule.set("charttemplatedata", (Object)fromModule.getString("charttemplatedata"));
            saveNewModules.add(toModule);
            DynamicObject fromEntry = fromModules.stream().filter(m -> m.getLong("module.id") == fromModule.getLong("id")).findFirst().orElse(null);
            if (fromEntry == null) continue;
            DynamicObject dyn = new DynamicObject(toModules.getDynamicObjectType());
            dyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dyn.set("module", (Object)newId);
            dyn.set("key", (Object)fromEntry.getString("key"));
            dyn.set("seq", (Object)fromEntry.getInt("seq"));
            toModules.add((Object)dyn);
        }
        return saveNewModules;
    }

    public static EpmApiOutput getReportSectionData(long modelId, long moduleId, Map<String, Long> dimMembers, String property) {
        EpmApiOutput output = new EpmApiOutput();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        List<DimensionInfo> allDimensionInfos = modelStrategyEx.getDim().getDimList();
        ArrayList<DimensionInfo> dimDefaultMemberMap = new ArrayList<DimensionInfo>(16);
        for (Map.Entry<String, Long> dim : dimMembers.entrySet()) {
            DimMemberInfo memberInfo;
            DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(allDimensionInfos, dim.getKey());
            if (dimensionInfo == null || (memberInfo = modelStrategyEx.getDimMember().findMemberById(dimensionInfo.getEntityName(), dim.getValue(), false)) == null) continue;
            dimensionInfo.getMembers().add(memberInfo);
            dimDefaultMemberMap.add(dimensionInfo);
        }
        MiddleModuleInput input = new MiddleModuleInput();
        input.setDmModelId(modelId);
        input.setModuleId(moduleId);
        input.setBegin(ModuleMiddleHelper.ModuleConvertEnum.EpmClient);
        input.setEnd(ModuleMiddleHelper.ModuleConvertEnum.Fidm);
        JSONObject propertyJson = JSON.parseObject((String)property);
        String type = DisclosureJsonHelper.getValue(propertyJson, "Type", "");
        ModuleEnum moduleEnum = ModuleEnum.getModuleByType(type);
        if (moduleEnum == ModuleEnum.REPORT_SECTION) {
            ReportSectionModule reportSectionModule = (ReportSectionModule)propertyJson.toJavaObject(ReportSectionModule.class);
            input.setSourceModule(reportSectionModule);
            MiddleModuleResult convertResult = ModuleMiddleHelper.convertToThird(input, false);
            if (convertResult.isSuccess()) {
                JSONObject result = new ReportSectionCalculate().createReportSection(modelId, dimDefaultMemberMap, (JSONObject)convertResult.getResult());
                String resultCode = DisclosureJsonHelper.getValue(result, "code", "");
                if ("0000".equals(resultCode)) {
                    output.setSuccess(true);
                    output.setData(result.getJSONObject("data"));
                } else {
                    output.setMessage(result.getString("msg"));
                }
            } else {
                output.setMessage(convertResult.getMessage());
            }
        } else if (moduleEnum == ModuleEnum.EB_REPORT_SECTION) {
            // empty if block
        }
        return output;
    }

    private static String convertToEpmModuleProperties(long modelId, long moduleId, String comefrom, GenerateInputFormular generateInputFormular) {
        DynamicObject module = BusinessDataServiceHelper.loadSingleFromCache((Object)moduleId, (String)"fidm_modulerepository");
        if (module == null) {
            return StringUtils.getEmpty();
        }
        String type = module.getString("type");
        String properties = module.getString("properties");
        if (StringUtils.isEmpty((String)comefrom)) {
            comefrom = module.getString("comefrom");
        }
        if (StringUtils.isNotEmpty((String)(properties = EpmModuleServiceHelper.convertToEpmModuleProperties(modelId, moduleId, comefrom, properties))) && generateInputFormular != null) {
            JSONObject propertiesJson = JSON.parseObject((String)properties);
            if (generateInputFormular.getModuleRange().contains(ModuleEnum.VAR.getType()) && ModuleEnum.VAR.getType().equals(type)) {
                DataPointModule dataPointModule = (DataPointModule)propertiesJson.toJavaObject(DataPointModule.class);
                if (!"0".equals(generateInputFormular.getUnit())) {
                    dataPointModule.getProperty().getNumberFormat().setMoneyUnit(Integer.parseInt(generateInputFormular.getUnit()));
                }
                if (generateInputFormular.getDecimalEnable()) {
                    dataPointModule.getProperty().getNumberFormat().setDecimalCount(generateInputFormular.getDecimal());
                }
                properties = JSON.toJSONString((Object)dataPointModule);
            }
            if (generateInputFormular.getModuleRange().contains(ModuleEnum.TABLE.getType()) && ModuleEnum.TABLE.getType().equals(type)) {
                TableModule tableModule = (TableModule)propertiesJson.toJavaObject(TableModule.class);
                if (!"0".equals(generateInputFormular.getUnit())) {
                    tableModule.getProperty().getNumberFormat().setMoneyUnit(Integer.parseInt(generateInputFormular.getUnit()));
                }
                if (generateInputFormular.getDecimalEnable()) {
                    tableModule.getProperty().getNumberFormat().setDecimalCount(generateInputFormular.getDecimal());
                }
                properties = JSON.toJSONString((Object)tableModule);
            }
            if (generateInputFormular.getModuleRange().contains(ModuleEnum.REPORT_SECTION.getType()) && ModuleEnum.REPORT_SECTION.getType().equals(type)) {
                ReportSectionModule reportSectionModule = (ReportSectionModule)propertiesJson.toJavaObject(ReportSectionModule.class);
                if (!"0".equals(generateInputFormular.getUnit())) {
                    reportSectionModule.getProperty().setMoneyUnit(Integer.parseInt(generateInputFormular.getUnit()));
                }
                if (generateInputFormular.getDecimalEnable()) {
                    reportSectionModule.getProperty().setDecimalCount(generateInputFormular.getDecimal());
                }
                properties = JSON.toJSONString((Object)reportSectionModule);
            }
        }
        return properties;
    }

    public static String convertToEpmModuleProperties(long modelId, long moduleId, String comefrom, String properties) {
        MiddleModuleResult convertResult;
        if (StringUtils.isEmpty((String)properties)) {
            return StringUtils.getEmpty();
        }
        MiddleModuleInput input = new MiddleModuleInput();
        input.setDmModelId(modelId);
        input.setModuleId(moduleId);
        input.setEnd(ModuleMiddleHelper.ModuleConvertEnum.EpmClient);
        if (ComeFromEnum.FIDM.getType().equals(comefrom) || ComeFromEnum.CM.getType().equals(comefrom) || ComeFromEnum.EB.getType().equals(comefrom)) {
            input.setBegin(ModuleMiddleHelper.ModuleConvertEnum.Fidm);
            input.setSourceModule(JSON.parseObject((String)properties));
        } else if (ComeFromEnum.FAR.getType().equals(comefrom)) {
            input.setBegin(ModuleMiddleHelper.ModuleConvertEnum.Far);
            input.setSourceModule(JSON.parseObject((String)properties));
        } else if (ComeFromEnum.EPMC.getType().equals(comefrom)) {
            if (properties.startsWith("{\"border") || properties.startsWith("{\"number")) {
                input.setBegin(ModuleMiddleHelper.ModuleConvertEnum.Fidm);
                input.setSourceModule(JSON.parseObject((String)properties));
            } else {
                return properties;
            }
        }
        if (input.getBegin() != null && (convertResult = ModuleMiddleHelper.convertToThird(input, false)).isSuccess()) {
            return JSON.toJSONString(convertResult.getResult());
        }
        return StringUtils.getEmpty();
    }
}

