/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.org.model.EnableEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.BCMDataReader;
import kd.epm.far.business.bcm.dto.BcmPermService;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.DmDimMemberEntityEnum;
import kd.epm.far.business.common.enums.MyReportStatusEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.util.PlatUtil;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.epmclient.EpmChapterServiceHelper;
import kd.epm.far.business.epmclient.EpmClientLogHelper;
import kd.epm.far.business.epmclient.EpmModuleServiceHelper;
import kd.epm.far.business.epmclient.dto.EpmApiOutput;
import kd.epm.far.business.epmclient.dto.Report;
import kd.epm.far.business.epmclient.dto.ReportSimple;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.report.DisclosureReportNameHelper;
import kd.epm.far.business.fidm.report.ReportChapterHelper;
import kd.epm.far.business.fidm.report.dto.GenerateInputFormular;
import kd.epm.far.business.fidm.template.dto.TemplateDimension;
import kd.epm.far.common.common.PresetConstant;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.DateTimeUtils;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class EpmReportServiceHelper {
    private static final String PARAM_CATALOGID = "CatalogId";
    private static final String PARAM_TEMPLATEID = "TemplateId";
    private static final String PARAM_ENTITYID = "EntityId";
    private static final String PARAM_ENTITYIDS = "EntityIds";
    private static final String PARAM_YEARID = "YearId";
    private static final String PARAM_PERIODID = "PeriodId";
    private static final String PARAM_NAME = "Name";
    private static final String PARAM_PERMCLASSID = "PermClassId";
    private static final String PARAM_MONEYUNIT = "MoneyUnit";
    private static final String PARAM_ISROUNDDECEMALS = "IsRoundDecemals";
    private static final String PARAM_DECEMALSNUMBER = "DecemalsNumber";
    private static final String PARAM_WORKRANGES = "WorkRanges";
    private static final String FIELD_REPORT = "report";
    private static final String FIELD_MODEL = "model";
    private static final String FIELD_ISPREVIEW = "ispreview";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_TEMPLATE_ID = "template.id";
    private static final String FIELD_DOCURL = "docurl";
    private static final String FIELD_ENTITYID = "entityid";
    private static final String FIELD_ISARCHIVED = "isarchived";
    private static final String FIELD_BCMENTITY = "bcmentity";
    private static final String FIELD_PERIOD = "period";
    private static final String FIELD_YEAR = "year";
    private static final String FIELD_SCENARIO = "scenario";
    private static final String FIELD_EPMENTITY = "epmentity";
    private static final String FIELD_BUDGETPERIOD = "budgetperiod";
    private static final String FIELD_VERSION = "version";
    private static final String FIELD_DATATYPE = "datatype";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_ISEDIT = "isedit";
    private static final String FIELD_DESQ = "desq";
    private static final String FIELD_PARAM = "param";
    private static final String FIELD_PARAMNUMBER = "paramnumber";
    private static final String FIELD_MODIFYTIME = "modifytime";
    private static final String FIELD_DIMMEMBERID = "dimmemberid";
    private static final String FIELD_DIMTYPE = "dimtype";
    private static final String FIELD_SAVEWORDTYPE = "savewordtype";
    private static final String FIELD_PREVIEWURL = "previewurl";

    private EpmReportServiceHelper() {
    }

    public static List<ReportSimple> getReports(long modelId, long templateId, String name, String flowStatus, Map<String, Object> param) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter(FIELD_ISPREVIEW, "=", (Object)"0"));
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        String modelType = modelStrategyEx.getModel().getModelInfo().getModelType();
        if (DisModelTypeEnum.CM.getType().equals(modelType) || DisModelTypeEnum.RPT.getType().equals(modelType)) {
            if (!EpmReportServiceHelper.checkCmFilters(modelId, qFilters, param)) {
                return new ArrayList<ReportSimple>(0);
            }
        } else if (DisModelTypeEnum.EB.getType().equals(modelType)) {
            EpmReportServiceHelper.checkEbFilters(qFilters, param);
        }
        if (StringUtils.isNotEmpty((String)name)) {
            qFilters.add(new QFilter(FIELD_NAME, "like", (Object)("%" + name + "%")));
        }
        if (StringUtils.isNotEmpty((String)flowStatus)) {
            String[] status = flowStatus.split(",");
            if (Arrays.stream(status).anyMatch(s -> MyReportStatusEnum.ARCHIVED.getValue().equals(s) || MyReportStatusEnum.UNARCHIVE.getValue().equals(s))) {
                qFilters.add(new QFilter(FIELD_ISARCHIVED, "in", (Object)status));
            }
            if (Arrays.stream(status).anyMatch(s -> MyReportStatusEnum.UNCOMMIT.getValue().equals(s) || MyReportStatusEnum.BACKED.getValue().equals(s) || MyReportStatusEnum.COMMITED.getValue().equals(s) || MyReportStatusEnum.AUDITED.getValue().equals(s))) {
                qFilters.add(new QFilter(FIELD_STATUS, "in", (Object)status));
            }
        } else {
            return new ArrayList<ReportSimple>(0);
        }
        if (templateId > 0L) {
            qFilters.add(new QFilter(FIELD_TEMPLATE_ID, "=", (Object)templateId));
        }
        QFilter permFilter = PermissionHelper.getReadAndWritePermFilter(modelId, "fidm_report");
        qFilters.add(permFilter);
        return EpmReportServiceHelper.getReportsByFilter(qFilters, modelType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkCmFilters(long modelId, List<QFilter> qFilters, Map<String, Object> param) {
        BcmPermService bcmPermService;
        List entityIds;
        long entityId = LongUtil.toLong((Object)param.get(PARAM_ENTITYID));
        long yearId = LongUtil.toLong((Object)param.get(PARAM_YEARID));
        long periodId = LongUtil.toLong((Object)param.get(PARAM_PERIODID));
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        long cmModelId = modelStrategyEx.getModel().getModelInfo().getModelId();
        boolean isCmAdmin = BCMDataReader.isAdmin(cmModelId);
        List<DimensionInfo> dimensions = modelStrategyEx.getDim().getDimList();
        if (entityId > 0L) {
            qFilters.add(new QFilter(FIELD_BCMENTITY, "=", (Object)entityId));
        } else if (param.containsKey(PARAM_ENTITYIDS) && !(entityIds = (List)param.get(PARAM_ENTITYIDS)).isEmpty()) {
            qFilters.add(new QFilter(FIELD_BCMENTITY, "in", (Object)entityIds));
        }
        if (!isCmAdmin) {
            long dimEntityId = DimensionUtils.getDimByNumber(dimensions, PresetConstant.ENTITY_DIM).getId();
            BcmPermService entityPermService = new BcmPermService(modelId, dimEntityId);
            QFilter entityQFilter = entityPermService.getPermQFilter(FIELD_BCMENTITY);
            if (entityQFilter != null) {
                qFilters.add(entityQFilter);
            }
        }
        if (periodId > 0L) {
            long dimPeriodId = DimensionUtils.getDimByNumber(dimensions, PresetConstant.PERIOD_DIM).getId();
            bcmPermService = new BcmPermService(modelId, dimPeriodId);
            if (!bcmPermService.hasPerm(periodId)) return false;
            qFilters.add(new QFilter(FIELD_PERIOD, "=", (Object)periodId));
        } else if (!isCmAdmin) {
            long dimPeriodId = DimensionUtils.getDimByNumber(dimensions, PresetConstant.PERIOD_DIM).getId();
            BcmPermService periodPermService = new BcmPermService(modelId, dimPeriodId);
            QFilter periodQFilter = periodPermService.getPermQFilter(FIELD_PERIOD);
            if (periodQFilter != null) {
                qFilters.add(periodQFilter);
            }
        }
        if (yearId > 0L) {
            long dimYearId = DimensionUtils.getDimByNumber(dimensions, PresetConstant.FY_DIM).getId();
            bcmPermService = new BcmPermService(modelId, dimYearId);
            if (!bcmPermService.hasPerm(yearId)) return false;
            qFilters.add(new QFilter(FIELD_YEAR, "=", (Object)yearId));
            return true;
        } else {
            if (isCmAdmin) return true;
            long dimYearId = DimensionUtils.getDimByNumber(dimensions, PresetConstant.FY_DIM).getId();
            BcmPermService yearPermService = new BcmPermService(modelId, dimYearId);
            QFilter yearQFilter = yearPermService.getPermQFilter(FIELD_YEAR);
            if (yearQFilter == null) return true;
            qFilters.add(yearQFilter);
        }
        return true;
    }

    private static void checkEbFilters(List<QFilter> qFilters, Map<String, Object> param) {
        List entityIds;
        long entityId = LongUtil.toLong((Object)param.get(PARAM_ENTITYID));
        long periodId = LongUtil.toLong((Object)param.get(PARAM_YEARID));
        long versionId = LongUtil.toLong((Object)param.get(PARAM_PERIODID));
        if (entityId > 0L) {
            qFilters.add(new QFilter(FIELD_EPMENTITY, "=", (Object)entityId));
        } else if (param.containsKey(PARAM_ENTITYIDS) && !(entityIds = (List)param.get(PARAM_ENTITYIDS)).isEmpty()) {
            qFilters.add(new QFilter(FIELD_EPMENTITY, "in", (Object)entityIds));
        }
        if (periodId > 0L) {
            qFilters.add(new QFilter(FIELD_BUDGETPERIOD, "=", (Object)periodId));
        }
        if (versionId > 0L) {
            qFilters.add(new QFilter(FIELD_VERSION, "=", (Object)versionId));
        }
    }

    private static List<ReportSimple> getReportsByFilter(List<QFilter> qFilters, String modelType) {
        DynamicObjectCollection reportDatas = QueryServiceHelper.query((String)"fidm_report", (String)"id,name,status,template.id,isedit,isarchived,desq,bcmentity,epmentity", (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<ReportSimple> reports = new ArrayList<ReportSimple>(reportDatas.size());
        for (DynamicObject row : reportDatas) {
            ReportSimple report = new ReportSimple();
            report.setId(row.getLong("id"));
            report.setName(row.getString(FIELD_NAME));
            report.setTemplateId(row.getLong(FIELD_TEMPLATE_ID));
            report.setCanEdit(!row.getBoolean(FIELD_ISEDIT));
            report.setStatus(row.getInt(FIELD_STATUS));
            if (MyReportStatusEnum.AUDITED.getValue().equals(row.getString(FIELD_STATUS))) {
                if (MyReportStatusEnum.ARCHIVED.getValue().equals(row.getString(FIELD_ISARCHIVED))) {
                    report.setStatus(Integer.parseInt(MyReportStatusEnum.ARCHIVED.getValue()));
                }
                if (MyReportStatusEnum.UNARCHIVE.getValue().equals(row.getString(FIELD_ISARCHIVED))) {
                    report.setStatus(Integer.parseInt(MyReportStatusEnum.UNARCHIVE.getValue()));
                }
            }
            if (DisModelTypeEnum.CM.getType().equals(modelType) || DisModelTypeEnum.RPT.getType().equals(modelType)) {
                report.setEntityId(row.getLong(FIELD_BCMENTITY));
            } else if (DisModelTypeEnum.EB.getType().equals(modelType)) {
                report.setEntityId(row.getLong(FIELD_EPMENTITY));
            }
            reports.add(report);
        }
        return reports;
    }

    public static Report getReport(long modelId, long reportId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter(FIELD_ISPREVIEW, "=", (Object)"0"));
        qFilters.add(new QFilter("id", "=", (Object)reportId));
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)"fidm_report", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (dy == null) {
            return null;
        }
        return EpmReportServiceHelper.getClientReportModel(modelId, dy);
    }

    private static Report getClientReportModel(long modelId, DynamicObject dy) {
        String modelType = new ModelStrategyEx(modelId).getModel().getModelInfo().getModelType();
        Report report = new Report();
        report.setId(dy.getLong("id"));
        report.setName(dy.getString(FIELD_NAME));
        report.setCanEdit(!dy.getBoolean(FIELD_ISEDIT));
        report.setTemplateCatalogId(dy.getLong("templatecatalog.id"));
        report.setTemplateCatalogName(dy.getString("templatecatalog.name"));
        report.setTemplateId(dy.getLong(FIELD_TEMPLATE_ID));
        report.setTemplateName(dy.getString("template.name"));
        report.setDocUrl(dy.getString(FIELD_DOCURL));
        report.setStatus(dy.getInt(FIELD_STATUS));
        report.setDseq(dy.getInt(FIELD_DESQ));
        if (MyReportStatusEnum.AUDITED.getValue().equals(dy.getString(FIELD_STATUS))) {
            if (MyReportStatusEnum.ARCHIVED.getValue().equals(dy.getString(FIELD_ISARCHIVED))) {
                report.setIsArchived(true);
                report.setStatus(Integer.parseInt(MyReportStatusEnum.ARCHIVED.getValue()));
            }
            if (MyReportStatusEnum.UNARCHIVE.getValue().equals(dy.getString(FIELD_ISARCHIVED))) {
                report.setIsArchived(false);
                report.setStatus(Integer.parseInt(MyReportStatusEnum.UNARCHIVE.getValue()));
            }
        }
        report.setAttachmentflag(dy.getBoolean("attachmentflag"));
        if (StringUtils.isNotEmpty((String)dy.getString(FIELD_DOCURL))) {
            report.setFullUrl(UrlService.getAttachmentFullUrl((String)dy.getString(FIELD_DOCURL)));
        }
        if (DisModelTypeEnum.CM.getType().equals(modelType) || DisModelTypeEnum.RPT.getType().equals(modelType)) {
            report.setEntityId(dy.getLong("bcmentity_id"));
            report.setYearId(dy.getLong("year_id"));
            report.setPeriodId(dy.getLong("period_id"));
            report.setScenarioId(dy.getLong("scenario_id"));
        } else if (DisModelTypeEnum.EB.getType().equals(modelType)) {
            report.setEntityId(dy.getLong("epmentity_id"));
            report.setPeriodId(dy.getLong("budgetperiod_id"));
            report.setVersionId(dy.getLong("version_id"));
            report.setDataType(dy.getLong("datatype_id"));
        }
        report.setParam(dy.getString(FIELD_PARAM));
        report.setParamNumber(dy.getString(FIELD_PARAMNUMBER));
        report.setPermClassId(EpmReportServiceHelper.getReportPermClass(modelId, dy.getLong("id")));
        report.setCreateTime(dy.getDate("createtime"));
        report.setCreator(dy.getString("creator.name"));
        report.setModifyTime(dy.getDate(FIELD_MODIFYTIME));
        report.setModifier(dy.getString("modifier.name"));
        report.setSubmitTime(dy.getDate("submittime"));
        report.setSubmitter(dy.getString("submitter.name"));
        report.setCallbackTime(dy.getDate("callbacktime"));
        report.setCallbacker(dy.getString("callbacker.name"));
        report.setReviewTime(dy.getDate("reviewtime"));
        report.setReviewer(dy.getString("reviewer.name"));
        report.setCancelReviewerTime(dy.getDate("cancelreviewertime"));
        report.setCancelReviewer(dy.getString("cancelreviewer.name"));
        report.setArchiveTime(dy.getDate("archivetime"));
        report.setArchiver(dy.getString("archiver.name"));
        report.setCancelArchiveTime(dy.getDate("cancelarchivetime"));
        report.setCancelArchiver(dy.getString("cancelarchiver.name"));
        DynamicObjectCollection reportDims = QueryServiceHelper.query((String)"fidm_report_dim", (String)"id,dimid.id,dimmemberid,dimtype", (QFilter[])new QFilter[]{new QFilter(FIELD_REPORT, "=", (Object)report.getId())});
        ArrayList<TemplateDimension> dimensions = new ArrayList<TemplateDimension>(reportDims.size());
        for (DynamicObject dim : reportDims) {
            TemplateDimension rd = new TemplateDimension();
            rd.setId(dim.getLong("id"));
            rd.setDimensionId(dim.getLong("dimid.id"));
            rd.setMemberId(dim.getLong(FIELD_DIMMEMBERID));
            rd.setDimensionType(dim.getString(FIELD_DIMTYPE));
            dimensions.add(rd);
        }
        report.setParamDimensions(dimensions);
        return report;
    }

    public static EpmApiOutput createReport(long modelId, Map<String, Object> param) {
        DimMemberInfo org;
        ModelStrategyEx modelStrategyEx;
        Optional<DimensionInfo> entityOpt;
        DynamicObject template;
        String message;
        long catalogId = LongUtil.toLong((Object)param.get(PARAM_CATALOGID));
        long templateId = LongUtil.toLong((Object)param.get(PARAM_TEMPLATEID));
        long permClassId = LongUtil.toLong((Object)param.get(PARAM_PERMCLASSID));
        String name = StringUtils.getStringValue((Object)param.get(PARAM_NAME));
        boolean canEdit = Boolean.parseBoolean(param.get("CanEdit").toString());
        boolean useReportNameRule = Boolean.parseBoolean(param.get("UseReportNameRule").toString());
        long entityId = LongUtil.toLong((Object)param.get(PARAM_ENTITYID));
        Map dimensionMembers = (Map)param.get("DimensionMembers");
        Map clientChapterDocuments = (Map)param.get("ClientChapterDocuments");
        Map unitParams = (Map)param.get("UnitParams");
        GenerateInputFormular input = new GenerateInputFormular();
        if (unitParams.containsKey(PARAM_ISROUNDDECEMALS)) {
            input.setDecimalEnable((Boolean)unitParams.get(PARAM_ISROUNDDECEMALS));
        }
        if (unitParams.containsKey(PARAM_WORKRANGES)) {
            input.setModuleRange((List)unitParams.get(PARAM_WORKRANGES));
        }
        if (unitParams.containsKey(PARAM_DECEMALSNUMBER)) {
            input.setDecimal((Integer)unitParams.get(PARAM_DECEMALSNUMBER));
        }
        if (unitParams.containsKey(PARAM_MONEYUNIT)) {
            input.setUnit(StringUtils.getStringValue(unitParams.get(PARAM_MONEYUNIT)));
        }
        if (StringUtils.isNotEmpty((String)(message = EpmReportServiceHelper.saveCheck(template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"fidm_template"), entityId, dimensionMembers)))) {
            return new EpmApiOutput(false, message);
        }
        Map<Object, Object> reportName = new HashMap(6);
        String modelType = new ModelStrategyEx(modelId).getModel().getModelInfo().getModelType();
        Map<String, DynamicObject> dimMembers = EpmReportServiceHelper.getDimMemberObject(dimensionMembers, modelType);
        if (!useReportNameRule) {
            List<QFilter> qFilters = EpmReportServiceHelper.getReportNameFilters(modelId, template, entityId, dimMembers, modelType);
            ResultInfo checkResult = DisclosureReportNameHelper.checkReportName(name, qFilters);
            if (Boolean.FALSE.equals(checkResult.isSuccess())) {
                return new EpmApiOutput(false, checkResult.getMessage());
            }
            reportName.put(FIELD_NAME, name);
            reportName.put(FIELD_DESQ, 0);
        } else {
            try {
                reportName = EpmReportServiceHelper.getReportNamesByRule(modelId, template, entityId, dimMembers, modelType);
            }
            catch (KDBizException ex) {
                return new EpmApiOutput(false, ex.getMessage());
            }
        }
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)userId);
        Date now = TimeServiceHelper.now();
        Map<String, String> params = EpmReportServiceHelper.getReportParams(modelId, dimensionMembers);
        DynamicObject report = EpmReportServiceHelper.createReportDynamicObject(modelId, catalogId, templateId, canEdit, modelType, entityId, reportName, dimMembers, params, userId, now);
        long reportId = report.getLong("id");
        Object[] oldChapterIds = QueryServiceHelper.query((String)"fidm_chapter", (String)"id", (QFilter[])new QFilter("template", "=", (Object)templateId).toArray()).stream().map(c -> c.getLong("id")).toArray();
        DynamicObject[] oldChapters = BusinessDataServiceHelper.load((Object[])oldChapterIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_chapter"));
        DynamicObjectCollection entryEntities = report.getDynamicObjectCollection("entryentity");
        DynamicObjectType dynamicObjectType = entryEntities.getDynamicObjectType();
        ArrayList newChapters = new ArrayList(oldChapters.length);
        PlatUtil.executeWithTXNew(tx -> {
            for (DynamicObject oldChapter : oldChapters) {
                if (EnableEnum.Disable.toString().equals(oldChapter.getString("enable"))) continue;
                DynamicObject newChapter = EpmChapterServiceHelper.copyChapter(oldChapter, userId, now);
                newChapter.set("template", (Object)0L);
                if (StringUtils.isNotEmpty((String)oldChapter.getString("url"))) {
                    List<DynamicObject> saveNewModules = EpmModuleServiceHelper.copyModules(modelId, oldChapter, newChapter, input);
                    if (!saveNewModules.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])saveNewModules.toArray(new DynamicObject[0]));
                    }
                    if (OpenWordEnum.EPMCLIENT.getType().equals(oldChapter.getString(FIELD_SAVEWORDTYPE))) {
                        if (clientChapterDocuments.containsKey(oldChapter.getString("id"))) {
                            String url = DisclosureFileHelper.upload("fidm_webpreview", newChapter.getLong("id"), newChapter.getString(FIELD_NAME), (String)clientChapterDocuments.get(oldChapter.getString("id")));
                            newChapter.set(FIELD_PREVIEWURL, (Object)url);
                        }
                    } else {
                        EpmChapterServiceHelper.copyChapterFile(modelId, templateId, oldChapter, newChapter, input, dimensionMembers, true);
                    }
                }
                newChapters.add(newChapter);
                DynamicObject reportChapter = (DynamicObject)dynamicObjectType.createInstance();
                reportChapter.set("chapter", (Object)newChapter);
                reportChapter.set("ischeck", (Object)"0");
                entryEntities.add((Object)reportChapter);
            }
            report.set("entryentity", (Object)entryEntities);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{report});
            PermissionHelper.savePermClassEntity(modelId, reportId, "fidm_report", permClassId, OperationStatus.ADDNEW);
            EpmReportServiceHelper.saveReportDimensions(modelId, reportId, dimensionMembers, modelType);
            if (!newChapters.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])newChapters.toArray(new DynamicObject[0]));
                ReportChapterHelper.batchSavePermClass(newChapters);
            }
        });
        String yearNumber = "";
        String periodNumber = "";
        String entityNumber = "";
        String rptName = "";
        if (DisModelTypeEnum.CM.getType().equals(modelType) || DisModelTypeEnum.RPT.getType().equals(modelType)) {
            if (dimMembers.containsKey(FIELD_YEAR)) {
                yearNumber = dimMembers.get(FIELD_YEAR).getString(FIELD_NUMBER);
            }
            if (dimMembers.containsKey(FIELD_PERIOD)) {
                periodNumber = dimMembers.get(FIELD_PERIOD).getString(FIELD_NUMBER);
            }
        } else if (DisModelTypeEnum.EB.getType().equals(modelType)) {
            if (dimMembers.containsKey(FIELD_BUDGETPERIOD)) {
                yearNumber = dimMembers.get(FIELD_BUDGETPERIOD).getString(FIELD_NUMBER);
            }
            if (dimMembers.containsKey(FIELD_VERSION)) {
                periodNumber = dimMembers.get(FIELD_VERSION).getString(FIELD_NUMBER);
            }
        }
        if ((entityOpt = (modelStrategyEx = new ModelStrategyEx(modelId)).getDim().getDimList().stream().filter(x -> x.getNumber().equals(PresetConstant.ENTITY_DIM)).findFirst()).isPresent() && null != (org = modelStrategyEx.getDimMember().findMemberById(entityOpt.get().getEntityName(), entityId))) {
            entityNumber = org.getNumber();
        }
        if (reportName.containsKey(FIELD_NAME)) {
            rptName = reportName.get(FIELD_NAME).toString();
        }
        EpmClientLogHelper.writeCreateReport(OperationResult.SUCCESS, modelId, template.getString(FIELD_NUMBER), yearNumber, periodNumber, entityNumber, rptName);
        return new EpmApiOutput(EpmReportServiceHelper.getReport(modelId, reportId));
    }

    private static String saveCheck(DynamicObject template, long entityId, Map<String, Long> dimensionMembers) {
        if (template == null) {
            return ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u3002", (String)"ReportServiceHelper_7", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (!template.getBoolean(FIELD_STATUS)) {
            return ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u751f\u6210\u62a5\u544a\u3002", (String)"ReportServiceHelper_8", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (entityId == 0L) {
            return ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportServiceHelper_9", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (dimensionMembers == null || dimensionMembers.isEmpty() || dimensionMembers.containsValue(0L)) {
            return ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportServiceHelper_10", (String)"epm-far-business", (Object[])new Object[0]);
        }
        return StringUtils.getEmpty();
    }

    private static Map<String, DynamicObject> getDimMemberObject(Map<String, Long> dimensionMembers, String modelType) {
        HashMap<String, DynamicObject> dimMembers = new HashMap<String, DynamicObject>(6);
        dimensionMembers.forEach((k, v) -> {
            if (DisModelTypeEnum.CM.getType().equals(modelType) || DisModelTypeEnum.RPT.getType().equals(modelType)) {
                if (PresetConstant.FY_DIM.equals(k)) {
                    dimMembers.put(FIELD_YEAR, BusinessDataServiceHelper.loadSingle((Object)v, (String)"bcm_fymembertree"));
                } else if (PresetConstant.PERIOD_DIM.equals(k)) {
                    dimMembers.put(FIELD_PERIOD, BusinessDataServiceHelper.loadSingle((Object)v, (String)"bcm_periodmembertree"));
                } else if (PresetConstant.SCENE_DIM.equals(k)) {
                    dimMembers.put(FIELD_SCENARIO, BusinessDataServiceHelper.loadSingle((Object)v, (String)"bcm_scenemembertree"));
                }
            } else if (DisModelTypeEnum.EB.getType().equals(modelType)) {
                if (DmDimMemberEntityEnum.EPM_BPERIOD.getNumber().equals(k)) {
                    dimMembers.put(FIELD_BUDGETPERIOD, BusinessDataServiceHelper.loadSingle((Object)v, (String)"epm_bperiodmembertree"));
                } else if (DmDimMemberEntityEnum.EPM_VERSION.getNumber().equals(k)) {
                    dimMembers.put(FIELD_VERSION, BusinessDataServiceHelper.loadSingle((Object)v, (String)"epm_versionmembertree"));
                } else if (DmDimMemberEntityEnum.EPM_DATATYPE.getNumber().equals(k)) {
                    dimMembers.put(FIELD_DATATYPE, BusinessDataServiceHelper.loadSingle((Object)v, (String)"epm_datatypemembertree"));
                }
            }
        });
        return dimMembers;
    }

    private static DynamicObject createReportDynamicObject(long modelId, long catalogId, long templateId, boolean canEdit, String modelType, long entityId, Map<String, Object> reportNames, Map<String, DynamicObject> dimMembers, Map<String, String> params, long userId, Date now) {
        DimMemberInfo member;
        DynamicObject report = BusinessDataServiceHelper.newDynamicObject((String)"fidm_report");
        report.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        report.set("templatecatalog", (Object)catalogId);
        report.set("template", (Object)templateId);
        report.set(FIELD_ISEDIT, (Object)(canEdit ? "0" : "1"));
        report.set(FIELD_MODEL, (Object)modelId);
        report.set(FIELD_STATUS, (Object)MyReportStatusEnum.UNCOMMIT.getValue());
        report.set(FIELD_ISARCHIVED, (Object)MyReportStatusEnum.UNARCHIVE.getValue());
        report.set(FIELD_ISPREVIEW, (Object)"0");
        report.set("creator", (Object)userId);
        report.set("createtime", (Object)now);
        report.set("modifier", (Object)userId);
        report.set(FIELD_MODIFYTIME, (Object)now);
        report.set(FIELD_NAME, reportNames.get(FIELD_NAME));
        report.set(FIELD_DESQ, reportNames.get(FIELD_DESQ));
        if (DisModelTypeEnum.CM.getType().equals(modelType) || DisModelTypeEnum.RPT.getType().equals(modelType)) {
            report.set(FIELD_BCMENTITY, (Object)entityId);
            report.set(FIELD_YEAR, (Object)dimMembers.get(FIELD_YEAR).getLong("id"));
            report.set(FIELD_PERIOD, (Object)dimMembers.get(FIELD_PERIOD).getLong("id"));
            if (dimMembers.containsKey(FIELD_SCENARIO)) {
                report.set(FIELD_SCENARIO, (Object)dimMembers.get(FIELD_SCENARIO).getLong("id"));
            }
        } else if (DisModelTypeEnum.EB.getType().equals(modelType)) {
            report.set(FIELD_EPMENTITY, (Object)entityId);
            report.set(FIELD_BUDGETPERIOD, (Object)dimMembers.get(FIELD_BUDGETPERIOD).getLong("id"));
            report.set(FIELD_VERSION, (Object)dimMembers.get(FIELD_VERSION).getLong("id"));
            if (dimMembers.containsKey(FIELD_DATATYPE)) {
                report.set(FIELD_DATATYPE, (Object)dimMembers.get(FIELD_DATATYPE).getLong("id"));
            }
        }
        String param = StringUtils.getEmpty();
        String paramNumber = StringUtils.getEmpty();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        List<DimensionInfo> allDimensions = modelStrategyEx.getDim().getDimList();
        DimensionInfo entityDim = DimensionUtils.getDimByNumber(allDimensions, PresetConstant.ENTITY_DIM);
        if (entityDim != null && (member = modelStrategyEx.getDimMember().findMemberById(entityDim.getEntityName(), entityId)) != null) {
            param = params.get(FIELD_PARAM) + entityDim.getName() + "." + member.getName();
            paramNumber = params.get(FIELD_PARAMNUMBER) + entityDim.getNumber() + "." + member.getNumber();
        }
        report.set(FIELD_PARAM, (Object)new LocaleString(param));
        report.set(FIELD_PARAMNUMBER, (Object)paramNumber);
        return report;
    }

    private static Map<String, Object> getReportNamesByRule(long modelId, DynamicObject template, long entityId, Map<String, DynamicObject> dimMembers, String modelType) {
        String entityName = "bcm_entitymembertree";
        if (DisModelTypeEnum.EB.getType().equals(modelType)) {
            entityName = "epm_entitymembertree";
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qfBuilder.add(new QFilter("id", "=", (Object)entityId));
        Map entityDys = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])qfBuilder.toArray());
        DynamicObject entity = (DynamicObject)entityDys.get(entityId);
        return EpmReportServiceHelper.getReportNameByRule(modelId, template, entity, dimMembers, modelType);
    }

    private static Map<String, Object> getReportNameByRule(long modelId, DynamicObject template, DynamicObject entity, Map<String, DynamicObject> dimMembers, String modelType) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (entity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"ReportServiceHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
        }
        StringBuilder reportName = new StringBuilder();
        DynamicObjectCollection reportNameRules = template.getDynamicObjectCollection("reportnamedefined");
        if (reportNameRules.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u544a\u540d\u79f0\u751f\u6210\u89c4\u5219\u4e0d\u5b58\u5728\u3002", (String)"ReportServiceHelper_15", (String)"epm-far-business", (Object[])new Object[0]));
        }
        for (DynamicObject rule : reportNameRules) {
            String fieldType;
            String fieldName = rule.getString("fieldname");
            String valueType = rule.getString("valuetype");
            switch (fieldType = fieldName.substring(0, 3)) {
                case "dim": {
                    EpmReportServiceHelper.getReportNameByRuleDim(fieldName, valueType, entity, dimMembers, reportName);
                    EpmReportServiceHelper.addSeparator(reportName, rule);
                    break;
                }
                case "val": {
                    reportName.append(rule.getString("value"));
                    EpmReportServiceHelper.addSeparator(reportName, rule);
                    break;
                }
                case "dsq": {
                    int dseq = EpmReportServiceHelper.getMaxDseq(modelId, template, entity, dimMembers, modelType);
                    reportName.append(dseq);
                    EpmReportServiceHelper.addSeparator(reportName, rule);
                    result.put(FIELD_DESQ, dseq);
                    break;
                }
                case "dat": {
                    if ("3".equals(valueType)) {
                        reportName.append(DateTimeUtils.format((Date)new Date(), (String)"dd"));
                    } else if ("4".equals(valueType)) {
                        reportName.append(DateTimeUtils.format((Date)new Date(), (String)"MMdd"));
                    } else if ("5".equals(valueType)) {
                        reportName.append(DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
                    }
                    EpmReportServiceHelper.addSeparator(reportName, rule);
                    break;
                }
                case "tna": {
                    reportName.append(template.getString(FIELD_NAME));
                    EpmReportServiceHelper.addSeparator(reportName, rule);
                    break;
                }
                case "tnm": {
                    reportName.append(template.getString(FIELD_NUMBER));
                    EpmReportServiceHelper.addSeparator(reportName, rule);
                    break;
                }
            }
        }
        String name = EpmReportServiceHelper.checkReportName(modelId, template, entity, dimMembers, modelType, reportName.toString());
        if (name.length() > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u544a\u540d\u79f0\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\uff0c\u6700\u5927\u957f\u5ea6\u4e3a100\u3002", (String)"ReportServiceHelper_12", (String)"epm-far-business", (Object[])new Object[0]));
        }
        result.put(FIELD_NAME, name);
        return result;
    }

    private static void getReportNameByRuleDim(String fieldName, String valueType, DynamicObject entity, Map<String, DynamicObject> dimMembers, StringBuilder reportName) {
        String dimNumber = fieldName.split("/")[1].split("_")[0];
        if ("entity".equals(dimNumber)) {
            switch (valueType) {
                case "1": {
                    reportName.append(entity.getString(FIELD_NUMBER));
                    break;
                }
                case "2": {
                    reportName.append(entity.getString(FIELD_NAME));
                    break;
                }
            }
        } else {
            switch (valueType) {
                case "1": {
                    reportName.append(dimMembers.get(dimNumber).getString(FIELD_NUMBER));
                    break;
                }
                case "2": {
                    reportName.append(dimMembers.get(dimNumber).getString(FIELD_NAME));
                    break;
                }
            }
        }
    }

    private static String checkReportName(long modelId, DynamicObject template, DynamicObject entity, Map<String, DynamicObject> dimMembers, String modelType, String name) {
        List<String> existNames = EpmReportServiceHelper.getDbReportNames(modelId, template, entity, dimMembers, modelType);
        if (existNames.isEmpty()) {
            return name;
        }
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String newName;
            String string = newName = i == 0 ? name : name + "(" + i + ")";
            if (existNames.contains(newName)) continue;
            name = newName;
            break;
        }
        return name;
    }

    private static int getMaxDseq(long modelId, DynamicObject template, DynamicObject entity, Map<String, DynamicObject> dimMembers, String modelType) {
        List<QFilter> qFilters = EpmReportServiceHelper.getReportNameFilters(modelId, template, entity.getLong("id"), dimMembers, modelType);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_report", (String)FIELD_DESQ, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"desq desc", (int)1);
        if (dys != null && !dys.isEmpty()) {
            return ((DynamicObject)dys.get(0)).getInt(FIELD_DESQ) + 1;
        }
        return 1;
    }

    private static List<String> getDbReportNames(long modelId, DynamicObject template, DynamicObject entity, Map<String, DynamicObject> dimMembers, String modelType) {
        List<QFilter> qFilters = EpmReportServiceHelper.getReportNameFilters(modelId, template, entity.getLong("id"), dimMembers, modelType);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_report", (String)FIELD_NAME, (QFilter[])qFilters.toArray(new QFilter[0]));
        return dys.stream().map(x -> x.getString(FIELD_NAME)).collect(Collectors.toList());
    }

    private static List<QFilter> getReportNameFilters(long modelId, DynamicObject template, long entityId, Map<String, DynamicObject> dimMembers, String modelType) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter(FIELD_TEMPLATE_ID, "=", (Object)template.getLong("id")));
        qFilters.add(new QFilter(FIELD_ISPREVIEW, "=", (Object)"0"));
        if (DisModelTypeEnum.CM.getType().equals(modelType) || DisModelTypeEnum.RPT.getType().equals(modelType)) {
            qFilters.add(new QFilter(FIELD_BCMENTITY, "=", (Object)entityId));
            qFilters.add(new QFilter(FIELD_YEAR, "=", (Object)dimMembers.get(FIELD_YEAR).getLong("id")));
            qFilters.add(new QFilter(FIELD_PERIOD, "=", (Object)dimMembers.get(FIELD_PERIOD).getLong("id")));
            if (dimMembers.containsKey(FIELD_SCENARIO)) {
                qFilters.add(new QFilter(FIELD_SCENARIO, "=", (Object)dimMembers.get(FIELD_SCENARIO).getLong("id")));
            }
        } else if (DisModelTypeEnum.EB.getType().equals(modelType)) {
            qFilters.add(new QFilter(FIELD_EPMENTITY, "=", (Object)entityId));
            qFilters.add(new QFilter(FIELD_BUDGETPERIOD, "=", (Object)dimMembers.get(FIELD_BUDGETPERIOD).getLong("id")));
            qFilters.add(new QFilter(FIELD_VERSION, "=", (Object)dimMembers.get(FIELD_VERSION).getLong("id")));
            if (dimMembers.containsKey(FIELD_DATATYPE)) {
                qFilters.add(new QFilter(FIELD_DATATYPE, "=", (Object)dimMembers.get(FIELD_DATATYPE).getLong("id")));
            }
        }
        return qFilters;
    }

    private static void addSeparator(StringBuilder reportName, DynamicObject rule) {
        switch (rule.getString("breakcombo")) {
            case "1": {
                reportName.append("-");
                break;
            }
            case "2": {
                reportName.append(".");
                break;
            }
            case "3": {
                reportName.append(" ");
                break;
            }
        }
    }

    private static Map<String, String> getReportParams(long modelId, Map<String, Long> dimensionMembers) {
        StringBuilder param = new StringBuilder();
        StringBuilder paramNumber = new StringBuilder();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        List<DimensionInfo> allDimensions = modelStrategyEx.getDim().getDimList();
        dimensionMembers.forEach((k, v) -> {
            DimMemberInfo member;
            DimensionInfo dim = DimensionUtils.getDimByNumber(allDimensions, k);
            if (dim != null && (member = modelStrategyEx.getDimMember().findMemberById(dim.getEntityName(), (Long)v)) != null) {
                param.append(dim.getName());
                param.append(".");
                param.append(member.getName());
                param.append(";");
                paramNumber.append((String)k);
                paramNumber.append(".");
                paramNumber.append(member.getNumber());
                paramNumber.append(";");
            }
        });
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put(FIELD_PARAM, param.toString());
        result.put(FIELD_PARAMNUMBER, paramNumber.toString());
        return result;
    }

    private static void saveReportDimensions(long modelId, long reportId, Map<String, Long> dimensionMembers, String modelType) {
        List<DimensionInfo> allDimensions = new ModelStrategyEx(modelId).getDim().getDimList();
        ArrayList reportDims = new ArrayList(dimensionMembers.size());
        if (DisModelTypeEnum.CM.getType().equals(modelType) || DisModelTypeEnum.RPT.getType().equals(modelType)) {
            dimensionMembers.forEach((k, v) -> {
                DimensionInfo dim = DimensionUtils.getDimByNumber(allDimensions, k);
                if (dim != null) {
                    DynamicObject reportDim = BusinessDataServiceHelper.newDynamicObject((String)"fidm_report_dim");
                    reportDim.set(FIELD_REPORT, (Object)reportId);
                    reportDim.set("dimid", (Object)dim.getId());
                    reportDim.set(FIELD_DIMMEMBERID, v);
                    reportDim.set(FIELD_DIMTYPE, (Object)"bcm_dimension");
                    reportDims.add(reportDim);
                }
            });
        } else if (DisModelTypeEnum.EB.getType().equals(modelType)) {
            dimensionMembers.forEach((k, v) -> {
                DimensionInfo dim = DimensionUtils.getDimByNumber(allDimensions, k);
                if (dim != null) {
                    DynamicObject reportDim = BusinessDataServiceHelper.newDynamicObject((String)"fidm_report_dim");
                    reportDim.set(FIELD_REPORT, (Object)reportId);
                    reportDim.set("dimid", (Object)dim.getId());
                    reportDim.set(FIELD_DIMMEMBERID, v);
                    reportDim.set(FIELD_DIMTYPE, (Object)"epm_dimension");
                    reportDims.add(reportDim);
                }
            });
        }
        if (!reportDims.isEmpty()) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)reportDims.get(0)).getDynamicObjectType(), (Object[])reportDims.toArray());
        }
    }

    private static long getReportPermClass(long modelId, long reportId) {
        QFBuilder permFilter = new QFBuilder();
        permFilter.add(new QFilter("fidmmodel", "=", (Object)modelId));
        permFilter.add(new QFilter(FIELD_ENTITYID, "=", (Object)reportId));
        permFilter.add(new QFilter("entityname", "=", (Object)"fidm_report"));
        DynamicObject permClassEntity = QueryServiceHelper.queryOne((String)"bcm_permclass_entity", (String)"permclass", (QFilter[])permFilter.toArray());
        if (permClassEntity != null) {
            return permClassEntity.getLong("permclass");
        }
        return 0L;
    }
}

