/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.util.PlatUtil;
import kd.epm.far.business.epmclient.EpmChapterServiceHelper;
import kd.epm.far.business.epmclient.EpmModuleServiceHelper;
import kd.epm.far.business.epmclient.dto.EpmApiOutput;
import kd.epm.far.business.fidm.chapter.DisclosureCopyHelper;
import kd.epm.far.business.fidm.report.ReportChapterHelper;
import kd.epm.far.business.fidm.template.DisclosureTemplateHelper;
import kd.epm.far.business.fidm.template.dto.Template;
import kd.epm.far.business.fidm.template.dto.TemplateDimension;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class EpmTemplateServiceHelper {
    public static List<Template> getTemplates(long modelId, List<Long> templateIds, long catalogId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("outputtype", "=", (Object)String.valueOf(1)));
        qFilters.add(new QFilter("templatecatalog.catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        if (templateIds != null) {
            qFilters.add(new QFilter("id", "in", templateIds));
            if (templateIds.isEmpty()) {
                return new ArrayList<Template>(0);
            }
        }
        if (catalogId > 0L) {
            qFilters.add(new QFilter("templatecatalog.id", "=", (Object)catalogId));
        }
        QFilter permqFilter = PermissionHelper.getReadAndWritePermFilter(modelId, "fidm_template");
        qFilters.add(permqFilter);
        Map templateDatas = BusinessDataServiceHelper.loadFromCache((String)"fidm_template", (QFilter[])qFilters.toArray(new QFilter[0]));
        List<Long> ids = templateDatas.values().stream().map(t -> t.getLong("id")).collect(Collectors.toList());
        Map<Long, Boolean> hasChapterIds = EpmTemplateServiceHelper.templateHasChapter(modelId, ids);
        ArrayList<Template> templates = new ArrayList<Template>(templateDatas.size());
        for (DynamicObject dy : templateDatas.values()) {
            TemplateDimension dimension;
            Template template = new Template();
            template.setId(dy.getLong("id"));
            template.setNumber(dy.getString("number"));
            template.setName(dy.getString("name"));
            template.setCatalogId(dy.getLong("templatecatalog.id"));
            template.setDseq(dy.getInt("sequence"));
            template.setStatus(dy.getBoolean("status"));
            template.setDescription(dy.getString("description"));
            template.setPermClassId(dy.getLong("permclass.id"));
            template.setPermClassNumber(dy.getString("permclass.number"));
            template.setCatalogName(dy.getString("templatecatalog.name"));
            template.setCreateTime(dy.getDate("createtime"));
            template.setCreator(dy.getString("creator.name"));
            template.setModifyTime(dy.getDate("modifytime"));
            template.setModifier(dy.getString("modifier.name"));
            template.setHasReportNameRule(!dy.getDynamicObjectCollection("reportnamedefined").isEmpty());
            if (hasChapterIds.containsKey(template.getId())) {
                template.setHasChapter(hasChapterIds.get(template.getId()));
            }
            DynamicObjectCollection dimDatas = dy.getDynamicObjectCollection("defmembentry");
            ArrayList<TemplateDimension> dimensions = new ArrayList<TemplateDimension>(dimDatas.size());
            for (DynamicObject dimRow : dimDatas) {
                dimension = new TemplateDimension();
                dimension.setId(dimRow.getLong("id"));
                if (dimRow.getDynamicObject("defdimension") != null) {
                    dimension.setDimensionId(dimRow.getDynamicObject("defdimension").getLong("id"));
                }
                dimension.setMemberId(dimRow.getLong("defmemberid"));
                dimension.setDseq(dimRow.getInt("seq"));
                dimension.setDimensionType(dimRow.getString("defdimtype"));
                dimensions.add(dimension);
            }
            template.setTemplateDimensions(dimensions);
            dimDatas = dy.getDynamicObjectCollection("parammembentry");
            dimensions = new ArrayList(dimDatas.size());
            for (DynamicObject dimRow : dimDatas) {
                dimension = new TemplateDimension();
                dimension.setId(dimRow.getLong("id"));
                if (dimRow.getDynamicObject("paramdimension") != null) {
                    dimension.setDimensionId(dimRow.getDynamicObject("paramdimension").getLong("id"));
                }
                dimension.setDseq(dimRow.getInt("seq"));
                dimension.setDimensionType(dimRow.getString("paramdimtype"));
                dimensions.add(dimension);
            }
            template.setTemplateParamDimensions(dimensions);
            templates.add(template);
        }
        return templates;
    }

    public static EpmApiOutput copyTemplate(long modelId, long oldTemplateId) {
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)userId);
        Date now = TimeServiceHelper.now();
        if (!DisclosureTemplateHelper.hasWritePermission(modelId, oldTemplateId)) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u6a21\u677f\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"DisclosureTemplateHelper_31", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObject oldTemplate = BusinessDataServiceHelper.loadSingle((Object)oldTemplateId, (String)"fidm_template");
        Object[] chapterIds = QueryServiceHelper.query((String)"fidm_chapter", (String)"id", (QFilter[])new QFilter("template", "=", (Object)oldTemplateId).toArray()).stream().map(c -> c.getLong("id")).toArray();
        DynamicObject[] oldChapters = BusinessDataServiceHelper.load((Object[])chapterIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_chapter"));
        Pair<String, String> numberName = EpmTemplateServiceHelper.getCopyTemplateNumberName(modelId, oldTemplate.getString("number"), oldTemplate.getString("name"));
        if (((String)numberName.p1).length() > 50) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u590d\u5236\u540e\u7684\u6a21\u677f\u7f16\u7801\u957f\u5ea6\u8d85\u8fc7\u4e8650\u3002", (String)"DisclosureTemplateHelper_26", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (((String)numberName.p2).length() > 100) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u590d\u5236\u540e\u7684\u6a21\u677f\u540d\u79f0\u957f\u5ea6\u8d85\u8fc7\u4e86100\u3002", (String)"DisclosureTemplateHelper_27", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObject newTemplate = BusinessDataServiceHelper.newDynamicObject((String)"fidm_template");
        long newTemplateId = GlobalIdUtil.genGlobalLongId();
        newTemplate.set("id", (Object)newTemplateId);
        newTemplate.set("number", numberName.p1);
        newTemplate.set("name", numberName.p2);
        newTemplate.set("creator", (Object)userId);
        newTemplate.set("createtime", (Object)now);
        newTemplate.set("modifier", (Object)userId);
        newTemplate.set("modifytime", (Object)now);
        newTemplate.set("status", (Object)"0");
        newTemplate.set("sequence", (Object)DisclosureTemplateHelper.getMaxDesq(modelId, oldTemplate.getLong("templatecatalog.id")));
        newTemplate.set("model", (Object)oldTemplate.getLong("model.id"));
        newTemplate.set("templatecatalog", (Object)oldTemplate.getLong("templatecatalog.id"));
        newTemplate.set("permclass", (Object)oldTemplate.getLong("permclass.id"));
        newTemplate.set("description", (Object)oldTemplate.getString("description"));
        newTemplate.set("outputtype", (Object)oldTemplate.getString("outputtype"));
        EpmTemplateServiceHelper.copyTemplateDimParam(newTemplate, oldTemplate);
        PlatUtil.executeWithTXNew(tx -> {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newTemplate});
            PermissionHelper.savePermClassEntity(modelId, newTemplateId, "fidm_template", oldTemplate.getLong("permclass.id"), OperationStatus.ADDNEW);
            CloneUtils cloneUtils = new CloneUtils(true, true);
            ArrayList<DynamicObject> newChapters = new ArrayList<DynamicObject>(oldChapters.length);
            for (DynamicObject oldChapter : oldChapters) {
                DynamicObject newChapter = EpmChapterServiceHelper.copyChapter(oldChapter, userId, now);
                newChapter.set("template", (Object)newTemplateId);
                long oldChapterId = oldChapter.getLong("id");
                long newChapterId = newChapter.getLong("id");
                if (StringUtils.isEmpty((String)oldChapter.getString("url"))) {
                    newChapters.add(newChapter);
                    continue;
                }
                List<DynamicObject> saveNewModules = EpmModuleServiceHelper.copyModules(modelId, oldChapter, newChapter, null);
                if (!saveNewModules.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])saveNewModules.toArray(new DynamicObject[0]));
                }
                EpmChapterServiceHelper.copyChapterFile(modelId, oldTemplateId, oldChapter, newChapter, null, null, false);
                DisclosureCopyHelper.copyVariable(cloneUtils, oldChapterId, newChapterId, user, now);
                DisclosureCopyHelper.copyDataSet(cloneUtils, oldChapterId, newChapterId, user, now);
                newChapters.add(newChapter);
            }
            if (!newChapters.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])newChapters.toArray(new DynamicObject[0]));
                ReportChapterHelper.batchSavePermClass(newChapters);
            }
        });
        ArrayList<Long> templateIds = new ArrayList<Long>(1);
        templateIds.add(newTemplate.getLong("id"));
        return new EpmApiOutput(EpmTemplateServiceHelper.getTemplates(modelId, templateIds, 0L).get(0));
    }

    private static Map<Long, Boolean> templateHasChapter(long modelId, List<Long> templateIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("template", "in", templateIds));
        DynamicObjectCollection chapters = QueryServiceHelper.query((String)"fidm_chapter", (String)"template", (QFilter[])qFilters.toArray(new QFilter[0]));
        List hasChapterIds = chapters.stream().map(c -> c.getLong("template")).distinct().collect(Collectors.toList());
        HashMap<Long, Boolean> results = new HashMap<Long, Boolean>(templateIds.size());
        for (long templateId : templateIds) {
            results.put(templateId, hasChapterIds.contains(templateId));
        }
        return results;
    }

    private static Pair<String, String> getCopyTemplateNumberName(long modelId, String number, String name) {
        String newNumber = number + "copy";
        String newName = name + "copy";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("outputtype", "=", (Object)String.valueOf(1)));
        qFilters.add(new QFilter("templatecatalog.catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"fidm_template", (String)"number,name", (QFilter[])qFilters.toArray(new QFilter[0]));
        for (int i = 0; i < templates.size(); ++i) {
            boolean flag1 = false;
            boolean flag2 = false;
            String finalNewNumber = newNumber;
            String finalNewName = newName;
            if (templates.stream().anyMatch(chapter -> chapter.getString("number").equals(finalNewNumber))) {
                flag1 = true;
                newNumber = number + "copy" + StringUtils.getStringValue((Object)(i + 1));
            }
            if (templates.stream().anyMatch(chapter -> chapter.getString("name").equals(finalNewName))) {
                flag2 = true;
                newName = name + "copy(" + (i + 1) + ")";
            }
            if (!flag1 && !flag2) break;
        }
        return new Pair((Object)newNumber, (Object)newName);
    }

    private static void copyTemplateDimParam(DynamicObject newTemplate, DynamicObject oldTemplate) {
        DynamicObjectCollection defmembentry = newTemplate.getDynamicObjectCollection("defmembentry");
        defmembentry.clear();
        for (Object oldDimParam : oldTemplate.getDynamicObjectCollection("defmembentry")) {
            DynamicObject dyn = new DynamicObject(defmembentry.getDynamicObjectType());
            dyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dyn.set("defdimension", (Object)oldDimParam.getDynamicObject("defdimension"));
            dyn.set("defmemberid", (Object)oldDimParam.getLong("defmemberid"));
            dyn.set("seq", (Object)oldDimParam.getInt("seq"));
            dyn.set("defdimtype", (Object)oldDimParam.getString("defdimtype"));
            defmembentry.add((Object)dyn);
        }
        DynamicObjectCollection parammembentry = newTemplate.getDynamicObjectCollection("parammembentry");
        parammembentry.clear();
        for (DynamicObject oldDimParam : oldTemplate.getDynamicObjectCollection("parammembentry")) {
            DynamicObject dyn = new DynamicObject(parammembentry.getDynamicObjectType());
            dyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dyn.set("paramdimension", (Object)oldDimParam.getDynamicObject("paramdimension"));
            dyn.set("seq", (Object)oldDimParam.getInt("seq"));
            dyn.set("paramdimtype", (Object)oldDimParam.getString("paramdimtype"));
            parammembentry.add((Object)dyn);
        }
        DynamicObjectCollection reportnamedefined = newTemplate.getDynamicObjectCollection("reportnamedefined");
        reportnamedefined.clear();
        for (DynamicObject oldNameDefined : oldTemplate.getDynamicObjectCollection("reportnamedefined")) {
            DynamicObject dyn = new DynamicObject(reportnamedefined.getDynamicObjectType());
            dyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dyn.set("fieldname", (Object)oldNameDefined.getString("fieldname"));
            dyn.set("valuetype", (Object)oldNameDefined.getString("valuetype"));
            dyn.set("value", (Object)oldNameDefined.getString("value"));
            dyn.set("breakcombo", (Object)oldNameDefined.getString("breakcombo"));
            dyn.set("desq", (Object)oldNameDefined.getInt("desq"));
            dyn.set("seq", (Object)oldNameDefined.getInt("seq"));
            reportnamedefined.add((Object)dyn);
        }
    }

    public static Pair<String, String> getDefaultTemplateNumberName(long modelId) {
        String number = "TemplateNumber";
        String name = ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0", (String)"DisclosureTemplateHelper_7", (String)"epm-far-business", (Object[])new Object[0]);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("outputtype", "=", (Object)String.valueOf(1)));
        qFilters.add(new QFilter("templatecatalog.catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"fidm_template", (String)"number,name", (QFilter[])qFilters.toArray(new QFilter[0]));
        String newNumber = number;
        String newName = name;
        for (int i = 0; i < templates.size(); ++i) {
            boolean flag1 = false;
            boolean flag2 = false;
            String finalNewNumber = newNumber;
            String finalNewName = newName;
            if (templates.stream().anyMatch(chapter -> chapter.getString("number").equals(finalNewNumber))) {
                flag1 = true;
                newNumber = number + StringUtils.getStringValue((Object)(i + 1));
            }
            if (templates.stream().anyMatch(chapter -> chapter.getString("name").equals(finalNewName))) {
                flag2 = true;
                newName = name + "(" + (i + 1) + ")";
            }
            if (!flag1 && !flag2) break;
        }
        return new Pair((Object)newNumber, (Object)newName);
    }
}

