/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.service.VersionService;
import kd.bos.portal.service.bo.Version;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.epmclient.dto.EpmClientVersion;
import org.apache.commons.lang3.StringUtils;

public class VersionHelper {
    private static Log log = LogFactory.getLog(VersionHelper.class);

    public static String getVersion() {
        List versions = VersionService.getVersionInfos();
        Iterator versionIterator = versions.iterator();
        String versionNum = "0.0.000.0";
        while (versionIterator.hasNext()) {
            Version version = (Version)versionIterator.next();
            if (!version.getProductNumber().startsWith("constellation_")) continue;
            versionNum = version.getVersion();
        }
        return versionNum;
    }

    public static EpmClientVersion getEpmClientPackageInfoByVersion(String version, boolean isLatest) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("status", "=", (Object)true));
        qFilters.add(new QFilter("userwhitelist.fbasedataid", "=", (Object)RequestContext.get().getCurrUserId()).or(new QFilter("userwhitelist.fbasedataid", "is null", null)));
        String selectFields = "id,version,attach.fbasedataid.url url";
        DynamicObjectCollection clientInfos = QueryServiceHelper.query((String)"bcm_epmclient_info", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"version desc");
        if (clientInfos.isEmpty()) {
            return null;
        }
        List ids = clientInfos.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        QFilter idsFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection remarks = QueryServiceHelper.query((String)"bcm_epmclient_info", (String)"id,remark", (QFilter[])new QFilter[]{idsFilter});
        Map<Long, String> idToRemarkMap = remarks.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("remark")));
        ArrayList<EpmClientVersion> epmVersions = new ArrayList<EpmClientVersion>(16);
        version = version.toUpperCase().replace("V", "").trim();
        for (DynamicObject clientInfo : clientInfos) {
            EpmClientVersion epmClientVersion;
            String versionTarget = clientInfo.getString("version").toUpperCase().replace("V", "").trim();
            Long id = clientInfo.getLong("id");
            if (isLatest) {
                if (VersionHelper.compareVersion(version, versionTarget) >= 0) continue;
                epmClientVersion = new EpmClientVersion();
                epmClientVersion.setVersion(clientInfo.getString("version"));
                if (idToRemarkMap.containsKey(id)) {
                    epmClientVersion.setRemark(idToRemarkMap.get(id));
                }
                epmClientVersion.setUrl(clientInfo.getString("url"));
                epmClientVersion.setFullVersion(VersionHelper.getFullVersion(versionTarget));
                epmVersions.add(epmClientVersion);
                continue;
            }
            if (!version.equals(versionTarget)) continue;
            epmClientVersion = new EpmClientVersion();
            epmClientVersion.setVersion(clientInfo.getString("version"));
            if (idToRemarkMap.containsKey(id)) {
                epmClientVersion.setRemark(idToRemarkMap.get(id));
            }
            epmClientVersion.setUrl(clientInfo.getString("url"));
            return epmClientVersion;
        }
        if (isLatest && !epmVersions.isEmpty()) {
            return VersionHelper.getLatestVersion(epmVersions);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] getFileBytes(String fileUrl) {
        block28: {
            byte[] byArray;
            Throwable throwable;
            BufferedInputStream inStream;
            ByteArrayOutputStream output;
            block27: {
                block25: {
                    block26: {
                        FileService fs = FileServiceFactory.getAttachmentFileService();
                        output = new ByteArrayOutputStream();
                        if (!kd.bos.util.StringUtils.isNotEmpty((String)fileUrl) || !fs.exists(fileUrl)) break block28;
                        inStream = new BufferedInputStream(fs.getInputStream(fileUrl));
                        throwable = null;
                        byte[] buf = new byte[1024];
                        int numBytesRead = 0;
                        while ((numBytesRead = inStream.read(buf)) != -1) {
                            output.write(buf, 0, numBytesRead);
                        }
                        byArray = output.toByteArray();
                        if (inStream == null) break block25;
                        if (throwable == null) break block26;
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block25;
                    }
                    inStream.close();
                }
                if (output.size() != 0) break block27;
                try {
                    output.close();
                }
                catch (IOException e) {
                    log.error("download_file failed on URL: " + fileUrl, (Throwable)e);
                }
            }
            return byArray;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (inStream != null) {
                                    if (throwable != null) {
                                        try {
                                            inStream.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        inStream.close();
                                    }
                                }
                                throw throwable4;
                            }
                        }
                        catch (IOException e) {
                            log.error("download_file failed on URL: " + fileUrl, (Throwable)e);
                            if (output.size() == 0) {
                                try {
                                    output.close();
                                }
                                catch (IOException e2) {
                                    log.error("download_file failed on URL: " + fileUrl, (Throwable)e2);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable6) {
                        if (output.size() == 0) {
                            try {
                                output.close();
                            }
                            catch (IOException e) {
                                log.error("download_file failed on URL: " + fileUrl, (Throwable)e);
                            }
                        }
                        throw throwable6;
                    }
                }
            }
        }
        return new byte[0];
    }

    private static int compareVersion(String version1, String version2) {
        String[] versionArray1 = version1.split("\\.");
        String[] versionArray2 = version2.split("\\.");
        if (versionArray1.length != 3 || versionArray2.length != 3) {
            return 0;
        }
        int diff = 0;
        for (int index = 0; index < 2 && (diff = versionArray1[index].length() - versionArray2[index].length()) == 0 && (diff = versionArray1[index].compareTo(versionArray2[index])) == 0; ++index) {
        }
        if (diff == 0) {
            String thirdStr1 = StringUtils.rightPad((String)versionArray1[2], (int)4, (String)"0");
            String thirdStr2 = StringUtils.rightPad((String)versionArray2[2], (int)4, (String)"0");
            diff = Integer.parseInt(thirdStr1) - Integer.parseInt(thirdStr2);
        }
        return diff;
    }

    private static String getFullVersion(String version) {
        String[] versionArray = version.split("\\.");
        String first = StringUtils.leftPad((String)versionArray[0], (int)4, (String)"0");
        String second = StringUtils.leftPad((String)versionArray[1], (int)4, (String)"0");
        String third = StringUtils.rightPad((String)versionArray[2], (int)4, (String)"0");
        return String.format("%s.%s.%s", first, second, third);
    }

    private static EpmClientVersion getLatestVersion(List<EpmClientVersion> versions) {
        Collections.sort(versions);
        String remarks = "";
        for (EpmClientVersion version : versions) {
            if (!kd.bos.util.StringUtils.isNotEmpty((String)version.getRemark())) continue;
            remarks = remarks.concat(version.getRemark());
        }
        EpmClientVersion latest = versions.get(versions.size() - 1);
        latest.setRemark(remarks);
        return latest;
    }
}

