/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient.module;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleEntity;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleService;
import kd.epm.far.business.common.module.middle.dto.BCMSectionShareModule;
import kd.epm.far.business.common.module.middle.dto.CommonShareModule;
import kd.epm.far.business.common.module.middle.dto.EBSectionShareModule;
import kd.epm.far.business.common.module.middle.dto.LineShareModule;
import kd.epm.far.business.common.module.middle.dto.PieShareModule;
import kd.epm.far.business.common.module.middle.dto.PointShareModule;
import kd.epm.far.business.common.module.middle.dto.ReportInfoShareModule;
import kd.epm.far.business.common.module.middle.dto.TableShareModule;
import kd.epm.far.business.epmclient.module.convert.ComboChartModuleConvert;
import kd.epm.far.business.epmclient.module.convert.DataPointModuleConvert;
import kd.epm.far.business.epmclient.module.convert.ReportInfoModuleConvert;
import kd.epm.far.business.epmclient.module.convert.ReportSectionModuleConvert;
import kd.epm.far.business.epmclient.module.convert.TableModuleConvert;
import kd.epm.far.business.epmclient.module.convert.TocModuleConvert;
import kd.epm.far.business.epmclient.module.convert.XYAxisChartModuleConvert;
import kd.epm.far.business.epmclient.module.convert.YAxisChartModuleConvert;
import kd.epm.far.business.epmclient.module.dto.BaseModule;
import kd.epm.far.business.epmclient.module.dto.ComboChartModule;
import kd.epm.far.business.epmclient.module.dto.DataPointModule;
import kd.epm.far.business.epmclient.module.dto.ReportInfoModule;
import kd.epm.far.business.epmclient.module.dto.ReportSectionModule;
import kd.epm.far.business.epmclient.module.dto.TableModule;
import kd.epm.far.business.epmclient.module.dto.TocModule;
import kd.epm.far.business.epmclient.module.dto.XYAxisChartModule;
import kd.epm.far.business.epmclient.module.dto.YAxisChartModule;

public class EpmModuleMiddleService
implements IMiddleModuleService<BaseModule> {
    @Override
    public BaseModule getModule(Long dmModelId, Long moduleId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model", "=", (Object)dmModelId));
        qFilters.add(new QFilter("id", "=", (Object)moduleId));
        DynamicObject module = BusinessDataServiceHelper.loadSingleFromCache((String)"fidm_modulerepository", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (module == null) {
            return null;
        }
        JSONObject propertiesJson = JSON.parseObject((String)module.getString("properties"));
        ModuleEnum moduleType = ModuleEnum.getModuleByType(module.getString("type"));
        switch (moduleType) {
            case TOC: {
                return (BaseModule)propertiesJson.toJavaObject(TocModule.class);
            }
            case VAR: {
                return (BaseModule)propertiesJson.toJavaObject(DataPointModule.class);
            }
            case REPORT_INFO: {
                return (BaseModule)propertiesJson.toJavaObject(ReportInfoModule.class);
            }
            case TABLE: {
                return (BaseModule)propertiesJson.toJavaObject(TableModule.class);
            }
            case REPORT_SECTION: {
                return (BaseModule)propertiesJson.toJavaObject(ReportSectionModule.class);
            }
            case PIE: 
            case DOUGHNUT: {
                return (BaseModule)propertiesJson.toJavaObject(YAxisChartModule.class);
            }
            case LINE: 
            case AREA: 
            case STACKED_COLUMNAR: 
            case STACKED_BAR: 
            case CLUSTERED_BAR: 
            case CLUSTERED_COLUMNAR: {
                return (BaseModule)propertiesJson.toJavaObject(XYAxisChartModule.class);
            }
            case LINE_STACKED_COLUMNAR: 
            case LINE_CLUSTERED_COLUMNAR: {
                return (BaseModule)propertiesJson.toJavaObject(ComboChartModule.class);
            }
            case EB_REPORT_SECTION: {
                break;
            }
        }
        return null;
    }

    @Override
    public Class getClassByModule(BaseModule module) {
        ModuleEnum moduleType = ModuleEnum.getModuleByType(StringUtils.getStringValue((Object)module.getType()));
        switch (moduleType) {
            case TOC: {
                return TocModuleConvert.class;
            }
            case VAR: {
                return DataPointModuleConvert.class;
            }
            case REPORT_INFO: {
                return ReportInfoModuleConvert.class;
            }
            case TABLE: {
                return TableModuleConvert.class;
            }
            case REPORT_SECTION: {
                return ReportSectionModuleConvert.class;
            }
            case PIE: 
            case DOUGHNUT: {
                return YAxisChartModuleConvert.class;
            }
            case LINE: 
            case AREA: 
            case STACKED_COLUMNAR: 
            case STACKED_BAR: 
            case CLUSTERED_BAR: 
            case CLUSTERED_COLUMNAR: {
                return XYAxisChartModuleConvert.class;
            }
            case LINE_STACKED_COLUMNAR: 
            case LINE_CLUSTERED_COLUMNAR: {
                return ComboChartModuleConvert.class;
            }
            case EB_REPORT_SECTION: {
                break;
            }
        }
        return null;
    }

    @Override
    public Class getClassByMiddle(IMiddleModuleEntity middle) {
        if (middle.getClass().equals(CommonShareModule.class)) {
            return TocModuleConvert.class;
        }
        if (middle.getClass().equals(PointShareModule.class)) {
            return DataPointModuleConvert.class;
        }
        if (middle.getClass().equals(ReportInfoShareModule.class)) {
            return ReportInfoModuleConvert.class;
        }
        if (middle.getClass().equals(TableShareModule.class)) {
            return TableModuleConvert.class;
        }
        if (middle.getClass().equals(BCMSectionShareModule.class)) {
            return ReportSectionModuleConvert.class;
        }
        if (middle.getClass().equals(PieShareModule.class)) {
            return YAxisChartModuleConvert.class;
        }
        if (middle.getClass().equals(LineShareModule.class)) {
            LineShareModule xyAxisChart = (LineShareModule)middle;
            if (xyAxisChart.type == LineShareModule.TypeEnum.POLYLINE_STACK || xyAxisChart.type == LineShareModule.TypeEnum.POLYLINE_AREA) {
                return ComboChartModuleConvert.class;
            }
            return XYAxisChartModuleConvert.class;
        }
        if (middle.getClass().equals(EBSectionShareModule.class)) {
            // empty if block
        }
        return null;
    }
}

