/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient.module;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.module.dto.Module;
import kd.epm.far.business.epmclient.module.dto.BaseModule;
import kd.epm.far.business.epmclient.module.dto.ComboChartModule;
import kd.epm.far.business.epmclient.module.dto.DataPointModule;
import kd.epm.far.business.epmclient.module.dto.ReportInfoModule;
import kd.epm.far.business.epmclient.module.dto.ReportSectionModule;
import kd.epm.far.business.epmclient.module.dto.TableModule;
import kd.epm.far.business.epmclient.module.dto.TocModule;
import kd.epm.far.business.epmclient.module.dto.XYAxisChartModule;
import kd.epm.far.business.epmclient.module.dto.YAxisChartModule;
import kd.epm.far.business.epmclient.module.dto.property.ComboChartLayout;
import kd.epm.far.business.epmclient.module.dto.property.DataPointProperty;
import kd.epm.far.business.epmclient.module.dto.property.DataSetFilter;
import kd.epm.far.business.epmclient.module.dto.property.DataSetProperty;
import kd.epm.far.business.epmclient.module.dto.property.ModuleDimMember;
import kd.epm.far.business.epmclient.module.dto.property.NumberFormat;
import kd.epm.far.business.epmclient.module.dto.property.ReportInfoProperty;
import kd.epm.far.business.epmclient.module.dto.property.ReportSectionProperty;
import kd.epm.far.business.epmclient.module.dto.property.TableColumn;
import kd.epm.far.business.epmclient.module.dto.property.TableProperty;
import kd.epm.far.business.epmclient.module.dto.property.XYAxisChartLayout;
import kd.epm.far.business.epmclient.module.dto.property.YAxisChartLayout;
import kd.epm.far.business.epmclient.module.dto.property.YAxisChartProperty;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.report.dto.GenerateInputFormular;

public class ModuleConvertHelper {
    private ModuleConvertHelper() {
    }

    public static String convertToClient(String type, Module module, JSONObject moduleJson, GenerateInputFormular inputFormular) {
        BaseModule baseModule = ModuleConvertHelper.getBaseModule(module, moduleJson);
        ModuleEnum moduleType = ModuleEnum.getModuleByType(type);
        switch (moduleType) {
            case TOC: {
                return JSON.toJSONString((Object)new TocModule(baseModule));
            }
            case VAR: {
                return ModuleConvertHelper.getDataPointModule(moduleJson, baseModule, inputFormular);
            }
            case REPORT_INFO: {
                return ModuleConvertHelper.getReportInfoModule(moduleJson, baseModule);
            }
            case TABLE: {
                return ModuleConvertHelper.getTableModule(moduleJson, baseModule, inputFormular);
            }
            case REPORT_SECTION: {
                return ModuleConvertHelper.getReportSectionModule(moduleJson, baseModule, inputFormular);
            }
            case PIE: 
            case DOUGHNUT: {
                return ModuleConvertHelper.getYAxisChartModule(moduleJson, baseModule, inputFormular);
            }
            case LINE: 
            case AREA: 
            case STACKED_COLUMNAR: 
            case STACKED_BAR: 
            case CLUSTERED_BAR: 
            case CLUSTERED_COLUMNAR: {
                return ModuleConvertHelper.getXyAxisChartModule(moduleJson, baseModule);
            }
            case LINE_STACKED_COLUMNAR: 
            case LINE_CLUSTERED_COLUMNAR: {
                return ModuleConvertHelper.getComboChartModule(moduleJson, baseModule);
            }
            case EB_REPORT_SECTION: {
                break;
            }
        }
        return JSON.toJSONString((Object)baseModule);
    }

    private static BaseModule getBaseModule(Module module, JSONObject moduleJson) {
        BaseModule baseModule = new BaseModule();
        baseModule.setKey(DisclosureJsonHelper.getValue(moduleJson, "id", ""));
        baseModule.setName(DisclosureJsonHelper.getValue(moduleJson, "name", ""));
        baseModule.setType(DisclosureJsonHelper.getValue(moduleJson, "type", 0));
        baseModule.setCopyFrom(module.getCopyFrom());
        return baseModule;
    }

    private static String getDataPointModule(JSONObject moduleJson, BaseModule baseModule, GenerateInputFormular inputFormular) {
        JSONObject dataPointJson = DisclosureJsonHelper.getJsonObject(moduleJson, "dataPoint");
        JSONObject numberFormatJson = DisclosureJsonHelper.getJsonObject(moduleJson, "dataFormat", "dataPoint");
        String expression = DisclosureJsonHelper.getValue(dataPointJson, "specialFormula", "");
        DataPointProperty property = new DataPointProperty();
        property.setExpression(expression);
        property.setNumberFormat(ModuleConvertHelper.getNumberFormat(numberFormatJson));
        if (inputFormular != null && inputFormular.getModuleRange().contains(ModuleEnum.VAR.getType())) {
            if (!"0".equals(inputFormular.getUnit())) {
                property.getNumberFormat().setMoneyUnit(Integer.parseInt(inputFormular.getUnit()));
            }
            if (inputFormular.getDecimalEnable()) {
                property.getNumberFormat().setDecimalCount(inputFormular.getDecimal());
            }
        }
        DataPointModule dataPointModule = new DataPointModule(baseModule);
        dataPointModule.setDataSet(ModuleConvertHelper.getDataSet(moduleJson));
        dataPointModule.setProperty(property);
        return JSON.toJSONString((Object)dataPointModule);
    }

    private static String getReportInfoModule(JSONObject moduleJson, BaseModule baseModule) {
        JSONObject reportInfoJson = DisclosureJsonHelper.getJsonObject(moduleJson, "specialMap");
        ReportInfoProperty property = new ReportInfoProperty();
        property.setPrefix(DisclosureJsonHelper.getValue(reportInfoJson, "rptPrefix", ""));
        property.setReportInfoType(ModuleConvertHelper.getReportInfoType(DisclosureJsonHelper.getValue(reportInfoJson, "rptInfoNumber", "")));
        property.setDateFormat(ModuleConvertHelper.getReportInfoDateFormat(DisclosureJsonHelper.getValue(reportInfoJson, "rptDateFormatNumber", "")));
        ReportInfoModule reportInfoModule = new ReportInfoModule(baseModule);
        reportInfoModule.setProperty(property);
        return JSON.toJSONString((Object)reportInfoModule);
    }

    private static String getTableModule(JSONObject moduleJson, BaseModule baseModule, GenerateInputFormular inputFormular) {
        JSONArray propertyArray = DisclosureJsonHelper.getJSONArray(moduleJson, "table", "property");
        JSONObject numberFormatJson = DisclosureJsonHelper.getJsonObject(moduleJson, "dataFormat", "table");
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>(propertyArray.size());
        for (Object prop : propertyArray) {
            JSONObject propertyJson = (JSONObject)prop;
            TableColumn column = new TableColumn();
            column.setType(DisclosureJsonHelper.getValue(propertyJson, "col_type", 1));
            column.setNumber(DisclosureJsonHelper.getValue(propertyJson, "column", ""));
            column.setName(DisclosureJsonHelper.getValue(propertyJson, "column_name", ""));
            column.setSortColumnIndex(DisclosureJsonHelper.getValue(propertyJson, "sort", "priority", 1));
            column.setSortType(ModuleConvertHelper.getSortType(DisclosureJsonHelper.getValue(propertyJson, "sort", "type", "")));
            column.setSortCustomValue(DisclosureJsonHelper.getValue(propertyJson, "sort", "customValue", ""));
            columns.add(column);
        }
        TableProperty property = new TableProperty();
        property.setColumns(columns);
        property.setNumberFormat(ModuleConvertHelper.getNumberFormat(numberFormatJson));
        if (inputFormular != null && inputFormular.getModuleRange().contains(ModuleEnum.TABLE.getType())) {
            if (!"0".equals(inputFormular.getUnit())) {
                property.getNumberFormat().setMoneyUnit(Integer.parseInt(inputFormular.getUnit()));
            }
            if (inputFormular.getDecimalEnable()) {
                property.getNumberFormat().setDecimalCount(inputFormular.getDecimal());
            }
        }
        TableModule tableModule = new TableModule(baseModule);
        tableModule.setDataSet(ModuleConvertHelper.getDataSet(moduleJson));
        tableModule.setProperty(property);
        return JSON.toJSONString((Object)tableModule);
    }

    private static String getReportSectionModule(JSONObject moduleJson, BaseModule baseModule, GenerateInputFormular inputFormular) {
        JSONObject reportSection = DisclosureJsonHelper.getJsonObject(moduleJson, "reportSection");
        JSONObject reportJson = DisclosureJsonHelper.getJsonObject(reportSection, "report");
        JSONObject numberFormatJson = DisclosureJsonHelper.getJsonObject(reportSection, "styleData");
        JSONArray dimsJson = DisclosureJsonHelper.getJSONArray(reportSection, "reportDims");
        ReportSectionProperty property = new ReportSectionProperty();
        property.setReportName(DisclosureJsonHelper.getValue(reportJson, "name", ""));
        property.setReportRange(DisclosureJsonHelper.getValue(reportJson, "range", ""));
        property.setMoneyUnit(DisclosureJsonHelper.getValue(numberFormatJson, "unit", 0));
        property.setDecimalEnable(DisclosureJsonHelper.getValue(numberFormatJson, "decimalEnable", false));
        property.setDecimalCount(DisclosureJsonHelper.getValue(numberFormatJson, "decimal", 2));
        if (inputFormular != null && inputFormular.getModuleRange().contains(ModuleEnum.REPORT_SECTION.getType())) {
            if (!"0".equals(inputFormular.getUnit())) {
                property.setMoneyUnit(Integer.parseInt(inputFormular.getUnit()));
            }
            property.setDecimalEnable(inputFormular.getDecimalEnable());
            property.setDecimalCount(inputFormular.getDecimal());
        }
        HashMap<String, Long> dimMembers = new HashMap<String, Long>(dimsJson.size());
        for (Object dimJson : dimsJson) {
            JSONObject dim = (JSONObject)dimJson;
            String dimNumber = DisclosureJsonHelper.getValue(dim, "dim_number", "");
            long memberId = DisclosureJsonHelper.getValue(dim, "member_id", 0L);
            dimMembers.put(dimNumber, memberId);
        }
        property.setDimMembers(dimMembers);
        ReportSectionModule reportSectionModule = new ReportSectionModule(baseModule);
        reportSectionModule.setProperty(property);
        return JSON.toJSONString((Object)reportSectionModule);
    }

    private static String getYAxisChartModule(JSONObject moduleJson, BaseModule baseModule, GenerateInputFormular inputFormular) {
        JSONObject specialMap = DisclosureJsonHelper.getJsonObject(moduleJson, "specialMap");
        JSONObject legendSort = DisclosureJsonHelper.getJsonObject(specialMap, "legendSort");
        YAxisChartLayout layout = new YAxisChartLayout();
        layout.setYAxis(DisclosureJsonHelper.getValue(specialMap, "detail", ""));
        layout.setLegend(DisclosureJsonHelper.getValue(specialMap, "legend", ""));
        layout.setLegendSortType(ModuleConvertHelper.getSortType(DisclosureJsonHelper.getValue(legendSort, "type", "")));
        layout.setLegendSortCustomValue(DisclosureJsonHelper.getValue(legendSort, "customValue", ""));
        YAxisChartProperty property = new YAxisChartProperty();
        property.setMoneyUnit(DisclosureJsonHelper.getValue(moduleJson, "dataFormat", "pie", "unit", 1));
        YAxisChartModule yAxisChartModule = new YAxisChartModule(baseModule);
        yAxisChartModule.setDataSet(ModuleConvertHelper.getDataSet(moduleJson));
        yAxisChartModule.setLayout(layout);
        yAxisChartModule.setProperty(property);
        return JSON.toJSONString((Object)yAxisChartModule);
    }

    private static String getXyAxisChartModule(JSONObject moduleJson, BaseModule baseModule) {
        JSONObject specialMap = DisclosureJsonHelper.getJsonObject(moduleJson, "specialMap");
        JSONObject xSort = DisclosureJsonHelper.getJsonObject(specialMap, "xSort");
        JSONObject legendSort = DisclosureJsonHelper.getJsonObject(specialMap, "legendSort");
        XYAxisChartLayout layout = new XYAxisChartLayout();
        layout.setXAxis(DisclosureJsonHelper.getValue(specialMap, "x", ""));
        layout.setXSortType(ModuleConvertHelper.getSortType(DisclosureJsonHelper.getValue(xSort, "type", "")));
        layout.setXSortCustomValue(DisclosureJsonHelper.getValue(xSort, "customValue", ""));
        layout.setYAxis(DisclosureJsonHelper.getValue(specialMap, "y", ""));
        layout.setLegend(DisclosureJsonHelper.getValue(specialMap, "legend", ""));
        layout.setLegendSortType(ModuleConvertHelper.getSortType(DisclosureJsonHelper.getValue(legendSort, "type", "")));
        layout.setLegendSortCustomValue(DisclosureJsonHelper.getValue(legendSort, "customValue", ""));
        XYAxisChartModule xyAxisChartModule = new XYAxisChartModule(baseModule);
        xyAxisChartModule.setDataSet(ModuleConvertHelper.getDataSet(moduleJson));
        xyAxisChartModule.setLayout(layout);
        return JSON.toJSONString((Object)xyAxisChartModule);
    }

    private static String getComboChartModule(JSONObject moduleJson, BaseModule baseModule) {
        JSONObject specialMap = DisclosureJsonHelper.getJsonObject(moduleJson, "specialMap");
        JSONObject xSort = DisclosureJsonHelper.getJsonObject(specialMap, "xSort");
        JSONObject columnarLegendSort = DisclosureJsonHelper.getJsonObject(specialMap, "columnarlegendSort");
        JSONObject lineLegendSort = DisclosureJsonHelper.getJsonObject(specialMap, "linelegendSort");
        ComboChartLayout layout = new ComboChartLayout();
        layout.setXAxis(DisclosureJsonHelper.getValue(specialMap, "x", ""));
        layout.setXSortType(ModuleConvertHelper.getSortType(DisclosureJsonHelper.getValue(xSort, "type", "")));
        layout.setXSortCustomValue(DisclosureJsonHelper.getValue(xSort, "customValue", ""));
        layout.setYAxis(DisclosureJsonHelper.getValue(specialMap, "y", ""));
        layout.setLegend(DisclosureJsonHelper.getValue(specialMap, "columnarlegend", ""));
        layout.setLegendSortType(ModuleConvertHelper.getSortType(DisclosureJsonHelper.getValue(columnarLegendSort, "type", "")));
        layout.setLegendSortCustomValue(DisclosureJsonHelper.getValue(columnarLegendSort, "customValue", ""));
        layout.setY2Axis(DisclosureJsonHelper.getValue(specialMap, "y1", ""));
        layout.setLegend2(DisclosureJsonHelper.getValue(specialMap, "linelegend", ""));
        layout.setLegend2SortType(ModuleConvertHelper.getSortType(DisclosureJsonHelper.getValue(lineLegendSort, "type", "")));
        layout.setLegend2SortCustomValue(DisclosureJsonHelper.getValue(lineLegendSort, "customValue", ""));
        ComboChartModule comboChartModule = new ComboChartModule(baseModule);
        comboChartModule.setDataSet(ModuleConvertHelper.getDataSet(moduleJson));
        comboChartModule.setLayout(layout);
        return JSON.toJSONString((Object)comboChartModule);
    }

    private static DataSetProperty getDataSet(JSONObject moduleJson) {
        JSONObject dataSetJson = DisclosureJsonHelper.getJsonObject(moduleJson, "dataset");
        DataSetProperty dataSet = new DataSetProperty();
        dataSet.setId(DisclosureJsonHelper.getValue(dataSetJson, "id", 0L));
        dataSet.setType(DisclosureJsonHelper.getValue(dataSetJson, "type", 0));
        dataSet.setMultiValueId(DisclosureJsonHelper.getValue(dataSetJson, "formula", "id", 0L));
        dataSet.setFilters(ModuleConvertHelper.getDataSetFilters(dataSetJson));
        dataSet.setVariables(ModuleConvertHelper.getDataSetVariables(dataSetJson));
        dataSet.setDimMembers(ModuleConvertHelper.getDataSetDimMembers(dataSetJson));
        return dataSet;
    }

    private static List<DataSetFilter> getDataSetFilters(JSONObject dataSetJson) {
        JSONArray filterArray = DisclosureJsonHelper.getJSONArray(dataSetJson, "datesetFilterItems");
        ArrayList<DataSetFilter> filters = new ArrayList<DataSetFilter>(filterArray.size());
        for (Object filter : filterArray) {
            JSONObject filterJson = (JSONObject)filter;
            DataSetFilter filterItem = new DataSetFilter();
            filterItem.setField(DisclosureJsonHelper.getValue(filterJson, "dimensionNumber", ""));
            filterItem.setCompare(DisclosureJsonHelper.getValue(filterJson, "condition", ""));
            long memberId = DisclosureJsonHelper.getValue(filterJson, "memberId", 0L);
            if (memberId > 0L) {
                filterItem.setValue(DisclosureJsonHelper.getValue(filterJson, "memberNumber", ""));
            } else {
                filterItem.setValue(DisclosureJsonHelper.getValue(filterJson, "value", ""));
            }
            filters.add(filterItem);
        }
        return filters;
    }

    private static Map<String, String> getDataSetVariables(JSONObject dataSetJson) {
        JSONArray varArray = DisclosureJsonHelper.getJSONArray(dataSetJson, "varParams");
        HashMap<String, String> variables = new HashMap<String, String>(varArray.size());
        for (Object varObject : varArray) {
            JSONObject varJson = (JSONObject)varObject;
            String number = DisclosureJsonHelper.getValue(varJson, "number", "");
            String value = DisclosureJsonHelper.getValue(varJson, "modifyvalue", "");
            variables.put(number, value);
        }
        return variables;
    }

    private static List<ModuleDimMember> getDataSetDimMembers(JSONObject dataSetJson) {
        JSONArray dimArray = DisclosureJsonHelper.getJSONArray(dataSetJson, "dimParams");
        ArrayList<ModuleDimMember> dims = new ArrayList<ModuleDimMember>(dimArray.size());
        for (Object dim : dimArray) {
            JSONObject dimJson = (JSONObject)dim;
            ModuleDimMember dimMember = new ModuleDimMember();
            long dimId = DisclosureJsonHelper.getValue(dimJson, "id", 0L);
            long memberId = DisclosureJsonHelper.getValue(dimJson, "member", "id", 0L);
            HashMap<Long, Integer> members = new HashMap<Long, Integer>(1);
            members.put(memberId, 10);
            dimMember.setDimensionId(dimId);
            dimMember.setMembers(members);
            dims.add(dimMember);
        }
        return dims;
    }

    private static NumberFormat getNumberFormat(JSONObject numberFormatJson) {
        NumberFormat numberFormat = new NumberFormat();
        numberFormat.setDataType(DisclosureJsonHelper.getValue(numberFormatJson, "numbertype", 1));
        numberFormat.setMoneyUnit(DisclosureJsonHelper.getValue(numberFormatJson, "unit", 1));
        numberFormat.setCurrencySymbol(DisclosureJsonHelper.getValue(numberFormatJson, "currencysign", ""));
        numberFormat.setDecimalCount(DisclosureJsonHelper.getValue(numberFormatJson, "decimal", 2));
        numberFormat.setIsThousandth(DisclosureJsonHelper.getValue(numberFormatJson, "thousandth", false));
        return numberFormat;
    }

    private static int getReportInfoType(String type) {
        switch (type) {
            case "entity.name": {
                return 1;
            }
            case "entity.number": {
                return 2;
            }
            case "modifytime": {
                return 3;
            }
            case "modifyname": {
                return 4;
            }
        }
        return 1;
    }

    private static int getReportInfoDateFormat(String format) {
        switch (format) {
            case "YYYYMMDD": {
                return 1;
            }
            case "YYYY-MM-DD": {
                return 2;
            }
            case "YYYY/MM/DD": {
                return 3;
            }
            case "YYYY\u5e74MM\u6708DD\u65e5": {
                return 4;
            }
            case "YYYYMM": {
                return 5;
            }
            case "YYYY-MM": {
                return 6;
            }
            case "YYYY\u5e74MM\u6708": {
                return 7;
            }
            case "YYYYQ": {
                return 8;
            }
            case "YYYY-Q": {
                return 9;
            }
            case "YYYY\u5e74Q\u5b63": {
                return 10;
            }
            case "YYYY": {
                return 11;
            }
            case "MM": {
                return 12;
            }
        }
        return 1;
    }

    private static int getSortType(String sortType) {
        switch (sortType) {
            case "": {
                return 0;
            }
            case "nameAsc": {
                return 1;
            }
            case "nameDesc": {
                return 2;
            }
            case "moneyAsc": {
                return 3;
            }
            case "moneyDesc": {
                return 4;
            }
            case "custom": {
                return 5;
            }
        }
        return 0;
    }
}

