/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient.module.convert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.DataPatternEnum;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.BCMSectionShareModule;
import kd.epm.far.business.common.module.middle.dto.LineShareModule;
import kd.epm.far.business.common.module.middle.dto.PieShareModule;
import kd.epm.far.business.common.module.middle.dto.ReportInfoShareModule;
import kd.epm.far.business.common.module.middle.node.dataset.DatasetDimParamNode;
import kd.epm.far.business.common.module.middle.node.dataset.DatasetFilterItemNode;
import kd.epm.far.business.common.module.middle.node.dataset.DatasetFormulaNode;
import kd.epm.far.business.common.module.middle.node.dataset.DatasetNode;
import kd.epm.far.business.common.module.middle.node.dataset.DatasetVarParamNode;
import kd.epm.far.business.common.module.middle.node.format.base.DataFormatNode;
import kd.epm.far.business.common.module.middle.node.format.base.InfoNode;
import kd.epm.far.business.common.module.middle.node.layout.SortNode;
import kd.epm.far.business.common.module.middle.node.layout.table.TableColumnNode;
import kd.epm.far.business.epmclient.module.dto.BaseModule;
import kd.epm.far.business.epmclient.module.dto.property.DataSetFilter;
import kd.epm.far.business.epmclient.module.dto.property.DataSetProperty;
import kd.epm.far.business.epmclient.module.dto.property.ModuleDimMember;
import kd.epm.far.business.epmclient.module.dto.property.NumberFormat;
import kd.epm.far.business.far.enums.SortEnum;
import kd.epm.far.common.common.LanguageHelper;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.LongUtil;

public class CommonConvertHelper {
    private CommonConvertHelper() {
    }

    public static BaseModule getBaseModule(ModuleEnum moduleType, InfoNode module, MiddleModuleInput input) {
        DynamicObject dyModule;
        BaseModule baseModule = new BaseModule();
        if (module.id != null) {
            baseModule.setKey(module.id.toString());
        }
        baseModule.setName(module.name);
        baseModule.setType(Integer.parseInt(moduleType.getType()));
        if (input.getModuleId() > 0L && (dyModule = BusinessDataServiceHelper.loadSingleFromCache((Object)input.getModuleId(), (String)"fidm_modulerepository")) != null) {
            baseModule.setCopyFrom(dyModule.getLong("copyfrom.id"));
        }
        return baseModule;
    }

    public static InfoNode getModuleInfoNode(BaseModule module, MiddleModuleInput input) {
        DynamicObject dyModule;
        InfoNode infoNode = new InfoNode();
        infoNode.name = module.getName();
        if (input.getModuleId() > 0L && (dyModule = BusinessDataServiceHelper.loadSingleFromCache((Object)input.getModuleId(), (String)"fidm_modulerepository")) != null) {
            infoNode.id = dyModule.getLong("id");
            infoNode.number = dyModule.getString("number");
        }
        return infoNode;
    }

    public static int getReportInfoType(ReportInfoShareModule.TypeEnum typeEnum) {
        if (typeEnum != null) {
            switch (typeEnum) {
                case Date: {
                    return 3;
                }
                case EntityName: {
                    return 1;
                }
                case EntityNumber: {
                    return 2;
                }
                case UserName: {
                    return 4;
                }
            }
        }
        return 1;
    }

    public static ReportInfoShareModule.TypeEnum getReportInfoType(int dataType) {
        switch (dataType) {
            case 1: {
                return ReportInfoShareModule.TypeEnum.EntityName;
            }
            case 2: {
                return ReportInfoShareModule.TypeEnum.EntityNumber;
            }
            case 3: {
                return ReportInfoShareModule.TypeEnum.Date;
            }
            case 4: {
                return ReportInfoShareModule.TypeEnum.UserName;
            }
        }
        return ReportInfoShareModule.TypeEnum.EntityName;
    }

    public static int getReportInfoDateFormat(String format) {
        switch (format) {
            case "YYYYMMDD": {
                return 1;
            }
            case "YYYY-MM-DD": {
                return 2;
            }
            case "YYYY/MM/DD": {
                return 3;
            }
            case "YYYY\u5e74MM\u6708DD\u65e5": {
                return 4;
            }
            case "YYYYMM": {
                return 5;
            }
            case "YYYY-MM": {
                return 6;
            }
            case "YYYY\u5e74MM\u6708": {
                return 7;
            }
            case "YYYYQ": {
                return 8;
            }
            case "YYYY-Q": {
                return 9;
            }
            case "YYYY\u5e74Q\u5b63": {
                return 10;
            }
            case "YYYY": {
                return 11;
            }
            case "MM": {
                return 12;
            }
        }
        return 1;
    }

    public static String getReportInfoDateFormat(int format) {
        switch (format) {
            case 1: {
                return "YYYYMMDD";
            }
            case 2: {
                return "YYYY-MM-DD";
            }
            case 3: {
                return "YYYY/MM/DD";
            }
            case 4: {
                return LanguageHelper.getChina((LanguageHelper.CNEnum)LanguageHelper.CNEnum.YearMonthDay);
            }
            case 5: {
                return "YYYYMM";
            }
            case 6: {
                return "YYYY-MM";
            }
            case 7: {
                return LanguageHelper.getChina((LanguageHelper.CNEnum)LanguageHelper.CNEnum.YearMonth);
            }
            case 8: {
                return "YYYYQ";
            }
            case 9: {
                return "YYYY-Q";
            }
            case 10: {
                return LanguageHelper.getChina((LanguageHelper.CNEnum)LanguageHelper.CNEnum.YearQuarter);
            }
            case 11: {
                return "YYYY";
            }
            case 12: {
                return "MM";
            }
        }
        return "YYYYMMDD";
    }

    public static DataSetProperty getDataSet(DatasetNode datasetNode) {
        DataSetProperty dataSet = new DataSetProperty();
        if (datasetNode != null) {
            if (StringUtils.isNotEmpty((String)datasetNode.id)) {
                dataSet.setId(LongUtil.toLong((Object)datasetNode.id));
            }
            if (StringUtils.isEmpty((String)datasetNode.type)) {
                DynamicObject dyDs = BusinessDataServiceHelper.loadSingleFromCache((Object)dataSet.getId(), (String)"fidm_dataset");
                if (dyDs != null) {
                    dataSet.setType(dyDs.getInt("type"));
                }
            } else {
                dataSet.setType(Integer.parseInt(datasetNode.type));
            }
            if (datasetNode.formula != null && StringUtils.isNotEmpty((String)datasetNode.formula.id)) {
                dataSet.setMultiValueId(LongUtil.toLong((Object)datasetNode.formula.id));
            }
            dataSet.setFilters(CommonConvertHelper.getDataSetFilters(datasetNode.datesetFilterItems));
            dataSet.setVariables(CommonConvertHelper.getDataSetVariables(datasetNode.varParams));
            dataSet.setDimMembers(CommonConvertHelper.getDataSetDimMembers(datasetNode.dimParams));
        }
        return dataSet;
    }

    private static List<DataSetFilter> getDataSetFilters(List<DatasetFilterItemNode> filterItemNodes) {
        if (filterItemNodes == null) {
            return new ArrayList<DataSetFilter>(0);
        }
        ArrayList<DataSetFilter> filters = new ArrayList<DataSetFilter>(filterItemNodes.size());
        for (DatasetFilterItemNode itemNode : filterItemNodes) {
            DataSetFilter filter = new DataSetFilter();
            filter.setField(itemNode.getDimensionNumber());
            filter.setCompare(itemNode.getCondition());
            filter.setValue(itemNode.getValue());
            ModuleDimMember dimMember = new ModuleDimMember();
            if (itemNode.getDimensionId() != null) {
                dimMember.setDimensionId(itemNode.getDimensionId());
            }
            if (itemNode.getMemberId() != null) {
                HashMap<Long, Integer> members = new HashMap<Long, Integer>(1);
                members.put(itemNode.getMemberId(), RangeEnum.VALUE_10.getValue());
                dimMember.setMembers(members);
            }
            filter.setDimMemberValue(dimMember);
            filters.add(filter);
        }
        return filters;
    }

    private static Map<String, String> getDataSetVariables(List<DatasetVarParamNode> varParamNodes) {
        if (varParamNodes == null) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> vars = new HashMap<String, String>(varParamNodes.size());
        for (DatasetVarParamNode varParamNode : varParamNodes) {
            vars.put(varParamNode.number, varParamNode.modifyvalue);
        }
        return vars;
    }

    private static List<ModuleDimMember> getDataSetDimMembers(List<DatasetDimParamNode> dimParamNodes) {
        if (dimParamNodes == null) {
            return new ArrayList<ModuleDimMember>(0);
        }
        ArrayList<ModuleDimMember> dimMembers = new ArrayList<ModuleDimMember>(dimParamNodes.size());
        for (DatasetDimParamNode dimParamNode : dimParamNodes) {
            ModuleDimMember dimMember = new ModuleDimMember();
            if (StringUtils.isNotEmpty((String)dimParamNode.id)) {
                dimMember.setDimensionId(LongUtil.toLong((Object)dimParamNode.id));
            }
            List<DatasetDimParamNode.DimParamMember> dimParamMembers = dimParamNode.getMembers();
            HashMap<Long, Integer> members = new HashMap<Long, Integer>(dimParamMembers.size());
            for (DatasetDimParamNode.DimParamMember dimParamMember : dimParamMembers) {
                if (!StringUtils.isNotEmpty((String)dimParamMember.id)) continue;
                members.put(LongUtil.toLong((Object)dimParamMember.id), RangeEnum.VALUE_10.getValue());
            }
            dimMember.setMembers(members);
            dimMembers.add(dimMember);
        }
        return dimMembers;
    }

    public static DatasetNode getDataSetNode(DataSetProperty dataSet) {
        DatasetNode datasetNode = new DatasetNode();
        datasetNode.id = StringUtils.getStringValue((Object)dataSet.getId());
        datasetNode.type = StringUtils.getStringValue((Object)dataSet.getType());
        datasetNode.formula = new DatasetFormulaNode(dataSet.getMultiValueId());
        datasetNode.datesetFilterItems = new ArrayList<DatasetFilterItemNode>(dataSet.getFilters().size());
        for (DataSetFilter filter : dataSet.getFilters()) {
            DatasetFilterItemNode filterItemNode = new DatasetFilterItemNode();
            filterItemNode.setDimensionNumber(filter.getField());
            filterItemNode.setCondition(filter.getCompare());
            filterItemNode.setValue(filter.getValue());
            ModuleDimMember dimMember = filter.getDimMemberValue();
            if (dimMember != null) {
                filterItemNode.setDimensionId(dimMember.getDimensionId());
                if (!dimMember.getIsProperty() && dimMember.getMembers() != null && !dimMember.getMembers().isEmpty()) {
                    filterItemNode.setMemberId(dimMember.getMembers().keySet().iterator().next());
                }
            }
            datasetNode.datesetFilterItems.add(filterItemNode);
        }
        datasetNode.varParams = new ArrayList<DatasetVarParamNode>(dataSet.getVariables().size());
        dataSet.getVariables().forEach((k, v) -> {
            DatasetVarParamNode varParamNode = new DatasetVarParamNode();
            varParamNode.number = k;
            varParamNode.defaultvalue = v;
            datasetNode.varParams.add(varParamNode);
        });
        datasetNode.dimParams = new ArrayList<DatasetDimParamNode>(dataSet.getDimMembers().size());
        for (ModuleDimMember dimMember : dataSet.getDimMembers()) {
            if (dimMember.getIsProperty()) continue;
            DatasetDimParamNode dimParamNode = new DatasetDimParamNode();
            dimParamNode.id = StringUtils.getStringValue((Object)dimMember.getDimensionId());
            dimParamNode.members = new ArrayList<DatasetDimParamNode.DimParamMember>(dimMember.getMembers().size());
            dimMember.getMembers().forEach((k, v) -> dimParamNode.members.add(new DatasetDimParamNode.DimParamMember((long)k)));
            datasetNode.dimParams.add(dimParamNode);
        }
        return datasetNode;
    }

    public static NumberFormat getNumberFormat(DataFormatNode dataFormatNode) {
        NumberFormat numberFormat = new NumberFormat();
        if (dataFormatNode != null) {
            numberFormat.setDataType(CommonConvertHelper.getDataType(dataFormatNode.dataType));
            if (dataFormatNode.unit != null) {
                numberFormat.setMoneyUnit(Integer.parseInt(dataFormatNode.unit.getType()));
            }
            numberFormat.setCurrencySymbol(dataFormatNode.currencysign);
            numberFormat.setDecimalCount(dataFormatNode.decimalPlace);
            numberFormat.setIsThousandth(dataFormatNode.thousandth);
        }
        return numberFormat;
    }

    public static DataFormatNode getDataFormatNode(NumberFormat numberFormat) {
        DataFormatNode dataFormatNode = new DataFormatNode();
        dataFormatNode.visible = true;
        dataFormatNode.dataType = CommonConvertHelper.getDataType(numberFormat.getDataType());
        dataFormatNode.unit = DataPatternEnum.getDataPatternByType(StringUtils.getStringValue((Object)numberFormat.getMoneyUnit()));
        dataFormatNode.currencysign = numberFormat.getCurrencySymbol();
        dataFormatNode.decimalPlace = numberFormat.getDecimalCount();
        dataFormatNode.thousandth = numberFormat.getIsThousandth();
        return dataFormatNode;
    }

    public static int getDataType(DataFormatNode.DataTypeEnum dataTypeEnum) {
        if (dataTypeEnum != null) {
            switch (dataTypeEnum) {
                case Number: {
                    return 1;
                }
                case Currency: {
                    return 2;
                }
                case Percent: {
                    return 3;
                }
            }
        }
        return 1;
    }

    public static DataFormatNode.DataTypeEnum getDataType(int dataType) {
        switch (dataType) {
            case 1: {
                return DataFormatNode.DataTypeEnum.Number;
            }
            case 2: {
                return DataFormatNode.DataTypeEnum.Currency;
            }
            case 3: {
                return DataFormatNode.DataTypeEnum.Percent;
            }
        }
        return DataFormatNode.DataTypeEnum.Number;
    }

    public static int getTableColumnType(TableColumnNode.ColTypeEnum colTypeEnum) {
        if (colTypeEnum != null) {
            switch (colTypeEnum) {
                case Text: {
                    return 1;
                }
                case Number: {
                    return 2;
                }
            }
        }
        return 1;
    }

    public static TableColumnNode.ColTypeEnum getTableColumnType(int columnType) {
        switch (columnType) {
            case 1: {
                return TableColumnNode.ColTypeEnum.Text;
            }
            case 2: {
                return TableColumnNode.ColTypeEnum.Number;
            }
        }
        return TableColumnNode.ColTypeEnum.Text;
    }

    public static int getSortType(SortNode sortNode) {
        if (sortNode != null && sortNode.type != null) {
            switch (sortNode.type) {
                case NAME_ASC: {
                    return 1;
                }
                case NAME_DESC: {
                    return 2;
                }
                case MONEY_ASC: {
                    return 3;
                }
                case MONEY_DESC: {
                    return 4;
                }
                case custom: {
                    return StringUtils.isEmpty((String)sortNode.customValue) ? 0 : 5;
                }
            }
        }
        return 0;
    }

    public static SortEnum getSortType(int sortType) {
        switch (sortType) {
            case 0: 
            case 5: {
                return SortEnum.custom;
            }
            case 1: {
                return SortEnum.NAME_ASC;
            }
            case 2: {
                return SortEnum.NAME_DESC;
            }
            case 3: {
                return SortEnum.MONEY_ASC;
            }
            case 4: {
                return SortEnum.MONEY_DESC;
            }
        }
        return SortEnum.custom;
    }

    public static int getMoneyUnit(BCMSectionShareModule.StyleNode.UnitEnum unitEnum) {
        if (unitEnum != null) {
            switch (unitEnum) {
                case Default: {
                    return 0;
                }
                case YUAN: {
                    return 1;
                }
                case THOUSAND_YUAN: {
                    return 2;
                }
                case TEN_THOUSAND_YUAN: {
                    return 3;
                }
                case MILLION_YUAN: {
                    return 4;
                }
                case BILLION_YUAN: {
                    return 5;
                }
            }
        }
        return 0;
    }

    public static BCMSectionShareModule.StyleNode.UnitEnum getMoneyUnit(int moneyUnit) {
        switch (moneyUnit) {
            case 0: {
                return BCMSectionShareModule.StyleNode.UnitEnum.Default;
            }
            case 1: {
                return BCMSectionShareModule.StyleNode.UnitEnum.YUAN;
            }
            case 2: {
                return BCMSectionShareModule.StyleNode.UnitEnum.THOUSAND_YUAN;
            }
            case 3: {
                return BCMSectionShareModule.StyleNode.UnitEnum.TEN_THOUSAND_YUAN;
            }
            case 4: {
                return BCMSectionShareModule.StyleNode.UnitEnum.MILLION_YUAN;
            }
            case 5: {
                return BCMSectionShareModule.StyleNode.UnitEnum.BILLION_YUAN;
            }
        }
        return BCMSectionShareModule.StyleNode.UnitEnum.Default;
    }

    public static ModuleEnum getChartModuleType(PieShareModule.TypeEnum typeEnum) {
        if (typeEnum != null) {
            switch (typeEnum) {
                case PIE: {
                    return ModuleEnum.PIE;
                }
                case DOUGHNUT: {
                    return ModuleEnum.DOUGHNUT;
                }
            }
        }
        return ModuleEnum.PIE;
    }

    public static PieShareModule.TypeEnum getChartModuleType(int type) {
        ModuleEnum typeEnum = ModuleEnum.getModuleByType(StringUtils.getStringValue((Object)type));
        if (typeEnum != null) {
            switch (typeEnum) {
                case PIE: {
                    return PieShareModule.TypeEnum.PIE;
                }
                case DOUGHNUT: {
                    return PieShareModule.TypeEnum.DOUGHNUT;
                }
            }
        }
        return PieShareModule.TypeEnum.PIE;
    }

    public static ModuleEnum getChartModuleType(LineShareModule.TypeEnum typeEnum, ModuleEnum defaultType) {
        if (typeEnum != null) {
            switch (typeEnum) {
                case LINE: {
                    return ModuleEnum.LINE;
                }
                case AREA: {
                    return ModuleEnum.AREA;
                }
                case BAR: {
                    return ModuleEnum.STACKED_COLUMNAR;
                }
                case BAR_AREA: {
                    return ModuleEnum.CLUSTERED_COLUMNAR;
                }
                case AREATA_BAR: {
                    return ModuleEnum.CLUSTERED_BAR;
                }
                case STACKED_BAR: {
                    return ModuleEnum.STACKED_BAR;
                }
                case POLYLINE_STACK: {
                    return ModuleEnum.LINE_STACKED_COLUMNAR;
                }
                case POLYLINE_AREA: {
                    return ModuleEnum.LINE_CLUSTERED_COLUMNAR;
                }
            }
        }
        return defaultType;
    }

    public static LineShareModule.TypeEnum getChartModuleType(int type, LineShareModule.TypeEnum defaultType) {
        ModuleEnum typeEnum = ModuleEnum.getModuleByType(StringUtils.getStringValue((Object)type));
        if (typeEnum != null) {
            switch (typeEnum) {
                case LINE: {
                    return LineShareModule.TypeEnum.LINE;
                }
                case AREA: {
                    return LineShareModule.TypeEnum.AREA;
                }
                case STACKED_COLUMNAR: {
                    return LineShareModule.TypeEnum.BAR;
                }
                case CLUSTERED_COLUMNAR: {
                    return LineShareModule.TypeEnum.BAR_AREA;
                }
                case CLUSTERED_BAR: {
                    return LineShareModule.TypeEnum.AREATA_BAR;
                }
                case STACKED_BAR: {
                    return LineShareModule.TypeEnum.STACKED_BAR;
                }
                case LINE_STACKED_COLUMNAR: {
                    return LineShareModule.TypeEnum.POLYLINE_STACK;
                }
                case LINE_CLUSTERED_COLUMNAR: {
                    return LineShareModule.TypeEnum.POLYLINE_AREA;
                }
            }
        }
        return defaultType;
    }
}

