/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient.module.convert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.BCMSectionShareModule;
import kd.epm.far.business.epmclient.module.convert.CommonConvertHelper;
import kd.epm.far.business.epmclient.module.dto.BaseModule;
import kd.epm.far.business.epmclient.module.dto.ReportSectionModule;
import kd.epm.far.business.epmclient.module.dto.property.ReportSectionProperty;

public class ReportSectionModuleConvert
implements IMiddleModuleConvert<BCMSectionShareModule, ReportSectionModule> {
    @Override
    public List<String> getTips() {
        return new ArrayList<String>(0);
    }

    @Override
    public ReportSectionModule toModule(MiddleModuleInput input, BCMSectionShareModule source) {
        BaseModule baseModule = CommonConvertHelper.getBaseModule(ModuleEnum.REPORT_SECTION, source.info, input);
        ReportSectionModule module = new ReportSectionModule(baseModule);
        ReportSectionProperty property = new ReportSectionProperty();
        if (source.layout != null) {
            property.setReportName(source.layout.bcmTemplateName);
            property.setReportRange(source.layout.area);
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(input.getDmModelId());
            List<DimensionInfo> allDimensions = modelStrategyEx.getDim().getDimList(false);
            HashMap<String, Long> dimMembers = new HashMap<String, Long>(source.layout.dimMemberMap.size());
            source.layout.dimMemberMap.forEach((k, v) -> {
                DimMemberInfo memberInfo;
                long memberId = 0L;
                DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(allDimensions, k);
                if (dimensionInfo != null && (memberInfo = modelStrategyEx.getDimMember().findMemberByNumber(dimensionInfo.getNumber(), (String)v, false)) != null) {
                    memberId = memberInfo.getId();
                }
                dimMembers.put((String)k, memberId);
            });
            property.setDimMembers(dimMembers);
        }
        if (source.format != null && source.format.styleNode != null) {
            property.setMoneyUnit(CommonConvertHelper.getMoneyUnit(source.format.styleNode.unit));
            property.setDecimalEnable(source.format.styleNode.decimalEnable);
            property.setDecimalCount(source.format.styleNode.decimalPlaces);
        }
        module.setProperty(property);
        return module;
    }

    @Override
    public BCMSectionShareModule toMiddle(MiddleModuleInput input, ReportSectionModule source) {
        BCMSectionShareModule middle = new BCMSectionShareModule();
        middle.info = CommonConvertHelper.getModuleInfoNode(source, input);
        middle.layout = new BCMSectionShareModule.LayoutNode();
        middle.layout.bcmTemplateName = source.getProperty().getReportName();
        middle.layout.area = source.getProperty().getReportRange();
        middle.layout.dimMemberMap = new HashMap<String, String>(source.getProperty().getDimMembers().size());
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(input.getDmModelId());
        List<DimensionInfo> allDimensions = modelStrategyEx.getDim().getDimList(false);
        source.getProperty().getDimMembers().forEach((k, v) -> {
            DimMemberInfo memberInfo;
            String memberNumber = StringUtils.getEmpty();
            DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(allDimensions, k);
            if (dimensionInfo != null && (memberInfo = modelStrategyEx.getDimMember().findMemberById(dimensionInfo.getEntityName(), (Long)v, false)) != null) {
                memberNumber = memberInfo.getNumber();
            }
            middle.layout.dimMemberMap.put((String)k, memberNumber);
        });
        middle.format = new BCMSectionShareModule.FormatNode();
        middle.format.styleNode = new BCMSectionShareModule.StyleNode();
        middle.format.styleNode.unit = CommonConvertHelper.getMoneyUnit(source.getProperty().getMoneyUnit());
        middle.format.styleNode.decimalEnable = source.getProperty().isDecimalEnable();
        middle.format.styleNode.decimalPlaces = source.getProperty().getDecimalCount();
        return middle;
    }
}

