/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient.module.convert;

import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.TableShareModule;
import kd.epm.far.business.common.module.middle.node.layout.SortNode;
import kd.epm.far.business.common.module.middle.node.layout.table.TableColumnNode;
import kd.epm.far.business.epmclient.module.convert.CommonConvertHelper;
import kd.epm.far.business.epmclient.module.dto.BaseModule;
import kd.epm.far.business.epmclient.module.dto.TableModule;
import kd.epm.far.business.epmclient.module.dto.property.TableColumn;
import kd.epm.far.business.epmclient.module.dto.property.TableProperty;

public class TableModuleConvert
implements IMiddleModuleConvert<TableShareModule, TableModule> {
    @Override
    public List<String> getTips() {
        return new ArrayList<String>(0);
    }

    @Override
    public TableModule toModule(MiddleModuleInput input, TableShareModule source) {
        BaseModule baseModule = CommonConvertHelper.getBaseModule(ModuleEnum.TABLE, source.info, input);
        TableModule module = new TableModule(baseModule);
        module.setDataSet(CommonConvertHelper.getDataSet(source.dataset));
        TableProperty property = new TableProperty();
        if (source.layout != null && source.layout.tableColumns != null) {
            ArrayList<TableColumn> columns = new ArrayList<TableColumn>(source.layout.tableColumns.size());
            for (TableColumnNode columnNode : source.layout.tableColumns) {
                TableColumn column = new TableColumn();
                column.setNumber(columnNode.number);
                column.setName(columnNode.rename);
                column.setType(CommonConvertHelper.getTableColumnType(columnNode.type));
                if (columnNode.sort != null) {
                    column.setSortType(CommonConvertHelper.getSortType(columnNode.sort));
                    column.setSortCustomValue(columnNode.sort.customValue);
                    if (StringUtils.isNotEmpty((String)columnNode.sort.priority)) {
                        column.setSortColumnIndex(Integer.parseInt(columnNode.sort.priority));
                    }
                }
                columns.add(column);
            }
            property.setColumns(columns);
        }
        if (source.format != null) {
            property.setNumberFormat(CommonConvertHelper.getNumberFormat(source.format.dataFormat));
        }
        module.setProperty(property);
        return module;
    }

    @Override
    public TableShareModule toMiddle(MiddleModuleInput input, TableModule source) {
        TableShareModule middle = new TableShareModule();
        middle.info = CommonConvertHelper.getModuleInfoNode(source, input);
        middle.dataset = CommonConvertHelper.getDataSetNode(source.getDataSet());
        middle.layout = new TableShareModule.LayoutNode();
        middle.layout.tableColumns = new ArrayList(source.getProperty().getColumns().size());
        for (TableColumn column : source.getProperty().getColumns()) {
            TableColumnNode columnNode = new TableColumnNode();
            columnNode.number = column.getNumber();
            columnNode.rename = column.getName();
            columnNode.type = CommonConvertHelper.getTableColumnType(column.getType());
            columnNode.sort = new SortNode();
            columnNode.sort.type = CommonConvertHelper.getSortType(column.getSortType());
            if (column.getSortType() == 5) {
                columnNode.sort.customValue = column.getSortCustomValue();
            }
            columnNode.sort.priority = StringUtils.getStringValue((Object)column.getSortColumnIndex());
            middle.layout.tableColumns.add(columnNode);
        }
        middle.format = new TableShareModule.FormatNode();
        middle.format.dataFormat = CommonConvertHelper.getDataFormatNode(source.getProperty().getNumberFormat());
        return middle;
    }
}

