/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient.module.convert;

import java.util.ArrayList;
import java.util.List;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.LineShareModule;
import kd.epm.far.business.common.module.middle.node.layout.SortNode;
import kd.epm.far.business.epmclient.module.convert.CommonConvertHelper;
import kd.epm.far.business.epmclient.module.dto.BaseModule;
import kd.epm.far.business.epmclient.module.dto.XYAxisChartModule;
import kd.epm.far.business.epmclient.module.dto.property.XYAxisChartLayout;

public class XYAxisChartModuleConvert
implements IMiddleModuleConvert<LineShareModule, XYAxisChartModule> {
    @Override
    public List<String> getTips() {
        return new ArrayList<String>(0);
    }

    @Override
    public XYAxisChartModule toModule(MiddleModuleInput input, LineShareModule source) {
        ModuleEnum moduleType = CommonConvertHelper.getChartModuleType(source.type, ModuleEnum.LINE);
        BaseModule baseModule = CommonConvertHelper.getBaseModule(moduleType, source.info, input);
        XYAxisChartModule module = new XYAxisChartModule(baseModule);
        module.setDataSet(CommonConvertHelper.getDataSet(source.dataset));
        XYAxisChartLayout layout = new XYAxisChartLayout();
        if (source.layout != null) {
            layout.setXAxis(source.layout.xAxisNumber);
            if (source.layout.xSort != null) {
                layout.setXSortType(CommonConvertHelper.getSortType(source.layout.xSort));
                layout.setXSortCustomValue(source.layout.xSort.customValue);
            }
            layout.setYAxis(source.layout.y1AxisNumber);
            layout.setLegend(source.layout.y1Legend);
            if (source.layout.y1LegendSort != null) {
                layout.setLegendSortType(CommonConvertHelper.getSortType(source.layout.y1LegendSort));
                layout.setLegendSortCustomValue(source.layout.y1LegendSort.customValue);
            }
        }
        module.setLayout(layout);
        return module;
    }

    @Override
    public LineShareModule toMiddle(MiddleModuleInput input, XYAxisChartModule source) {
        LineShareModule middle = new LineShareModule();
        middle.type = CommonConvertHelper.getChartModuleType(source.getType(), LineShareModule.TypeEnum.LINE);
        middle.info = CommonConvertHelper.getModuleInfoNode(source, input);
        middle.dataset = CommonConvertHelper.getDataSetNode(source.getDataSet());
        middle.layout = new LineShareModule.LayoutNode();
        middle.layout.xAxisNumber = source.getLayout().getXAxis();
        middle.layout.xSort = new SortNode();
        middle.layout.xSort.type = CommonConvertHelper.getSortType(source.getLayout().getXSortType());
        if (source.getLayout().getXSortType() == 5) {
            middle.layout.xSort.customValue = source.getLayout().getXSortCustomValue();
        }
        middle.layout.y1AxisNumber = source.getLayout().getYAxis();
        middle.layout.y1Legend = source.getLayout().getLegend();
        middle.layout.y1LegendSort = new SortNode();
        middle.layout.y1LegendSort.type = CommonConvertHelper.getSortType(source.getLayout().getLegendSortType());
        if (source.getLayout().getLegendSortType() == 5) {
            middle.layout.y1LegendSort.customValue = source.getLayout().getLegendSortCustomValue();
        }
        return middle;
    }
}

