/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.epmclient.module.convert;

import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.DataPatternEnum;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.PieShareModule;
import kd.epm.far.business.common.module.middle.node.format.base.DataFormatNode;
import kd.epm.far.business.common.module.middle.node.layout.SortNode;
import kd.epm.far.business.epmclient.module.convert.CommonConvertHelper;
import kd.epm.far.business.epmclient.module.dto.BaseModule;
import kd.epm.far.business.epmclient.module.dto.YAxisChartModule;
import kd.epm.far.business.epmclient.module.dto.property.YAxisChartLayout;
import kd.epm.far.business.epmclient.module.dto.property.YAxisChartProperty;

public class YAxisChartModuleConvert
implements IMiddleModuleConvert<PieShareModule, YAxisChartModule> {
    @Override
    public List<String> getTips() {
        return new ArrayList<String>(0);
    }

    @Override
    public YAxisChartModule toModule(MiddleModuleInput input, PieShareModule source) {
        ModuleEnum moduleType = CommonConvertHelper.getChartModuleType(source.type);
        BaseModule baseModule = CommonConvertHelper.getBaseModule(moduleType, source.info, input);
        YAxisChartModule module = new YAxisChartModule(baseModule);
        module.setDataSet(CommonConvertHelper.getDataSet(source.dataset));
        YAxisChartLayout layout = new YAxisChartLayout();
        if (source.layout != null) {
            layout.setYAxis(source.layout.displayValueNumber);
            layout.setLegend(source.layout.legendNumber);
            if (source.layout.legendSort != null) {
                layout.setLegendSortType(CommonConvertHelper.getSortType(source.layout.legendSort));
                layout.setLegendSortCustomValue(source.layout.legendSort.customValue);
            }
        }
        module.setLayout(layout);
        YAxisChartProperty property = new YAxisChartProperty();
        if (source.format != null && source.format.dataFormat != null) {
            property.setMoneyUnit(Integer.parseInt(source.format.dataFormat.unit.getType()));
        }
        module.setProperty(property);
        return module;
    }

    @Override
    public PieShareModule toMiddle(MiddleModuleInput input, YAxisChartModule source) {
        PieShareModule middle = new PieShareModule();
        middle.type = CommonConvertHelper.getChartModuleType(source.getType());
        middle.info = CommonConvertHelper.getModuleInfoNode(source, input);
        middle.dataset = CommonConvertHelper.getDataSetNode(source.getDataSet());
        middle.layout = new PieShareModule.LayoutNode();
        middle.layout.legendNumber = source.getLayout().getLegend();
        middle.layout.displayValueNumber = source.getLayout().getYAxis();
        middle.layout.legendSort = new SortNode();
        middle.layout.legendSort.type = CommonConvertHelper.getSortType(source.getLayout().getLegendSortType());
        if (source.getLayout().getLegendSortType() == 5) {
            middle.layout.legendSort.customValue = source.getLayout().getLegendSortCustomValue();
        }
        middle.format = new PieShareModule.FormatNode();
        middle.format.dataFormat = new DataFormatNode();
        middle.format.dataFormat.unit = DataPatternEnum.getDataPatternByType(StringUtils.getStringValue((Object)source.getProperty().getMoneyUnit()));
        return middle;
    }
}

