/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.far;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.strategy.ModelStrategy;
import kd.epm.far.business.eb.EBDimensionHelper;
import kd.epm.far.business.far.enums.MemberSourceEnum;
import kd.epm.far.business.far.enums.SysDimensionEnum;
import kd.epm.far.business.far.model.DimDefaultValueVo;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.QFBuilder;

public class DimDefaultValueHelper {
    public static DimDefaultValueVo getDefaultValue(String shortNumber, Long modelId, DisModelTypeEnum typeEnum) {
        List<DynamicObject> dimDefaultValues = DimDefaultValueHelper.queryDimDefaultValues(modelId, "");
        Optional<DynamicObject> present = dimDefaultValues.stream().filter(dy -> shortNumber.equalsIgnoreCase(dy.getString("number"))).findFirst();
        if (present.isPresent()) {
            return DimDefaultValueHelper.getDimDefaultValueVo(shortNumber, typeEnum, present);
        }
        DimDefaultValueVo vo = new DimDefaultValueVo();
        vo.setDefaultCurs(DimDefaultValueHelper.getCursDimMemberInfos(ModelStrategy.getStrategy(typeEnum).getDimDefaultValue(shortNumber), null));
        vo.setDefaultValue(ModelStrategy.getStrategy(typeEnum).getDimDefaultValue(shortNumber));
        return vo;
    }

    public static DimDefaultValueVo getDefaultValue(String shortNumber, Long modelId, DisModelTypeEnum typeEnum, String defaultDataSet) {
        List<DynamicObject> dimDefaultValues = DimDefaultValueHelper.queryDimDefaultValues(modelId, defaultDataSet);
        Optional<DynamicObject> present = dimDefaultValues.stream().filter(dy -> shortNumber.equalsIgnoreCase(dy.getString("number"))).findFirst();
        if (present.isPresent()) {
            return DimDefaultValueHelper.getDimDefaultValueVo(shortNumber, typeEnum, present);
        }
        DimDefaultValueVo vo = new DimDefaultValueVo();
        if (typeEnum == DisModelTypeEnum.EB && !StringUtils.isBlank((CharSequence)defaultDataSet)) {
            List allDims = EBDimensionHelper.getBudgetDyoByModelId(modelId, defaultDataSet, shortNumber).values().stream().sorted(Comparator.comparingInt(org -> org.getInt("dseq"))).collect(Collectors.toList());
            if (allDims.size() == 0) {
                vo.setDefaultValue(ModelStrategy.getStrategy(typeEnum).getDimDefaultValue(shortNumber));
                vo.setDefaultCurs(DimDefaultValueHelper.getCursDimMemberInfos(ModelStrategy.getStrategy(typeEnum).getDimDefaultValue(shortNumber), null));
            } else {
                DimDefaultValueVo defaultValueVo = DimDefaultValueHelper.getEbDefaultValue((DynamicObject)allDims.get(0), modelId, DisModelTypeEnum.EB, defaultDataSet);
                vo.setDefaultValue(defaultValueVo.getDefaultValue());
                vo.setDefaultCurs(DimDefaultValueHelper.getCursDimMemberInfos(defaultValueVo.getDefaultValue(), defaultValueVo.getMemberId()));
            }
        } else {
            vo.setDefaultValue(ModelStrategy.getStrategy(typeEnum).getDimDefaultValue(shortNumber));
            vo.setDefaultCurs(DimDefaultValueHelper.getCursDimMemberInfos(ModelStrategy.getStrategy(typeEnum).getDimDefaultValue(shortNumber), null));
        }
        return vo;
    }

    private static DimDefaultValueVo getDimDefaultValueVo(String shortNumber, DisModelTypeEnum typeEnum, Optional<DynamicObject> present) {
        DimDefaultValueVo dimDefaultValueVo = DimDefaultValueHelper.buildVo(present.get(), false);
        if (dimDefaultValueVo.getDefaultCurs() == null || dimDefaultValueVo.getDefaultCurs().isEmpty()) {
            dimDefaultValueVo.setDefaultCurs(DimDefaultValueHelper.getCursDimMemberInfos(ModelStrategy.getStrategy(typeEnum).getDimDefaultValue(shortNumber), null));
        }
        return dimDefaultValueVo;
    }

    private static List<DimMemberInfo> getCursDimMemberInfos(String number, Long memid) {
        ArrayList<DimMemberInfo> dfCurs = new ArrayList<DimMemberInfo>();
        DimMemberInfo dimMemberInfo = new DimMemberInfo();
        dimMemberInfo.setNumber(number);
        dimMemberInfo.setRange(10);
        dimMemberInfo.setId(memid);
        dfCurs.add(dimMemberInfo);
        return dfCurs;
    }

    public static List<DynamicObject> getDimDefaultValues(Long modelId, String dataSet) {
        return (List)ThreadCache.get((Object)(CacheKey.PrefixString + Joiner.on((String)"#").join((Object)modelId, (Object)dataSet, new Object[]{"getDimDefaultValues"})), () -> {
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)modelId);
            if (StringUtils.isNotEmpty((CharSequence)dataSet)) {
                builder.add("dataset", "=", (Object)dataSet);
            }
            return Lists.newArrayList((Object[])BusinessDataServiceHelper.load((String)"far_default_dim_value", (String)"modifior.name,modifytime,number,defaultvalue,defaultcurs,memberid", (QFilter[])builder.toArray()));
        });
    }

    public static List<DynamicObject> queryDimDefaultValues(Long modelId, String dataSet) {
        return (List)ThreadCache.get((Object)(CacheKey.PrefixString + Joiner.on((String)"#").join((Object)modelId, (Object)dataSet, new Object[]{"queryDimDefaultValues"})), () -> {
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)modelId);
            if (StringUtils.isNotEmpty((CharSequence)dataSet)) {
                builder.add("dataset", "=", (Object)dataSet);
            }
            return Lists.newArrayList((Iterable)QueryServiceHelper.query((String)"far_default_dim_value", (String)"modifior.name,modifytime,number,defaultvalue,defaultcurs,memberid", (QFilter[])builder.toArray()));
        });
    }

    public static DimDefaultValueVo buildVo(DynamicObject dy, boolean withEntityName) {
        return DimDefaultValueHelper.buildVo(dy, dy.getString("defaultcurs"), withEntityName);
    }

    public static DimDefaultValueVo buildVo(DynamicObject dy, String cursJson, boolean withEntityName) {
        DimDefaultValueVo vo = new DimDefaultValueVo();
        vo.setMemberId(dy.getLong("memberid"));
        vo.setDefaultValue(dy.getString("defaultvalue"));
        vo.setDefaultCurs(StringUtils.isNotEmpty((CharSequence)cursJson) ? (List)JSON.parseObject((String)cursJson, (TypeReference)new TypeReference<List<DimMemberInfo>>(){}, (Feature[])new Feature[0]) : null);
        vo.setNumber(dy.getString("number"));
        vo.setModifyTime(dy.getDate("modifytime"));
        if (withEntityName) {
            vo.setEntityName(dy.getString("membermodel"));
            vo.setName(dy.getString("name"));
            vo.setDimId(dy.getLong("dimid"));
        } else {
            vo.setModifiorName(dy.getString("modifior.name"));
        }
        return vo;
    }

    public static DimDefaultValueVo getEbDefaultValue(DynamicObject dims, Long modelId, DisModelTypeEnum typeEnum, String dataSet) {
        String shortNumber = dims.getString("shortNumber");
        List<DynamicObject> dimDefaultValues = DimDefaultValueHelper.queryDimDefaultValues(modelId, dataSet);
        Optional<DynamicObject> present = dimDefaultValues.stream().filter(dy -> shortNumber.equalsIgnoreCase(dy.getString("number"))).findFirst();
        if (present.isPresent()) {
            return DimDefaultValueHelper.getDimDefaultValueVo(shortNumber, typeEnum, present);
        }
        DimDefaultValueVo vo = new DimDefaultValueVo();
        if ("A".equals(shortNumber)) {
            String result = DimDefaultValueHelper.getAccount(dataSet, modelId);
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                vo.setDefaultValue(result);
            } else {
                vo.setDefaultValue(ModelStrategy.getStrategy(typeEnum).getDimDefaultValue(shortNumber));
            }
        } else {
            String result = DimDefaultValueHelper.getMemberTree(dims, modelId);
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                vo.setDefaultValue(result);
            } else {
                vo.setDefaultValue(ModelStrategy.getStrategy(typeEnum).getDimDefaultValue(shortNumber));
            }
        }
        vo.setDefaultCurs(DimDefaultValueHelper.getCursDimMemberInfos(vo.getDefaultValue(), vo.getMemberId()));
        return vo;
    }

    protected static String getAccount(String extendsmodelid, Long modelId) {
        String result = "";
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("number", "=", (Object)extendsmodelid);
        DynamicObject[] dataSetObject = BusinessDataServiceHelper.load((String)"eb_dataset", (String)"id,number", (QFilter[])builder.toArray(), (String)"createdate desc");
        if (dataSetObject == null || dataSetObject.length <= 0) {
            return result;
        }
        DynamicObject dynamicObject = dataSetObject[0];
        Object datasetId = dynamicObject.get("id");
        String menberentityid = "epm_accountmembertree";
        QFilter qFilter = new QFilter("dataset", "=", (Object)Long.parseLong(datasetId.toString()));
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter[] memberFilters = null;
        memberFilters = new QFilter[]{qFilter, modelQf, new QFilter("membersource", "!=", (Object)MemberSourceEnum.COSMIC_INVISIBLE.getIndex())};
        DynamicObject[] dobjs = BusinessDataServiceHelper.load((String)menberentityid, (String)"id,name,number,dseq,parent,isleaf,level", (QFilter[])memberFilters, (String)"dseq");
        if (dobjs != null && dobjs.length > 0) {
            DynamicObject dobj = dobjs[0];
            result = dobj.get("number").toString();
        }
        return result;
    }

    protected static String getMemberTree(DynamicObject dims, Long modelId) {
        String result = "";
        DynamicObject[] memberTree = DimDefaultValueHelper.getRootMemberTree(dims, modelId);
        if (memberTree.length > 0) {
            boolean existChildrenNode;
            DynamicObject parent = memberTree[memberTree.length - 1];
            if (memberTree.length > 1) {
                parent = memberTree[1];
            }
            result = (existChildrenNode = DimDefaultValueHelper.existChildrenNode(dims, modelId, parent)) ? DimDefaultValueHelper.getMemberTreeResult(dims, modelId, parent) : parent.getString("number");
        }
        return result;
    }

    protected static boolean existChildrenNode(DynamicObject dims, Long modelId, DynamicObject parent) {
        QFBuilder builder = DimDefaultValueHelper.getQueryChildrenBuilder(dims, modelId, parent);
        String selectFiled = "id,name,number,dseq,parent,modifier.id,modifier.number,modifier.name";
        DynamicObjectCollection _members = QueryServiceHelper.query((String)dims.getString("membermodel"), (String)selectFiled, (QFilter[])builder.toArray(), (String)"level, dseq, number");
        return _members != null && _members.size() > 0;
    }

    protected static String getMemberTreeResult(DynamicObject dims, Long modelId, DynamicObject parent) {
        String result = "";
        DynamicObject[] childrenMemberTree = DimDefaultValueHelper.getChildrenMemberTree(dims, modelId, parent);
        if (childrenMemberTree.length > 0) {
            DynamicObject dynamicObject = childrenMemberTree[0];
            result = dynamicObject.getString("number");
        }
        return result;
    }

    protected static DynamicObject[] getRootMemberTree(DynamicObject dims, Long modelId) {
        QFBuilder builder = DimDefaultValueHelper.getQueryMemberBuilder(dims, modelId);
        String selectFiled = "id,name,number,dseq,parent,modifier.id,modifier.number,modifier.name";
        DynamicObjectCollection _members = QueryServiceHelper.query((String)dims.getString("membermodel"), (String)selectFiled, (QFilter[])builder.toArray(), (String)"level, dseq, number");
        DynamicObject[] members = _members != null ? (DynamicObject[])_members.toArray((Object[])new DynamicObject[_members.size()]) : new DynamicObject[]{};
        return members;
    }

    protected static DynamicObject[] getChildrenMemberTree(DynamicObject dims, Long modelId, DynamicObject parent) {
        boolean existChildrenNode;
        DynamicObject[] members;
        QFBuilder builder = DimDefaultValueHelper.getQueryChildrenBuilder(dims, modelId, parent);
        String selectFiled = "id,name,number,dseq,parent,modifier.id,modifier.number,modifier.name";
        DynamicObjectCollection _members = QueryServiceHelper.query((String)dims.getString("membermodel"), (String)selectFiled, (QFilter[])builder.toArray(), (String)"level, dseq, number");
        DynamicObject[] dynamicObjectArray = members = _members != null ? (DynamicObject[])_members.toArray((Object[])new DynamicObject[_members.size()]) : new DynamicObject[]{};
        if (_members != null && _members.size() > 0 && (existChildrenNode = DimDefaultValueHelper.existChildrenNode(dims, modelId, parent = (DynamicObject)_members.get(0)))) {
            return DimDefaultValueHelper.getChildrenMemberTree(dims, modelId, parent);
        }
        return members;
    }

    protected static QFBuilder getQueryMemberBuilder(DynamicObject dims, Long modelId) {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("dimension", "=", (Object)dims.getLong("id"));
        builder.add("membersource", "!=", (Object)MemberSourceEnum.COSMIC_INVISIBLE.getIndex());
        builder.add("membersource", "!=", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex());
        if (!dims.getString("number").equals(SysDimensionEnum.AuditTrail.getNumber())) {
            builder.add("enable", "=", (Object)"1");
        }
        builder.add("level", "in", (Object)new int[]{1, 2});
        return builder;
    }

    protected static QFBuilder getQueryChildrenBuilder(DynamicObject dims, Long modelId, DynamicObject parent) {
        long parentId = parent.getLong("id");
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("dimension", "=", (Object)dims.getLong("id"));
        builder.add("parent", "=", (Object)parentId);
        builder.add("enable", "=", (Object)"1");
        builder.add("membersource", "!=", (Object)MemberSourceEnum.COSMIC_INVISIBLE.getIndex());
        return builder;
    }

    public static List<DimMemberInfo> getDfCurs(String shortNumber, DisModelTypeEnum typeEnum) {
        ArrayList<DimMemberInfo> dimMemberInfos = new ArrayList<DimMemberInfo>(1);
        DimMemberInfo dimMemberInfo = new DimMemberInfo();
        dimMemberInfo.setNumber(ModelStrategy.getStrategy(typeEnum).getDimDefaultValue(shortNumber));
        dimMemberInfo.setRange(10);
        dimMemberInfos.add(dimMemberInfo);
        return dimMemberInfos;
    }

    public static String buildDfCursExpression(List<DimMemberInfo> dimMemberInfos) {
        StringBuilder sb = new StringBuilder();
        if (dimMemberInfos == null || dimMemberInfos.isEmpty()) {
            return "";
        }
        for (int i = 0; i < dimMemberInfos.size(); ++i) {
            DimMemberInfo dimMemberInfo = dimMemberInfos.get(i);
            sb.append(dimMemberInfo.getNumber()).append(".").append(RangeEnum.getRangeByVal((int)dimMemberInfo.getRange()).getNumber());
            if (i >= dimMemberInfos.size() - 1) continue;
            sb.append(";");
        }
        return sb.toString();
    }
}

