/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.far.calculate;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.far.calculate.ICalculate;
import net.sourceforge.pinyin4j.PinyinHelper;
import org.apache.commons.collections4.CollectionUtils;

public class AbstractCalculate
implements ICalculate {
    private static final Log log = LogFactory.getLog(AbstractCalculate.class);
    protected String datasetType;
    protected Object sourceData;
    protected Object property;
    protected Set<String> moneyKeys;
    protected List<DatasetFilterItem> filterItems;
    protected Boolean isWithName;
    protected Long datasetMultiId;
    protected JSONObject item;
    protected Map<String, String> multiDataNameMap = new HashMap<String, String>(2);
    protected List<Map<String, Object>> multiSourceData = new ArrayList<Map<String, Object>>(2);
    protected String multiColumnPre = "newCol_";
    protected Map<String, String> multiColumnNameMap = new HashMap<String, String>(2);
    protected Set<String> multiMoneyKeys = new HashSet<String>(2);
    protected List<DatasetFilterItem> multiFilterItems = new ArrayList<DatasetFilterItem>(2);

    public AbstractCalculate() {
    }

    public AbstractCalculate(String datasetType, Object sourceData, Object property, Map<String, Object> params) {
        this.datasetType = datasetType;
        this.sourceData = sourceData;
        this.property = property;
        this.moneyKeys = (Set)params.get("moneyKeys");
        this.filterItems = (List)params.get("filterItems");
        this.isWithName = (Boolean)params.get("isWithName");
        this.item = (JSONObject)params.get("itemJson");
        JSONObject datasetJson = (JSONObject)params.get("datasetJson");
        if (Objects.nonNull(datasetJson) && Objects.nonNull(datasetJson.getJSONObject("formula"))) {
            this.datasetMultiId = datasetJson.getJSONObject("formula").getLong("id");
        }
    }

    protected static String toPinYinString(String str) {
        StringBuilder sb = new StringBuilder();
        String[] arr = null;
        for (int i = 0; i < str.length(); ++i) {
            arr = PinyinHelper.toHanyuPinyinStringArray((char)str.charAt(i));
            if (arr != null && arr.length > 0) {
                for (String string : arr) {
                    sb.append(string);
                }
                continue;
            }
            if (arr != null) continue;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> calculate() {
        Map<String, Object> returnData = null;
        switch (this.datasetType) {
            case "1": {
                returnData = this.getSingleValue();
                break;
            }
            case "2": {
                List list = (List)this.sourceData;
                this.multiColumnNameMap = new LinkedHashMap<String, String>(2);
                this.multiSourceData = this.convertToNewMutiList(list, this.multiColumnNameMap);
                this.multiMoneyKeys = this.convertToNewMutiMoney(this.moneyKeys, this.multiColumnNameMap);
                this.multiFilterItems = this.convertToNewMutiFilterItems(this.filterItems, this.multiColumnNameMap);
                if (this.isWithName.booleanValue()) {
                    this.multiDataNameMap = this.getSourceDataName(this.multiSourceData, this.multiMoneyKeys);
                }
                returnData = this.getMultiRow();
                this.sortReturnData(returnData.get("data"));
                break;
            }
            case "3": {
                returnData = this.getMultiValue();
                this.afterGetMultiValue(this.datasetType, this.item, this.sourceData, returnData);
                break;
            }
        }
        return returnData;
    }

    protected Map<String, Object> getSingleValue() {
        return Collections.emptyMap();
    }

    protected Map<String, Object> getMultiRow() {
        return Collections.emptyMap();
    }

    protected Map<String, Object> getMultiValue() {
        return Collections.emptyMap();
    }

    protected String getErrorEesc(String error) {
        if (StringUtils.equals((CharSequence)"***", (CharSequence)error)) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u96c6\u5b58\u5728\u65e0\u6743\u6210\u5458\u3002", (String)"AbstractCalculate_3", (String)"epm-far-business", (Object[])new Object[0]);
        }
        return error;
    }

    private List<Map<String, Object>> convertToNewMutiList(List<Map<String, Object>> source, Map<String, String> nameMap) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(2);
        int index = nameMap.size() + 1;
        for (Map<String, Object> item : source) {
            LinkedHashMap<String, Object> newItem = new LinkedHashMap<String, Object>(2);
            for (Map.Entry<String, Object> entry : item.entrySet()) {
                if (!nameMap.containsKey(entry.getKey())) {
                    nameMap.put(entry.getKey(), this.multiColumnPre + index);
                    ++index;
                }
                newItem.put(nameMap.get(entry.getKey()), entry.getValue());
            }
            result.add(newItem);
        }
        return result;
    }

    private Set<String> convertToNewMutiMoney(Set<String> source, Map<String, String> nameMap) {
        HashSet<String> realMoneyKeys = new HashSet<String>(2);
        if (source != null) {
            int index = nameMap.size() + 1;
            for (String item : source) {
                if (!nameMap.containsKey(item)) {
                    nameMap.put(item, this.multiColumnPre + index);
                    ++index;
                }
                realMoneyKeys.add(nameMap.get(item));
            }
        }
        return realMoneyKeys;
    }

    private List<DatasetFilterItem> convertToNewMutiFilterItems(List<DatasetFilterItem> source, Map<String, String> nameMap) {
        ArrayList<DatasetFilterItem> result = new ArrayList<DatasetFilterItem>(2);
        if (source != null) {
            int index = nameMap.size() + 1;
            for (DatasetFilterItem item : source) {
                if (!nameMap.containsKey(item.getDimensionNumber())) {
                    nameMap.put(item.getDimensionNumber(), this.multiColumnPre + index);
                    ++index;
                }
                item.setDimensionNumber(nameMap.get(item.getDimensionNumber()));
                result.add(item);
            }
        }
        return result;
    }

    protected String getDataSetColumnName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        if (this.multiColumnNameMap.containsKey(name)) {
            return this.multiColumnNameMap.get(name);
        }
        if (name.contains("=")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5ea6\u91cf\u503c\u5df2\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"AbstractCalculate_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (name.contains("FMONEY")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5ea6\u91cf\u503c\u5df2\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"AbstractCalculate_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return name;
    }

    protected String getMemberName(Row row, String dimensionNumber) {
        return this.multiDataNameMap.get(dimensionNumber + "_" + row.getString(dimensionNumber));
    }

    private Map<String, String> getSourceDataName(List<Map<String, Object>> newSource, Set<String> newMoneyKeys) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        if (CollectionUtils.isEmpty(newSource)) {
            return result;
        }
        for (Map<String, Object> e : newSource) {
            for (Map.Entry<String, Object> entry : e.entrySet()) {
                String name;
                String key = entry.getKey();
                Object valueObj = entry.getValue();
                String[] value = Objects.isNull(valueObj) ? new String[]{" "} : (valueObj instanceof String ? ((String)valueObj).split(";") : valueObj.toString().split(";"));
                String string = name = value.length > 1 ? value[1] : "";
                if (value.length == 0) {
                    value = new String[]{""};
                }
                e.put(key, value[0]);
                if (newMoneyKeys.contains(key)) continue;
                result.put(key + "_" + value[0], value.length == 1 ? value[0] : name);
            }
        }
        return result;
    }

    protected BigDecimal convertValueToDecimal(String value) {
        return new BigDecimal(value);
    }

    protected void sortReturnData(Object data) {
    }

    public void afterGetMultiValue(String datasetType, JSONObject itemObject, Object sourceData, Object data) {
    }
}

