/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.far.calculate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.far.business.far.calculate.AbstractCalculate;
import kd.epm.far.business.far.calculate.CalculateHelper;
import kd.epm.far.business.far.enums.SortEnum;
import org.apache.commons.collections.CollectionUtils;

public class AnalysisAbstractCalculate
extends AbstractCalculate {
    public static final String NODE_DETAIL = "detail";
    private static final Log log = LogFactory.getLog(AnalysisAbstractCalculate.class);

    public AnalysisAbstractCalculate(String datasetType, Object sourceData, Object property, Map<String, Object> params) {
        super(datasetType, sourceData, property, params);
    }

    protected DataSet getDataSet() {
        for (Map item : this.multiSourceData) {
            for (String valeCol : this.multiMoneyKeys) {
                BigDecimal val = new BigDecimal(0);
                Object d = item.get(valeCol);
                if (Objects.nonNull(d)) {
                    try {
                        val = new BigDecimal(d.toString());
                    }
                    catch (Exception ex) {
                        log.warn((Throwable)ex);
                    }
                }
                item.put(valeCol, val);
            }
        }
        DataSet dataSet = CalculateHelper.createAlgoDataSet(this.multiSourceData, this.multiMoneyKeys);
        dataSet = CalculateHelper.whereByFilter(dataSet, this.multiFilterItems, (Set<String>)this.multiMoneyKeys);
        return dataSet;
    }

    protected List<Map<String, Object>> createXY(List<String> xAxisList, DataSet dataSet, String typeName, String xAxisNumber, String yAxisNumber, String legendNumber) {
        return this.createXY(xAxisList, dataSet, typeName, xAxisNumber, yAxisNumber, legendNumber, 0);
    }

    protected List<Map<String, Object>> createXY(List<String> xAxisList, DataSet dataSet, String typeName, String xAxisNumber, String yAxisNumber, String legendNumber, int yAxisIndex) {
        ArrayList<Map<String, Object>> seriesList = new ArrayList<Map<String, Object>>(10);
        if (StringUtils.isEmpty((CharSequence)yAxisNumber)) {
            return seriesList;
        }
        if (StringUtils.isEmpty((CharSequence)legendNumber)) {
            ArrayList data = new ArrayList(2);
            xAxisList.clear();
            dataSet.groupBy(new String[]{xAxisNumber}).sum(yAxisNumber).finish().forEach(e -> {
                xAxisList.add(this.getMemberName((Row)e, xAxisNumber));
                data.add(this.convertValueToDecimal(e.getString(yAxisNumber)));
            });
            HashMap<String, Object> series = new HashMap<String, Object>();
            series.put("name", "");
            series.put("type", typeName);
            series.put("data", data);
            if (yAxisIndex > 0) {
                series.put("yAxisIndex", yAxisIndex);
            }
            seriesList.add(series);
        } else {
            dataSet.groupBy(new String[]{xAxisNumber, legendNumber}).sum(yAxisNumber).finish().forEach(e -> {
                String legendName = this.getMemberName((Row)e, legendNumber);
                Map findSeries = Maps.newHashMapWithExpectedSize((int)1);
                if (Objects.nonNull(legendName)) {
                    findSeries = seriesList.stream().filter(x -> !x.get("name").equals("") && x.get("name") != null && Objects.equals(x.get("name").toString(), legendName)).findAny().orElse(null);
                }
                String xAxisName = this.getMemberName((Row)e, xAxisNumber);
                if (Objects.nonNull(findSeries) && Objects.nonNull(legendName)) {
                    List valList = (List)findSeries.get("data");
                    valList.set(xAxisList.indexOf(xAxisName), this.convertValueToDecimal(e.getString(yAxisNumber)));
                } else {
                    ArrayList<BigDecimal> valList = new ArrayList<BigDecimal>(xAxisList.size());
                    xAxisList.forEach(v -> valList.add(new BigDecimal(0)));
                    valList.set(xAxisList.indexOf(xAxisName), this.convertValueToDecimal(e.getString(yAxisNumber)));
                    HashMap<String, Object> series = new HashMap<String, Object>();
                    if (Objects.isNull(legendName)) {
                        series.put("name", "");
                    } else {
                        series.put("name", legendName);
                    }
                    series.put("type", typeName);
                    series.put("data", valList);
                    if (yAxisIndex > 0) {
                        series.put("yAxisIndex", yAxisIndex);
                    }
                    seriesList.add(series);
                }
            });
        }
        return seriesList;
    }

    protected List<Map<String, Object>> createBySeriesChar(List<String> xAxisList, DataSet dataSet, String typeName, String xAxisNumber, String yAxisNumber, String legendNumber, String smallSeriesChartNumber) {
        return this.createBySeriesChar(xAxisList, dataSet, typeName, xAxisNumber, yAxisNumber, legendNumber, smallSeriesChartNumber, 0);
    }

    protected List<Map<String, Object>> createBySeriesChar(List<String> xAxisList, DataSet dataSet, String typeName, String xAxisNumber, String yAxisNumber, String legendNumber, String smallSeriesChartNumber, int yAxisIndex) {
        ArrayList<Map<String, Object>> seriesList = new ArrayList<Map<String, Object>>(10);
        if (StringUtils.isEmpty((CharSequence)yAxisNumber)) {
            return seriesList;
        }
        if (StringUtils.isEmpty((CharSequence)legendNumber)) {
            dataSet.groupBy(new String[]{xAxisNumber, smallSeriesChartNumber}).sum(yAxisNumber).finish().forEach(e -> {
                String smallSeriesChartName = this.getMemberName((Row)e, smallSeriesChartNumber);
                String xAxisName = this.getMemberName((Row)e, xAxisNumber);
                Map findSeries = seriesList.stream().filter(x -> Objects.equals(x.get("name").toString(), smallSeriesChartName)).findAny().orElse(null);
                if (Objects.nonNull(findSeries)) {
                    List detailList = (List)findSeries.get(NODE_DETAIL);
                    List valList = (List)((Map)detailList.get(0)).get("data");
                    valList.set(xAxisList.indexOf(xAxisName), this.convertValueToDecimal(e.getString(yAxisNumber)));
                } else {
                    ArrayList<BigDecimal> valList = new ArrayList<BigDecimal>(xAxisList.size());
                    xAxisList.forEach(v -> valList.add(new BigDecimal(0)));
                    valList.set(xAxisList.indexOf(xAxisName), this.convertValueToDecimal(e.getString(yAxisNumber)));
                    ArrayList detailList = new ArrayList(1);
                    HashMap<String, Object> detail = new HashMap<String, Object>();
                    detail.put("name", "");
                    detail.put("type", typeName);
                    detail.put("data", valList);
                    if (yAxisIndex > 0) {
                        detail.put("yAxisIndex", yAxisIndex);
                    }
                    detailList.add(detail);
                    HashMap<String, Object> series = new HashMap<String, Object>();
                    series.put("name", smallSeriesChartName);
                    series.put(NODE_DETAIL, detailList);
                    seriesList.add(series);
                }
            });
        } else {
            dataSet.groupBy(new String[]{xAxisNumber, smallSeriesChartNumber, legendNumber}).sum(yAxisNumber).finish().forEach(e -> {
                String smallSeriesChartName = this.getMemberName((Row)e, smallSeriesChartNumber);
                String xAxisName = this.getMemberName((Row)e, xAxisNumber);
                String legendName = this.getMemberName((Row)e, legendNumber);
                Map findSeries = seriesList.stream().filter(x -> Objects.equals(x.get("name").toString(), smallSeriesChartName)).findAny().orElse(null);
                if (Objects.nonNull(findSeries)) {
                    List detailList = (List)findSeries.get(NODE_DETAIL);
                    Map findDetail = detailList.stream().filter(x -> Objects.equals(x.get("name").toString(), legendName)).findAny().orElse(null);
                    if (Objects.nonNull(findDetail)) {
                        List valList = (List)findDetail.get("data");
                        valList.set(xAxisList.indexOf(xAxisName), this.convertValueToDecimal(e.getString(yAxisNumber)));
                    } else {
                        ArrayList<BigDecimal> valList = new ArrayList<BigDecimal>(xAxisList.size());
                        xAxisList.forEach(v -> valList.add(new BigDecimal(0)));
                        valList.set(xAxisList.indexOf(xAxisName), this.convertValueToDecimal(e.getString(yAxisNumber)));
                        HashMap<String, Object> detail = new HashMap<String, Object>();
                        detail.put("name", legendName);
                        detail.put("type", typeName);
                        detail.put("data", valList);
                        if (yAxisIndex > 0) {
                            detail.put("yAxisIndex", yAxisIndex);
                        }
                        detailList.add(detail);
                    }
                } else {
                    ArrayList<BigDecimal> valList = new ArrayList<BigDecimal>(xAxisList.size());
                    xAxisList.forEach(v -> valList.add(new BigDecimal(0)));
                    valList.set(xAxisList.indexOf(xAxisName), this.convertValueToDecimal(e.getString(yAxisNumber)));
                    ArrayList detailList = new ArrayList(1);
                    HashMap<String, Object> detail = new HashMap<String, Object>();
                    detail.put("name", legendName);
                    detail.put("type", typeName);
                    detail.put("data", valList);
                    if (yAxisIndex > 0) {
                        detail.put("yAxisIndex", yAxisIndex);
                    }
                    detailList.add(detail);
                    HashMap<String, Object> series = new HashMap<String, Object>();
                    series.put("name", smallSeriesChartName);
                    series.put(NODE_DETAIL, detailList);
                    seriesList.add(series);
                }
            });
        }
        return seriesList;
    }

    protected void MergeSeriesChar(List<Map<String, Object>> seriesList, List<Map<String, Object>> combineSeriesList) {
        if (combineSeriesList.size() == 0) {
            return;
        }
        if (seriesList.size() == 0) {
            seriesList.addAll(combineSeriesList);
            return;
        }
        for (Map<String, Object> combine : combineSeriesList) {
            String seriesName = combine.get("name").toString();
            List detailList = (List)combine.get(NODE_DETAIL);
            if (detailList.size() == 0) continue;
            Map findSeries = seriesList.stream().filter(x -> Objects.equals(x.get("name").toString(), seriesName)).findAny().orElse(null);
            if (Objects.nonNull(findSeries)) {
                List seriesDetailList = (List)findSeries.get(NODE_DETAIL);
                seriesDetailList.addAll(detailList);
                continue;
            }
            seriesList.add(combine);
            return;
        }
    }

    protected List<String> getJsonStringList(JSONArray jsonArray) {
        ArrayList<String> result = new ArrayList<String>(2);
        if (Objects.isNull(jsonArray)) {
            return result;
        }
        for (Object item : jsonArray) {
            String yAxisNumber = (String)this.multiColumnNameMap.get(item.toString());
            if (StringUtils.isEmpty((CharSequence)yAxisNumber)) continue;
            result.add(yAxisNumber);
        }
        return result;
    }

    protected void sortByValue(Map<String, Object> data) {
        JSONObject requrestObject = (JSONObject)this.property;
        String sortY = requrestObject.getString("sortSelectY");
        final SortEnum sortEnum = SortEnum.getEnumByName(sortY);
        if (sortEnum == null) {
            return;
        }
        List seriesList = (List)data.get("series");
        if (CollectionUtils.isEmpty((Collection)seriesList)) {
            return;
        }
        switch (sortEnum) {
            case NAME_ASC: 
            case NAME_DESC: {
                seriesList.sort(new Comparator<Map<String, Object>>(){

                    @Override
                    public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                        String name1 = AbstractCalculate.toPinYinString((String)o1.get("name"));
                        String name2 = AbstractCalculate.toPinYinString((String)o2.get("name"));
                        return name1.compareTo(name2) * sortEnum.getOrderBy();
                    }
                });
                break;
            }
            case MONEY_ASC: 
            case MONEY_DESC: {
                seriesList.sort(new Comparator<Map<String, Object>>(){

                    @Override
                    public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                        List data1 = (List)o1.get("data");
                        List data2 = (List)o2.get("data");
                        BigDecimal totalMoney1 = BigDecimal.ZERO;
                        BigDecimal totalMoney2 = BigDecimal.ZERO;
                        for (Object data : data1) {
                            totalMoney1 = totalMoney1.add(new BigDecimal(data.toString()));
                        }
                        for (Object data : data2) {
                            totalMoney2 = totalMoney2.add(new BigDecimal(data.toString()));
                        }
                        return totalMoney1.compareTo(totalMoney2) * sortEnum.getOrderBy();
                    }
                });
                break;
            }
            case custom: {
                String custom = requrestObject.getString("customValueY");
                if (StringUtils.isEmpty((CharSequence)custom)) break;
                List<String> customList = Arrays.stream(custom.split(";")).distinct().collect(Collectors.toList());
                Map<String, Map> nameMap = seriesList.stream().collect(Collectors.toMap(t -> (String)t.get("name"), k -> k, (v1, v2) -> v2));
                customList.retainAll(nameMap.keySet());
                if (CollectionUtils.isEmpty(customList)) break;
                ArrayList newSeriesList = Lists.newArrayList();
                customList.forEach(t -> newSeriesList.add(nameMap.get(t)));
                for (Map seriesMap : seriesList) {
                    String name = (String)seriesMap.get("name");
                    if (customList.contains(name)) continue;
                    newSeriesList.add(nameMap.get(name));
                }
                seriesList = newSeriesList;
                break;
            }
        }
        data.put("series", seriesList);
    }

    protected void sortByKey(Map<String, Object> data, String sortKey) {
        JSONObject requrestObject = (JSONObject)this.property;
        String sortX = requrestObject.getString("sortSelectX");
        SortEnum sortEnum = SortEnum.getEnumByName(sortX);
        if (sortEnum == null) {
            return;
        }
        List axis = (List)data.get(sortKey);
        List seriesList = (List)data.get("series");
        if (CollectionUtils.isEmpty((Collection)seriesList)) {
            return;
        }
        HashMap sortMap = Maps.newHashMapWithExpectedSize((int)axis.size());
        switch (sortEnum) {
            case NAME_ASC: 
            case NAME_DESC: {
                ArrayList axisCopy = Lists.newArrayList((Iterable)axis);
                this.buildSortMapByString(sortEnum, axis, sortMap, axisCopy);
                data.put(sortKey, axisCopy);
                this.sortValue(seriesList, sortMap);
                break;
            }
            case MONEY_ASC: 
            case MONEY_DESC: {
                ArrayList totalMoney = Lists.newArrayListWithCapacity((int)axis.size());
                for (Map series : seriesList) {
                    List fMoney = (List)series.get("data");
                    for (int i = 0; i < fMoney.size(); ++i) {
                        if (totalMoney.size() > i) {
                            BigDecimal money = ((BigDecimal)totalMoney.get(i)).add(new BigDecimal(fMoney.get(i).toString()));
                            totalMoney.set(i, money);
                            continue;
                        }
                        totalMoney.add(new BigDecimal(fMoney.get(i).toString()));
                    }
                }
                ArrayList totalMoneyCopy = Lists.newArrayList((Iterable)totalMoney);
                this.buildSortMapByBigDecimal(sortEnum, totalMoney, sortMap, totalMoneyCopy);
                ArrayList axisCopy = Lists.newArrayListWithCapacity((int)axis.size());
                for (int i = 0; i < axis.size(); ++i) {
                    axisCopy.add(axis.get((Integer)sortMap.get(i)));
                }
                data.put(sortKey, axisCopy);
                this.sortValue(seriesList, sortMap);
                break;
            }
            case custom: {
                int i;
                String custom = requrestObject.getString("customValueX");
                if (StringUtils.isEmpty((CharSequence)custom)) break;
                List customList = Arrays.stream(custom.split(";")).distinct().collect(Collectors.toList());
                customList.retainAll(axis);
                if (CollectionUtils.isEmpty(customList)) break;
                for (i = 0; i < customList.size(); ++i) {
                    int index = axis.indexOf(customList.get(i));
                    sortMap.put(i, index);
                }
                ArrayList axisCopy = Lists.newArrayList(customList);
                for (i = 0; i < axis.size(); ++i) {
                    String value = (String)axis.get(i);
                    if (customList.contains(value)) continue;
                    axisCopy.add(value);
                    sortMap.put(axisCopy.size() - 1, i);
                }
                data.put(sortKey, axisCopy);
                this.sortValue(seriesList, sortMap);
                break;
            }
        }
    }

    private void sortValue(List<Map<String, Object>> seriesList, Map<Integer, Integer> sortMap) {
        for (Map<String, Object> series : seriesList) {
            List fMoney = (List)series.get("data");
            ArrayList newFMoney = Lists.newArrayListWithCapacity((int)fMoney.size());
            for (int i = 0; i < fMoney.size(); ++i) {
                newFMoney.add(new BigDecimal(fMoney.get(sortMap.get(i)).toString()));
            }
            series.put("data", newFMoney);
        }
    }

    private void buildSortMapByBigDecimal(final SortEnum sortEnum, List<BigDecimal> oldMoney, Map<Integer, Integer> sortMap, List<BigDecimal> newMoney) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)oldMoney.size());
        newMoney.sort(new Comparator<BigDecimal>(){

            @Override
            public int compare(BigDecimal o1, BigDecimal o2) {
                return o1.compareTo(o2) * sortEnum.getOrderBy();
            }
        });
        for (int i = 0; i < oldMoney.size(); ++i) {
            BigDecimal old = oldMoney.get(i);
            Integer integer = map.getOrDefault(old, 1);
            sortMap.put(this.findByOrderNumber(newMoney, old, integer), i);
            map.put(old, integer + 1);
        }
    }

    private <T> Integer findByOrderNumber(List<T> newList, T value, int orderNumber) {
        int order = 1;
        for (int i = 0; i < newList.size(); ++i) {
            if (!newList.get(i).equals(value)) continue;
            if (order == orderNumber) {
                return i;
            }
            ++order;
        }
        return order;
    }

    private void buildSortMapByString(final SortEnum sortEnum, List<String> oldStr, Map<Integer, Integer> sortMap, List<String> newStr) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)oldStr.size());
        newStr.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return AbstractCalculate.toPinYinString(o1).compareTo(AbstractCalculate.toPinYinString(o2)) * sortEnum.getOrderBy();
            }
        });
        for (int i = 0; i < oldStr.size(); ++i) {
            String old = oldStr.get(i);
            Integer integer = map.getOrDefault(old, 1);
            sortMap.put(this.findByOrderNumber(newStr, old, integer), i);
            map.put(old, integer + 1);
        }
    }
}

