/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.far.calculate;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.far.calculate.AnalysisAbstractCalculate;
import kd.epm.far.business.far.calculate.CalculateHelper;
import kd.epm.far.business.far.enums.ModuleEnum;
import kd.epm.far.common.common.util.LongUtil;

public class AnalysisDataPointCalculate
extends AnalysisAbstractCalculate {
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String C = "c";
    private static final String CONFIG = "config";
    private static final String DATAPOINT = "dataPoint";

    public AnalysisDataPointCalculate(String datasetType, Object sourceData, Object property, Map<String, Object> params) {
        super(datasetType, sourceData, property, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getMultiRow() {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        ArrayList data = new ArrayList(2);
        try (DataSet dataSet = this.getDataSet();){
            dataSet.forEach(e -> {
                if (data.size() == 0) {
                    for (int i = 0; i < e.size(); ++i) {
                        data.add(e.getString(i));
                    }
                }
            });
            returnData.put("data", data);
        }
        return returnData;
    }

    @Override
    protected Map<String, Object> getSingleValue() {
        ArrayList<String> data = new ArrayList<String>(2);
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        Object obj = this.sourceData;
        if (Objects.nonNull(obj)) {
            data.add(obj.toString());
        }
        returnData.put("data", data);
        return returnData;
    }

    @Override
    protected Map<String, Object> getMultiValue() {
        HashMap mapData;
        Object obj;
        String datasetMultiNumber;
        DynamicObject multiValueEntry;
        ArrayList<String> data = new ArrayList<String>(2);
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        if (Objects.nonNull(this.datasetMultiId) && this.datasetMultiId > 0L && Objects.nonNull(multiValueEntry = DatasetDataReader.getMultiDataSetValue(this.datasetMultiId, false)) && !StringUtils.isEmpty((CharSequence)(datasetMultiNumber = multiValueEntry.getString(NUMBER))) && Objects.nonNull(obj = (mapData = (HashMap)this.sourceData).get(datasetMultiNumber))) {
            String returnValue = obj.toString();
            if (CalculateHelper.checkNumber(returnValue)) {
                data.add(returnValue);
                returnData.put("data", data);
                return returnData;
            }
            returnValue = this.getErrorEesc(returnValue);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6570\u636e\u8ba1\u7b97\u5f02\u5e38:\"%s\"\u3002", (String)"AbstractCalculate_4", (String)"epm-far-business", (Object[])new Object[0]), returnValue);
            returnData.put("errorMsg", errorMsg);
            return returnData;
        }
        String errorMsg = ResManager.loadKDString((String)"\u7ec4\u4ef6\u6570\u636e\u8ba1\u7b97\u5f02\u5e38\u3002\u6240\u9009\u591a\u503c\u6570\u636e\u96c6\u7684\u516c\u5f0f\u4e0d\u5b58\u5728\u6216\u672a\u9009\u62e9\u3002", (String)"AnalysisDataPointCalculate_0", (String)"epm-far-business", (Object[])new Object[0]);
        returnData.put("errorMsg", errorMsg);
        return returnData;
    }

    @Override
    public void afterGetMultiValue(String datasetType, JSONObject itemObject, Object sourceData, Object data) {
        String moduleType = ModuleEnum.getModuleByNumber(itemObject.get((Object)"type").toString()).getType();
        if (!Objects.equals(moduleType, ModuleEnum.Analysis_DATA_POINT.getType())) {
            return;
        }
        JSONObject jsonObject = itemObject.getJSONObject(C).getJSONObject(CONFIG).getJSONObject(DATAPOINT).getJSONObject("child");
        if (Objects.isNull(jsonObject)) {
            return;
        }
        JSONObject datasetFormula = jsonObject.getJSONObject("datasetFormula");
        if (Objects.isNull(datasetFormula)) {
            return;
        }
        Object o = datasetFormula.get((Object)ID);
        if (!LongUtil.isvalidLong((Object)o)) {
            return;
        }
        Object datasetMultiNumber = datasetFormula.get((Object)NUMBER);
        if (Objects.isNull(datasetMultiNumber) || StringUtils.isEmpty((CharSequence)datasetMultiNumber.toString())) {
            return;
        }
        HashMap mapData = (HashMap)sourceData;
        Object obj = mapData.get(datasetMultiNumber.toString());
        if (Objects.isNull(obj)) {
            return;
        }
        JSONObject c = jsonObject.getJSONObject(C);
        if (Objects.nonNull(c)) {
            JSONObject dataPoint = c.getJSONObject(CONFIG).getJSONObject(DATAPOINT);
            dataPoint.put("data", (Object)obj.toString());
        }
    }
}

