/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.far.calculate;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.far.business.far.calculate.AbstractCalculate;
import kd.epm.far.business.far.calculate.AnalysisAbstractCalculate;
import kd.epm.far.business.far.enums.SortEnum;
import org.apache.commons.collections.CollectionUtils;

public class AnalysisPieCalculate
extends AnalysisAbstractCalculate {
    public AnalysisPieCalculate(String datasetType, Object sourceData, Object property, Map<String, Object> params) {
        super(datasetType, sourceData, property, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getMultiRow() {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        JSONObject requrestObject = (JSONObject)this.property;
        String legendNumber = this.getDataSetColumnName(requrestObject.getString("legendNumber"));
        String displayValueNumber = this.getDataSetColumnName(requrestObject.getString("displayValueNumber"));
        String legendDetailNumber = this.getDataSetColumnName(requrestObject.getString("legendDetailNumber"));
        ArrayList list = new ArrayList(10);
        returnData.put("data", list);
        try (DataSet dataSet = this.getDataSet();){
            if (dataSet.getRowMeta().getFieldCount() > 0) {
                if (StringUtils.isEmpty((CharSequence)legendNumber)) {
                    BigDecimal value = BigDecimal.ZERO;
                    for (Row e : dataSet.groupBy(new String[]{displayValueNumber}).sum(displayValueNumber).finish()) {
                        value = value.add(this.convertValueToDecimal(e.getString(displayValueNumber)));
                    }
                    HashMap<String, BigDecimal> r = new HashMap<String, BigDecimal>();
                    r.put("value", value);
                    list.add(r);
                } else if (StringUtils.isEmpty((CharSequence)legendDetailNumber)) {
                    for (Row e : dataSet.groupBy(new String[]{legendNumber}).sum(displayValueNumber).finish()) {
                        HashMap<String, Object> r = new HashMap<String, Object>();
                        r.put("name", this.getMemberName(e, legendNumber));
                        r.put("value", this.convertValueToDecimal(e.getString(displayValueNumber)));
                        list.add(r);
                    }
                } else {
                    for (Row e : dataSet.groupBy(new String[]{legendNumber, legendDetailNumber}).sum(displayValueNumber).finish()) {
                        HashMap<String, Object> r = new HashMap<String, Object>();
                        r.put("name", this.getMemberName(e, legendNumber));
                        r.put("detailName", this.getMemberName(e, legendDetailNumber));
                        r.put("value", this.convertValueToDecimal(e.getString(displayValueNumber)));
                        list.add(r);
                    }
                }
            }
        }
        return returnData;
    }

    @Override
    protected void sortReturnData(Object data) {
        String legendNumber;
        List list = (List)data;
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        ArrayList copyList = Lists.newArrayList((Iterable)list);
        JSONObject requrestObject = (JSONObject)this.property;
        String legendDetailNumber = requrestObject.getString("legendDetailNumber");
        if (StringUtils.isNotEmpty((CharSequence)legendDetailNumber)) {
            this.sort(list, SortEnum.getEnumByName(requrestObject.getString("sortSelectY")), false);
        }
        if (StringUtils.isNotEmpty((CharSequence)(legendNumber = requrestObject.getString("legendNumber")))) {
            this.sort(list, SortEnum.getEnumByName(requrestObject.getString("sortSelectX")), true);
        }
        if (StringUtils.isNotEmpty((CharSequence)requrestObject.getString("sortSelectY")) && StringUtils.isEmpty((CharSequence)requrestObject.getString("sortSelectX"))) {
            StringBuilder sb = new StringBuilder();
            copyList.forEach(t -> sb.append(t.get("name")).append(";"));
            requrestObject.put("customValueX", (Object)sb.toString());
            this.sort(list, SortEnum.custom, true);
        }
    }

    private void sort(List<Map<String, Object>> list, final SortEnum sortEnum, boolean isX) {
        if (sortEnum == null) {
            return;
        }
        String sortKey = isX ? "name" : "detailName";
        final Map<String, List<Map>> sortMap = list.stream().collect(Collectors.groupingBy(t -> (String)t.get(sortKey)));
        ArrayList newList = Lists.newArrayListWithCapacity((int)list.size());
        switch (sortEnum) {
            case NAME_ASC: 
            case NAME_DESC: {
                Stream<String> sortedX = sortMap.keySet().stream().sorted(new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return AbstractCalculate.toPinYinString(o1).compareTo(AbstractCalculate.toPinYinString(o2)) * sortEnum.getOrderBy();
                    }
                });
                sortedX.forEach(t -> newList.addAll((Collection)sortMap.get(t)));
                list.clear();
                list.addAll(newList);
                break;
            }
            case MONEY_ASC: 
            case MONEY_DESC: {
                Stream<String> sortedX = sortMap.keySet().stream().sorted(new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        List map1 = (List)sortMap.get(o1);
                        List map2 = (List)sortMap.get(o2);
                        BigDecimal totalMoney1 = BigDecimal.ZERO;
                        BigDecimal totalMoney2 = BigDecimal.ZERO;
                        for (Map map : map1) {
                            totalMoney1 = totalMoney1.add(new BigDecimal(map.get("value").toString()));
                        }
                        for (Map map : map2) {
                            totalMoney2 = totalMoney2.add(new BigDecimal(map.get("value").toString()));
                        }
                        return totalMoney1.compareTo(totalMoney2) * sortEnum.getOrderBy();
                    }
                });
                sortedX.forEach(t -> newList.addAll((Collection)sortMap.get(t)));
                list.clear();
                list.addAll(newList);
                break;
            }
            case custom: {
                JSONObject requrestObject = (JSONObject)this.property;
                String customValue = isX ? requrestObject.getString("customValueX") : requrestObject.getString("customValueY");
                if (StringUtils.isEmpty((CharSequence)customValue)) break;
                ArrayList customList = Arrays.stream(customValue.split(";")).distinct().collect(Collectors.toList());
                customList.retainAll(sortMap.keySet());
                if (CollectionUtils.isEmpty(customList)) {
                    customList = Lists.newArrayList(sortMap.keySet());
                }
                customList.forEach(t -> newList.addAll((Collection)sortMap.get(t)));
                for (Map.Entry<String, List<Map>> entry : sortMap.entrySet()) {
                    if (customList.contains(entry.getKey())) continue;
                    newList.addAll((Collection)entry.getValue());
                }
                list.clear();
                list.addAll(newList);
                break;
            }
        }
    }
}

