/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.far.calculate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.far.calculate.AnalysisAbstractCalculate;
import kd.epm.far.business.far.calculate.CalculateHelper;

public class AnalysisTableCalculate
extends AnalysisAbstractCalculate {
    private static final String NUMBER = "number";
    private static final String COL_TYPE = "col_type";
    private static final String COMPUTED_TYPE = "3";

    public AnalysisTableCalculate(String datasetType, Object sourceData, Object property, Map<String, Object> params) {
        super(datasetType, sourceData, property, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getMultiRow() {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        JSONObject requrestObject = (JSONObject)this.property;
        JSONArray tableColumns = requrestObject.getJSONArray("TableColumns");
        if (!Objects.nonNull(tableColumns) || tableColumns.size() == 0) {
            return returnData;
        }
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(10);
        HashMap sortData = Maps.newHashMapWithExpectedSize((int)tableColumns.size());
        try (DataSet dataSet = this.getDataSet();){
            JSONArray tableSorts;
            if (dataSet.getRowMeta().getFieldCount() > 0) {
                dataSet.forEach(e -> {
                    HashMap<Object, Object> item = new HashMap<Object, Object>(tableColumns.size());
                    HashMap computes = Maps.newHashMapWithExpectedSize((int)tableColumns.size());
                    for (Object e2 : tableColumns) {
                        String columnStr;
                        JSONObject cloumnObject = (JSONObject)e2;
                        String sourceColumn = cloumnObject.getString(NUMBER);
                        String string = cloumnObject.getString(COL_TYPE);
                        boolean isCompute = string.equals(COMPUTED_TYPE);
                        String string2 = columnStr = isCompute ? sourceColumn : this.getDataSetColumnName(sourceColumn);
                        if (!isCompute) {
                            sortData.putIfAbsent(sourceColumn, Lists.newArrayListWithExpectedSize((int)tableColumns.size()));
                            if (string.equals("1")) {
                                if (Objects.equals(columnStr, sourceColumn)) {
                                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8868\u683c\u5217\u7ef4\u201c%s\u201d\u5f02\u5e38\uff0c\u6570\u636e\u96c6\u5ea6\u91cf\u503c\u5df2\u53d8\u52a8\u6216\u8be5\u5217\u7ef4\u4e0d\u652f\u6301\u5206\u7ec4\u805a\u5408\u3002", (String)"AnalysisTableCalculate_3", (String)"epm-far-business", (Object[])new Object[0]), sourceColumn));
                                }
                                item.put(sourceColumn, this.getMemberName((Row)e, columnStr));
                                ((List)sortData.get(sourceColumn)).add(this.getMemberName((Row)e, columnStr));
                                continue;
                            }
                            item.put(sourceColumn, this.convertValueToDecimal(e.getString(columnStr)));
                            ((List)sortData.get(sourceColumn)).add(this.convertValueToDecimal(e.getString(columnStr)));
                            continue;
                        }
                        String computed = cloumnObject.getString("computed");
                        computed = computed.replaceAll("\uff08", "(");
                        computed = computed.replaceAll("\uff09", ")");
                        computes.put(columnStr, computed);
                    }
                    for (Map.Entry entry : computes.entrySet()) {
                        String cmp = (String)entry.getValue();
                        for (Map.Entry entry2 : item.entrySet()) {
                            if (Objects.isNull(entry2.getValue())) {
                                cmp = cmp.replaceAll((String)entry2.getKey(), "");
                                continue;
                            }
                            cmp = cmp.replaceAll((String)entry2.getKey(), entry2.getValue().toString());
                        }
                        if (Objects.equals(cmp, entry.getValue())) {
                            entry.setValue(cmp);
                        }
                        sortData.putIfAbsent(entry.getKey(), Lists.newArrayListWithExpectedSize((int)tableColumns.size()));
                        if (Objects.equals("", cmp)) {
                            item.put(entry.getKey(), BigDecimal.ZERO);
                            ((List)sortData.get(entry.getKey())).add(BigDecimal.ZERO);
                            continue;
                        }
                        try {
                            BigDecimal res = CalculateHelper.calculateByExpression(cmp);
                            item.put(entry.getKey(), res);
                            ((List)sortData.get(entry.getKey())).add(res);
                        }
                        catch (RuntimeException evExp) {
                            if (Objects.equals(evExp.getCause().getMessage(), "Division by zero")) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u5217\u5b58\u5728\u96640\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AnalysisTableCalculate_2", (String)"epm-far-business", (Object[])new Object[0]));
                            }
                            throw new KDBizException(evExp.getMessage());
                        }
                        catch (Exception exp) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u5217\u672a\u77e5\u9519\u8bef\u65e0\u6cd5\u89e3\u6790\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"AnalysisTableCalculate_1", (String)"epm-far-business", (Object[])new Object[0]));
                        }
                    }
                    if (item.size() > 0) {
                        data.add(item);
                    }
                });
            }
            if (Objects.nonNull(tableSorts = requrestObject.getJSONArray("TableSorts")) && tableSorts.size() > 0) {
                Comparator<Map<String, Object>> comparators = null;
                for (int i = 0; i < tableSorts.size(); ++i) {
                    JSONObject cur = tableSorts.getJSONObject(i);
                    String number = cur.getString(NUMBER);
                    String sort = cur.getString("sort");
                    boolean isMoney = Objects.equals(cur.getString(COL_TYPE), "2") || Objects.equals(cur.getString(COL_TYPE), COMPUTED_TYPE);
                    boolean isAsc = Objects.equals(sort, "asc");
                    if (Objects.equals(sort, "custom")) {
                        String[] customValues = cur.getString("customValue").split(";");
                        HashMap sortMap = Maps.newHashMapWithExpectedSize((int)customValues.length);
                        for (int j = 0; j < customValues.length; ++j) {
                            if (isMoney) {
                                BigDecimal cV = new BigDecimal(customValues[j]);
                                if (!((List)sortData.get(number)).contains(cV)) continue;
                                sortMap.put(cV, j);
                                continue;
                            }
                            if (!((List)sortData.get(number)).contains(customValues[j])) continue;
                            sortMap.put(customValues[j], j);
                        }
                        List objects = (List)sortData.get(number);
                        int finalLen = objects.size();
                        for (Object o : objects) {
                            sortMap.putIfAbsent(o, finalLen++);
                        }
                        if (comparators == null) {
                            comparators = this.buildComparator(number, sortMap);
                            continue;
                        }
                        comparators = comparators.thenComparing(this.buildComparator(number, sortMap));
                        continue;
                    }
                    comparators = comparators == null ? this.buildComparator(number, isAsc, isMoney) : comparators.thenComparing(this.buildComparator(number, isAsc, isMoney));
                }
                data.sort(comparators);
            }
            returnData.put("data", data);
        }
        return returnData;
    }

    private Comparator<Map<String, Object>> buildComparator(String number, boolean isAsc, boolean isMoney) {
        if (isAsc) {
            if (isMoney) {
                return Comparator.comparing(a -> new BigDecimal(String.valueOf(a.get(number))));
            }
            return Comparator.comparing(a -> AnalysisTableCalculate.toPinYinString(a.get(number).toString()));
        }
        if (isMoney) {
            return Comparator.comparing(a -> new BigDecimal(String.valueOf(a.get(number))), Comparator.reverseOrder());
        }
        return Comparator.comparing(a -> AnalysisTableCalculate.toPinYinString(a.get(number).toString()), Comparator.reverseOrder());
    }

    private Comparator<Map<String, Object>> buildComparator(String number, Map<Object, Integer> sortMap) {
        return Comparator.comparingInt(map -> (Integer)sortMap.get(map.get(number)));
    }
}

