/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.far.calculate;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.far.calculate.AbstractCalculate;
import kd.epm.far.business.far.calculate.ICalculate;
import kd.epm.far.business.far.enums.ModuleEnum;
import kd.epm.far.business.far.enums.VariableTypeEnum;
import kd.epm.far.business.far.model.ParamData;
import kd.epm.far.business.fidm.util.TypeUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CalculateHelper {
    public static final String DATASETTYPE_SINGLE = "1";
    public static final String DATASETTYPE_MULTIROW = "2";
    public static final String DATASETTYPE_MULTI = "3";
    public static final String ERROR_MSG = "errorMsg";

    public static ICalculate calInstance(String moduleType, String datasetType, Object sourceData, JSONObject itemObject, List<DatasetFilterItem> filterItems, Set<String> moneyKeys, Boolean isWithName) {
        AbstractCalculate calculateObj = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("filterItems", filterItems);
            params.put("moneyKeys", moneyKeys);
            params.put("isWithName", isWithName);
            params.put("datasetJson", itemObject.getJSONObject("dataset"));
            params.put("itemJson", itemObject);
            ModuleEnum moduleEnum = ModuleEnum.getModuleByType(moduleType);
            Constructor<?> constructor = moduleEnum.getCalculateClass().getConstructors()[0];
            calculateObj = (AbstractCalculate)constructor.newInstance(datasetType, sourceData, itemObject.getJSONObject("dataset").getJSONObject("request"), params);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u53ef\u89c6\u5316\u5bf9\u8c61\u5b9e\u4f8b\u5931\u8d25\u3002", (String)"CalculateHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return calculateObj;
    }

    public static DataSet createAlgoDataSet(List<Map<String, Object>> data, Set<String> numberKeys) {
        ArrayList<Object> columnList = null;
        columnList = CollectionUtils.isNotEmpty(data) ? new ArrayList<String>(data.get(0).keySet()) : new ArrayList();
        ArrayList<Object> typeList = new ArrayList<Object>(columnList.size());
        for (Object column : columnList) {
            if (Objects.nonNull(numberKeys) && numberKeys.contains(column)) {
                typeList.add(DataType.BigDecimalType);
                continue;
            }
            typeList.add(DataType.StringType);
        }
        ArrayList<Object[]> coll = new ArrayList<Object[]>(data.size());
        for (Map map : data) {
            Object[] tempData = new Object[columnList.size()];
            for (int i = 0; i < columnList.size(); ++i) {
                tempData[i] = map.get(columnList.get(i));
            }
            coll.add(tempData);
        }
        String[] columns = columnList.toArray(new String[columnList.size()]);
        DataType[] dataTypeArray = typeList.toArray(new DataType[typeList.size()]);
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])columns, (DataType[])dataTypeArray);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)CalculateHelper.class.getName()).createDataSet(new Input[]{inputs});
    }

    @Deprecated
    public static DataSet whereByFilter(DataSet dataSet, DynamicObjectCollection datasetfilter, Set<String> numberKeys) {
        if (CollectionUtils.isEmpty((Collection)datasetfilter)) {
            return dataSet;
        }
        for (DynamicObject filter : datasetfilter) {
            String filterName = filter.getString("dimensionnumber");
            String filterValue = filter.getString("membernumber");
            String condition = filter.getString("condition");
            String value = filter.getString("value");
            String realValue = null;
            realValue = Objects.nonNull(numberKeys) && numberKeys.contains(filterName) ? value : "'" + filterValue + "'";
            if (Objects.equals("is null", condition) || Objects.equals("is not null", condition)) {
                realValue = "";
            }
            dataSet = dataSet.where(filterName + condition + realValue);
        }
        return dataSet;
    }

    public static DataSet whereByFilter(DataSet dataSet, List<DatasetFilterItem> datasetfilter, Set<String> numberKeys) {
        if (CollectionUtils.isEmpty(datasetfilter)) {
            return dataSet;
        }
        for (DatasetFilterItem filter : datasetfilter) {
            String filterName = filter.getDimensionNumber();
            String filterValue = filter.getMemberNumber();
            String condition = filter.getCondition();
            String value = filter.getValue();
            String realValue = null;
            realValue = Objects.nonNull(numberKeys) && numberKeys.contains(filterName) ? value : "'" + filterValue + "'";
            if (Objects.equals("is null", condition) || Objects.equals("is not null", condition)) {
                condition = " " + condition;
                realValue = "";
            }
            dataSet = dataSet.where(filterName + condition + realValue);
        }
        return dataSet;
    }

    public static boolean isDimQueryConfig(ParamData paramData) {
        Integer valueType = paramData.getValuetype();
        String dimId = paramData.getDimid();
        return VariableTypeEnum.DIM.getCode() == valueType.intValue() && Objects.isNull(dimId);
    }

    public static boolean checkNumber(String str) {
        int dotCount = 0;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            char c = str.charAt(i);
            if (i == 0 && c == '-') {
                return true;
            }
            if (!(c == '.' ? ++dotCount >= 2 : !Character.isDigit(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPositiveInteger(String str, boolean needZero) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        String pattern = "^[1-9]\\d*$";
        if (needZero) {
            pattern = "^\\d*$";
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static BigDecimal calculateByExpression(String expression) {
        BigDecimal res = new BigDecimal(0);
        if (StringUtils.isBlank((CharSequence)expression)) {
            return res;
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("calulate");
        XSSFRow row = sheet.createRow(0);
        XSSFCell cell = row.getCell(1);
        if (cell == null) {
            cell = row.createCell(1, CellType.FORMULA);
        }
        try {
            cell.setCellFormula(expression);
        }
        catch (Exception ex) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f[%1$s]\u8ba1\u7b97\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MutilValueCalculate_0", (String)"epm-far-business", (Object[])new Object[0]), expression));
        }
        CellValue cellVal = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator().evaluate((Cell)cell);
        if (cellVal != null && cellVal.getCellType() == CellType.NUMERIC) {
            res = TypeUtils.convertValueToDecimal(String.valueOf(cellVal.getNumberValue()));
        }
        return res;
    }
}

