/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.far.module.middle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.LineShareModule;
import kd.epm.far.business.common.module.middle.node.format.ChartParametersNode;
import kd.epm.far.business.common.module.middle.node.format.base.DescriptNode;
import kd.epm.far.business.common.module.middle.node.format.base.RotateNode;
import kd.epm.far.business.common.module.middle.node.format.base.TimeRefreshNode;
import kd.epm.far.business.far.enums.ModuleEnum;
import kd.epm.far.business.far.module.middle.helper.AnalysisMiddleNodeHelper;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.middle.helper.DisclosureMiddleToJsonHelper;

public class LineModuleConvert
implements IMiddleModuleConvert<LineShareModule, JSONObject> {
    private List<String> tips = new ArrayList<String>(100);

    @Override
    public List<String> getTips() {
        return this.tips;
    }

    @Override
    public LineShareModule toMiddle(MiddleModuleInput input, JSONObject module) {
        LineShareModule.TypeEnum typeEnum = LineShareModule.TypeEnum.BAR;
        ModuleEnum moduleEnum = ModuleEnum.getModuleByNumber(DisclosureJsonHelper.getValue(module, "type", ""));
        if (ModuleEnum.Analysis_LINE_CHART_POLYLINE.getType().equalsIgnoreCase(moduleEnum.getType())) {
            typeEnum = LineShareModule.TypeEnum.LINE;
        } else if (ModuleEnum.Analysis_LINE_CHART_STACK_SQUARE.getType().equalsIgnoreCase(moduleEnum.getType())) {
            typeEnum = LineShareModule.TypeEnum.AREA;
        } else if (ModuleEnum.Analysis_BAR_CHART_BAR_AREATA.getType().equalsIgnoreCase(moduleEnum.getType())) {
            typeEnum = LineShareModule.TypeEnum.BAR_AREA;
        } else if (ModuleEnum.Analysis_BAR_CHART_BAR_POLYLINE_STACK.getType().equalsIgnoreCase(moduleEnum.getType())) {
            typeEnum = LineShareModule.TypeEnum.POLYLINE_STACK;
        } else if (ModuleEnum.Analysis_BAR_CHART_BAR_POLYLINE_AREATA.getType().equalsIgnoreCase(moduleEnum.getType())) {
            typeEnum = LineShareModule.TypeEnum.POLYLINE_AREA;
        } else if (ModuleEnum.Analysis_BAR_CHART_AREATA_BAR_CHART.getType().equalsIgnoreCase(moduleEnum.getType())) {
            typeEnum = LineShareModule.TypeEnum.AREATA_BAR;
        } else if (ModuleEnum.Analysis_BAR_CHART_STACK_BAR_CHART.getType().equalsIgnoreCase(moduleEnum.getType())) {
            typeEnum = LineShareModule.TypeEnum.STACKED_BAR;
        }
        LineShareModule middle = new LineShareModule();
        middle.type = typeEnum;
        middle.info = AnalysisMiddleNodeHelper.createInfo(module);
        middle.dataset = AnalysisMiddleNodeHelper.createDataset(module);
        middle.format = LineModuleConvert.createFormatNode(module);
        middle.layout = this.createLayoutNode(moduleEnum, module);
        return middle;
    }

    public static LineShareModule.FormatNode createFormatNode(JSONObject module) {
        JSONObject c = module.getJSONObject("c");
        JSONObject config = c.getJSONObject("config");
        LineShareModule.FormatNode formatNode = new LineShareModule.FormatNode();
        formatNode.title = AnalysisMiddleNodeHelper.createTitleNode(module);
        formatNode.legend = AnalysisMiddleNodeHelper.createLegendNode(module);
        formatNode.dataFormat = AnalysisMiddleNodeHelper.createDataFormatNode(config, "digitalFormat");
        formatNode.rotate = AnalysisMiddleNodeHelper.createRotateNode(config);
        formatNode.chartParameters = AnalysisMiddleNodeHelper.createChartParametersNode(c);
        formatNode.dataAreaZoom = AnalysisMiddleNodeHelper.createDataAreaZoomNode(config);
        formatNode.axisSettings = AnalysisMiddleNodeHelper.createAxisSettingsNode(module);
        formatNode.timeRefresh = AnalysisMiddleNodeHelper.createTimeRefreshNode(c);
        formatNode.gridLine = AnalysisMiddleNodeHelper.createGridLineNode(c);
        formatNode.background = AnalysisMiddleNodeHelper.createBackgroundNode(module);
        formatNode.border = AnalysisMiddleNodeHelper.createBorderNode(module);
        formatNode.desp = AnalysisMiddleNodeHelper.createDespNode(c);
        formatNode.dataPenetration = AnalysisMiddleNodeHelper.createDataPenetrationNode(config);
        formatNode.body = AnalysisMiddleNodeHelper.createBodyNode(module);
        return formatNode;
    }

    private LineShareModule.LayoutNode createLayoutNode(ModuleEnum moduleEnum, JSONObject module) {
        LineShareModule.LayoutNode layout = new LineShareModule.LayoutNode();
        layout.xAxisNumber = DisclosureJsonHelper.getValue(module, "dataset", "request", "xAxisNumber", "");
        layout.y1AxisNumber = DisclosureJsonHelper.getValue(module, "dataset", "request", "yAxisNumber", "");
        if (ModuleEnum.Analysis_BAR_CHART_AREATA_BAR_CHART.getNumber().equalsIgnoreCase(moduleEnum.getNumber()) || ModuleEnum.Analysis_BAR_CHART_STACK_BAR_CHART.getNumber().equalsIgnoreCase(moduleEnum.getNumber())) {
            layout.xAxisNumber = DisclosureJsonHelper.getValue(module, "dataset", "request", "yAxisNumber", "");
            layout.y1AxisNumber = DisclosureJsonHelper.getValue(module, "dataset", "request", "xAxisNumber", "");
        }
        layout.xSort = AnalysisMiddleNodeHelper.createSortNode(module, "sortSelectX", "customValueX");
        layout.y1LegendSort = AnalysisMiddleNodeHelper.createSortNode(module, "sortSelectY", "customValueY");
        layout.y1Legend = DisclosureJsonHelper.getValue(module, "dataset", "request", "legendNumber", "");
        JSONArray yAxisLineNumbers = DisclosureJsonHelper.getJSONArray(module, "dataset", "request", "yAxisLineNumbers");
        if (yAxisLineNumbers != null && yAxisLineNumbers.size() > 0) {
            layout.y2AxisNumber = yAxisLineNumbers.get(0).toString();
            layout.y2Legend = layout.y1Legend;
            layout.y2LegendSort = AnalysisMiddleNodeHelper.createSortNode(module, "sortSelectY", "customValueY");
        }
        return layout;
    }

    @Override
    public JSONObject toModule(MiddleModuleInput input, LineShareModule middle) {
        JSONObject module = this.getDefaultJsonObejct(middle.type);
        DisclosureMiddleToJsonHelper.createInfo(module, middle.info);
        AnalysisMiddleNodeHelper.createDataset(module, middle.dataset);
        LineModuleConvert.createLayout(module, middle.layout);
        LineModuleConvert.createFormat(module, middle.format);
        return module;
    }

    private JSONObject getDefaultJsonObejct(LineShareModule.TypeEnum typeEnum) {
        throw new KDBizException("default module values not implementation.");
    }

    public static void createLayout(JSONObject module, LineShareModule.LayoutNode layoutNode) {
        if (layoutNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5e03\u5c40\u6570\u636e\uff0c\u65e0\u6cd5\u8f6c\u6362\u3002", (String)"AnalysisMiddleNodeHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)layoutNode.xAxisNumber) || StringUtils.isEmpty((String)layoutNode.y1AxisNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e03\u5c40\u6570\u636e\u7684\u56fe\u4f8b/\u5c55\u793a\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8f6c\u6362\u3002", (String)"AnalysisMiddleNodeHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        JSONObject dataset = module.getJSONObject("dataset");
        JSONObject request = new JSONObject();
        boolean flag = dataset.containsKey((Object)"request");
        if (flag) {
            request = dataset.getJSONObject("request");
        }
        JSONObject xSort = DisclosureMiddleToJsonHelper.createSort(layoutNode.xSort);
        JSONObject ySort = DisclosureMiddleToJsonHelper.createSort(layoutNode.y1LegendSort);
        if (xSort != null) {
            request.put("sortSelectX", (Object)xSort.getString("type"));
            request.put("customValueX", (Object)xSort.getString("customValue"));
        }
        if (ySort != null) {
            request.put("sortSelectY", (Object)ySort.getString("type"));
            request.put("customValueY", (Object)ySort.getString("customValue"));
        }
        request.put("xAxisNumber", (Object)layoutNode.xAxisNumber);
        request.put("yAxisNumber", (Object)layoutNode.y1AxisNumber);
        if (!flag) {
            dataset.put("request", (Object)request);
        }
    }

    public static void createFormat(JSONObject module, LineShareModule.FormatNode formatNode) {
        JSONObject config;
        if (formatNode == null) {
            return;
        }
        JSONObject c = module.getJSONObject("c");
        if (c != null && (config = c.getJSONObject("config")) != null) {
            AnalysisMiddleNodeHelper.setDataFormat(config, formatNode.dataFormat);
            AnalysisMiddleNodeHelper.setDataAreaZoom(config, formatNode.dataAreaZoom);
            RotateNode rotate = formatNode.rotate;
            if (rotate == null) {
                rotate = new RotateNode();
            }
            DisclosureJsonHelper.setValue(config, "rotate", rotate.size, 0);
            ChartParametersNode chartParameters = formatNode.chartParameters;
            if (chartParameters == null) {
                chartParameters = new ChartParametersNode();
            }
            DisclosureJsonHelper.setValue(c, "chartParameters", chartParameters.enable, false);
            TimeRefreshNode timeRefresh = formatNode.timeRefresh;
            if (timeRefresh == null) {
                timeRefresh = new TimeRefreshNode();
            }
            DisclosureJsonHelper.setValue(c, "enableTimedRefresh", timeRefresh.enableTimedRefresh, false);
            DisclosureJsonHelper.setValue(c, "timeInterval", timeRefresh.timeInterval, 3);
            AnalysisMiddleNodeHelper.setGridLine(c, formatNode.gridLine);
            DescriptNode desp = formatNode.desp;
            if (desp == null) {
                desp = new DescriptNode();
            }
            DisclosureJsonHelper.setValue(c, "desp", "show", desp.visible, false);
            DisclosureJsonHelper.setValue(c, "desp", "content", desp.content, "");
            AnalysisMiddleNodeHelper.setDataPenetration(config, formatNode.dataPenetration);
        }
        AnalysisMiddleNodeHelper.setTitle(module, formatNode.title);
        AnalysisMiddleNodeHelper.setLegend(module, formatNode.legend);
        AnalysisMiddleNodeHelper.setBody(module, formatNode.body);
        AnalysisMiddleNodeHelper.setBackground(module, formatNode.background);
        AnalysisMiddleNodeHelper.setBorder(module, formatNode.border);
        AnalysisMiddleNodeHelper.setAxisSettingsNode(module, formatNode.axisSettings);
    }
}

