/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.far.module.middle;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.PieShareModule;
import kd.epm.far.business.common.module.middle.node.format.ChartParametersNode;
import kd.epm.far.business.common.module.middle.node.format.base.DescriptNode;
import kd.epm.far.business.common.module.middle.node.format.base.InfoNode;
import kd.epm.far.business.common.module.middle.node.format.base.LegendNode;
import kd.epm.far.business.common.module.middle.node.format.base.RotateNode;
import kd.epm.far.business.common.module.middle.node.format.base.TimeRefreshNode;
import kd.epm.far.business.common.module.middle.node.format.base.TitleNode;
import kd.epm.far.business.far.enums.ModuleEnum;
import kd.epm.far.business.far.module.middle.helper.AnalysisMiddleJsonHelper;
import kd.epm.far.business.far.module.middle.helper.AnalysisMiddleNodeHelper;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;

public class PieModuleConvert
implements IMiddleModuleConvert<PieShareModule, JSONObject> {
    private List<String> tips = new ArrayList<String>(100);

    @Override
    public List<String> getTips() {
        return this.tips;
    }

    @Override
    public PieShareModule toMiddle(MiddleModuleInput input, JSONObject module) {
        PieShareModule.TypeEnum typeEnum = PieShareModule.TypeEnum.PIE;
        ModuleEnum moduleEnum = ModuleEnum.getModuleByNumber(DisclosureJsonHelper.getValue(module, "type", ""));
        if (ModuleEnum.Analysis_PIE_CHART_DOUGHNUT.getType().equalsIgnoreCase(moduleEnum.getType())) {
            typeEnum = PieShareModule.TypeEnum.DOUGHNUT;
        } else if (ModuleEnum.Analysis_PIE_CHART_PIE_ROSE.getType().equalsIgnoreCase(moduleEnum.getType())) {
            typeEnum = PieShareModule.TypeEnum.ROSE;
        }
        PieShareModule middle = new PieShareModule();
        middle.type = typeEnum;
        middle.info = AnalysisMiddleNodeHelper.createInfo(module);
        middle.dataset = AnalysisMiddleNodeHelper.createDataset(module);
        middle.layout = this.createLayoutNode(module);
        middle.format = PieModuleConvert.createPieFormatNode(module);
        return middle;
    }

    private PieShareModule.LayoutNode createLayoutNode(JSONObject module) {
        PieShareModule.LayoutNode layout = new PieShareModule.LayoutNode();
        layout.legendNumber = DisclosureJsonHelper.getValue(module, "dataset", "request", "legendNumber", "");
        layout.displayValueNumber = DisclosureJsonHelper.getValue(module, "dataset", "request", "displayValueNumber", "");
        layout.legendSort = AnalysisMiddleNodeHelper.createSortNode(module, "sortSelectX", "customValueX");
        return layout;
    }

    public static PieShareModule.FormatNode createPieFormatNode(JSONObject module) {
        JSONObject c = module.getJSONObject("c");
        JSONObject config = c.getJSONObject("config");
        PieShareModule.FormatNode formatNode = new PieShareModule.FormatNode();
        formatNode.title = AnalysisMiddleNodeHelper.createTitleNode(module);
        formatNode.legend = PieModuleConvert.createLegendNode(module);
        formatNode.dataFormat = AnalysisMiddleNodeHelper.createDataFormatNode(config, "digitalFormat");
        formatNode.rotate = AnalysisMiddleNodeHelper.createRotateNode(config);
        formatNode.chartParameters = AnalysisMiddleNodeHelper.createChartParametersNode(c);
        formatNode.dataAreaZoom = AnalysisMiddleNodeHelper.createDataAreaZoomNode(config);
        formatNode.axisSettings = AnalysisMiddleNodeHelper.createAxisSettingsNode(module);
        formatNode.timeRefresh = AnalysisMiddleNodeHelper.createTimeRefreshNode(c);
        formatNode.gridLine = AnalysisMiddleNodeHelper.createGridLineNode(c);
        formatNode.background = AnalysisMiddleNodeHelper.createBackgroundNode(module);
        formatNode.border = AnalysisMiddleNodeHelper.createBorderNode(module);
        formatNode.desp = AnalysisMiddleNodeHelper.createDespNode(c);
        formatNode.dataPenetration = AnalysisMiddleNodeHelper.createDataPenetrationNode(config);
        formatNode.body = AnalysisMiddleNodeHelper.createBodyNode(module);
        return formatNode;
    }

    public static TitleNode createTitleNode(JSONObject module) {
        TitleNode titleNode = new TitleNode();
        titleNode.visible = DisclosureJsonHelper.getValue(module, "title", "visible", true);
        titleNode.content = DisclosureJsonHelper.getValue(module, "title", "name", "");
        titleNode.font = AnalysisMiddleNodeHelper.createFontNodeNode(DisclosureJsonHelper.getJsonObject(module, "c", "title"));
        return titleNode;
    }

    public static LegendNode createLegendNode(JSONObject module) {
        JSONObject charts = DisclosureJsonHelper.getJsonObject(module, "c", "config", "charts");
        JSONObject legend = DisclosureJsonHelper.getJsonObject(charts, "legend");
        LegendNode legendNode = new LegendNode();
        legendNode.visible = DisclosureJsonHelper.getValue(legend, "c", "show", true);
        legendNode.position = AnalysisMiddleNodeHelper.getLegendAlign(DisclosureJsonHelper.getValue(module, "c", "config", "legendPos", 0));
        legendNode.font = AnalysisMiddleNodeHelper.createFontNodeNode(DisclosureJsonHelper.getJsonObject(legend, "textStyle"));
        return legendNode;
    }

    @Override
    public JSONObject toModule(MiddleModuleInput input, PieShareModule middle) {
        JSONObject module = this.getDefaultJsonObejct(middle.type);
        PieModuleConvert.createInfo(module, middle.info);
        AnalysisMiddleNodeHelper.createDataset(module, middle.dataset);
        PieModuleConvert.createLayout(module, middle.layout);
        PieModuleConvert.createFormat(module, middle.format);
        return module;
    }

    public static void createInfo(JSONObject module, InfoNode infoNode) {
        AnalysisMiddleJsonHelper.createInfo(module, infoNode);
    }

    private JSONObject getDefaultJsonObejct(PieShareModule.TypeEnum typeEnum) {
        throw new KDBizException("default module values not implementation.");
    }

    public static void createLayout(JSONObject module, PieShareModule.LayoutNode layoutNode) {
        JSONObject sort;
        if (layoutNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5e03\u5c40\u6570\u636e\uff0c\u65e0\u6cd5\u8f6c\u6362\u3002", (String)"AnalysisMiddleNodeHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)layoutNode.legendNumber) || StringUtils.isEmpty((String)layoutNode.displayValueNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e03\u5c40\u6570\u636e\u7684\u56fe\u4f8b/\u5c55\u793a\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8f6c\u6362\u3002", (String)"AnalysisMiddleNodeHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        JSONObject dataset = module.getJSONObject("dataset");
        JSONObject request = new JSONObject();
        boolean flag = dataset.containsKey((Object)"request");
        if (flag) {
            request = dataset.getJSONObject("request");
        }
        if ((sort = AnalysisMiddleJsonHelper.createSort(layoutNode.legendSort)) != null) {
            request.put("sortSelectX", (Object)sort.getString("type"));
            request.put("customValueX", (Object)sort.getString("customValue"));
        }
        request.put("legendNumber", (Object)layoutNode.legendNumber);
        request.put("displayValueNumber", (Object)layoutNode.displayValueNumber);
        if (!flag) {
            dataset.put("request", (Object)request);
        }
    }

    public static void createFormat(JSONObject module, PieShareModule.FormatNode formatNode) {
        JSONObject config;
        if (formatNode == null) {
            return;
        }
        JSONObject c = module.getJSONObject("c");
        if (c != null && (config = c.getJSONObject("config")) != null) {
            AnalysisMiddleNodeHelper.setDataFormat(config, formatNode.dataFormat);
            AnalysisMiddleNodeHelper.setDataAreaZoom(config, formatNode.dataAreaZoom);
            RotateNode rotate = formatNode.rotate;
            if (rotate == null) {
                rotate = new RotateNode();
            }
            DisclosureJsonHelper.setValue(config, "rotate", rotate.size, 0);
            ChartParametersNode chartParameters = formatNode.chartParameters;
            if (chartParameters == null) {
                chartParameters = new ChartParametersNode();
            }
            DisclosureJsonHelper.setValue(c, "chartParameters", chartParameters.enable, false);
            TimeRefreshNode timeRefresh = formatNode.timeRefresh;
            if (timeRefresh == null) {
                timeRefresh = new TimeRefreshNode();
            }
            DisclosureJsonHelper.setValue(c, "enableTimedRefresh", timeRefresh.enableTimedRefresh, false);
            DisclosureJsonHelper.setValue(c, "timeInterval", timeRefresh.timeInterval, 3);
            AnalysisMiddleNodeHelper.setGridLine(c, formatNode.gridLine);
            DescriptNode desp = formatNode.desp;
            if (desp == null) {
                desp = new DescriptNode();
            }
            DisclosureJsonHelper.setValue(c, "desp", "show", desp.visible, false);
            DisclosureJsonHelper.setValue(c, "desp", "content", desp.content, "");
            AnalysisMiddleNodeHelper.setDataPenetration(config, formatNode.dataPenetration);
        }
        AnalysisMiddleNodeHelper.setTitle(module, formatNode.title);
        AnalysisMiddleNodeHelper.setLegend(module, formatNode.legend);
        AnalysisMiddleNodeHelper.setBody(module, formatNode.body);
        AnalysisMiddleNodeHelper.setBackground(module, formatNode.background);
        AnalysisMiddleNodeHelper.setBorder(module, formatNode.border);
        AnalysisMiddleNodeHelper.setAxisSettingsNode(module, formatNode.axisSettings);
    }
}

