/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.far.module.middle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.dto.TableShareModule;
import kd.epm.far.business.common.module.middle.node.format.ChartParametersNode;
import kd.epm.far.business.common.module.middle.node.format.base.DescriptNode;
import kd.epm.far.business.common.module.middle.node.format.base.FontNode;
import kd.epm.far.business.common.module.middle.node.format.base.ScrollNode;
import kd.epm.far.business.common.module.middle.node.format.base.TitleNode;
import kd.epm.far.business.common.module.middle.node.format.table.TableSettingsNode;
import kd.epm.far.business.common.module.middle.node.layout.SortNode;
import kd.epm.far.business.common.module.middle.node.layout.TotalNode;
import kd.epm.far.business.common.module.middle.node.layout.table.TableColumnNode;
import kd.epm.far.business.common.module.middle.node.layout.table.TableModelNode;
import kd.epm.far.business.far.enums.SortEnum;
import kd.epm.far.business.far.module.middle.helper.AnalysisMiddleJsonHelper;
import kd.epm.far.business.far.module.middle.helper.AnalysisMiddleNodeHelper;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.common.common.json.JacksonUtils;

public class TableModuleConvert
implements IMiddleModuleConvert<TableShareModule, JSONObject> {
    private List<String> tips = new ArrayList<String>(100);
    public static String DIGITALFORMAT = "digitalFormat";

    @Override
    public List<String> getTips() {
        return this.tips;
    }

    @Override
    public TableShareModule toMiddle(MiddleModuleInput input, JSONObject module) {
        TableShareModule middle = new TableShareModule();
        middle.info = AnalysisMiddleNodeHelper.createInfo(module);
        middle.dataset = AnalysisMiddleNodeHelper.createDataset(module);
        middle.format = TableModuleConvert.createFormatNode(module);
        middle.layout = this.createLayoutNode(module);
        return middle;
    }

    public static TableShareModule.FormatNode createFormatNode(JSONObject module) {
        JSONObject config = module.getJSONObject("c");
        JSONObject tableModel = config.getJSONObject("tableModel");
        TableShareModule.FormatNode formatNode = new TableShareModule.FormatNode();
        formatNode.dataFormat = AnalysisMiddleNodeHelper.createDataFormatNode(config, DIGITALFORMAT);
        formatNode.body = AnalysisMiddleNodeHelper.createBodyNode(module);
        formatNode.background = AnalysisMiddleNodeHelper.createBackgroundNode(module);
        formatNode.border = AnalysisMiddleNodeHelper.createBorderNode(module);
        formatNode.chartParameters = AnalysisMiddleNodeHelper.createChartParametersNode(config);
        formatNode.desp = AnalysisMiddleNodeHelper.createDespNode(config);
        formatNode.title = TableModuleConvert.createTitleNode(module);
        if (tableModel != null) {
            formatNode.scroll = AnalysisMiddleNodeHelper.createScrollNode(tableModel);
            formatNode.total = TableModuleConvert.createTotalNode(tableModel);
            formatNode.tableSettings = TableModuleConvert.createTableSettingsNode(tableModel);
            formatNode.font = AnalysisMiddleNodeHelper.createFontNodeNode(tableModel.getJSONObject("row"));
        }
        return formatNode;
    }

    public static TitleNode createTitleNode(JSONObject module) {
        TitleNode titleNode = new TitleNode();
        titleNode.visible = DisclosureJsonHelper.getValue(module, "c", "title", "show", true);
        titleNode.content = DisclosureJsonHelper.getValue(module, "title", "");
        titleNode.font = AnalysisMiddleNodeHelper.createFontNodeNode(DisclosureJsonHelper.getJsonObject(module, "c", "title"));
        return titleNode;
    }

    private static TableSettingsNode createTableSettingsNode(JSONObject tableModel) {
        TableSettingsNode tableSettings = new TableSettingsNode();
        JSONObject row = tableModel.getJSONObject("row");
        if (row == null) {
            return tableSettings;
        }
        tableSettings.enableHG = DisclosureJsonHelper.getValue(row, "enableHG", true);
        tableSettings.enableHGW = DisclosureJsonHelper.getValue(row, "enableHGW", 1);
        tableSettings.backColorH = DisclosureJsonHelper.getValue(row, "backColorH", "");
        tableSettings.enableVG = DisclosureJsonHelper.getValue(row, "enableVG", true);
        tableSettings.enableVGC = DisclosureJsonHelper.getValue(row, "enableVGC", "");
        tableSettings.backColorB = DisclosureJsonHelper.getValue(row, "backColorB", "");
        tableSettings.enableHGC = DisclosureJsonHelper.getValue(row, "enableHGC", "");
        tableSettings.enableVGW = DisclosureJsonHelper.getValue(row, "enableVGW", 1);
        tableSettings.height = DisclosureJsonHelper.getValue(row, "height", 44);
        return tableSettings;
    }

    private static TotalNode createTotalNode(JSONObject tableModel) {
        JSONObject total = tableModel.getJSONObject("total");
        TotalNode totalNode = new TotalNode();
        if (total != null) {
            totalNode.name = total.getString("name");
            totalNode.show = total.getBoolean("show") != null;
        }
        return totalNode;
    }

    private TableShareModule.LayoutNode createLayoutNode(JSONObject module) {
        JSONObject dataset = module.getJSONObject("dataset");
        boolean flag = dataset.containsKey((Object)"request");
        TableShareModule.LayoutNode layout = new TableShareModule.LayoutNode();
        layout.tableModel = TableModuleConvert.createTableModel(module);
        if (flag) {
            JSONObject request = dataset.getJSONObject("request");
            layout.tableColumns = TableModuleConvert.createTableColumns(request);
        }
        return layout;
    }

    @Override
    public JSONObject toModule(MiddleModuleInput input, TableShareModule middle) {
        JSONObject module = this.getDefaultJsonObejct();
        AnalysisMiddleJsonHelper.createInfo(module, middle.info);
        AnalysisMiddleNodeHelper.createDataset(module, middle.dataset);
        TableModuleConvert.createFormat(module, middle.format);
        TableModuleConvert.createLayout(module, middle.layout);
        return module;
    }

    public static void createFormat(JSONObject module, TableShareModule.FormatNode formatNode) {
        if (formatNode == null) {
            return;
        }
        JSONObject config = module.getJSONObject("c");
        if (config != null) {
            AnalysisMiddleNodeHelper.setDataFormat(config, formatNode.dataFormat, "digitalFormat");
            JSONObject tableModel = config.getJSONObject("tableModel");
            ChartParametersNode chartParameters = formatNode.chartParameters;
            if (chartParameters == null) {
                chartParameters = new ChartParametersNode();
            }
            DisclosureJsonHelper.setValue(config, "chartParameters", chartParameters.enable, false);
            DescriptNode desp = formatNode.desp;
            if (desp == null) {
                desp = new DescriptNode();
            }
            DisclosureJsonHelper.setValue(config, "desp", "show", desp.visible, false);
            DisclosureJsonHelper.setValue(config, "desp", "content", desp.content, "");
            if (tableModel != null) {
                JSONObject row = tableModel.getJSONObject("row");
                AnalysisMiddleNodeHelper.setFontStyle(row, formatNode.font);
                TableModuleConvert.setTitle(module, formatNode);
                TableModuleConvert.setTableSettings(row, formatNode);
                ScrollNode scroll = formatNode.scroll;
                if (scroll == null) {
                    scroll = new ScrollNode();
                }
                DisclosureJsonHelper.setValue(tableModel, "isScroll", scroll.enable, true);
                TableModuleConvert.setTotal(tableModel, formatNode);
            }
        }
        AnalysisMiddleNodeHelper.setBody(module, formatNode.body);
        AnalysisMiddleNodeHelper.setBackground(module, formatNode.background);
        AnalysisMiddleNodeHelper.setBorder(module, formatNode.border);
    }

    private static void setTotal(JSONObject tableModel, TableShareModule.FormatNode formatNode) {
        TotalNode total = formatNode.total;
        DisclosureJsonHelper.setValue(tableModel, "total", "name", total.name, "");
        DisclosureJsonHelper.setValue(tableModel, "total", "show", total.show, false);
    }

    public static void setTableSettings(JSONObject row, TableShareModule.FormatNode formatNode) {
        TableSettingsNode tableSettings = formatNode.tableSettings;
        DisclosureJsonHelper.setValue(row, "enableHG", tableSettings.enableHG, true);
        DisclosureJsonHelper.setValue(row, "enableHGW", tableSettings.enableHGW, 1);
        DisclosureJsonHelper.setValue(row, "backColorH", tableSettings.backColorH, "");
        DisclosureJsonHelper.setValue(row, "enableVG", tableSettings.enableVG, true);
        DisclosureJsonHelper.setValue(row, "enableVGC", tableSettings.enableVGC, "");
        DisclosureJsonHelper.setValue(row, "backColorB", tableSettings.backColorB, "");
        DisclosureJsonHelper.setValue(row, "enableHGC", tableSettings.enableHGC, "");
        DisclosureJsonHelper.setValue(row, "enableVGW", tableSettings.enableVGW, 1);
        DisclosureJsonHelper.setValue(row, "height", tableSettings.height, 44);
    }

    public static void setTitle(JSONObject module, TableShareModule.FormatNode formatNode) {
        TitleNode titleNode = formatNode.title;
        FontNode font = titleNode.font;
        DisclosureJsonHelper.setValue(module, "c", "title", "show", titleNode.visible, true);
        DisclosureJsonHelper.setValue(module, "title", titleNode.content, "");
        AnalysisMiddleNodeHelper.setFontStyle(DisclosureJsonHelper.getJsonObject(module, "c", "title"), font);
    }

    private JSONObject getDefaultJsonObejct() {
        String defaultStr = "{\"c\":{\"showBack\":true,\"borderColor\":\"rgba(255,255,255, 1)\",\"chartModel\":{\"add\":true,\"relationName\":[],\"edit\":false,\"drillMem\":\"\",\"relationId\":[],\"drill\":false},\"bkColor\":\"#FFFFFF\",\"enableTimedRefresh\":false,\"gridLineShow\":true,\"minWidth\":200,\"title\":{\"backColor\":\"#FFFFFF\",\"underline\":\"none\",\"show\":true,\"fontSize\":18,\"fontStyle\":\"normal\",\"align\":\"center\",\"foreColor\":\"#2A2A2A\",\"fontWeight\":\"normal\"},\"showBorder\":true,\"visibles\":[true,true,true],\"mainVerticalAxis\":\"false\",\"spindleSecondaryVertical\":\"false\",\"minHeight\":260,\"desp\":{\"show\":false,\"content\":\"\"},\"borderOpacity\":1,\"mainLevelMainShaft\":\"true\",\"borderWidth\":0,\"spindleSecondaryLevel\":\"false\",\"chartParameters\":false,\"timeInterval\":3,\"opacity\":1,\"borderStyle\":\"dotted\",\"config\":{\"compLinkage\":{\"filterDims\":[],\"isHighLight\":false,\"ids\":[],\"dimMap\":{},\"status\":false},\"rotate\":0,\"charts\":{\"yAxis\":[{\"axisLabel\":{\"rotate\":0,\"textStyle\":{\"enable\":true,\"fontSize\":\"12\",\"fontStyle\":\"normal\",\"fontWeight\":\"normal\"}},\"nameRotate\":90,\"splitLine\":{\"show\":true},\"name\":\"\u5ea6\u91cf\u503c\",\"nameGap\":40,\"nameLocation\":\"middle\",\"type\":\"value\",\"minorSplitLine\":{\"show\":false}},{\"axisLabel\":{\"rotate\":0,\"textStyle\":{\"enable\":true,\"fontSize\":\"12\",\"fontStyle\":\"normal\",\"fontWeight\":\"normal\"}},\"nameGap\":30,\"type\":\"value\"}],\"backgroundColor\":\"transparent\",\"xAxis\":[{\"axisLabel\":{\"rotate\":0,\"textStyle\":{\"enable\":true,\"fontSize\":\"12\",\"fontStyle\":\"normal\",\"fontWeight\":\"normal\"}},\"data\":[\"\u4e00\u6708\",\"\u4e8c\u6708\",\"\u4e09\u6708\",\"\u56db\u6708\",\"\u4e94\u6708\",\"\u516d\u6708\",\"\u4e03\u6708\"],\"nameRotate\":0,\"splitLine\":{\"show\":false},\"name\":\"\u8d22\u5e74\",\"nameGap\":25,\"nameLocation\":\"middle\",\"type\":\"category\",\"minorSplitLine\":{\"show\":false}}],\"legend\":{\"orient\":\"horizontal\",\"show\":true,\"textStyle\":{},\"align\":\"auto\"},\"grid\":{\"x\":28,\"y\":60,\"y2\":20,\"x2\":20,\"containLabel\":true},\"series\":[{\"data\":[100,200,300,400,500,600,700],\"name\":\"A\u90e8\u95e8\",\"emphasis\":{\"focus\":\"series\"},\"label\":{\"position\":\"inside\"},\"type\":\"line\"},{\"data\":[200,300,400,500,600,700,800],\"name\":\"B\u90e8\u95e8\",\"emphasis\":{\"focus\":\"series\"},\"label\":{\"position\":\"inside\"},\"type\":\"line\"},{\"data\":[300,400,500,600,700,800,900],\"name\":\"C\u90e8\u95e8\",\"emphasis\":{\"focus\":\"series\"},\"label\":{\"position\":\"inside\"},\"type\":\"line\"},{\"data\":[400,500,600,700,800,900,1000],\"name\":\"D\u90e8\u95e8\",\"emphasis\":{\"focus\":\"series\"},\"label\":{\"position\":\"inside\"},\"type\":\"line\"}],\"tooltip\":{\"appendToBody\":true,\"axisPointer\":{\"type\":\"shadow\"},\"trigger\":\"axis\"},\"textStyle\":{\"enable\":true,\"fontSize\":\"12\",\"fontStyle\":\"normal\",\"fontWeight\":\"normal\"},\"label\":{\"rotate\":0,\"show\":false,\"fontSize\":14,\"align\":\"center\",\"fontStyle\":\"normal\",\"fontWeight\":\"normal\"}},\"dataDrillingDown\":{\"path\":[],\"nextRotateEabled\":false,\"type\":\"1\",\"nextDirectEabled\":false},\"dataAreaZoom\":{\"status\":false},\"openStyle\":\"\",\"yLineRotate\":0,\"digitalFormat\":{\"unit\":1,\"data\":\"10000000.1234\",\"unitarea\":1,\"prefix\":\"\",\"enableThousands\":false,\"dataLabelType\":\"default\",\"suffix\":\"\",\"currencySymbols\":\"\u00a5\",\"digitalType\":\"digital\",\"decimalPlace\":2},\"show\":true,\"nextLevelData\":\"\",\"rateSuffix\":\"\",\"top\":\"center\",\"xAxisValue\":{\"min\":0,\"max\":0,\"enabled\":false},\"xRotate\":0,\"map\":{\"dataDisplayMode\":0,\"mapColorConfigMode\":5,\"type\":\"china\",\"displayMode\":0},\"dashboard\":{\"datasetFormula\":[{},{},{},{}],\"data\":\"50\",\"max\":100,\"prefix\":\"\",\"datasetTypes\":[\"\",\"\",\"\",\"\"],\"suffix\":\"\",\"currencySymbols\":\"\u00a5\",\"decimalPlace\":2,\"targetValueCount\":2,\"unit\":1,\"min\":0,\"enableThousands\":false,\"aimValues\":[30,70],\"digitalType\":\"digital\"},\"tagRotate\":0,\"waterfull\":{\"colors\":{\"summary\":\"#0c8fff\",\"up\":\"#1aab40\",\"down\":\"#d64554\"}},\"orient\":\"vertical\",\"yRotate\":0,\"dataNextLevel\":{\"nextLevelData\":\"\",\"status\":false},\"xDigitalFormat\":{\"unit\":1,\"data\":\"10000000.1234\",\"unitarea\":1,\"enable\":true,\"prefix\":\"\",\"enableThousands\":true,\"dataLabelType\":\"default\",\"suffix\":\"\",\"currencySymbols\":\"\u00a5\",\"digitalType\":\"digital\",\"decimalPlace\":2},\"yLDigitalFormat\":{\"unit\":1,\"data\":\"10000000.1234\",\"unitarea\":1,\"enable\":true,\"prefix\":\"\",\"enableThousands\":true,\"dataLabelType\":\"default\",\"suffix\":\"\",\"currencySymbols\":\"\u00a5\",\"digitalType\":\"digital\",\"decimalPlace\":2},\"legendPos\":2,\"yDigitalFormat\":{\"unit\":1,\"data\":\"10000000.1234\",\"unitarea\":1,\"enable\":true,\"prefix\":\"\",\"enableThousands\":true,\"dataLabelType\":\"default\",\"suffix\":\"\",\"currencySymbols\":\"\u00a5\",\"digitalType\":\"digital\",\"decimalPlace\":2},\"label\":\"\",\"sort\":\"\",\"yTextStyle\":{\"color\":\"#6f6f6f\",\"enable\":true,\"fontSize\":12,\"fontStyle\":\"normal\",\"fontWeight\":\"normal\"},\"tagTextStyle\":{\"color\":\"#6f6f6f\",\"fontSize\":12,\"fontStyle\":\"normal\",\"fontWeight\":\"normal\"},\"dataJointSearch\":{\"status\":false},\"yAxisValue\":{\"min\":0,\"max\":0,\"enabled\":false},\"p\":4,\"unit\":1,\"xTextStyle\":{\"color\":\"#6f6f6f\",\"enable\":true,\"fontSize\":12,\"fontStyle\":\"normal\",\"fontWeight\":\"normal\"},\"left\":\"right\",\"yLAxisValue\":{\"min\":0,\"max\":0,\"enabled\":false},\"yLineSubRotate\":0}},\"isNewAdd\":false,\"level\":1,\"h\":320,\"active\":true,\"index\":1,\"pid\":\"0\",\"type\":\"analysis_line_chart_polyline\",\"title\":\"\u6807\u9898\",\"s\":\"\",\"w\":500,\"name\":\"\u6298\u7ebf\u56fe2\",\"x\":10,\"y\":10,\"id\":\"1911664672172419072\",\"dataset\":{\"number\":\"TestMulRow001\",\"request\":{\"xAxisReName\":\"\u8d22\u5e74\",\"yAxisReName\":\"\u5ea6\u91cf\u503c\",\"yTitleShow\":false,\"sortSelectX\":\"\",\"sortSelectY\":\"\",\"xTitleShow\":false,\"xAxisNumber\":\"Year\",\"ynameRotate\":90,\"xnameRotate\":0,\"yAxisNumber\":\"FMONEY\",\"yAxisLineNumbers\":[],\"yLineSubRotate\":-90},\"dataSrcType\":\"bcm_model\",\"dimParams\":[],\"name\":\"\u591a\u884c\u6570\u636e\u96c6\",\"datesetFilterItems\":[],\"id\":\"1909593124921979904\",\"detail\":[{\"number\":\"Period\",\"name\":\"\u671f\u95f4\",\"member\":[\"M_M01\",\"M_M02\",\"M_M03\",\"M_M04\"],\"id\":\"Period\",\"type\":\"LCD\",\"col_type\":\"1\"},{\"number\":\"Account\",\"name\":\"\u79d1\u76ee\",\"member\":[\"R1003\"],\"id\":\"Account\",\"type\":\"LCD\",\"col_type\":\"1\"},{\"number\":\"Scenario\",\"name\":\"\u60c5\u666f\",\"member\":[\"MRpt\"],\"id\":\"Scenario\",\"type\":\"LCD\",\"col_type\":\"1\"},{\"number\":\"Year\",\"name\":\"\u8d22\u5e74\",\"member\":[\"FY2020\",\"FY2021\",\"FY2022\",\"FY2023\"],\"id\":\"Year\",\"type\":\"LCD\",\"col_type\":\"1\"},{\"number\":\"Entity\",\"name\":\"\u7ec4\u7ec7\",\"member\":[\"Entity.idescendants\"],\"id\":\"Entity\",\"type\":\"LCD\",\"col_type\":\"1\"},{\"number\":\"FMONEY\",\"name\":\"\u5ea6\u91cf\u503c\",\"id\":\"FMONEY\",\"type\":\"DM\",\"col_type\":\"2\"}],\"type\":\"2\",\"varParams\":[]},\"switchXY\":false,\"CGTheme\":{\"system\":true,\"canvasBgColor\":\"#f2f3f5\",\"index\":0,\"theme\":\"\",\"title\":\"\u9ed8\u8ba4\",\"compBgColor\":\"#FFFFFF\",\"contrastColor\":\"#2A2A2A\"}}";
        return AnalysisMiddleJsonHelper.getDefaultJsonObejct(defaultStr);
    }

    public static void createLayout(JSONObject module, TableShareModule.LayoutNode layoutNode) {
        if (layoutNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5e03\u5c40\u6570\u636e\uff0c\u65e0\u6cd5\u8f6c\u6362\u3002", (String)"AnalysisMiddleNodeHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        JSONObject dataset = module.getJSONObject("dataset");
        JSONObject request = new JSONObject();
        boolean flag = dataset.containsKey((Object)"request");
        if (flag) {
            request = dataset.getJSONObject("request");
        }
        TableModuleConvert.createTableModelNode(module, layoutNode.tableModel);
        TableModuleConvert.createTableNode(request, layoutNode.tableColumns, "TableColumns");
        if (!flag) {
            dataset.put("request", (Object)request);
        }
    }

    private static void createTableNode(JSONObject request, ArrayList<?> tableColumns, String key) {
        JSONArray tableColumn = new JSONArray();
        tableColumns.stream().forEach(c -> {
            JSONObject datasetObj = JSONObject.parseObject((String)JacksonUtils.toJson((Object)c));
            tableColumn.add((Object)datasetObj);
        });
        if (StringUtils.isNotEmpty((String)key)) {
            request.put(key, (Object)tableColumn);
        }
    }

    private static void createTableModelNode(JSONObject module, TableModelNode tableModel) {
        JSONObject config = module.getJSONObject("c");
        JSONObject tableModelNode = config.getJSONObject("tableModel");
        if (tableModelNode == null) {
            return;
        }
        DisclosureJsonHelper.setValue(tableModelNode, "header", tableModel.header, new ArrayList());
        DisclosureJsonHelper.setValue(tableModelNode, "bkColor", tableModel.bkColor, "");
        DisclosureJsonHelper.setValue(tableModelNode, "show", tableModel.show, true);
    }

    public static TableModelNode createTableModel(JSONObject module) {
        JSONObject config = module.getJSONObject("c");
        JSONObject tableModel = config.getJSONObject("tableModel");
        if (tableModel == null) {
            return new TableModelNode();
        }
        TableModelNode tableModelNode = new TableModelNode();
        tableModelNode.header = tableModel.getJSONArray("header");
        tableModelNode.bkColor = DisclosureJsonHelper.getValue(tableModel, "bkColor", "");
        tableModelNode.show = DisclosureJsonHelper.getValue(tableModel, "show", true);
        return tableModelNode;
    }

    public static ArrayList<TableColumnNode> createTableColumns(JSONObject request) {
        ArrayList<TableColumnNode> tableColumnResults = new ArrayList<TableColumnNode>();
        List<JSONObject> tableColumns = DisclosureJsonHelper.getJSONObjectList(request.getJSONArray("TableColumns"));
        List<JSONObject> tableSorts = DisclosureJsonHelper.getJSONObjectList(request.getJSONArray("TableSorts"));
        for (JSONObject item : tableColumns) {
            TableColumnNode columnNode = (TableColumnNode)JSON.parseObject((String)item.toJSONString(), TableColumnNode.class);
            JSONObject find = tableSorts.stream().filter(m -> columnNode.number.equalsIgnoreCase(m.getString("number"))).findFirst().orElse(null);
            if (find != null) {
                String sort = find.getString("sort");
                boolean isAsc = "asc".equalsIgnoreCase(sort);
                String customValue = find.getString("customValue");
                String col_type = find.getString("col_type");
                SortEnum sortEnum = null;
                if ("custom".equalsIgnoreCase(sort)) {
                    sortEnum = SortEnum.custom;
                } else if ("2".equalsIgnoreCase(col_type)) {
                    sortEnum = isAsc ? SortEnum.MONEY_ASC : SortEnum.MONEY_DESC;
                } else {
                    SortEnum sortEnum2 = sortEnum = isAsc ? SortEnum.NAME_ASC : SortEnum.NAME_DESC;
                }
                if (sortEnum != null) {
                    SortNode sortNode = new SortNode();
                    sortNode.type = sortEnum;
                    sortNode.customValue = customValue;
                    columnNode.sort = sortNode;
                }
            }
            tableColumnResults.add(columnNode);
        }
        return tableColumnResults;
    }
}

