/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.far.module.middle.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.DataPatternEnum;
import kd.epm.far.business.common.module.middle.node.dataset.DatasetNode;
import kd.epm.far.business.common.module.middle.node.format.ChartParametersNode;
import kd.epm.far.business.common.module.middle.node.format.CompLinkageNode;
import kd.epm.far.business.common.module.middle.node.format.DataAreaZoomNode;
import kd.epm.far.business.common.module.middle.node.format.DataDrillingDownNode;
import kd.epm.far.business.common.module.middle.node.format.DataJointSearchNode;
import kd.epm.far.business.common.module.middle.node.format.DataNextLevelNode;
import kd.epm.far.business.common.module.middle.node.format.DataPenetrationNode;
import kd.epm.far.business.common.module.middle.node.format.axis.AxisNode;
import kd.epm.far.business.common.module.middle.node.format.axis.AxisSettingsNode;
import kd.epm.far.business.common.module.middle.node.format.axis.AxisValueNode;
import kd.epm.far.business.common.module.middle.node.format.axis.GridLineNode;
import kd.epm.far.business.common.module.middle.node.format.base.BackgroundNode;
import kd.epm.far.business.common.module.middle.node.format.base.BodyNode;
import kd.epm.far.business.common.module.middle.node.format.base.BorderNode;
import kd.epm.far.business.common.module.middle.node.format.base.DataFormatNode;
import kd.epm.far.business.common.module.middle.node.format.base.DescriptNode;
import kd.epm.far.business.common.module.middle.node.format.base.FontNode;
import kd.epm.far.business.common.module.middle.node.format.base.InfoNode;
import kd.epm.far.business.common.module.middle.node.format.base.LegendNode;
import kd.epm.far.business.common.module.middle.node.format.base.RotateNode;
import kd.epm.far.business.common.module.middle.node.format.base.ScrollNode;
import kd.epm.far.business.common.module.middle.node.format.base.TextNode;
import kd.epm.far.business.common.module.middle.node.format.base.TimeRefreshNode;
import kd.epm.far.business.common.module.middle.node.format.base.TitleNode;
import kd.epm.far.business.common.module.middle.node.layout.SortNode;
import kd.epm.far.business.far.enums.SortEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.common.common.json.JacksonUtils;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;

public class AnalysisMiddleNodeHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, AnalysisMiddleNodeHelper.class);
    public static double FarModuleUnit = 500.0;

    public static InfoNode createInfo(JSONObject module) {
        InfoNode info = new InfoNode();
        info.id = DisclosureJsonHelper.getValue(module, "id", 0L);
        info.name = DisclosureJsonHelper.getValue(module, "name", "");
        info.number = DisclosureJsonHelper.getValue(module, "number", "");
        info.level = DisclosureJsonHelper.getValue(module, "level", 0);
        info.index = DisclosureJsonHelper.getValue(module, "index", 1);
        return info;
    }

    public static DatasetNode createDataset(JSONObject module) {
        Long datasetId = DisclosureJsonHelper.getValue(module, "dataset", "id", 0L);
        if (!LongUtil.isvalidLong((Object)datasetId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u8282\u70b9\u8f6c\u6362\uff0c\u65e0\u6570\u636e\u96c6\u6570\u636e\u3002", (String)"ModuleMiddleHelper_11", (String)"epm-far-business", (Object[])new Object[0]));
        }
        try {
            return (DatasetNode)JSON.parseObject((String)module.getJSONObject("dataset").toJSONString(), DatasetNode.class);
        }
        catch (Exception ex) {
            logger.error("far createDataset error:" + module.toJSONString(), (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u8282\u70b9\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u65e5\u5fd7\u3002", (String)"ModuleMiddleHelper_12", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static BodyNode createBodyNode(JSONObject module) {
        double width = DisclosureJsonHelper.getValue(module, "w", FarModuleUnit);
        double height = DisclosureJsonHelper.getValue(module, "h", 0);
        double positionX = DisclosureJsonHelper.getValue(module, "x", 0);
        double positionY = DisclosureJsonHelper.getValue(module, "y", 0);
        BodyNode bodyNode = new BodyNode();
        if (width > 0.0) {
            bodyNode.width = width / FarModuleUnit * 100.0;
            bodyNode.height = height / width * 100.0;
            bodyNode.positionX = positionX / width * 100.0;
            bodyNode.positionY = positionY / width * 100.0;
        }
        return bodyNode;
    }

    public static SortNode createSortNode(JSONObject module, String sortSelectNodeName, String customValueNodeName) {
        String typeName = DisclosureJsonHelper.getValue(module, "dataset", "request", sortSelectNodeName, "");
        String customValue = DisclosureJsonHelper.getValue(module, "dataset", "request", customValueNodeName, "");
        if (StringUtils.isEmpty((String)typeName)) {
            return null;
        }
        SortEnum sortEnum = SortEnum.getEnumByName(typeName);
        if (sortEnum == null) {
            return null;
        }
        SortNode sortNode = new SortNode();
        sortNode.type = SortEnum.getEnumByName(typeName);
        sortNode.customValue = customValue;
        return sortNode;
    }

    public static DataFormatNode createDataFormatNode(JSONObject config, String dataFormatNodeName) {
        DataFormatNode dataFormatNode = new DataFormatNode();
        dataFormatNode.visible = DisclosureJsonHelper.getValue(config, "charts", "label", "show", true);
        dataFormatNode.unit = DataPatternEnum.getDataPatternByRatio(DisclosureJsonHelper.getValue(config, dataFormatNodeName, "unit", 1));
        dataFormatNode.dataLabelType = AnalysisMiddleNodeHelper.getDataFormatDataLabel(DisclosureJsonHelper.getValue(config, dataFormatNodeName, "dataLabelType", "default"));
        dataFormatNode.currencysign = DisclosureJsonHelper.getValue(config, dataFormatNodeName, "currencySymbols", "");
        dataFormatNode.data = DisclosureJsonHelper.getValue(config, dataFormatNodeName, "data", "");
        dataFormatNode.unitarea = DisclosureJsonHelper.getValue(config, dataFormatNodeName, "unitarea", 1);
        dataFormatNode.dataType = AnalysisMiddleNodeHelper.getDataFormatDataType(DisclosureJsonHelper.getValue(config, dataFormatNodeName, "digitalType", "digital"));
        dataFormatNode.thousandth = DisclosureJsonHelper.getValue(config, dataFormatNodeName, "enableThousands", false);
        dataFormatNode.decimalPlace = DisclosureJsonHelper.getValue(config, dataFormatNodeName, "decimalPlace", 2);
        dataFormatNode.enable = DisclosureJsonHelper.getValue(config, dataFormatNodeName, "enable", false);
        dataFormatNode.angle = DisclosureJsonHelper.getValue(config, "tagRotate", 0);
        dataFormatNode.alignment = AnalysisMiddleNodeHelper.getAlignmentEnum(DisclosureJsonHelper.getValue(config, dataFormatNodeName, "align", "center"));
        return dataFormatNode;
    }

    private static DataFormatNode.DataLabelEnum getDataFormatDataLabel(String dataType) {
        if ("default".equalsIgnoreCase(dataType)) {
            return DataFormatNode.DataLabelEnum.outEnd;
        }
        return DataFormatNode.DataLabelEnum.inEnd;
    }

    private static DataFormatNode.DataTypeEnum getDataFormatDataType(String dataType) {
        if ("currency".equalsIgnoreCase(dataType)) {
            return DataFormatNode.DataTypeEnum.Currency;
        }
        if ("percent".equalsIgnoreCase(dataType)) {
            return DataFormatNode.DataTypeEnum.Percent;
        }
        return DataFormatNode.DataTypeEnum.Number;
    }

    public static TitleNode createTitleNode(JSONObject module) {
        TitleNode titleNode = new TitleNode();
        titleNode.visible = DisclosureJsonHelper.getValue(module, "c", "title", "show", true);
        titleNode.content = DisclosureJsonHelper.getValue(module, "title", "");
        titleNode.font = AnalysisMiddleNodeHelper.createFontNodeNode(DisclosureJsonHelper.getJsonObject(module, "c", "title"));
        return titleNode;
    }

    public static FontNode createFontNodeNode(JSONObject font) {
        if (font == null) {
            return new FontNode();
        }
        FontNode fontNode = new FontNode();
        fontNode.fontSize = DisclosureJsonHelper.getValue(font, "fontSize", 14);
        fontNode.bold = "bold".equalsIgnoreCase(DisclosureJsonHelper.getValue(font, "fontWeight", ""));
        fontNode.italic = "italic".equalsIgnoreCase(DisclosureJsonHelper.getValue(font, "fontStyle", ""));
        fontNode.underline = "underline".equalsIgnoreCase(DisclosureJsonHelper.getValue(font, "underline", ""));
        fontNode.foreColor = DisclosureJsonHelper.getValue(font, "foreColor", "");
        fontNode.backColor = DisclosureJsonHelper.getValue(font, "backColor", "");
        fontNode.alignment = AnalysisMiddleNodeHelper.getAlignmentEnum(DisclosureJsonHelper.getValue(font, "align", "center"));
        fontNode.color = DisclosureJsonHelper.getValue(font, "color", "");
        return fontNode;
    }

    public static TextNode createTextNodeNode(JSONObject text) {
        if (text == null) {
            return new TextNode();
        }
        TextNode textNode = new TextNode();
        textNode.fontSize = DisclosureJsonHelper.getValue(text, "fontSize", 14);
        textNode.bold = "bold".equalsIgnoreCase(DisclosureJsonHelper.getValue(text, "fontWeight", ""));
        textNode.italic = "italic".equalsIgnoreCase(DisclosureJsonHelper.getValue(text, "fontStyle", ""));
        textNode.color = DisclosureJsonHelper.getValue(text, "color", "");
        textNode.enable = DisclosureJsonHelper.getValue(text, "enable", true);
        return textNode;
    }

    public static AxisValueNode createAxisValueNodeNode(JSONObject text) {
        if (text == null) {
            return new AxisValueNode();
        }
        AxisValueNode axisValueNode = new AxisValueNode();
        axisValueNode.max = DisclosureJsonHelper.getValue(text, "max", 0);
        axisValueNode.min = DisclosureJsonHelper.getValue(text, "min", 0);
        axisValueNode.enable = DisclosureJsonHelper.getValue(text, "enabled", false);
        return axisValueNode;
    }

    public static FontNode.AlignmentEnum getAlignmentEnum(String align) {
        if ("right".equalsIgnoreCase(align)) {
            return FontNode.AlignmentEnum.Right;
        }
        if ("center".equalsIgnoreCase(align)) {
            return FontNode.AlignmentEnum.Center;
        }
        return FontNode.AlignmentEnum.Left;
    }

    public static LegendNode.Alignment getLegendAlign(int align) {
        for (LegendNode.Alignment value : LegendNode.Alignment.values()) {
            if (value.getType() != align) continue;
            return value;
        }
        return LegendNode.Alignment.UpLeft;
    }

    public static BackgroundNode createBackgroundNode(JSONObject module) {
        BackgroundNode backgroundNode = new BackgroundNode();
        backgroundNode.color = DisclosureJsonHelper.getValue(module, "c", "bkColor", "");
        backgroundNode.transparency = DisclosureJsonHelper.getValue(module, "c", "opacity", 1.0);
        backgroundNode.visible = DisclosureJsonHelper.getValue(module, "c", "showBack", true);
        return backgroundNode;
    }

    public static BorderNode createBorderNode(JSONObject module) {
        BorderNode borderNode = new BorderNode();
        borderNode.color = DisclosureJsonHelper.getValue(module, "c", "borderColor", "");
        borderNode.transparency = DisclosureJsonHelper.getValue(module, "c", "borderOpacity", 1.0);
        borderNode.visible = DisclosureJsonHelper.getValue(module, "c", "showBorder", true);
        borderNode.witdh = DisclosureJsonHelper.getValue(module, "c", "borderWidth", 1.0);
        borderNode.borderStyle = DisclosureJsonHelper.getValue(module, "c", "borderStyle", "dotted");
        return borderNode;
    }

    public static void createDataset(JSONObject module, DatasetNode datasetNode) {
        if (datasetNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u96c6\u6570\u636e\uff0c\u65e0\u6cd5\u8f6c\u6362\u3002", (String)"AnalysisMiddleNodeHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        try {
            JSONObject dataset = module.getJSONObject("dataset");
            JSONObject datasetObj = JSONObject.parseObject((String)JacksonUtils.toJson((Object)datasetNode));
            for (String key : datasetObj.keySet()) {
                Object value = datasetObj.get((Object)key);
                dataset.put(key, value);
            }
        }
        catch (KDBizException bizException) {
            throw bizException;
        }
        catch (Exception ex) {
            logger.error("fidm createDataset error:" + module.toJSONString(), (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u65e5\u5fd7\u3002", (String)"AnalysisMiddleNodeHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static String getDataFormatByType(Integer type) {
        String dataType = "digital";
        if (type.intValue() == DataFormatNode.DataTypeEnum.Currency.getType()) {
            dataType = "currency";
        } else if (type.intValue() == DataFormatNode.DataTypeEnum.Percent.getType()) {
            dataType = "percent";
        }
        return dataType;
    }

    public static String getAlignByEnum(Integer type) {
        String align = "";
        if (type.intValue() == FontNode.AlignmentEnum.Right.getType()) {
            align = "right";
        } else if (type.intValue() == FontNode.AlignmentEnum.Center.getType()) {
            align = "center";
        } else if (type.intValue() == FontNode.AlignmentEnum.Left.getType()) {
            align = "left";
        }
        return align;
    }

    public static void setFontStyle(JSONObject font, FontNode fontNode) {
        if (font != null) {
            DisclosureJsonHelper.setValue(font, "fontSize", fontNode.fontSize, 14);
            DisclosureJsonHelper.setValue(font, "fontWeight", fontNode.bold ? "bold" : "", "");
            DisclosureJsonHelper.setValue(font, "fontStyle", fontNode.italic ? "italic" : "normal", "");
            DisclosureJsonHelper.setValue(font, "underline", fontNode.underline ? "underline" : "none", "");
            String align = AnalysisMiddleNodeHelper.getAlignByEnum(fontNode.alignment.getType());
            DisclosureJsonHelper.setValue(font, "align", align, "center");
            DisclosureJsonHelper.setValue(font, "foreColor", fontNode.foreColor, "");
            DisclosureJsonHelper.setValue(font, "backColor", fontNode.backColor.toUpperCase(), "");
            DisclosureJsonHelper.setValue(font, "color", fontNode.color, "");
        }
    }

    public static void setDataFormat(JSONObject config, DataFormatNode formatObj, String name) {
        if (formatObj != null) {
            DisclosureJsonHelper.setValue(config, "charts", "label", "show", formatObj.visible, true);
            DisclosureJsonHelper.setValue(config, name, "unit", formatObj.unit.getRatio(), 1);
            DisclosureJsonHelper.setValue(config, name, "enableThousands", formatObj.thousandth, false);
            DisclosureJsonHelper.setValue(config, name, "currencySymbols", formatObj.currencysign, "");
            DisclosureJsonHelper.setValue(config, name, "decimalPlace", formatObj.decimalPlace, 2);
            DisclosureJsonHelper.setValue(config, name, "digitalType", AnalysisMiddleNodeHelper.getDataFormatByType(formatObj.dataType.getType()), "digital");
            DisclosureJsonHelper.setValue(config, name, "enable", formatObj.enable, true);
            DisclosureJsonHelper.setValue(config, name, "dataLabelType", (Object)formatObj.dataLabelType, true);
            DisclosureJsonHelper.setValue(config, name, "dataLabelType", (Object)formatObj.dataLabelType, "default");
            DisclosureJsonHelper.setValue(config, name, "data", formatObj.data, "");
            DisclosureJsonHelper.setValue(config, name, "unitarea", formatObj.unitarea, 1);
            DisclosureJsonHelper.setValue(config, "tagRotate", formatObj.angle, 0);
            String alignByEnum = AnalysisMiddleNodeHelper.getAlignByEnum(formatObj.alignment.getType());
            DisclosureJsonHelper.setValue(config, name, "align", alignByEnum, "center");
        }
    }

    public static void setTextNode(JSONObject text, TextNode textNode) {
        if (text != null) {
            DisclosureJsonHelper.setValue(text, "fontSize", textNode.fontSize, 14);
            DisclosureJsonHelper.setValue(text, "fontWeight", textNode.bold ? "bold" : "", "");
            DisclosureJsonHelper.setValue(text, "fontStyle", textNode.italic ? "italic" : "normal", "");
            DisclosureJsonHelper.setValue(text, "color", textNode.color, "");
            DisclosureJsonHelper.setValue(text, "enable", textNode.enable, true);
        }
    }

    public static void setAxisValueNode(JSONObject axis, AxisValueNode axisValueNode) {
        if (axis != null) {
            DisclosureJsonHelper.setValue(axis, "min", axisValueNode.min, 0);
            DisclosureJsonHelper.setValue(axis, "max", axisValueNode.max, 0);
            DisclosureJsonHelper.setValue(axis, "enabled", axisValueNode.enable, false);
        }
    }

    public static RotateNode createRotateNode(JSONObject config) {
        RotateNode rotate = new RotateNode();
        if (config != null) {
            rotate.size = DisclosureJsonHelper.getValue(config, "rotate", 0);
        }
        return rotate;
    }

    public static DataPenetrationNode createDataPenetrationNode(JSONObject config) {
        DataPenetrationNode dataPenetrationNode = new DataPenetrationNode();
        try {
            dataPenetrationNode.dataDrillingDown = (DataDrillingDownNode)JSON.parseObject((String)config.getJSONObject("dataDrillingDown").toJSONString(), DataDrillingDownNode.class);
        }
        catch (Exception ex) {
            logger.error("far createDataset error:" + config.toJSONString(), (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u94bb\u53d6\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u65e5\u5fd7\u3002", (String)"ModuleMiddleHelper_18", (String)"epm-far-business", (Object[])new Object[0]));
        }
        try {
            dataPenetrationNode.compLinkage = (CompLinkageNode)JSON.parseObject((String)config.getJSONObject("compLinkage").toJSONString(), CompLinkageNode.class);
        }
        catch (Exception ex) {
            logger.error("far createDataset error:" + config.toJSONString(), (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u4ef6\u8054\u52a8\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u65e5\u5fd7\u3002", (String)"ModuleMiddleHelper_19", (String)"epm-far-business", (Object[])new Object[0]));
        }
        dataPenetrationNode.dataNextLevel = AnalysisMiddleNodeHelper.createDataNextLevelNode(config);
        dataPenetrationNode.dataJointSearch = AnalysisMiddleNodeHelper.createDataJointSearchNode(config);
        return dataPenetrationNode;
    }

    private static DataJointSearchNode createDataJointSearchNode(JSONObject config) {
        DataJointSearchNode dataJointSearchNode = new DataJointSearchNode();
        dataJointSearchNode.status = DisclosureJsonHelper.getValue(config, "dataJointSearch", "status", false);
        return dataJointSearchNode;
    }

    private static DataNextLevelNode createDataNextLevelNode(JSONObject config) {
        DataNextLevelNode dataNextLevelNode = new DataNextLevelNode();
        dataNextLevelNode.openStyle = DisclosureJsonHelper.getValue(config, "openStyle", "");
        dataNextLevelNode.status = DisclosureJsonHelper.getValue(config, "dataNextLevel", "status", false);
        dataNextLevelNode.nextLevelData = DisclosureJsonHelper.getValue(config, "dataNextLevel", "nextLevelData", "");
        return dataNextLevelNode;
    }

    public static DescriptNode createDespNode(JSONObject config) {
        DescriptNode despNode = new DescriptNode();
        despNode.visible = DisclosureJsonHelper.getValue(config, "desp", "show", false);
        despNode.content = DisclosureJsonHelper.getValue(config, "desp", "content", "");
        return despNode;
    }

    public static GridLineNode createGridLineNode(JSONObject config) {
        GridLineNode gridLineNode = new GridLineNode();
        gridLineNode.gridLineShow = DisclosureJsonHelper.getValue(config, "gridLineShow", true);
        gridLineNode.spindleSecondaryVertical = DisclosureJsonHelper.getValue(config, "spindleSecondaryVertical", "false");
        gridLineNode.mainLevelMainShaft = DisclosureJsonHelper.getValue(config, "mainLevelMainShaft", "true");
        gridLineNode.spindleSecondaryLevel = DisclosureJsonHelper.getValue(config, "spindleSecondaryLevel", "false");
        gridLineNode.mainVerticalAxis = DisclosureJsonHelper.getValue(config, "mainVerticalAxis", "false");
        return gridLineNode;
    }

    public static TimeRefreshNode createTimeRefreshNode(JSONObject config) {
        TimeRefreshNode timeRefreshNode = new TimeRefreshNode();
        timeRefreshNode.enableTimedRefresh = DisclosureJsonHelper.getValue(config, "enableTimedRefresh", false);
        timeRefreshNode.timeInterval = DisclosureJsonHelper.getValue(config, "timeInterval", 3);
        return timeRefreshNode;
    }

    public static AxisSettingsNode createAxisSettingsNode(JSONObject module) {
        AxisSettingsNode axisSettingsNode = new AxisSettingsNode();
        axisSettingsNode.xAxis = AnalysisMiddleNodeHelper.createAxAxisNode(module, "xAxis");
        axisSettingsNode.yAxis = AnalysisMiddleNodeHelper.createAxAxisNode(module, "yAxis");
        return axisSettingsNode;
    }

    public static AxisNode createAxAxisNode(JSONObject module, String type) {
        AxisValueNode axisValue;
        int rotate;
        int nameRotate;
        TextNode textStyle;
        DataFormatNode dataFormat;
        String axisReName;
        AxisNode axisNode = new AxisNode();
        JSONObject c = module.getJSONObject("c");
        JSONObject config = c.getJSONObject("config");
        if ("xAxis".equals(type)) {
            axisReName = DisclosureJsonHelper.getValue(module, "dataset", "request", "xAxisReName", "");
            dataFormat = AnalysisMiddleNodeHelper.createDataFormatNode(config, "xDigitalFormat");
            textStyle = AnalysisMiddleNodeHelper.createTextNodeNode(DisclosureJsonHelper.getJsonObject(config, "xTextStyle"));
            nameRotate = DisclosureJsonHelper.getValue(module, "dataset", "request", "xnameRotate", 0);
            rotate = DisclosureJsonHelper.getValue(config, "xRotate", 0);
            axisValue = AnalysisMiddleNodeHelper.createAxisValueNodeNode(DisclosureJsonHelper.getJsonObject(config, "xAxisValue"));
        } else {
            axisReName = DisclosureJsonHelper.getValue(module, "dataset", "request", "yAxisReName", "");
            dataFormat = AnalysisMiddleNodeHelper.createDataFormatNode(config, "yDigitalFormat");
            textStyle = AnalysisMiddleNodeHelper.createTextNodeNode(DisclosureJsonHelper.getJsonObject(config, "yTextStyle"));
            nameRotate = DisclosureJsonHelper.getValue(module, "dataset", "request", "ynameRotate", 0);
            rotate = DisclosureJsonHelper.getValue(config, "yRotate", 0);
            axisValue = AnalysisMiddleNodeHelper.createAxisValueNodeNode(DisclosureJsonHelper.getJsonObject(config, "yAxisValue"));
            axisNode.lDataFormat = AnalysisMiddleNodeHelper.createDataFormatNode(config, "yLDigitalFormat");
            axisNode.lAxisValue = AnalysisMiddleNodeHelper.createAxisValueNodeNode(DisclosureJsonHelper.getJsonObject(config, "yLAxisValue"));
            axisNode.yLineRotate = DisclosureJsonHelper.getValue(config, "yLineRotate", 0);
            axisNode.yLineSubRotate = DisclosureJsonHelper.getValue(config, "yLineSubRotate", 0);
            axisNode.yAxisLineReName = DisclosureJsonHelper.getValue(module, "dataset", "request", "yAxisLineReName", "");
        }
        axisNode.axisReName = axisReName;
        axisNode.dataFormat = dataFormat;
        axisNode.textStyle = textStyle;
        axisNode.rotate = rotate;
        axisNode.nameRotate = nameRotate;
        axisNode.axisValue = axisValue;
        AnalysisMiddleNodeHelper.createNameGapNode(config, axisNode, type);
        return axisNode;
    }

    private static void createNameGapNode(JSONObject config, AxisNode axisNode, String type) {
        int nameGap = 0;
        int lineNameGap = 0;
        JSONObject charts = DisclosureJsonHelper.getJsonObject(config, "charts");
        JSONArray axisArray = DisclosureJsonHelper.getJSONArray(charts, type);
        if (axisArray != null && axisArray.size() > 0) {
            Object line;
            Object first = axisArray.get(0);
            if (!ObjectUtils.isEmpty((Object)first)) {
                JSONObject jsonObject = JSONObject.parseObject((String)first.toString());
                nameGap = DisclosureJsonHelper.getValue(jsonObject, "nameGap", 0);
            }
            if (axisArray.size() > 1 && !ObjectUtils.isEmpty((Object)(line = axisArray.get(1)))) {
                JSONObject jsonObject = JSONObject.parseObject((String)line.toString());
                lineNameGap = DisclosureJsonHelper.getValue(jsonObject, "nameGap", 0);
            }
        }
        axisNode.nameGap = nameGap;
        axisNode.lineNameGap = lineNameGap;
    }

    public static DataAreaZoomNode createDataAreaZoomNode(JSONObject config) {
        DataAreaZoomNode dataAreaZoomNode = new DataAreaZoomNode();
        dataAreaZoomNode.status = DisclosureJsonHelper.getValue(config, "dataAreaZoom", "status", false);
        return dataAreaZoomNode;
    }

    public static LegendNode createLegendNode(JSONObject module) {
        JSONObject charts = DisclosureJsonHelper.getJsonObject(module, "c", "config", "charts");
        JSONObject legend = DisclosureJsonHelper.getJsonObject(charts, "legend");
        LegendNode legendNode = new LegendNode();
        legendNode.visible = DisclosureJsonHelper.getValue(legend, "c", "show", true);
        legendNode.position = AnalysisMiddleNodeHelper.getLegendAlign(DisclosureJsonHelper.getValue(module, "c", "config", "legendPos", 0));
        legendNode.font = AnalysisMiddleNodeHelper.createFontNodeNode(DisclosureJsonHelper.getJsonObject(module, "c", "config", "tagTextStyle"));
        return legendNode;
    }

    public static void setDataPenetration(JSONObject config, DataPenetrationNode dataPenetrationNode) {
        DataNextLevelNode dataNextLevelNode;
        JSONObject compLinkage;
        JSONObject dataDrillingDown = JSONObject.parseObject((String)JacksonUtils.toJson((Object)dataPenetrationNode.dataDrillingDown));
        if (dataDrillingDown != null) {
            DisclosureJsonHelper.setValue(config, "dataDrillingDown", dataDrillingDown, JSONObject.parseObject((String)JacksonUtils.toJson((Object)new DataDrillingDownNode())));
        }
        if ((compLinkage = JSONObject.parseObject((String)JacksonUtils.toJson((Object)dataPenetrationNode.compLinkage))) != null) {
            DisclosureJsonHelper.setValue(config, "compLinkage", compLinkage, JSONObject.parseObject((String)JacksonUtils.toJson((Object)new CompLinkageNode())));
        }
        if ((dataNextLevelNode = dataPenetrationNode.dataNextLevel) == null) {
            dataNextLevelNode = new DataNextLevelNode();
        }
        DisclosureJsonHelper.setValue(config, "openStyle", dataNextLevelNode.openStyle, "");
        DisclosureJsonHelper.setValue(config, "dataNextLevel", "status", dataNextLevelNode.status, false);
        DisclosureJsonHelper.setValue(config, "dataNextLevel", "nextLevelData", dataNextLevelNode.nextLevelData, "");
        DataJointSearchNode dataJointSearch = dataPenetrationNode.dataJointSearch;
        if (dataJointSearch == null) {
            dataJointSearch = new DataJointSearchNode();
        }
        DisclosureJsonHelper.setValue(config, "dataJointSearch", dataJointSearch, new DataJointSearchNode());
    }

    public static void setGridLine(JSONObject config, GridLineNode gridLineNode) {
        if (gridLineNode == null) {
            gridLineNode = new GridLineNode();
        }
        DisclosureJsonHelper.setValue(config, "gridLineShow", gridLineNode.gridLineShow, true);
        DisclosureJsonHelper.setValue(config, "spindleSecondaryVertical", gridLineNode.spindleSecondaryVertical, "false");
        DisclosureJsonHelper.setValue(config, "mainLevelMainShaft", gridLineNode.mainLevelMainShaft, "true");
        DisclosureJsonHelper.setValue(config, "spindleSecondaryLevel", gridLineNode.spindleSecondaryLevel, "false");
        DisclosureJsonHelper.setValue(config, "mainVerticalAxis", gridLineNode.mainVerticalAxis, "false");
    }

    public static void setAxisSettingsNode(JSONObject module, AxisSettingsNode axisSettingsNode) {
        AnalysisMiddleNodeHelper.setAxAxisNode(module, "xAxis", axisSettingsNode.xAxis);
        AnalysisMiddleNodeHelper.setAxAxisNode(module, "yAxis", axisSettingsNode.yAxis);
    }

    private static void setAxAxisNode(JSONObject module, String type, AxisNode axisNode) {
        JSONObject c = module.getJSONObject("c");
        JSONObject config = c.getJSONObject("config");
        if (axisNode == null) {
            axisNode = new AxisNode();
        }
        if ("xAxis".equals(type)) {
            DisclosureJsonHelper.setValue(module, "dataset", "request", "xAxisReName", axisNode.axisReName, "");
            AnalysisMiddleNodeHelper.setDataFormat(config, axisNode.dataFormat, "xDigitalFormat");
            AnalysisMiddleNodeHelper.setTextNode(config.getJSONObject("xTextStyle"), axisNode.textStyle);
            DisclosureJsonHelper.setValue(module, "dataset", "request", "xnameRotate", axisNode.nameRotate, 0);
            DisclosureJsonHelper.setValue(config, "xRotate", axisNode.rotate, 0);
            AnalysisMiddleNodeHelper.setAxisValueNode(config.getJSONObject("xAxisValue"), axisNode.axisValue);
        } else {
            DisclosureJsonHelper.setValue(module, "dataset", "request", "yAxisReName", axisNode.axisReName, "");
            AnalysisMiddleNodeHelper.setDataFormat(config, axisNode.dataFormat, "yDigitalFormat");
            AnalysisMiddleNodeHelper.setTextNode(config.getJSONObject("yTextStyle"), axisNode.textStyle);
            DisclosureJsonHelper.setValue(module, "dataset", "request", "ynameRotate", axisNode.nameRotate, 0);
            DisclosureJsonHelper.setValue(config, "yRotate", axisNode.rotate, 0);
            AnalysisMiddleNodeHelper.setAxisValueNode(config.getJSONObject("yAxisValue"), axisNode.axisValue);
            AnalysisMiddleNodeHelper.setDataFormat(config, axisNode.lDataFormat, "yLDigitalFormat");
            AnalysisMiddleNodeHelper.setAxisValueNode(config.getJSONObject("yLAxisValue"), axisNode.lAxisValue);
            DisclosureJsonHelper.setValue(config, "yLineRotate", axisNode.yLineRotate, 0);
            DisclosureJsonHelper.setValue(config, "yLineSubRotate", axisNode.yLineSubRotate, 0);
            DisclosureJsonHelper.setValue(module, "dataset", "request", "yAxisLineReName", axisNode.yAxisLineReName, "");
        }
        AnalysisMiddleNodeHelper.setNameGapNode(config, axisNode, type);
    }

    private static void setNameGapNode(JSONObject config, AxisNode axisNode, String type) {
        JSONObject charts;
        JSONArray axisArray;
        if (axisNode == null) {
            axisNode = new AxisNode();
        }
        if ((axisArray = DisclosureJsonHelper.getJSONArray(charts = DisclosureJsonHelper.getJsonObject(config, "charts"), type)) != null && axisArray.size() > 0) {
            Object line;
            Object first = axisArray.get(0);
            if (!ObjectUtils.isEmpty((Object)first)) {
                JSONObject jsonObject = JSONObject.parseObject((String)first.toString());
                jsonObject.put("nameGap", (Object)axisNode.nameGap);
            }
            if (axisArray.size() > 1 && !ObjectUtils.isEmpty((Object)(line = axisArray.get(1)))) {
                JSONObject jsonObject = JSONObject.parseObject((String)line.toString());
                jsonObject.put("nameGap", (Object)axisNode.lineNameGap);
            }
        }
    }

    public static void setDataAreaZoom(JSONObject config, DataAreaZoomNode dataAreaZoom) {
        JSONObject datasetObj = JSONObject.parseObject((String)JacksonUtils.toJson((Object)dataAreaZoom));
        DisclosureJsonHelper.setValue(config, "dataAreaZoom", datasetObj, JSONObject.parseObject((String)JacksonUtils.toJson((Object)new DataAreaZoomNode())));
    }

    public static void setDataFormat(JSONObject config, DataFormatNode dataFormat) {
        AnalysisMiddleNodeHelper.setDataFormat(config, dataFormat, "digitalFormat");
    }

    public static void setTitle(JSONObject module, TitleNode titleNode) {
        DisclosureJsonHelper.setValue(module, "c", "title", "show", titleNode.visible, true);
        DisclosureJsonHelper.setValue(module, "title", titleNode.content, "");
        FontNode fontNode = titleNode.font;
        JSONObject font = DisclosureJsonHelper.getJsonObject(module, "c", "title");
        AnalysisMiddleNodeHelper.setFontStyle(font, fontNode);
    }

    public static void setLegend(JSONObject module, LegendNode legendNode) {
        JSONObject charts = DisclosureJsonHelper.getJsonObject(module, "c", "config", "charts");
        JSONObject legend = DisclosureJsonHelper.getJsonObject(charts, "legend");
        if (legendNode == null) {
            legendNode = new LegendNode();
        }
        DisclosureJsonHelper.setValue(legend, "c", "show", legendNode.visible, true);
        DisclosureJsonHelper.setValue(module, "c", "config", "legendPos", legendNode.position.getType(), 0);
        AnalysisMiddleNodeHelper.setFontStyle(DisclosureJsonHelper.getJsonObject(module, "c", "config", "tagTextStyle"), legendNode.font);
    }

    public static void setBody(JSONObject module, BodyNode body) {
        double widthData;
        if (body == null) {
            body = new BodyNode();
        }
        if ((widthData = body.width) > 0.0) {
            double resultWidth = widthData / 100.0 * FarModuleUnit;
            DisclosureJsonHelper.setValue(module, "w", resultWidth, FarModuleUnit);
            DisclosureJsonHelper.setValue(module, "h", body.height / 100.0 * resultWidth, 0);
            DisclosureJsonHelper.setValue(module, "x", body.positionX / 100.0 * resultWidth, 0);
            DisclosureJsonHelper.setValue(module, "y", body.positionY / 100.0 * resultWidth, 0);
        } else {
            DisclosureJsonHelper.setValue(module, "w", FarModuleUnit, "");
            DisclosureJsonHelper.setValue(module, "h", 0, 0);
            DisclosureJsonHelper.setValue(module, "x", 0, 0);
            DisclosureJsonHelper.setValue(module, "y", 0, 0);
        }
    }

    public static void setBackground(JSONObject module, BackgroundNode backgroundNode) {
        if (backgroundNode == null) {
            backgroundNode = new BackgroundNode();
        }
        DisclosureJsonHelper.setValue(module, "c", "bkColor", backgroundNode.color, "");
        DisclosureJsonHelper.setValue(module, "c", "opacity", backgroundNode.transparency, 1);
        DisclosureJsonHelper.setValue(module, "c", "showBack", backgroundNode.visible, true);
    }

    public static void setBorder(JSONObject module, BorderNode borderNode) {
        if (borderNode == null) {
            borderNode = new BorderNode();
        }
        DisclosureJsonHelper.setValue(module, "c", "borderColor", borderNode.color, "");
        DisclosureJsonHelper.setValue(module, "c", "borderOpacity", borderNode.transparency, 1);
        DisclosureJsonHelper.setValue(module, "c", "showBorder", borderNode.visible, true);
        DisclosureJsonHelper.setValue(module, "c", "borderWidth", (int)borderNode.witdh, 1);
        DisclosureJsonHelper.setValue(module, "c", "borderStyle", borderNode.borderStyle, "dotted");
    }

    public static ScrollNode createScrollNode(JSONObject tableModel) {
        ScrollNode scroll = new ScrollNode();
        if (tableModel != null) {
            scroll.enable = DisclosureJsonHelper.getValue(tableModel, "isScroll", true);
        }
        return scroll;
    }

    public static ChartParametersNode createChartParametersNode(JSONObject config) {
        ChartParametersNode chartParameters = new ChartParametersNode();
        if (config != null) {
            chartParameters.enable = DisclosureJsonHelper.getValue(config, "chartParameters", false);
        }
        return chartParameters;
    }
}

