/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.base;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;

public class DisclosureExceptionHelper {
    public static String buildExceptionMsg(String title, Throwable e, int stackLimit) {
        List stackMsgs = Arrays.stream(e.getStackTrace()).filter(ele -> Objects.nonNull(ele.getClassName()) && ele.getClassName().startsWith("kd.epm.far")).map(ele -> String.format("%s:%s %s \n\n", ele.getFileName(), ele.getLineNumber(), ele.toString())).collect(Collectors.toList());
        if (stackLimit > 0) {
            stackMsgs = stackMsgs.subList(0, Math.min(stackMsgs.size(), stackLimit));
        }
        return String.format("%s\r\n %s[%s] %s", title, e.getMessage(), RequestContext.get().getTraceId(), String.join((CharSequence)",", stackMsgs));
    }
}

