/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.session.SessionManager;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.util.FarNumberRule;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class DisclosureFileHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosureFileHelper.class);
    public static final int FILE_TIMEOUT_SECONDS = 86400;
    public static final String FILEURLTICKETPARAM = "kd_cs_ticket";
    public static final String DOC_FILE_SUFFIX = ".docx";
    public static final String PDF_FILE_SUFFIX = ".pdf";
    public static final String JSON_FILE_SUFFIX = ".json";
    public static final char URL_JOIN = '?';
    public static final char URL_PRAMA_JOIN = '&';
    public static final char URL_PRAMA_EQUEAL = '=';

    public static String getAttachmentFileName(String appId, String formId, Object pkId, String filename) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)appId, (String)formId, (Object)pkId, (String)filename);
    }

    public static String saveAsNew(String oldUrl, String fileName, Map fileNameData) {
        String appId = "fidm";
        String formId = (String)fileNameData.get("formId");
        Object pkId = fileNameData.get("pkId");
        String url = "";
        oldUrl = DisclosureFileHelper.removeFileTicket(oldUrl);
        InputStream in = FileServiceFactory.getAttachmentFileService().getInputStream(oldUrl);
        FileService service = FileServiceFactory.getAttachmentFileService();
        FileItem fileItem = null;
        fileName = DisclosureFileHelper.getFileName(fileName);
        fileItem = new FileItem(fileName, DisclosureFileHelper.getAttachmentFileName(appId, formId, pkId, fileName), in);
        fileItem.setCreateNewFileWhenExists(true);
        url = service.upload(fileItem);
        try {
            in.close();
        }
        catch (IOException var17) {
            logger.info(var17.getMessage());
        }
        return url;
    }

    public static String saveAsNew(InputStream in, String appId, String formId, Object pkId, String fileName) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        FileItem fileItem = null;
        fileName = DisclosureFileHelper.getFileName(fileName);
        int maxSize = 200;
        if (fileName.length() > maxSize) {
            fileName = fileName.substring(fileName.length() - maxSize, fileName.length());
        }
        fileItem = new FileItem(fileName, DisclosureFileHelper.getAttachmentFileName(appId, formId, pkId, fileName), in);
        fileItem.setCreateNewFileWhenExists(false);
        return service.upload(fileItem);
    }

    public static String uploadEmptyTempFile(String fileName, String urlPrefix, boolean addToken) {
        String sampleString = "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";
        String newUrl = "";
        logger.info("uploadEmptyTempFile name: " + fileName);
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(sampleString));
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            newUrl = cache.saveAsUrl(fileName, (InputStream)in, 86400);
            if (addToken && StringUtils.isNotEmpty((String)RequestContext.get().getGlobalSessionId())) {
                newUrl = newUrl + "&access_token=" + RequestContext.get().getGlobalSessionId();
            }
            newUrl = urlPrefix + newUrl;
            ((InputStream)in).close();
        }
        catch (Exception var17) {
            logger.info("uploadEmptyTempFile InputStream fail:" + var17.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\u3002", (String)"WpsFileServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return newUrl;
    }

    public static String uploadModuleTempFile(String fileName, String urlPrefix) {
        fileName = DisclosureFileHelper.getFileName(fileName);
        String sampleString = "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";
        String newUrl = "";
        logger.info("uploadEmptyTempFile name: " + fileName);
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(sampleString));
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            newUrl = cache.saveAsUrl(fileName, (InputStream)in, 86400);
            newUrl = urlPrefix + newUrl;
            ((InputStream)in).close();
        }
        catch (Exception var17) {
            logger.info("uploadModuleTempFile InputStream fail:" + var17.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\u3002", (String)"WpsFileServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return newUrl;
    }

    public static String getRandFileName(String title, String tips, Boolean addSuffix) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((String)title)) {
            sb.append(title);
        }
        if (tips == null) {
            tips = ResManager.loadKDString((String)"\u9884\u89c8", (String)"DisclosureServiceHelper_4", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)tips)) {
            if (sb.length() > 0) {
                sb.append("-");
            }
            sb.append(tips);
        }
        if (sb.length() > 0) {
            sb.append("-");
        }
        sb.append(new SimpleDateFormat("hhmmss").format(new Date()));
        if (addSuffix.booleanValue()) {
            sb.append(DOC_FILE_SUFFIX);
        }
        return sb.toString();
    }

    public static String uploadTempFile(String url, String urlPrefix, String fileName, boolean addToken) {
        logger.info("uploadTempFile url : " + url);
        String newUrl = "";
        try {
            url = DisclosureFileHelper.removeFileTicket(url);
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            FileService service = FileServiceFactory.getAttachmentFileService();
            byte[] outputStreamByte = DisclosureFileHelper.convertToByte(service.getInputStream(url));
            ByteArrayInputStream byteIns = new ByteArrayInputStream(outputStreamByte);
            newUrl = cache.saveAsUrl(fileName, (InputStream)byteIns, 86400);
            if (addToken) {
                newUrl = DisclosureFileHelper.addToken(newUrl);
            }
            newUrl = urlPrefix + newUrl;
            byteIns.close();
        }
        catch (Exception var17) {
            logger.info("uploadTempFile close InputStream fail:" + var17.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\u3002", (String)"WpsFileServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return newUrl;
    }

    public static String uploadTempFile(InputStream in, String fileName, String urlPrefix) {
        return DisclosureFileHelper.uploadTempFile(in, fileName, urlPrefix, DOC_FILE_SUFFIX, 86400);
    }

    public static String uploadTempFile(InputStream in, String fileName, String urlPrefix, String fileSuffix) {
        return DisclosureFileHelper.uploadTempFile(in, fileName, urlPrefix, fileSuffix, 86400);
    }

    public static String uploadTempFile(InputStream in, String fileName, String urlPrefix, String fileSuffix, int timeout) {
        if (StringUtils.isNotEmpty((String)fileSuffix) && fileName.indexOf(fileSuffix) < 0) {
            fileName = fileName + fileSuffix;
        }
        logger.info("uploadTempFile url : " + fileName);
        String newUrl = "";
        try {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            newUrl = cache.saveAsUrl(fileName, in, timeout);
            newUrl = urlPrefix + newUrl;
            in.close();
        }
        catch (Exception var17) {
            logger.info("uploadTempFile close InputStream fail:" + var17.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\u3002", (String)"WpsFileServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return newUrl;
    }

    public static String getUrlPrefix() {
        RequestContext rc = RequestContext.get();
        if (rc != null && rc.getClientFullContextPath() != null) {
            return rc.getClientFullContextPath();
        }
        logger.error(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7f51\u7ad9\u5730\u5740\u5931\u8d25\u3002", (String)"WpsFileServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        return "";
    }

    public static String addToken(String tempUrl) {
        if (StringUtils.isEmpty((String)tempUrl)) {
            return tempUrl;
        }
        if (StringUtils.isNotEmpty((String)RequestContext.get().getGlobalSessionId())) {
            char join = '?';
            if (tempUrl.indexOf(63) > 0) {
                join = '&';
            }
            tempUrl = tempUrl + join + "access_token=" + RequestContext.get().getGlobalSessionId();
        }
        return tempUrl;
    }

    public static String addTicket(String tempUrl) {
        if (StringUtils.isEmpty((String)tempUrl)) {
            return tempUrl;
        }
        if (StringUtils.isNotEmpty((String)RequestContext.get().getGlobalSessionId())) {
            char join = '?';
            if (tempUrl.indexOf(63) > 0) {
                join = '&';
            }
            tempUrl = tempUrl + join + FILEURLTICKETPARAM + '=' + DisclosureFileHelper.getTicket();
        }
        return tempUrl;
    }

    public static InputStream getFileInputStream(String docUrl, boolean isTempFile) {
        if (StringUtils.isEmpty((String)docUrl)) {
            return null;
        }
        if (isTempFile) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            return cache.getInputStream(docUrl);
        }
        docUrl = DisclosureFileHelper.removeFileTicket(docUrl);
        FileService service = FileServiceFactory.getAttachmentFileService();
        if (!service.exists(docUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WpsFileServiceHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return service.getInputStream(docUrl);
    }

    public static byte[] getFileBytes(String docUrl, boolean isTempFile) {
        if (StringUtils.isEmpty((String)docUrl)) {
            return null;
        }
        if (isTempFile) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            return DisclosureFileHelper.convertToByte(cache.getInputStream(docUrl));
        }
        docUrl = DisclosureFileHelper.removeFileTicket(docUrl);
        FileService service = FileServiceFactory.getAttachmentFileService();
        if (!service.exists(docUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WpsFileServiceHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return DisclosureFileHelper.convertToByte(service.getInputStream(docUrl));
    }

    public static String upload(String formId, Object pkId, String fileName, String docBytes) {
        if (StringUtils.isEmpty((String)docBytes)) {
            return "";
        }
        fileName = DisclosureFileHelper.getFileName(fileName);
        byte[] fileData = DisclosureFileHelper.base64ConvertToBytes(docBytes);
        String path = DisclosureFileHelper.getAttachmentFileName("fidm", formId, pkId, fileName);
        ByteArrayInputStream stream = new ByteArrayInputStream(fileData);
        FileService service = FileServiceFactory.getAttachmentFileService();
        FileItem fileItem = new FileItem(fileName, path, (InputStream)stream);
        fileItem.setCreateNewFileWhenExists(false);
        String url = service.upload(fileItem);
        try {
            ((InputStream)stream).close();
        }
        catch (IOException ex) {
            logger.info(ex.getMessage());
        }
        return url;
    }

    public static String uploadFile(String tempUrl, String formId, String docId, String fileName) {
        fileName = DisclosureFileHelper.getFileName(fileName);
        String pkId = docId;
        String path = FileNameUtils.getAttachmentFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)"fidm", (String)formId, (Object)pkId, (String)fileName);
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        byte[] outputStreamByte = DisclosureFileHelper.convertToByte(cache.getInputStream(tempUrl));
        ByteArrayInputStream byteIns = new ByteArrayInputStream(outputStreamByte);
        FileService service = FileServiceFactory.getAttachmentFileService();
        FileItem fileItem = new FileItem(fileName, path, (InputStream)byteIns);
        fileItem.setCreateNewFileWhenExists(true);
        try {
            byteIns.close();
        }
        catch (IOException var17) {
            logger.info("upload url close InputStream fail:" + var17.getMessage());
        }
        String newUrl = service.upload(fileItem);
        return newUrl;
    }

    private static byte[] convertToByte(InputStream inputStream) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            byte[] array = buffer.toByteArray();
            inputStream.close();
            return array;
        }
        catch (IOException var17) {
            logger.info("upload url close InputStream fail:" + var17.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\u3002", (String)"WpsFileServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static String uploadGenealFile(String formId, Object pkId, String fileName, String fileBase64Str, boolean isFull) {
        byte[] fileData = DisclosureFileHelper.base64ConvertToBytes(fileBase64Str);
        if (fileData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u56fe\u7247\u6570\u636e\u8f6c\u6362\u5931\u8d25\u3002", (String)"DisclosureServiceHelper_16", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String path = DisclosureFileHelper.getAttachmentFileName("fidm", formId, pkId, fileName);
        ByteArrayInputStream stream = new ByteArrayInputStream(fileData);
        FileService service = FileServiceFactory.getAttachmentFileService();
        FileItem fileItem = new FileItem(fileName, path, (InputStream)stream);
        fileItem.setCreateNewFileWhenExists(false);
        String url = service.upload(fileItem);
        try {
            ((InputStream)stream).close();
        }
        catch (IOException ex) {
            logger.info(ex.getMessage());
        }
        if (!url.contains(formId) || !url.contains(pkId.toString())) {
            url = url + "&kd_cs_ticket=" + DisclosureFileHelper.getTicket();
        }
        if (isFull && StringUtils.isNotEmpty((String)url)) {
            url = UrlService.getAttachmentFullUrl((String)url);
        }
        return url;
    }

    public static String getTicket() {
        return SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
    }

    public static byte[] base64ConvertToBytes(String srcData) {
        try {
            if (srcData.startsWith("data:image/png;base64,") || srcData.startsWith("data:image/jpeg;base64,")) {
                srcData = srcData.replace("data:image/png;base64,", "").replace("data:image/jpeg;base64,", "");
            }
            return Base64.getDecoder().decode(srcData);
        }
        catch (Exception ex) {
            logger.error("dm base64ConvertToBytes fail", (Throwable)ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] urlConvertToBytes(String fullUrl) {
        if (StringUtils.isEmpty((String)fullUrl)) {
            return null;
        }
        int findIndex = fullUrl.indexOf("download.do?path=");
        if (findIndex <= 0) return DisclosureFileHelper.download(fullUrl);
        String url = fullUrl.substring(fullUrl.indexOf("download.do?path=") + 17);
        url = DisclosureFileHelper.removeFileTicket(url);
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (ByteArrayOutputStream outputStream = DisclosureFileHelper.readInputStream(service.getInputStream(url));){
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            logger.error("dm urlConvertToBytes fail", (Throwable)ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] download(String fullUrl) {
        try {
            URL url = new URL(fullUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            try (InputStream is = conn.getInputStream();){
                byte[] data;
                byte[] byArray = data = DisclosureFileHelper.readInputStream(is).toByteArray();
                return byArray;
            }
        }
        catch (Exception ex) {
            logger.error("dm urlConvertToBytes download fail", (Throwable)ex);
            return null;
        }
    }

    public static ByteArrayOutputStream readInputStream(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) > -1) {
            outputStream.write(buffer, 0, len);
        }
        outputStream.flush();
        return outputStream;
    }

    public static String removeFileTicket(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return url;
        }
        int startIndex = url.indexOf(FILEURLTICKETPARAM);
        if (startIndex > 0) {
            url = url.substring(0, startIndex - 1);
        }
        return url;
    }

    public static String getFileName(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            return fileName;
        }
        int docTypeIndex = (fileName = fileName.trim().toLowerCase()).indexOf(DOC_FILE_SUFFIX);
        if (docTypeIndex <= 0) {
            fileName = fileName.trim() + DOC_FILE_SUFFIX;
        }
        if (FarNumberRule.checkWordName(fileName).isSuccess().booleanValue()) {
            return fileName;
        }
        String utf8FileName = fileName;
        return utf8FileName;
    }

    public static String getFileType(String fileName) {
        String fileType = "";
        if (StringUtils.isEmpty((String)fileName)) {
            return fileType;
        }
        int docTypeIndex = (fileName = fileName.trim().toLowerCase()).lastIndexOf(46);
        if (docTypeIndex <= 0) {
            return fileType;
        }
        fileType = fileName.substring(docTypeIndex);
        return fileType;
    }

    public static String getFileNameNotFileType(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            return fileName;
        }
        int docTypeIndex = fileName.lastIndexOf(46);
        if (docTypeIndex <= 0) {
            return fileName;
        }
        fileName = fileName.substring(0, docTypeIndex);
        return fileName;
    }
}

