/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class DisclosureFormHelper {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, DisclosureFormHelper.class);

    public static void resetAppId(IFormView view) {
        view.getFormShowParameter().setAppId("fidm");
    }

    public static FormShowParameter createFormParam(Object entity) {
        FormShowParameter formShowParameter = new FormShowParameter();
        if (entity != null) {
            formShowParameter.setCustomParam("inputEnityParam", (Object)JSON.toJSONString((Object)entity));
        }
        return formShowParameter;
    }

    private static <T> T getFormInputParam(IFormView view, Class<T> clazz) {
        try {
            String jsonStr = (String)view.getFormShowParameter().getCustomParam("inputEnityParam");
            if (StringUtils.isEmpty((String)jsonStr)) {
                return null;
            }
            Object input = JSONObject.parseObject((String)jsonStr, clazz);
            return (T)input;
        }
        catch (Exception ex) {
            String msg = ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u6216\u68c0\u67e5\u65e5\u5fd7!", (String)"DisclosureFormHelper_0", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(msg, (Throwable)ex);
            throw new KDBizException(msg);
        }
    }

    public static <T> T getFormInputParam(IFormView view, Class<T> clazz, Boolean isShowNullExpetion) {
        T input = DisclosureFormHelper.getFormInputParam(view, clazz);
        if (isShowNullExpetion.booleanValue() && input == null) {
            String msg = ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u6216\u68c0\u67e5\u65e5\u5fd7!", (String)"DisclosureFormHelper_0", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        return input;
    }

    public static String getFormControlValueStr(Object strObject) {
        if (strObject == null) {
            return "";
        }
        if (strObject instanceof LocaleString) {
            return ((LocaleString)strObject).getLocaleValue();
        }
        return strObject.toString();
    }

    public static boolean getFormControlValueBool(Object strObject) {
        if (strObject == null) {
            return false;
        }
        if (strObject instanceof Boolean) {
            return (Boolean)strObject;
        }
        return "true".equalsIgnoreCase(String.valueOf(strObject));
    }

    public static int getFormControlValueInt(Object strObject, int defaultValue) {
        if (strObject == null) {
            return defaultValue;
        }
        if (strObject instanceof Integer) {
            return (Integer)strObject;
        }
        return TypeUtils.convertValueToInt(strObject, defaultValue);
    }

    public static Long getFormControlValueLong(Object strObject, String key) {
        if (strObject == null) {
            return 0L;
        }
        if (strObject instanceof Long) {
            return (Long)strObject;
        }
        if (strObject instanceof DynamicObject) {
            return ((DynamicObject)strObject).getLong(key);
        }
        return TypeUtils.convertValueToLong(strObject, 0L);
    }

    public static String getFormControlValueCombo(Object strObject, String defaultValue) {
        if (strObject == null) {
            return defaultValue;
        }
        return strObject.toString();
    }

    public static String toSerializedString(List<QFilter> qFilterList) {
        ArrayList<String> list = new ArrayList<String>(qFilterList.size());
        for (QFilter qFilter : qFilterList) {
            if (qFilter == null) continue;
            list.add(qFilter.toSerializedString());
        }
        return JSON.toJSONString(list);
    }

    public static List<QFilter> fromSerializedString(String qFiltersStr) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (StringUtils.isEmpty((String)qFiltersStr)) {
            return qFilters;
        }
        List list = JSON.parseArray((String)qFiltersStr, String.class);
        for (String qFilter : list) {
            if (StringUtils.isEmpty((String)qFilter)) continue;
            qFilters.add(QFilter.fromSerializedString((String)qFilter));
        }
        return qFilters;
    }
}

