/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.base;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.template.DisclosureTemplateHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;

public class DisclosureLogHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosureLogHelper.class);

    public static void writeTemplate(String formId, OperationResult result, OperationName operationName, Long templateId) {
        try {
            if (!LongUtil.isvalidLong((Object)templateId)) {
                return;
            }
            DynamicObject template = DisclosureTemplateHelper.getTemplate(templateId, false);
            if (template == null) {
                return;
            }
            Long dmModelId = template.getLong("model.id");
            if (!LongUtil.isvalidLong((Object)dmModelId)) {
                return;
            }
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            DisclosureLogHelper.writeTemplate(formId, result, operationName, modelInfo, template);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeTemplate(String formId, OperationResult result, OperationName operationName, ModelInfo modelInfo, DynamicObject template) {
        try {
            if (modelInfo == null) {
                return;
            }
            String templateNumebr = template == null ? "" : template.getString("number");
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.TEMPLATE).buildOpName(operationName).buildFormNumber(formId).buildAppId("fidm").buildFormatParams(new Object[]{modelInfo.getNumber(), templateNumebr}).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeTemplateChapter(OperationResult result, OperationName operationName, Long chapterId) {
        try {
            DynamicObject chapter = DisclosureChapterHelper.getChapter(chapterId, false);
            if (chapter == null) {
                return;
            }
            Long dmModelId = chapter.getLong("model.id");
            if (!LongUtil.isvalidLong((Object)dmModelId)) {
                return;
            }
            Long templateId = chapter.getLong("template.id");
            if (!LongUtil.isvalidLong((Object)templateId)) {
                return;
            }
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            DynamicObject template = DisclosureTemplateHelper.getTemplate(templateId, false);
            DisclosureLogHelper.writeTemplateChapter(result, operationName, modelInfo, template, chapter);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeTemplateChapter(OperationResult result, OperationName operationName, ModelInfo modelInfo, Long chapterId) {
        try {
            if (modelInfo == null) {
                return;
            }
            DynamicObject chapter = DisclosureChapterHelper.getChapter(chapterId, false);
            if (chapter == null) {
                return;
            }
            Long templateId = chapter.getLong("template.id");
            if (!LongUtil.isvalidLong((Object)templateId)) {
                return;
            }
            DynamicObject template = DisclosureTemplateHelper.getTemplate(templateId, false);
            DisclosureLogHelper.writeTemplateChapter(result, operationName, modelInfo, template, chapter);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeTemplateChapter(OperationResult result, OperationName operationName, ModelInfo modelInfo, DynamicObject template, DynamicObject chapter) {
        try {
            if (modelInfo == null) {
                return;
            }
            String chapterNumber = chapter == null ? "" : chapter.getString("number");
            String templateNumebr = template == null ? "" : template.getString("number");
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.TEMPLATECHAPTER).buildOpName(operationName).buildFormNumber("fidm_webdesign").buildAppId("fidm").buildFormatParams(new Object[]{modelInfo.getNumber(), templateNumebr, chapterNumber}).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeChapteRepository(OperationResult result, OperationName operationName, ModelInfo modelInfo, DynamicObject chapter) {
        try {
            if (modelInfo == null) {
                return;
            }
            String chapterNumber = chapter == null ? "" : chapter.getString("number");
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.CHAPTEREPOSITORY).buildOpName(operationName).buildFormNumber("fidm_chapterepositorylist").buildAppId("fidm").buildFormatParams(new Object[]{modelInfo.getNumber(), chapterNumber}).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeModuleRepository(OperationResult result, OperationName operationName, ModelInfo modelInfo, DynamicObject module) {
        try {
            if (modelInfo == null) {
                return;
            }
            String moduleNumebr = module == null ? "" : module.getString("number");
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.COMPONENT_GALLERY).buildOpName(operationName).buildFormNumber("fidm_webdesign").buildAppId("fidm").buildFormatParams(new Object[]{modelInfo.getNumber(), moduleNumebr}).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeReportChapter(OperationResult result, OperationName operationName, ModelInfo modelInfo, DynamicObject report, DynamicObject chapter) {
        try {
            if (modelInfo == null) {
                return;
            }
            String chapterNumber = chapter == null ? "" : chapter.getString("number");
            String reportName = report == null ? "" : report.getString("name");
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.REPORT).buildOpName(operationName).buildFormNumber("fidm_webreport_edit").buildAppId("fidm").buildFormatParams(new Object[]{modelInfo.getNumber(), TypeUtils.toPinYinString(reportName), chapterNumber}).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeReportChapter(OperationResult result, ModelInfo modelInfo, DynamicObject report, DynamicObject chapter, OperationName operate) {
        try {
            if (modelInfo == null) {
                return;
            }
            String chapterNumber = chapter == null ? "" : chapter.getString("number");
            String reportName = report == null ? "" : report.getString("name");
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.REPORT).buildOpName(operate).buildFormNumber("fidm_webreport_edit").buildAppId("fidm").buildFormatParams(new Object[]{modelInfo.getNumber(), TypeUtils.toPinYinString(reportName), chapterNumber}).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeReportOper(OperationResult result, ModelInfo modelInfo, DynamicObject report, OperationName operate) {
        try {
            String org;
            if (modelInfo == null) {
                return;
            }
            String reportName = report == null ? "" : report.getString("name");
            String year = report == null ? "" : report.getString("year.number");
            String period = report == null ? "" : report.getString("period.number");
            String string = org = report == null ? "" : report.getString("bcmentity.number");
            if (StringUtils.isEmpty((String)period)) {
                String string2 = period = report == null ? "" : report.getString("budgetperiod.number");
            }
            if (StringUtils.isEmpty((String)org)) {
                org = report == null ? "" : report.getString("epmentity.number");
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.REPORT).buildOpName(operate).buildFormNumber("fidm_webreport_edit").buildAppId("fidm").buildFormatParams(new Object[]{modelInfo.getNumber(), year, period, org, TypeUtils.toPinYinString(reportName)}).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeReportCreate(OperationResult result, ModelInfo modelInfo, DynamicObject template, Long reportId) {
        try {
            String org;
            DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
            if (modelInfo == null) {
                return;
            }
            String templateNumebr = template == null ? "" : template.getString("number");
            String templateName = template == null ? "" : template.getString("name");
            String reportName = report == null ? "" : report.getString("name");
            String year = report == null ? "" : report.getString("year.number");
            String period = report == null ? "" : report.getString("period.number");
            String string = org = report == null ? "" : report.getString("bcmentity.number");
            if (StringUtils.isEmpty((String)period)) {
                String string2 = period = report == null ? "" : report.getString("budgetperiod.number");
            }
            if (StringUtils.isEmpty((String)org)) {
                org = report == null ? "" : report.getString("epmentity.number");
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.TEMPLATE).buildOpName(OperationName.GENERALMYREPORT).buildFormNumber("fidm_report_generate").buildAppId("fidm").buildFormatParams(new Object[]{modelInfo.getNumber(), templateNumebr, year, period, org, TypeUtils.toPinYinString(reportName)}).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeTemplateCataLog(OperationResult result, OperationName operationName, ModelInfo modelInfo, DynamicObject[] templateCataLog) {
        try {
            if (modelInfo == null) {
                return;
            }
            for (DynamicObject dyn : templateCataLog) {
                String catalogNumber = dyn == null ? "" : dyn.getString("number");
                AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.TEMPLATE).buildOpName(operationName).buildFormNumber("fidm_templatelist").buildAppId("fidm").buildFormatParams(new Object[]{modelInfo.getNumber(), catalogNumber}).buildOpResult(result);
                AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
            }
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }

    public static void writeConfigLog(OperationResult result, OperationName operationName, String var1, String var2) {
        try {
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.MODEL).buildOpName(operationName).buildFormNumber("fidm_configsetting").buildAppId("fidm").buildFormatParams(new Object[]{var1, var2}).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }
}

