/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.tree.TreeNode;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.base.dto.DisclosureTreeDto;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;

public class DisclosureTreeHelper {
    public static final int MAX_TREE_COUNT = 10000;

    public static void spreadAllNode(TreeNode treenode) {
        if (treenode == null) {
            return;
        }
        treenode.setIsOpened(true);
        if (null != treenode.getChildren()) {
            List nodes = treenode.getChildren();
            for (TreeNode t : nodes) {
                DisclosureTreeHelper.spreadAllNode(t);
            }
        }
    }

    public static DisclosureTreeDto getRoot(List<DisclosureTreeDto> rootNodeList) {
        for (DisclosureTreeDto item : rootNodeList) {
            if (!StringUtils.isEmpty((String)item.getParentId()) && !"0".equalsIgnoreCase(item.getParentId())) continue;
            return item;
        }
        return null;
    }

    public static TreeNode findFocusNodeById(TreeNode tree, String id) {
        if (StringUtils.isEmpty((String)id) || tree == null) {
            return null;
        }
        if (id.equals(tree.getId())) {
            return tree;
        }
        if (tree.getChildren() != null) {
            for (TreeNode c : tree.getChildren()) {
                TreeNode fc = DisclosureTreeHelper.findFocusNodeById(c, id);
                if (fc == null) continue;
                return fc;
            }
        }
        return null;
    }

    public static TreeNode setEntryNode(TreeNode root, List<DisclosureTreeDto> rootNodeList, String headId) {
        HashMap<String, List<DisclosureTreeDto>> nodeMap = new HashMap<String, List<DisclosureTreeDto>>(16);
        for (DisclosureTreeDto node : rootNodeList) {
            String parentId = node.getParentId();
            ArrayList<DisclosureTreeDto> nodeList = (ArrayList<DisclosureTreeDto>)nodeMap.get(parentId);
            if (nodeList == null) {
                nodeList = new ArrayList<DisclosureTreeDto>(16);
                nodeMap.put(parentId, nodeList);
            }
            nodeList.add(node);
        }
        return DisclosureTreeHelper.createNode(root, nodeMap, headId, 10000);
    }

    private static TreeNode createNode(TreeNode parentNode, Map<String, List<DisclosureTreeDto>> nodeMap, String headId, int maxCount) {
        List<DisclosureTreeDto> list = nodeMap.get(headId);
        if (list == null || list.size() == 0) {
            return parentNode;
        }
        ArrayList<TreeNode> children = parentNode.getChildren();
        if (children == null) {
            children = new ArrayList<TreeNode>(list.size());
            parentNode.setChildren(children);
        }
        int i = 0;
        for (DisclosureTreeDto map : list) {
            if (maxCount != 0 && (maxCount <= 0 || ++i > maxCount)) continue;
            TreeNode entry = new TreeNode();
            entry.setParentid(headId);
            entry.setId(map.getId());
            entry.setText(map.getName());
            if (StringUtils.isNotEmpty((String)map.getIcon())) {
                entry.setIcon(map.getIcon());
            }
            String entryHeadId = map.getId();
            DisclosureTreeHelper.createNode(entry, nodeMap, entryHeadId, maxCount);
            children.add(entry);
        }
        return parentNode;
    }

    public static DisclosureTreeDto findDtoById(List<DisclosureTreeDto> treeDtos, String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        if (treeDtos == null || treeDtos.size() == 0) {
            return null;
        }
        for (DisclosureTreeDto c : treeDtos) {
            if (!id.equalsIgnoreCase(c.getId())) continue;
            return c;
        }
        return null;
    }

    public static List<String> getTreeIds(List<DisclosureTreeDto> treeDtos, String id) {
        ArrayList<String> ids = new ArrayList<String>(treeDtos.size());
        if (StringUtils.isEmpty((String)id)) {
            for (DisclosureTreeDto node : treeDtos) {
                ids.add(node.getId());
            }
            return ids;
        }
        HashMap<String, List<DisclosureTreeDto>> nodeMap = new HashMap<String, List<DisclosureTreeDto>>(16);
        for (DisclosureTreeDto node : treeDtos) {
            String parentId = node.getParentId();
            ArrayList<DisclosureTreeDto> nodeList = (ArrayList<DisclosureTreeDto>)nodeMap.get(parentId);
            if (nodeList == null) {
                nodeList = new ArrayList<DisclosureTreeDto>(16);
                nodeMap.put(parentId, nodeList);
            }
            nodeList.add(node);
        }
        ids.add(id);
        DisclosureTreeHelper.getTreeChildrenIds(nodeMap, id, ids);
        return ids;
    }

    private static void getTreeChildrenIds(Map<String, List<DisclosureTreeDto>> nodeMap, String id, List<String> ids) {
        List<DisclosureTreeDto> list = nodeMap.get(id);
        if (list == null || list.size() == 0) {
            return;
        }
        for (DisclosureTreeDto children : list) {
            ids.add(children.getId());
            DisclosureTreeHelper.getTreeChildrenIds(nodeMap, children.getId(), ids);
        }
    }

    public static void setReadOnly(List<DisclosureTreeDto> rootNodeList, String curNodeId, List<String> readOnlyIds) {
        HashMap<String, List<DisclosureTreeDto>> nodeMap = new HashMap<String, List<DisclosureTreeDto>>(16);
        DisclosureTreeDto curNode = null;
        for (DisclosureTreeDto node : rootNodeList) {
            String parentId = node.getParentId();
            ArrayList<DisclosureTreeDto> nodeList = (ArrayList<DisclosureTreeDto>)nodeMap.get(parentId);
            if (nodeList == null) {
                nodeList = new ArrayList<DisclosureTreeDto>(16);
                nodeMap.put(parentId, nodeList);
            }
            nodeList.add(node);
            if (!curNodeId.equalsIgnoreCase(node.getId())) continue;
            curNode = node;
        }
        if (curNode != null) {
            boolean curReadOnly = readOnlyIds.contains(curNode.getId());
            if (StringUtils.isEmpty((String)curNode.getParentId()) || "0".equalsIgnoreCase(curNode.getParentId())) {
                curReadOnly = false;
            }
            if (curReadOnly) {
                curNode.setPermClassType(DataTypeEnum.READ.getIndex());
            }
            DisclosureTreeHelper.setChildrenReadOnly(nodeMap, curNode, readOnlyIds);
        }
    }

    private static void setChildrenReadOnly(Map<String, List<DisclosureTreeDto>> nodeMap, DisclosureTreeDto parentDto, List<String> readOnlyIds) {
        if (parentDto == null) {
            return;
        }
        List<DisclosureTreeDto> list = nodeMap.get(parentDto.getId());
        if (list == null || list.size() == 0) {
            return;
        }
        boolean parentReadOnly = DataTypeEnum.READ.getIndex().equalsIgnoreCase(parentDto.getPermClassType());
        for (DisclosureTreeDto children : list) {
            boolean readOnly;
            boolean curReadOnly = readOnlyIds.contains(children.getId());
            boolean bl = readOnly = parentReadOnly || curReadOnly;
            if (readOnly) {
                children.setPermClassType(DataTypeEnum.READ.getIndex());
            }
            DisclosureTreeHelper.setChildrenReadOnly(nodeMap, children, readOnlyIds);
        }
    }
}

