/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.base;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.dto.ZipFileItem;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.GlobalIdUtil;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class DisclosureZipFileHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosureZipFileHelper.class);
    private static final int BUFFER = 512;
    public static final String Zip_FILE_SUFFIX = ".zip";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String zipFile(String zipfileName, List<ZipFileItem> zipFileItemList, String urlPrefix) {
        int docTypeIndex;
        if (zipFileItemList == null || zipFileItemList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u538b\u7f29\u6587\u4ef6\u5217\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WpsFileServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)zipfileName)) {
            zipfileName = GlobalIdUtil.genGlobalLongId() + Zip_FILE_SUFFIX;
        }
        if ((docTypeIndex = zipfileName.indexOf(Zip_FILE_SUFFIX)) <= 0) {
            zipfileName = zipfileName.trim() + Zip_FILE_SUFFIX;
        }
        byte[] buffer = new byte[512];
        int readLength = 0;
        int exists = 0;
        ByteArrayOutputStream oo = new ByteArrayOutputStream();
        InputStream inputStream = null;
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(oo);){
            for (ZipFileItem entry : zipFileItemList) {
                try {
                    inputStream = DisclosureFileHelper.getFileInputStream(entry.getUrl(), entry.isTempFile());
                    if (inputStream == null) continue;
                    ZipEntry z = new ZipEntry(entry.getFileName());
                    zipOutputStream.putNextEntry(z);
                    while ((readLength = inputStream.read(buffer, 0, 512)) != -1) {
                        zipOutputStream.write(buffer, 0, readLength);
                    }
                    zipOutputStream.closeEntry();
                    ++exists;
                }
                catch (Exception ex) {
                    logger.error("dm getFileInputStream error", (Throwable)ex);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (Exception ex1) {
            logger.error("dm ZipOutputStream error", (Throwable)ex1);
        }
        finally {
            try {
                if (oo != null) {
                    oo.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception ex2) {
                logger.error("dm ZipOutputStream close error", (Throwable)ex2);
            }
        }
        if (exists > 0) {
            ByteArrayInputStream finalInputStream = new ByteArrayInputStream(oo.toByteArray());
            return DisclosureFileHelper.uploadTempFile(finalInputStream, zipfileName, urlPrefix, "");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ZipFileItem> unzipFile(String tempUrl, List<String> filters, String urlPrefix, String fileType) {
        ArrayList<ZipFileItem> fileItemList = new ArrayList<ZipFileItem>(100);
        InputStream fis = null;
        BufferedInputStream bis = null;
        ZipArchiveInputStream inputStream = null;
        try {
            fis = DisclosureFileHelper.getFileInputStream(tempUrl, true);
            bis = new BufferedInputStream(fis);
            inputStream = new ZipArchiveInputStream((InputStream)bis);
            ZipArchiveEntry entry = null;
            int readLength = 0;
            byte[] buffer = new byte[512];
            while ((entry = inputStream.getNextZipEntry()) != null) {
                String curfileType;
                if (entry.isDirectory() || filters != null && filters.size() > 0 && !TypeUtils.endsWithIgnore(filters, curfileType = DisclosureFileHelper.getFileType(entry.getName()))) continue;
                ByteArrayOutputStream os = null;
                try {
                    os = new ByteArrayOutputStream();
                    while ((readLength = inputStream.read(buffer, 0, 512)) != -1) {
                        os.write(buffer, 0, readLength);
                    }
                    ByteArrayInputStream itemIn = new ByteArrayInputStream(os.toByteArray());
                    String itemUrl = DisclosureFileHelper.uploadTempFile(itemIn, entry.getName(), urlPrefix, fileType, 3600);
                    ZipFileItem zipFileItem = new ZipFileItem();
                    zipFileItem.setFileName(entry.getName());
                    zipFileItem.setTempFile(true);
                    zipFileItem.setUrl(itemUrl);
                    fileItemList.add(zipFileItem);
                }
                finally {
                    if (os == null) continue;
                    os.close();
                }
            }
            logger.info("******************unzip finish********************");
        }
        catch (Exception e) {
            try {
                logger.error("unzip file error", (Throwable)e);
            }
            catch (Throwable throwable) {
                DisclosureZipFileHelper.closeStream(inputStream);
                DisclosureZipFileHelper.closeStream(bis);
                DisclosureZipFileHelper.closeStream(fis);
                throw throwable;
            }
            DisclosureZipFileHelper.closeStream(inputStream);
            DisclosureZipFileHelper.closeStream(bis);
            DisclosureZipFileHelper.closeStream(fis);
        }
        DisclosureZipFileHelper.closeStream((Closeable)inputStream);
        DisclosureZipFileHelper.closeStream(bis);
        DisclosureZipFileHelper.closeStream(fis);
        return fileItemList;
    }

    private static void closeStream(Closeable closeStream) {
        if (closeStream != null) {
            try {
                closeStream.close();
            }
            catch (IOException e) {
                logger.error("closeStream error", (Throwable)e);
            }
        }
    }
}

