/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.chapter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.org.model.EnableEnum;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.util.FarNumberRule;
import kd.epm.far.business.common.util.PlatUtil;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.chapter.dto.ChapterCatalog;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class ChapterCatalogHelper {
    private ChapterCatalogHelper() {
    }

    public static List<ChapterCatalog> getChapterCatalogs(long modelId, boolean onlyWritePermission) {
        QFilter permqFilter;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("status", "=", (Object)StatusEnum.Checked.toString()));
        qFilters.add(new QFilter("enable", "=", (Object)EnableEnum.Enable.toString()));
        if (onlyWritePermission) {
            permqFilter = PermissionHelper.getWritePermFilter(modelId, "fidm_chaptergroup");
            qFilters.add(permqFilter);
        } else {
            permqFilter = PermissionHelper.getReadAndWritePermFilter(modelId, "fidm_chaptergroup");
            qFilters.add(permqFilter);
        }
        DynamicObjectCollection catalogDatas = QueryServiceHelper.query((String)"fidm_chaptergroup", (String)"id,number,name,longnumber,sequence,level,isleaf,parent.id,parent.name,permclass.id,permclass.number,instruction", (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<ChapterCatalog> catalogs = new ArrayList<ChapterCatalog>(catalogDatas.size());
        for (DynamicObject dy : catalogDatas) {
            ChapterCatalog catalog = new ChapterCatalog();
            catalog.setId(dy.getLong("id"));
            catalog.setNumber(dy.getString("number"));
            catalog.setName(dy.getString("name"));
            catalog.setLongNumber(dy.getString("longnumber"));
            catalog.setLevel(dy.getInt("level"));
            catalog.setIsLeaf(dy.getBoolean("isleaf"));
            catalog.setDseq(dy.getInt("sequence"));
            catalog.setParentId(dy.getLong("parent.id"));
            catalog.setParentName(dy.getString("parent.name"));
            catalog.setPermClassId(dy.getLong("permclass.id"));
            catalog.setPermClassNumber(dy.getString("permclass.number"));
            catalog.setDescription(dy.getString("instruction"));
            catalogs.add(catalog);
        }
        return catalogs;
    }

    public static ResultInfo saveChapterCatalog(long modelId, ChapterCatalog chapterCatalog) {
        DynamicObject parent;
        DynamicObject catalog;
        OperationStatus status;
        String oldLongNumber;
        long oldParentId;
        int oldLevel;
        Date now = TimeServiceHelper.now();
        long userId = RequestContext.get().getCurrUserId();
        String msg = ChapterCatalogHelper.saveCheck(modelId, chapterCatalog);
        if (StringUtils.isNotEmpty((String)msg)) {
            return ResultInfo.fail(msg);
        }
        if (chapterCatalog.getId() == 0L) {
            if (!ChapterCatalogHelper.hasWritePermission(modelId, chapterCatalog.getParentId())) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u5f53\u524d\u7ae0\u8282\u5206\u7c7b\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ChapterCatalogHelper_13", (String)"epm-far-business", (Object[])new Object[0]));
            }
            oldLevel = 1;
            oldParentId = 0L;
            oldLongNumber = "";
            status = OperationStatus.ADDNEW;
            chapterCatalog.setId(GlobalIdUtil.genGlobalLongId());
            catalog = BusinessDataServiceHelper.newDynamicObject((String)"fidm_chaptergroup");
            catalog.set("id", (Object)chapterCatalog.getId());
            catalog.set("masterid", (Object)chapterCatalog.getId());
            catalog.set("number", (Object)chapterCatalog.getNumber());
            catalog.set("status", (Object)StatusEnum.Checked);
            catalog.set("enable", (Object)EnableEnum.Enable);
            catalog.set("isleaf", (Object)true);
            catalog.set("model", (Object)modelId);
            catalog.set("catalogtype", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType());
            catalog.set("creator", (Object)userId);
            catalog.set("createtime", (Object)now);
        } else {
            if (!ChapterCatalogHelper.hasWritePermission(modelId, chapterCatalog.getId())) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u5f53\u524d\u7ae0\u8282\u5206\u7c7b\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ChapterCatalogHelper_13", (String)"epm-far-business", (Object[])new Object[0]));
            }
            status = OperationStatus.EDIT;
            catalog = BusinessDataServiceHelper.loadSingle((Object)chapterCatalog.getId(), (String)"fidm_chaptergroup");
            oldParentId = catalog.getLong("parent.id");
            oldLongNumber = catalog.getString("longnumber");
            oldLevel = catalog.getInt("level");
        }
        catalog.set("name", (Object)chapterCatalog.getName());
        catalog.set("instruction", (Object)chapterCatalog.getDescription());
        catalog.set("parent", (Object)chapterCatalog.getParentId());
        catalog.set("permclass", (Object)chapterCatalog.getPermClassId());
        catalog.set("modifier", (Object)userId);
        catalog.set("modifytime", (Object)now);
        if (oldParentId != chapterCatalog.getParentId()) {
            catalog.set("sequence", (Object)ChapterCatalogHelper.getCatalogMaxDesq(modelId, chapterCatalog.getParentId()));
        }
        if ((parent = BusinessDataServiceHelper.loadSingle((Object)chapterCatalog.getParentId(), (String)"fidm_chaptergroup")) != null) {
            catalog.set("longnumber", (Object)(parent.getString("longnumber") + "." + catalog.getString("number")));
            catalog.set("level", (Object)(parent.getInt("level") + 1));
        }
        PlatUtil.executeWithTXNew(tx -> {
            List<Long> ids;
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{catalog});
            PermissionHelper.savePermClassEntity(modelId, chapterCatalog.getId(), "fidm_chaptergroup", chapterCatalog.getPermClassId(), status);
            if (status == OperationStatus.EDIT && oldParentId != chapterCatalog.getParentId() && !(ids = ChapterCatalogHelper.getChildrenIds(modelId, chapterCatalog.getId(), oldLongNumber)).isEmpty()) {
                DynamicObject[] dys;
                for (DynamicObject dy : dys = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fidm_chaptergroup"))) {
                    dy.set("longnumber", (Object)dy.getString("longnumber").replaceFirst(oldLongNumber, catalog.getString("longnumber")));
                    dy.set("level", (Object)(dy.getInt("level") + catalog.getInt("level") - oldLevel));
                    dy.set("modifier", (Object)userId);
                    dy.set("modifytime", (Object)now);
                }
                SaveServiceHelper.save((DynamicObject[])dys);
            }
        });
        return ResultInfo.success(chapterCatalog.getId());
    }

    public static ResultInfo deleteChapterCatalog(long modelId, long catalogId) {
        if (!ChapterCatalogHelper.hasWritePermission(modelId, catalogId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5f53\u524d\u7ae0\u8282\u5206\u7c7b\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ChapterCatalogHelper_13", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((Object)catalogId, (String)"fidm_chaptergroup");
        if (catalog == null || catalogId == 0L) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ChapterCatalogHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        long parentId = catalog.getLong("parent.id");
        if (parentId == 0L) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"ChapterCatalogHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        List<Long> catalogIds = ChapterCatalogHelper.getChildrenIds(modelId, catalogId, catalog.getString("longnumber"));
        catalogIds.add(catalogId);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_chapter", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("group", "in", catalogIds)});
        PlatUtil.executeWithTXNew(tx -> {
            try {
                DynamicObject[] chapters = BusinessDataServiceHelper.load((Object[])dys.stream().map(d -> d.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fidm_chapter"));
                if (chapters != null && chapters.length > 0) {
                    for (DynamicObject chapter : chapters) {
                        chapter.set("group", (Object)parentId);
                    }
                    SaveServiceHelper.save((DynamicObject[])chapters);
                }
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fidm_chaptergroup"), (Object[])catalogIds.toArray());
                Iterator iterator = catalogIds.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    PermissionHelper.savePermClassEntity(modelId, id, "fidm_chaptergroup", 0L, OperationStatus.EDIT);
                }
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
                qFilters.add(new QFilter("model", "=", (Object)modelId));
                qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
                qFilters.add(new QFilter("parent", "=", (Object)parentId));
                qFilters.add(new QFilter("id", "!=", (Object)catalogId));
                boolean existsChild = QueryServiceHelper.exists((String)"fidm_chaptergroup", (QFilter[])qFilters.toArray(new QFilter[0]));
                if (!existsChild) {
                    DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"fidm_chaptergroup");
                    parent.set("isleaf", (Object)true);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parent});
                }
                DisclosureLogHelper.writeChapteRepository(OperationResult.SUCCESS, OperationName.CATALOG_DELETE, modelInfo, catalog);
            }
            catch (Exception ex) {
                DisclosureLogHelper.writeChapteRepository(OperationResult.FAILURE, OperationName.CATALOG_DELETE, modelInfo, catalog);
                throw ex;
            }
        });
        return ResultInfo.success(catalogId);
    }

    public static ResultInfo moveChapterCatalog(long modelId, long catalogId, int type) {
        long moveId;
        DynamicObject dyMove;
        List temps;
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((Object)catalogId, (String)"fidm_chaptergroup");
        if (catalog == null) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ChapterCatalogHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (!ChapterCatalogHelper.hasWritePermission(modelId, catalog.getLong("parent.id"))) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ae0\u8282\u5206\u7c7b\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ChapterCatalogHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
        }
        int seq = catalog.getInt("sequence");
        List<ChapterCatalog> catalogs = ChapterCatalogHelper.getChapterCatalogs(modelId, false);
        if (type == 1) {
            temps = catalogs.stream().filter(c -> c.getParentId() == catalog.getLong("parent.id") && c.getDseq() < seq).sorted(Comparator.comparing(ChapterCatalog::getDseq).reversed()).collect(Collectors.toList());
            if (temps.isEmpty()) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u7b2c\u4e00\u4e2a\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"ChapterCatalogHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
            }
        } else {
            temps = catalogs.stream().filter(c -> c.getParentId() == catalog.getLong("parent.id") && c.getDseq() > seq).sorted(Comparator.comparing(ChapterCatalog::getDseq)).collect(Collectors.toList());
            if (temps.isEmpty()) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u540e\u4e00\u4e2a\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"ChapterCatalogHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
            }
        }
        if ((dyMove = BusinessDataReader.loadSingle((Object)(moveId = ((ChapterCatalog)temps.get(0)).getId()), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fidm_chaptergroup"))) != null) {
            catalog.set("sequence", (Object)dyMove.getInt("sequence"));
            dyMove.set("sequence", (Object)seq);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{catalog, dyMove});
        }
        return ResultInfo.success(catalogId);
    }

    private static String saveCheck(long modelId, ChapterCatalog chapterCatalog) {
        if (chapterCatalog.getId() == 0L) {
            if (StringUtils.isEmpty((String)chapterCatalog.getNumber())) {
                return ResManager.loadKDString((String)"\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChapterCatalogHelper_4", (String)"epm-far-business", (Object[])new Object[0]);
            }
            if (ChapterCatalogHelper.existsChapterCatalog(modelId, 0L, chapterCatalog.getNumber())) {
                return ResManager.loadKDString((String)"\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"ChapterCatalogHelper_5", (String)"epm-far-business", (Object[])new Object[0]);
            }
            if (!FarNumberRule.checkNumber(chapterCatalog.getNumber())) {
                return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ChapterCatalogHelper_6", (String)"epm-far-business", (Object[])new Object[0]);
            }
        } else if (!ChapterCatalogHelper.existsChapterCatalog(modelId, chapterCatalog.getId(), StringUtils.getEmpty())) {
            return ResManager.loadKDString((String)"\u5206\u7c7b\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ChapterCatalogHelper_0", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)chapterCatalog.getName())) {
            return ResManager.loadKDString((String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChapterCatalogHelper_7", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (chapterCatalog.getNumber().length() > 30) {
            return ResManager.loadKDString((String)"\u5206\u7c7b\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u3002", (String)"ChapterCatalogHelper_10", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (chapterCatalog.getName().length() > 50) {
            return ResManager.loadKDString((String)"\u5206\u7c7b\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"ChapterCatalogHelper_11", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)chapterCatalog.getDescription()) && chapterCatalog.getDescription().length() > 100) {
            return ResManager.loadKDString((String)"\u5206\u7c7b\u63cf\u8ff0\u8bf4\u660e\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"ChapterCatalogHelper_12", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (!"root".equals(chapterCatalog.getNumber())) {
            if (chapterCatalog.getParentId() == 0L) {
                return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0a\u7ea7\u5206\u7c7b\u3002", (String)"ChapterCatalogHelper_8", (String)"epm-far-business", (Object[])new Object[0]);
            }
            if (!ChapterCatalogHelper.existsChapterCatalog(modelId, chapterCatalog.getParentId(), StringUtils.getEmpty())) {
                return ResManager.loadKDString((String)"\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\u3002", (String)"ChapterCatalogHelper_9", (String)"epm-far-business", (Object[])new Object[0]);
            }
        }
        return StringUtils.getEmpty();
    }

    private static boolean existsChapterCatalog(long modelId, long id, String number) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        if (StringUtils.isEmpty((String)number)) {
            qFilters.add(new QFilter("id", "=", (Object)id));
        } else {
            qFilters.add(new QFilter("number", "=", (Object)number));
        }
        return QueryServiceHelper.exists((String)"fidm_chaptergroup", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    private static int getCatalogMaxDesq(long modelId, Long parentId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("parent", "=", (Object)parentId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_chaptergroup", (String)"sequence", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"sequence desc", (int)1);
        if (dys != null && !dys.isEmpty()) {
            return ((DynamicObject)dys.get(0)).getInt("sequence") + 1;
        }
        return 1;
    }

    private static List<Long> getChildrenIds(long modelId, long id, String longNumber) {
        ArrayList<Long> ids = new ArrayList<Long>(6);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("id", "!=", (Object)id));
        qFilters.add(new QFilter("longnumber", "like", (Object)(longNumber + ".%")));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"fidm_chaptergroup", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
            for (DynamicObject row : dynamicObjects) {
                if (row.getLong("id") <= 0L) continue;
                ids.add(row.getLong("id"));
            }
        }
        return ids;
    }

    public static boolean hasWritePermission(long modelId, long catalogId) {
        boolean result;
        DynamicObject catalog = BusinessDataServiceHelper.loadSingleFromCache((Object)catalogId, (String)"fidm_chaptergroup");
        if (catalog != null && (result = PermissionHelper.hasWritePerm(modelId, "fidm_chaptergroup", catalogId))) {
            if (catalog.getLong("parent.id") == 0L) {
                return true;
            }
            return ChapterCatalogHelper.hasWritePermission(modelId, catalog.getLong("parent.id"));
        }
        return false;
    }
}

