/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.chapter;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.EnableEnum;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.enums.ChapterCommitStatusEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.util.FarNumberRule;
import kd.epm.far.business.common.util.PlatUtil;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.epmclient.EpmChapterServiceHelper;
import kd.epm.far.business.epmclient.EpmModuleServiceHelper;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.chapter.ChapterCatalogHelper;
import kd.epm.far.business.fidm.chapter.ChapterServiceHelper;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.chapter.DisclosureCopyHelper;
import kd.epm.far.business.fidm.chapter.dto.Chapter;
import kd.epm.far.business.fidm.chapter.dto.ChapterModule;
import kd.epm.far.business.fidm.chapter.dto.ChapterSaveInput;
import kd.epm.far.business.fidm.chapter.dto.ChapterSimple;
import kd.epm.far.business.fidm.design.DisclosurePreviewService;
import kd.epm.far.business.fidm.design.dto.ChapterPreviewResult;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;

public class ChapterRepositoryHelper {
    private static final Log log = LogFactory.getLog(ChapterRepositoryHelper.class);

    public static List<ChapterSimple> getChapters(long modelId) {
        ArrayList<ChapterSimple> chapters = new ArrayList<ChapterSimple>(6);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("status", "=", (Object)StatusEnum.Checked.toString()));
        qFilters.add(new QFilter("template", "=", (Object)0L));
        qFilters.add(new QFilter("group", ">", (Object)0L));
        QFilter permFilter = PermissionHelper.getReadAndWritePermFilter(modelId, "fidm_chapter");
        qFilters.add(permFilter);
        DynamicObjectCollection chapterRows = QueryServiceHelper.query((String)"fidm_chapter", (String)"id,number,name,sequence,template,enable,commitstatus,group,savewordtype", (QFilter[])qFilters.toArray(new QFilter[0]));
        for (DynamicObject chapterRow : chapterRows) {
            ChapterSimple chapter = new ChapterSimple();
            chapter.setId(chapterRow.getLong("id"));
            chapter.setNumber(chapterRow.getString("number"));
            chapter.setName(chapterRow.getString("name"));
            chapter.setDseq(chapterRow.getInt("sequence"));
            chapter.setTemplateId(chapterRow.getLong("template"));
            chapter.setEnable(chapterRow.getBoolean("enable"));
            chapter.setCommitStatus(chapterRow.getString("commitstatus"));
            chapter.setCatalogId(chapterRow.getLong("group"));
            chapter.setSaveWordType(chapterRow.getString("savewordtype"));
            chapters.add(chapter);
        }
        return chapters;
    }

    public static Chapter getChapter(long modelId, long chapterId, Map<String, Long> dimMembers) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("id", "=", (Object)chapterId));
        DynamicObject chapterRow = BusinessDataServiceHelper.loadSingleFromCache((String)"fidm_chapter", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (chapterRow == null) {
            return null;
        }
        Chapter chapter = new Chapter();
        chapter.setId(chapterRow.getLong("id"));
        chapter.setNumber(chapterRow.getString("number"));
        chapter.setName(chapterRow.getString("name"));
        chapter.setDseq(chapterRow.getInt("sequence"));
        chapter.setTemplateId(chapterRow.getLong("template.id"));
        chapter.setEnable(chapterRow.getBoolean("enable"));
        chapter.setCommitStatus(chapterRow.getString("commitstatus"));
        chapter.setPermClassId(chapterRow.getLong("permclass_id"));
        if (chapter.getPermClassId() > 0L) {
            chapter.setPermClassNumber(PermissionHelper.getPermClassNumber(modelId, chapter.getPermClassId()));
        }
        chapter.setCatalogId(chapterRow.getLong("group_id"));
        if (chapter.getCatalogId() > 0L) {
            ArrayList<QFilter> qFilterCatalogs = new ArrayList<QFilter>(4);
            qFilterCatalogs.add(new QFilter("model", "=", (Object)modelId));
            qFilterCatalogs.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
            qFilterCatalogs.add(new QFilter("id", "=", (Object)chapter.getCatalogId()));
            DynamicObject catalog = QueryServiceHelper.queryOne((String)"fidm_chaptergroup", (String)"name", (QFilter[])qFilterCatalogs.toArray(new QFilter[0]));
            if (catalog != null) {
                chapter.setCatalogName(catalog.getString("name"));
            }
        }
        chapter.setDescription(chapterRow.getString("description"));
        chapter.setUrl(chapterRow.getString("url"));
        chapter.setPreviewUrl(chapterRow.getString("previewurl"));
        if (StringUtils.isNotEmpty((String)chapterRow.getString("url"))) {
            chapter.setFullUrl(UrlService.getAttachmentFullUrl((String)chapterRow.getString("url")));
        }
        if (StringUtils.isNotEmpty((String)chapterRow.getString("previewurl"))) {
            chapter.setPreviewFullUrl(UrlService.getAttachmentFullUrl((String)chapterRow.getString("previewurl")));
        }
        chapter.setCreator(chapterRow.getString("creator.name"));
        chapter.setCreateTime(chapterRow.getDate("createtime"));
        chapter.setModifier(chapterRow.getString("modifier.name"));
        chapter.setModifyTime(chapterRow.getDate("modifytime"));
        chapter.setCommitor(chapterRow.getString("commitor.name"));
        chapter.setCommitTime(chapterRow.getDate("committime"));
        chapter.setSendBacker(chapterRow.getString("sendbacker.name"));
        chapter.setSendBackTime(chapterRow.getDate("sendbacktime"));
        chapter.setSaveWordType(chapterRow.getString("savewordtype"));
        DynamicObjectCollection dyModules = chapterRow.getDynamicObjectCollection("entryentity");
        ArrayList<ChapterModule> modules = new ArrayList<ChapterModule>(dyModules.size());
        for (DynamicObject dyModule : dyModules) {
            ChapterModule module = new ChapterModule();
            module.setId(dyModule.getLong("id"));
            module.setModuleId(dyModule.getLong("module_id"));
            module.setKey(dyModule.getString("key"));
            module.setDseq(dyModule.getInt("seq"));
            modules.add(module);
        }
        chapter.setModules(modules);
        String fullUrl = ChapterRepositoryHelper.getChapterPreviewFile(modelId, chapter.getId(), chapter.getSaveWordType(), dimMembers, true);
        if (StringUtils.isNotEmpty((String)fullUrl)) {
            chapter.setFullUrl(fullUrl);
        }
        return chapter;
    }

    public static ResultInfo save(ChapterSaveInput input) {
        DynamicObject chapter;
        OperationStatus status;
        if (!ChapterRepositoryHelper.hasWritePermission(input.getDmModelId(), input.getChapterId(), input.getCatalogId())) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterRepositoryHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ResultInfo checkResult = ChapterRepositoryHelper.saveCheck(input);
        if (Boolean.FALSE.equals(checkResult.isSuccess())) {
            return checkResult;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(input.getDmModelId());
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        Long chapterId = input.getChapterId();
        Date now = TimeServiceHelper.now();
        long userId = RequestContext.get().getCurrUserId();
        if (!LongUtil.isvalidLong((Object)chapterId)) {
            status = OperationStatus.ADDNEW;
            chapterId = GlobalIdUtil.genGlobalLongId();
            chapter = BusinessDataServiceHelper.newDynamicObject((String)"fidm_chapter");
            chapter.set("id", (Object)chapterId);
            chapter.set("masterid", (Object)chapterId);
            chapter.set("status", (Object)StatusEnum.Checked);
            chapter.set("enable", (Object)EnableEnum.Enable);
            chapter.set("commitstatus", (Object)ChapterCommitStatusEnum.INIT.getType());
            chapter.set("model", (Object)input.getDmModelId());
            chapter.set("template", (Object)0L);
            chapter.set("sequence", (Object)0L);
            chapter.set("creator", (Object)userId);
            chapter.set("createtime", (Object)now);
            chapter.set("number", (Object)input.getNumber());
            chapter.set("savewordtype", (Object)input.getSaveWordType().getType());
            chapter.set("comefrom", (Object)OpenWordEnum.getComefromByType(input.getSaveWordType().getType()).getType());
        } else {
            status = OperationStatus.EDIT;
            chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
            if (chapter == null) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ChapterRepositoryHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
            }
        }
        chapter.set("number", (Object)input.getNumber());
        chapter.set("name", input.getName());
        chapter.set("description", input.getDescription());
        chapter.set("permclass", (Object)input.getPermClassId());
        chapter.set("group", (Object)input.getCatalogId());
        chapter.set("modifier", (Object)userId);
        chapter.set("modifytime", (Object)now);
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
            PermissionHelper.savePermClassEntity(input.getDmModelId(), chapterId, "fidm_chapter", input.getPermClassId(), status);
            if (status == OperationStatus.ADDNEW && LongUtil.isvalidLong((Object)input.getOldChapterId())) {
                DisclosureCopyHelper.copyChapter(input.getOldChapterId(), chapterId);
            }
            DisclosureLogHelper.writeChapteRepository(OperationResult.SUCCESS, status == OperationStatus.ADDNEW ? OperationName.CREATE : OperationName.EDIT, modelInfo, chapter);
        }
        catch (Exception ex) {
            DisclosureLogHelper.writeChapteRepository(OperationResult.FAILURE, status == OperationStatus.ADDNEW ? OperationName.CREATE : OperationName.EDIT, modelInfo, chapter);
            throw ex;
        }
        return ResultInfo.success(chapterId);
    }

    public static ResultInfo saveAsRepositoryByEPM(ChapterSaveInput input) {
        if (!ChapterServiceHelper.hasWritePermissionForTempalte(input.getDmModelId(), input.getChapterId())) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterServiceHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ResultInfo checkResult = ChapterRepositoryHelper.saveCheck(input);
        if (Boolean.FALSE.equals(checkResult.isSuccess())) {
            return checkResult;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)input.getDmModelId()));
        qFilters.add(new QFilter("id", "=", (Object)input.getChapterId()));
        DynamicObject oldChapter = BusinessDataServiceHelper.loadSingle((String)"fidm_chapter", (QFilter[])qFilters.toArray(new QFilter[0]));
        Date now = TimeServiceHelper.now();
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject newChapter = EpmChapterServiceHelper.copyChapter(oldChapter, userId, now);
        newChapter.set("template", (Object)0L);
        newChapter.set("number", (Object)input.getNumber());
        newChapter.set("name", input.getName());
        newChapter.set("group", (Object)input.getCatalogId());
        newChapter.set("permclass", (Object)input.getPermClassId());
        newChapter.set("description", input.getDescription());
        newChapter.set("sequence", (Object)ChapterRepositoryHelper.getMaxDesq(input.getDmModelId(), input.getCatalogId()));
        newChapter.set("status", (Object)StatusEnum.Checked);
        long newChapterId = newChapter.getLong("id");
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)userId);
        List<DynamicObject> saveNewModules = EpmModuleServiceHelper.copyModules(input.getDmModelId(), oldChapter, newChapter, null);
        ChapterRepositoryHelper.CopyChapterFile(input.getDmModelId(), oldChapter, newChapter);
        PlatUtil.executeWithTXNew(tx -> {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newChapter});
            CloneUtils cloneUtils = new CloneUtils(true, true);
            DisclosureCopyHelper.copyVariable(cloneUtils, input.getChapterId(), newChapterId, user, now);
            DisclosureCopyHelper.copyDataSet(cloneUtils, input.getChapterId(), newChapterId, user, now);
            if (!saveNewModules.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])saveNewModules.toArray(new DynamicObject[0]));
            }
            PermissionHelper.savePermClassEntity(input.getDmModelId(), newChapterId, "fidm_chapter", newChapter.getLong("permclass"), OperationStatus.ADDNEW);
        });
        return ResultInfo.success(newChapterId);
    }

    private static ResultInfo saveCheck(ChapterSaveInput input) {
        ResultInfo wordNameRes;
        if (input == null || !LongUtil.isvalidLong((Object)input.getDmModelId())) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!", (String)"DisclosureCommon_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)input.getNumber())) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DisclosureCommon_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (input.getName() == null || StringUtils.isEmpty((String)input.getName().toString())) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DisclosureCommon_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (!LongUtil.isvalidLong((Object)input.getCatalogId())) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ae0\u8282\u5206\u7c7b\u3002", (String)"ChapterRepositoryHelper_7", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ResultInfo resultInfo = FarNumberRule.checkChapterNumber(input.getNumber());
        if (Boolean.FALSE.equals(resultInfo.isSuccess())) {
            return resultInfo;
        }
        if (input.getName() != null && Boolean.FALSE.equals((wordNameRes = FarNumberRule.checkWordName(input.getName().toString())).isSuccess())) {
            return wordNameRes;
        }
        List<Long> existIds = ChapterRepositoryHelper.getChapterByNumber(input.getDmModelId(), input.getNumber());
        if (!existIds.isEmpty() && !existIds.contains(input.getChapterId())) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"DisclosureCommon_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (input.getNumber() != null && input.getNumber().length() > 30) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u7ae0\u8282\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u3002", (String)"ChapterServiceHelper_18", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (input.getName() != null && input.getName().toString().length() > 50) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u7ae0\u8282\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"ChapterServiceHelper_19", (String)"epm-far-business", (Object[])new Object[0]));
        }
        try {
            if (input.getDescription() != null && input.getDescription().toString().length() > 200) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u7ae0\u8282\u63cf\u8ff0\u8bf4\u660e\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7200\u3002", (String)"ChapterServiceHelper_22", (String)"epm-far-business", (Object[])new Object[0]));
            }
        }
        catch (Exception ex) {
            log.error("fimd saveCheck failed", (Throwable)ex);
        }
        return ResultInfo.success();
    }

    public static ResultInfo deleteChapter(long modelId, long chapterId) {
        if (!ChapterRepositoryHelper.hasWritePermission(modelId, chapterId, 0L)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterRepositoryHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        if (chapter == null) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ChapterRepositoryHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObject chapterDy = DisclosureChapterHelper.getChapter(chapterId);
        Long groupId = chapterDy.getLong("group");
        if (!LongUtil.isvalidLong((Object)groupId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ChapterRepositoryHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (EnableEnum.Enable.toString().equals(chapter.getString("enable"))) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ChapterRepositoryHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection chapterModules = chapter.getDynamicObjectCollection("entryentity");
        List moduleIds = chapterModules.stream().map(m -> m.getLong("module.id")).collect(Collectors.toList());
        PlatUtil.executeWithTXNew(tx -> {
            QFilter filter = new QFilter("id", "=", (Object)chapterId).and("model", "=", (Object)modelId);
            DeleteServiceHelper.delete((String)"fidm_chapter", (QFilter[])new QFilter[]{filter});
            PermissionHelper.savePermClassEntity(modelId, chapterId, "fidm_chapter", 0L, OperationStatus.EDIT);
            filter = new QFilter("chapterid", "=", (Object)chapterId).and("model", "=", (Object)modelId);
            BusinessDataWriter.delete((String)"fidm_disc_variable", (QFilter[])new QFilter[]{filter});
            DatasetServiceHelper.deleteDataSetByChapter(chapterId);
            if (!moduleIds.isEmpty()) {
                filter = new QFilter("id", "in", (Object)moduleIds).and("model", "=", (Object)modelId);
                DeleteServiceHelper.delete((String)"fidm_modulerepository", (QFilter[])new QFilter[]{filter});
            }
        });
        return ResultInfo.success();
    }

    public static ResultInfo setEnableStatus(long modelId, long chapterId, boolean enable) {
        if (!ChapterRepositoryHelper.hasWritePermission(modelId, chapterId, 0L)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterRepositoryHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        if (chapter == null) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ChapterRepositoryHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String enableStatus = chapter.getString("enable");
        if (enable && "1".equals(enableStatus)) {
            return ResultInfo.success(chapterId);
        }
        if (!enable && "0".equals(enableStatus)) {
            return ResultInfo.success(chapterId);
        }
        chapter.set("enable", (Object)(enable ? "1" : "0"));
        chapter.set("modifier", (Object)RequestContext.get().getCurrUserId());
        chapter.set("modifytime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
        return ResultInfo.success(chapterId);
    }

    private static List<Long> getChapterByNumber(Long dmModelId, String number) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)dmModelId));
        qFilters.add(new QFilter("group", ">", (Object)0));
        qFilters.add(new QFilter("number", "=", (Object)number));
        DynamicObjectCollection list = QueryServiceHelper.query((String)"fidm_chapter", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        return list.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
    }

    private static int getMaxDesq(long modelId, long catalogId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("template", "=", (Object)0L));
        qFilters.add(new QFilter("group", "=", (Object)catalogId));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_chapter", (String)"sequence", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"sequence desc", (int)1);
        if (dys != null && !dys.isEmpty()) {
            return ((DynamicObject)dys.get(0)).getInt("sequence") + 1;
        }
        return 1;
    }

    public static String getChapterPreviewFile(long modelId, long chapterId, String saveWordType, Map<String, Long> dimMembers, boolean randFileName) {
        if (OpenWordEnum.EPMCLIENT.getType().equals(saveWordType) || dimMembers == null) {
            return StringUtils.getEmpty();
        }
        String userName = RequestContext.get().getUserName();
        String urlPrefix = RequestContext.get().getClientFullContextPath();
        HashMap<String, DimMemberInfo> memberMap = new HashMap<String, DimMemberInfo>(dimMembers.size());
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        List<DimensionInfo> dimensions = modelStrategyEx.getDim().getDimList();
        for (Map.Entry<String, Long> dimMember : dimMembers.entrySet()) {
            DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(dimensions, dimMember.getKey());
            DimMemberInfo member = modelStrategyEx.getDimMember().findMemberById(dimensionInfo.getEntityName(), dimMember.getValue());
            memberMap.put(dimMember.getKey(), member);
        }
        ChapterPreviewResult result = DisclosurePreviewService.chapterRepositoryPreview(modelId, chapterId, memberMap, userName, randFileName, urlPrefix, OpenWordEnum.WPSPLUGIN.getType(), null);
        return result.getPreviewUrl();
    }

    private static void CopyChapterFile(long modelId, DynamicObject oldChapter, DynamicObject newChapter) {
        block30: {
            long oldChapterId = oldChapter.getLong("id");
            long newChapterId = newChapter.getLong("id");
            if (OpenWordEnum.EPMCLIENT.getType().equals(oldChapter.getString("savewordtype"))) {
                try (InputStream inputStream = DisclosureFileHelper.getFileInputStream(oldChapter.getString("url"), false);){
                    String url = DisclosureFileHelper.saveAsNew(inputStream, "fidm", "fidm_chapterepositorylist", newChapterId, newChapter.getString("name"));
                    newChapter.set("url", (Object)url);
                    break block30;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ResManager.loadKDString((String)"\u52a0\u8f7d\u6587\u4ef6\u5931\u8d25\u3002", (String)"ReportGenerateService_0", (String)"epm-far-business", (Object[])new Object[0]), ex);
                }
            }
            Map<String, Long> dimMembers = EpmChapterServiceHelper.getChapterDefaultDimMembers(modelId, oldChapterId);
            String url = ChapterRepositoryHelper.getChapterPreviewFile(modelId, oldChapterId, oldChapter.getString("savewordtype"), dimMembers, true);
            if (StringUtils.isNotEmpty((String)url)) {
                try (InputStream inputStream = DisclosureFileHelper.getFileInputStream(url, true);){
                    url = DisclosureFileHelper.saveAsNew(inputStream, "fidm", "fidm_chapterepositorylist", newChapterId, newChapter.getString("name"));
                    newChapter.set("url", (Object)url);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ResManager.loadKDString((String)"\u52a0\u8f7d\u6587\u4ef6\u5931\u8d25\u3002", (String)"ReportGenerateService_0", (String)"epm-far-business", (Object[])new Object[0]), ex);
                }
            }
        }
    }

    public static boolean hasWritePermission(long modelId, long chapterId, long catalogId) {
        if (chapterId <= 0L) {
            return ChapterCatalogHelper.hasWritePermission(modelId, catalogId);
        }
        DynamicObject chapter = BusinessDataServiceHelper.loadSingleFromCache((Object)chapterId, (String)"fidm_chapter");
        if (chapter != null) {
            boolean result = PermissionHelper.hasWritePerm(modelId, "fidm_chapter", chapterId);
            if (result) {
                result = ChapterCatalogHelper.hasWritePermission(modelId, chapter.getLong("group_id"));
            }
            return result;
        }
        return false;
    }
}

