/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.chapter;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.EnableEnum;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.ChapterComeFromEnum;
import kd.epm.far.business.common.enums.ChapterCommitStatusEnum;
import kd.epm.far.business.common.enums.MyReportStatusEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.util.FarNumberRule;
import kd.epm.far.business.common.util.PlatUtil;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.epmclient.EpmChapterServiceHelper;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.chapter.dto.Chapter;
import kd.epm.far.business.fidm.chapter.dto.ChapterModule;
import kd.epm.far.business.fidm.chapter.dto.ChapterSimple;
import kd.epm.far.business.fidm.design.DisclosurePreviewService;
import kd.epm.far.business.fidm.design.dto.ChapterPreviewResult;
import kd.epm.far.business.fidm.design.preview.DisclosurePreviewHelper;
import kd.epm.far.business.fidm.report.DisclosureReportHelper;
import kd.epm.far.business.fidm.template.DisclosureTemplateHelper;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class ChapterServiceHelper {
    private static final Log log = LogFactory.getLog(ChapterServiceHelper.class);
    public static final String ENABLE = "1";
    public static final String DISABLE = "0";
    private static final String FIELD_MODEL = "model";
    private static final String FIELD_SEQUENCE = "sequence";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_TEMPLATE_ID = "template.id";
    private static final String FIELD_CHAPTER_ID = "chapter.id";
    private static final String FIELD_ENTRYENTITY = "entryentity";
    private static final String FIELD_ENABLE = "enable";
    private static final String FIELD_COMMITSTATUS = "commitstatus";
    private static final String FIELD_ISCHECK = "ischeck";
    private static final String FIELD_PERMCLASS = "permclass";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_PREVIEWURL = "previewurl";
    private static final String FIELD_MODIFYTIME = "modifytime";
    private static final String FIELD_MODIFIER = "modifier";
    private static final String FIELD_TEMPLATE = "template";
    private static final String FIELD_CHAPTER = "chapter";
    private static final String FIELD_URL = "url";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_GROUP = "group";
    private static final String FIELD_CREATOR = "creator";
    private static final String FIELD_CREATETIME = "createtime";
    private static final String FIELD_MASTERID = "masterid";

    public static Chapter getChapter(long modelId, long chapterId, long reportId, Map<String, Long> dimMembers) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter("id", "=", (Object)chapterId));
        DynamicObject chapterRow = BusinessDataServiceHelper.loadSingle((String)"fidm_chapter", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (chapterRow == null) {
            return null;
        }
        DynamicObject reportChapter = null;
        if (reportId > 0L) {
            ArrayList<QFilter> qFiltersReport = new ArrayList<QFilter>(6);
            qFiltersReport.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
            qFiltersReport.add(new QFilter("ispreview", "=", (Object)DISABLE));
            qFiltersReport.add(new QFilter("id", "=", (Object)reportId));
            reportChapter = BusinessDataServiceHelper.loadSingle((String)"fidm_report", (QFilter[])qFiltersReport.toArray(new QFilter[0]));
        }
        Chapter chapter = new Chapter();
        chapter.setId(chapterRow.getLong("id"));
        chapter.setNumber(chapterRow.getString(FIELD_NUMBER));
        chapter.setName(chapterRow.getString("name"));
        chapter.setDseq(chapterRow.getInt(FIELD_SEQUENCE));
        chapter.setTemplateId(chapterRow.getLong(FIELD_TEMPLATE_ID));
        chapter.setReportId(reportId);
        if (reportChapter != null) {
            chapter.setTemplateId(reportChapter.getLong(FIELD_TEMPLATE_ID));
            DynamicObjectCollection entries = reportChapter.getDynamicObjectCollection(FIELD_ENTRYENTITY);
            for (Object entry : entries) {
                if (entry.getLong(FIELD_CHAPTER_ID) != chapterId) continue;
                chapter.setIsCheck(entry.getBoolean(FIELD_ISCHECK));
                break;
            }
        }
        chapter.setEnable(chapterRow.getBoolean(FIELD_ENABLE));
        chapter.setCommitStatus(chapterRow.getString(FIELD_COMMITSTATUS));
        chapter.setPermClassId(chapterRow.getLong("permclass_id"));
        if (chapter.getPermClassId() > 0L) {
            chapter.setPermClassNumber(PermissionHelper.getPermClassNumber(modelId, chapter.getPermClassId()));
        }
        chapter.setCatalogId(chapterRow.getLong("group_id"));
        chapter.setDescription(chapterRow.getString(FIELD_DESCRIPTION));
        chapter.setUrl(chapterRow.getString(FIELD_URL));
        chapter.setPreviewUrl(chapterRow.getString(FIELD_PREVIEWURL));
        chapter.setSaveWordType(chapterRow.getString("savewordtype"));
        if (StringUtils.isNotEmpty((String)chapterRow.getString(FIELD_URL))) {
            chapter.setFullUrl(UrlService.getAttachmentFullUrl((String)chapterRow.getString(FIELD_URL)));
        }
        if (StringUtils.isNotEmpty((String)chapterRow.getString(FIELD_PREVIEWURL))) {
            chapter.setPreviewFullUrl(UrlService.getAttachmentFullUrl((String)chapterRow.getString(FIELD_PREVIEWURL)));
        }
        chapter.setCreator(chapterRow.getString("creator.name"));
        chapter.setCreateTime(chapterRow.getDate(FIELD_CREATETIME));
        chapter.setModifier(chapterRow.getString("modifier.name"));
        chapter.setModifyTime(chapterRow.getDate(FIELD_MODIFYTIME));
        chapter.setCommitor(chapterRow.getString("commitor.name"));
        chapter.setCommitTime(chapterRow.getDate("committime"));
        chapter.setSendBacker(chapterRow.getString("sendbacker.name"));
        chapter.setSendBackTime(chapterRow.getDate("sendbacktime"));
        DynamicObjectCollection dyModules = chapterRow.getDynamicObjectCollection(FIELD_ENTRYENTITY);
        ArrayList<ChapterModule> modules = new ArrayList<ChapterModule>(dyModules.size());
        for (DynamicObject dyModule : dyModules) {
            ChapterModule module = new ChapterModule();
            module.setId(dyModule.getLong("id"));
            module.setModuleId(dyModule.getLong("module_id"));
            module.setKey(dyModule.getString("key"));
            module.setDseq(dyModule.getInt("seq"));
            modules.add(module);
        }
        chapter.setModules(modules);
        if (reportId == 0L) {
            List<JSONObject> moduleList = DisclosurePreviewHelper.getModuleList(modelId, chapterRow);
            String url = ChapterServiceHelper.getChapterPreviewFile(modelId, chapter.getTemplateId(), chapter.getId(), moduleList, chapter.getSaveWordType(), dimMembers, true);
            if (StringUtils.isNotEmpty((String)url)) {
                chapter.setFullUrl(url);
            }
        }
        return chapter;
    }

    public static ResultInfo saveChapterInfo(long modelId, long templateId, long reportId, long chapterId, String number, String name, long permClassId, String description, boolean isAutoNumberName) {
        DynamicObject chapter;
        if (templateId == 0L && reportId == 0L) {
            return ResultInfo.fail("");
        }
        long userId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        if (reportId == 0L) {
            String message;
            if (!DisclosureTemplateHelper.hasWritePermission(modelId, templateId)) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u6a21\u677f\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"DisclosureTemplateHelper_31", (String)"epm-far-business", (Object[])new Object[0]));
            }
            if (isAutoNumberName) {
                Pair<String, String> numberName = EpmChapterServiceHelper.getDefaultChapterNumberName(modelId, templateId);
                if (StringUtils.isEmpty((String)number)) {
                    number = (String)numberName.p1;
                }
                if (StringUtils.isEmpty((String)name)) {
                    name = (String)numberName.p2;
                }
            }
            if (StringUtils.isNotEmpty((String)(message = ChapterServiceHelper.saveCheck(modelId, templateId, chapterId, number, name, description)))) {
                return ResultInfo.fail(message);
            }
            ResultInfo result = ChapterServiceHelper.checkChapterForTemplate(modelId, templateId, chapterId, chapterId == 0L, false);
            if (Boolean.FALSE.equals(result.isSuccess())) {
                return result;
            }
            if (chapterId == 0L) {
                chapterId = GlobalIdUtil.genGlobalLongId();
                chapter = BusinessDataServiceHelper.newDynamicObject((String)"fidm_chapter");
                chapter.set("id", (Object)chapterId);
                chapter.set(FIELD_MASTERID, (Object)chapterId);
                chapter.set(FIELD_NUMBER, (Object)number);
                chapter.set(FIELD_STATUS, (Object)StatusEnum.TempSave);
                chapter.set(FIELD_ENABLE, (Object)EnableEnum.Enable);
                chapter.set(FIELD_COMMITSTATUS, (Object)ChapterCommitStatusEnum.INIT.getType());
                chapter.set(FIELD_MODEL, (Object)modelId);
                chapter.set(FIELD_TEMPLATE, (Object)templateId);
                chapter.set(FIELD_SEQUENCE, (Object)ChapterServiceHelper.getMaxDesq(modelId, templateId));
                chapter.set(FIELD_CREATOR, (Object)userId);
                chapter.set(FIELD_CREATETIME, (Object)now);
                chapter.set("savewordtype", (Object)OpenWordEnum.EPMCLIENT.getType());
                chapter.set("comefrom", (Object)ChapterComeFromEnum.EPMC.getType());
            } else {
                if (!ChapterServiceHelper.hasWritePermissionForTempalte(modelId, chapterId)) {
                    return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterServiceHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
                }
                chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
                if (ChapterCommitStatusEnum.COMMIT.getType().equals(chapter.getString(FIELD_COMMITSTATUS))) {
                    return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u63d0\u4ea4\uff0c\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"ChapterServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
                }
            }
        } else {
            if (!ChapterServiceHelper.hasWritePermissionForReport(modelId, chapterId, reportId)) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterServiceHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)name)) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u7ae0\u8282\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChapterServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
            }
            ResultInfo result = ChapterServiceHelper.checkChapterForReport(modelId, reportId, chapterId, true);
            if (Boolean.FALSE.equals(result.isSuccess())) {
                return result;
            }
            chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        }
        chapter.set("name", (Object)name);
        chapter.set(FIELD_DESCRIPTION, (Object)description);
        chapter.set(FIELD_PERMCLASS, (Object)permClassId);
        chapter.set(FIELD_MODIFIER, (Object)userId);
        chapter.set(FIELD_MODIFYTIME, (Object)now);
        long finalChapterId = chapterId;
        PlatUtil.executeWithTXNew(tx -> {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
            PermissionHelper.savePermClassEntity(modelId, finalChapterId, "fidm_chapter", permClassId, OperationStatus.EDIT);
        });
        return ResultInfo.success(chapterId);
    }

    public static ResultInfo saveChapterDocument(long modelId, long templateId, long reportId, long chapterId, String modules, String docBytes) {
        if (templateId == 0L && reportId == 0L || StringUtils.isEmpty((String)docBytes)) {
            return ResultInfo.fail("");
        }
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        if (templateId > 0L) {
            if (!ChapterServiceHelper.hasWritePermissionForTempalte(modelId, chapterId)) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterServiceHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
            }
            ResultInfo result = ChapterServiceHelper.checkChapterForTemplate(modelId, templateId, chapterId, chapterId == 0L, false);
            if (Boolean.FALSE.equals(result.isSuccess())) {
                return result;
            }
            if (ChapterCommitStatusEnum.COMMIT.getType().equals(chapter.getString(FIELD_COMMITSTATUS))) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u63d0\u4ea4\uff0c\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"ChapterServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
            }
            EpmChapterServiceHelper.saveTemplateChapterDoc(modelId, templateId, chapter, modules, docBytes);
        } else {
            if (!ChapterServiceHelper.hasWritePermissionForReport(modelId, chapterId, reportId)) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterServiceHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
            }
            ResultInfo result = ChapterServiceHelper.checkChapterForReport(modelId, reportId, chapterId, true);
            if (Boolean.FALSE.equals(result.isSuccess())) {
                return result;
            }
            String docName = chapter.getString("name") + "preview";
            String url = DisclosureFileHelper.upload("fidm_webpreview", chapterId, docName, docBytes);
            chapter.set(FIELD_PREVIEWURL, (Object)url);
            chapter.set(FIELD_MODIFIER, (Object)RequestContext.get().getCurrUserId());
            chapter.set(FIELD_MODIFYTIME, (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
        }
        return ResultInfo.success(chapterId);
    }

    public static ResultInfo setChapterCheck(long modelId, long reportId, long chapterId, boolean isCheck) {
        if (!ChapterServiceHelper.hasWritePermissionForReport(modelId, chapterId, reportId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterServiceHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ResultInfo result = ChapterServiceHelper.checkChapterForReport(modelId, reportId, chapterId, false);
        if (Boolean.FALSE.equals(result.isSuccess())) {
            return result;
        }
        PlatUtil.executeWithTXNew(tx -> {
            DynamicObject report = (DynamicObject)result.getData();
            DynamicObjectCollection entries = report.getDynamicObjectCollection(FIELD_ENTRYENTITY);
            for (DynamicObject entry : entries) {
                if (entry.getLong(FIELD_CHAPTER_ID) != chapterId) continue;
                entry.set(FIELD_ISCHECK, (Object)(isCheck ? ENABLE : DISABLE));
                DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
                chapter.set(FIELD_MODIFIER, (Object)RequestContext.get().getCurrUserId());
                chapter.set(FIELD_MODIFYTIME, (Object)TimeServiceHelper.now());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{report});
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
                break;
            }
        });
        return ResultInfo.success(chapterId);
    }

    public static ResultInfo moveChapter(long modelId, long templateId, long chapterId, int type) {
        long moveId;
        DynamicObject[] dys;
        if (!DisclosureTemplateHelper.hasWritePermission(modelId, templateId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u6a21\u677f\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"DisclosureTemplateHelper_31", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ResultInfo result = ChapterServiceHelper.checkChapterForTemplate(modelId, templateId, chapterId, false, false);
        if (Boolean.FALSE.equals(result.isSuccess())) {
            return result;
        }
        DynamicObject dyCurrent = (DynamicObject)result.getData();
        int seq = dyCurrent.getInt(FIELD_SEQUENCE);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter(FIELD_TEMPLATE, "=", (Object)templateId));
        qFilters.add(PermissionHelper.getReadAndWritePermFilter(modelId, "fidm_chapter"));
        if (type == 1) {
            qFilters.add(new QFilter(FIELD_SEQUENCE, "<", (Object)seq));
            dys = BusinessDataServiceHelper.load((String)"fidm_chapter", (String)"id,sequence", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"sequence desc", (int)1);
            if (dys == null || dys.length == 0) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u662f\u7b2c\u4e00\u4e2a\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"ChapterServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
            }
            moveId = dys[0].getLong("id");
        } else {
            qFilters.add(new QFilter(FIELD_SEQUENCE, ">", (Object)seq));
            dys = BusinessDataServiceHelper.load((String)"fidm_chapter", (String)"id,sequence", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"sequence asc", (int)1);
            if (dys == null || dys.length == 0) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u662f\u6700\u540e\u4e00\u4e2a\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"ChapterServiceHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
            }
            moveId = dys[0].getLong("id");
        }
        DynamicObject dyMove = BusinessDataReader.loadSingle((Object)moveId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fidm_chapter"));
        if (dyMove != null) {
            dyCurrent.set(FIELD_SEQUENCE, (Object)dyMove.getInt(FIELD_SEQUENCE));
            dyMove.set(FIELD_SEQUENCE, (Object)seq);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyCurrent, dyMove});
        }
        return ResultInfo.success(moveId);
    }

    public static ResultInfo deleteChapter(long modelId, long templateId, long chapterId) {
        if (!ChapterServiceHelper.hasWritePermissionForTempalte(modelId, chapterId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterServiceHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ResultInfo result = ChapterServiceHelper.checkChapterForTemplate(modelId, templateId, chapterId, false, true);
        if (Boolean.FALSE.equals(result.isSuccess())) {
            return result;
        }
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        DynamicObjectCollection chapterModules = chapter.getDynamicObjectCollection(FIELD_ENTRYENTITY);
        List moduleIds = chapterModules.stream().map(m -> m.getLong("module.id")).collect(Collectors.toList());
        PlatUtil.executeWithTXNew(tx -> {
            QFilter filter = new QFilter("id", "=", (Object)chapterId).and(FIELD_MODEL, "=", (Object)modelId);
            DeleteServiceHelper.delete((String)"fidm_chapter", (QFilter[])new QFilter[]{filter});
            PermissionHelper.savePermClassEntity(modelId, chapterId, "fidm_chapter", 0L, OperationStatus.EDIT);
            filter = new QFilter("chapterid", "=", (Object)chapterId).and(FIELD_MODEL, "=", (Object)modelId);
            BusinessDataWriter.delete((String)"fidm_disc_variable", (QFilter[])new QFilter[]{filter});
            DatasetServiceHelper.deleteDataSetByChapter(chapterId);
            if (!moduleIds.isEmpty()) {
                filter = new QFilter("id", "in", (Object)moduleIds).and(FIELD_MODEL, "=", (Object)modelId);
                DeleteServiceHelper.delete((String)"fidm_modulerepository", (QFilter[])new QFilter[]{filter});
            }
        });
        return ResultInfo.success(chapterId);
    }

    public static ResultInfo setCommitStatus(long modelId, long templateId, long chapterId, String status) {
        if (!ChapterServiceHelper.hasWritePermissionForTempalte(modelId, chapterId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterServiceHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ResultInfo result = ChapterServiceHelper.checkChapterForTemplate(modelId, templateId, chapterId, false, false);
        if (Boolean.FALSE.equals(result.isSuccess())) {
            return result;
        }
        DynamicObject chapter = (DynamicObject)result.getData();
        String commitStatus = chapter.getString(FIELD_COMMITSTATUS);
        if (ChapterCommitStatusEnum.COMMIT.getType().equals(status) && ChapterCommitStatusEnum.COMMIT.getType().equals(commitStatus)) {
            return ResultInfo.success(chapterId);
        }
        if (ChapterCommitStatusEnum.SENDBACK.getType().equals(status) && ChapterCommitStatusEnum.INIT.getType().equals(commitStatus)) {
            return ResultInfo.success(chapterId);
        }
        if (ChapterCommitStatusEnum.SENDBACK.getType().equals(status) && ChapterCommitStatusEnum.SENDBACK.getType().equals(commitStatus)) {
            return ResultInfo.success(chapterId);
        }
        chapter.set(FIELD_COMMITSTATUS, (Object)status);
        if (ChapterCommitStatusEnum.COMMIT.getType().equals(status)) {
            chapter.set("commitor", (Object)RequestContext.get().getCurrUserId());
            chapter.set("committime", (Object)TimeServiceHelper.now());
        } else {
            chapter.set("sendbacker", (Object)RequestContext.get().getCurrUserId());
            chapter.set("sendbacktime", (Object)TimeServiceHelper.now());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
        return ResultInfo.success(chapterId);
    }

    public static ResultInfo setEnableStatus(long modelId, long templateId, long chapterId, String status) {
        if (!ChapterServiceHelper.hasWritePermissionForTempalte(modelId, chapterId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterServiceHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ResultInfo result = ChapterServiceHelper.checkChapterForTemplate(modelId, templateId, chapterId, false, false);
        if (Boolean.FALSE.equals(result.isSuccess())) {
            return result;
        }
        DynamicObject chapter = (DynamicObject)result.getData();
        String enableStatus = chapter.getString(FIELD_ENABLE);
        if (ENABLE.equals(status) && ENABLE.equals(enableStatus)) {
            return ResultInfo.success(chapterId);
        }
        if (DISABLE.equals(status) && DISABLE.equals(enableStatus)) {
            return ResultInfo.success(chapterId);
        }
        chapter.set(FIELD_ENABLE, (Object)status);
        chapter.set(FIELD_MODIFIER, (Object)RequestContext.get().getCurrUserId());
        chapter.set(FIELD_MODIFYTIME, (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
        return ResultInfo.success(chapterId);
    }

    public static List<ChapterSimple> getChaptersByReport(long modelId, List<Long> reportIds) {
        ArrayList<ChapterSimple> chapters = new ArrayList<ChapterSimple>(6);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter("ispreview", "=", (Object)DISABLE));
        qFilters.add(new QFilter("id", "in", reportIds));
        QFilter permFilter = PermissionHelper.getReadAndWritePermFilter(modelId, "fidm_report");
        qFilters.add(permFilter);
        Map reportDatas = BusinessDataServiceHelper.loadFromCache((String)"fidm_report", (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayListMultimap<String, Long> chapterPerm = PermClassEntityHelper.getFIDMPermissionMap("fidm_chapter", modelId, RequestContext.get().getCurrUserId());
        for (DynamicObject report : reportDatas.values()) {
            DynamicObjectCollection chapterRows = report.getDynamicObjectCollection(FIELD_ENTRYENTITY);
            for (DynamicObject chapterRow : chapterRows) {
                if (chapterPerm.get((Object)DataTypeEnum.NO.getIndex()).contains(chapterRow.getLong(FIELD_CHAPTER_ID))) continue;
                ChapterSimple chapter = new ChapterSimple();
                chapter.setId(chapterRow.getLong(FIELD_CHAPTER_ID));
                chapter.setIsCheck(chapterRow.getBoolean(FIELD_ISCHECK));
                chapter.setNumber(chapterRow.getDynamicObject(FIELD_CHAPTER).getString(FIELD_NUMBER));
                chapter.setName(chapterRow.getDynamicObject(FIELD_CHAPTER).getString("name"));
                chapter.setDseq(chapterRow.getDynamicObject(FIELD_CHAPTER).getInt(FIELD_SEQUENCE));
                chapter.setReportId(report.getLong("id"));
                chapter.setTemplateId(report.getLong(FIELD_TEMPLATE_ID));
                chapter.setEnable(true);
                chapter.setCommitStatus(ChapterCommitStatusEnum.COMMIT.getType());
                chapter.setSaveWordType(chapterRow.getDynamicObject(FIELD_CHAPTER).getString("savewordtype"));
                if (StringUtils.isNotEmpty((String)chapterRow.getDynamicObject(FIELD_CHAPTER).getString(FIELD_PREVIEWURL))) {
                    chapter.setPreviewFullUrl(UrlService.getAttachmentFullUrl((String)chapterRow.getDynamicObject(FIELD_CHAPTER).getString(FIELD_PREVIEWURL)));
                }
                chapters.add(chapter);
            }
        }
        return chapters;
    }

    public static List<ChapterSimple> getChaptersByTemplate(long modelId, List<Long> templateIds, boolean checkPermission) {
        ArrayList<ChapterSimple> chapters = new ArrayList<ChapterSimple>(6);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter(FIELD_TEMPLATE, "in", templateIds));
        if (checkPermission) {
            QFilter permFilter = PermissionHelper.getReadAndWritePermFilter(modelId, "fidm_chapter");
            qFilters.add(permFilter);
        }
        DynamicObjectCollection chapterRows = QueryServiceHelper.query((String)"fidm_chapter", (String)"id,number,name,sequence,template,enable,commitstatus,savewordtype,url", (QFilter[])qFilters.toArray(new QFilter[0]));
        for (DynamicObject chapterRow : chapterRows) {
            ChapterSimple chapter = new ChapterSimple();
            chapter.setId(chapterRow.getLong("id"));
            chapter.setNumber(chapterRow.getString(FIELD_NUMBER));
            chapter.setName(chapterRow.getString("name"));
            chapter.setDseq(chapterRow.getInt(FIELD_SEQUENCE));
            chapter.setTemplateId(chapterRow.getLong(FIELD_TEMPLATE));
            chapter.setEnable(chapterRow.getBoolean(FIELD_ENABLE));
            chapter.setCommitStatus(chapterRow.getString(FIELD_COMMITSTATUS));
            chapter.setSaveWordType(chapterRow.getString("savewordtype"));
            if (StringUtils.isNotEmpty((String)chapterRow.getString(FIELD_URL))) {
                chapter.setFullUrl(UrlService.getAttachmentFullUrl((String)chapterRow.getString(FIELD_URL)));
            }
            chapters.add(chapter);
        }
        return chapters;
    }

    private static String saveCheck(long modelId, long templateId, long chapterId, String number, String name, String description) {
        if (chapterId == 0L) {
            if (StringUtils.isEmpty((String)number)) {
                return ResManager.loadKDString((String)"\u7ae0\u8282\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChapterServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]);
            }
            if (ChapterServiceHelper.existsChapter(modelId, templateId, number)) {
                return ResManager.loadKDString((String)"\u7ae0\u8282\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"ChapterServiceHelper_6", (String)"epm-far-business", (Object[])new Object[0]);
            }
            ResultInfo resultInfo = FarNumberRule.checkChapterNumber(number);
            if (Boolean.FALSE.equals(resultInfo.isSuccess())) {
                return resultInfo.getMessage();
            }
        }
        if (StringUtils.isEmpty((String)name)) {
            return ResManager.loadKDString((String)"\u7ae0\u8282\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChapterServiceHelper_8", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)number) && number.length() > 30) {
            return ResManager.loadKDString((String)"\u7ae0\u8282\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u3002", (String)"ChapterServiceHelper_18", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)name) && name.length() > 50) {
            return ResManager.loadKDString((String)"\u7ae0\u8282\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"ChapterServiceHelper_19", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)description) && description.length() > 200) {
            return ResManager.loadKDString((String)"\u7ae0\u8282\u63cf\u8ff0\u8bf4\u660e\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7200\u3002", (String)"ChapterServiceHelper_22", (String)"epm-far-business", (Object[])new Object[0]);
        }
        return StringUtils.getEmpty();
    }

    private static ResultInfo checkChapterForReport(long modelId, long reportId, long chapterId, boolean isCheck) {
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        if (report == null) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u62a5\u544a\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ChapterServiceHelper_9", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (MyReportStatusEnum.COMMITED.getValue().equals(report.getString(FIELD_STATUS))) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u62a5\u544a\u5df2\u63d0\u4ea4\uff0c\u4e0d\u53ef\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ChapterServiceHelper_10", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (MyReportStatusEnum.AUDITED.getValue().equals(report.getString(FIELD_STATUS))) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u62a5\u544a\u5df2\u5ba1\u6838\uff0c\u4e0d\u53ef\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ChapterServiceHelper_11", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String reportPerm = PermClassEntityHelper.getSingleFIDMPermission("fidm_report", reportId, modelId, userId, "fidmmodel");
        if (!reportPerm.equals(DataTypeEnum.WRITEIN.getIndex())) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u62a5\u544a\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterServiceHelper_12", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection entries = report.getDynamicObjectCollection(FIELD_ENTRYENTITY);
        List dynamicObjects = entries.stream().filter(v -> v.getLong(FIELD_CHAPTER_ID) == chapterId).collect(Collectors.toList());
        if (dynamicObjects.isEmpty()) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ChapterServiceHelper_13", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (isCheck && ((DynamicObject)dynamicObjects.get(0)).getBoolean(FIELD_ISCHECK)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u62a5\u544a\u7ae0\u8282\u5df2\u9501\u5b9a\u5b9a\u7a3f\uff0c\u4e0d\u53ef\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ChapterServiceHelper_23", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String chapterPerm = PermClassEntityHelper.getSingleFIDMPermission("fidm_chapter", chapterId, modelId, userId, "fidmmodel");
        if (!chapterPerm.equals(DataTypeEnum.WRITEIN.getIndex())) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ChapterServiceHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return ResultInfo.success(report);
    }

    private static ResultInfo checkChapterForTemplate(long modelId, long templateId, long chapterId, boolean isAdd, boolean isDelete) {
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"fidm_template");
        if (template == null) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ChapterServiceHelper_15", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (!isAdd) {
            DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
            if (chapter == null) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ChapterServiceHelper_13", (String)"epm-far-business", (Object[])new Object[0]));
            }
            if (isDelete && chapter.get(FIELD_COMMITSTATUS).toString().equals(ChapterCommitStatusEnum.COMMIT.getType())) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u63d0\u4ea4\uff0c\u9700\u6253\u56de\u624d\u80fd\u5220\u9664\u3002", (String)"ChapterServiceHelper_17", (String)"epm-far-business", (Object[])new Object[0]));
            }
            return ResultInfo.success(chapter);
        }
        return ResultInfo.success();
    }

    private static boolean existsChapter(long modelId, long templateId, String number) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter(FIELD_TEMPLATE, "=", (Object)templateId));
        qFilters.add(new QFilter(FIELD_NUMBER, "=", (Object)number));
        if (templateId == 0L) {
            qFilters.add(new QFilter(FIELD_GROUP, ">", (Object)0));
        }
        return QueryServiceHelper.exists((String)"fidm_chapter", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    private static int getMaxDesq(long modelId, long templateId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter(FIELD_TEMPLATE, "=", (Object)templateId));
        qFilters.add(new QFilter(FIELD_GROUP, "=", (Object)0));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_chapter", (String)FIELD_SEQUENCE, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"sequence desc", (int)1);
        if (dys != null && !dys.isEmpty()) {
            return ((DynamicObject)dys.get(0)).getInt(FIELD_SEQUENCE) + 1;
        }
        return 1;
    }

    public static String getChapterPreviewFile(long modelId, long templateId, long chapterId, List<JSONObject> moduleList, String saveWordType, Map<String, Long> dimMembers, boolean randFileName) {
        if (OpenWordEnum.EPMCLIENT.getType().equals(saveWordType) || templateId == 0L || dimMembers == null) {
            return StringUtils.getEmpty();
        }
        String userName = RequestContext.get().getUserName();
        String urlPrefix = RequestContext.get().getClientFullContextPath();
        HashMap<String, DimMemberInfo> memberMap = new HashMap<String, DimMemberInfo>(dimMembers.size());
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        List<DimensionInfo> dimensions = modelStrategyEx.getDim().getDimList();
        for (Map.Entry<String, Long> dimMember : dimMembers.entrySet()) {
            DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(dimensions, dimMember.getKey());
            DimMemberInfo member = modelStrategyEx.getDimMember().findMemberById(dimensionInfo.getEntityName(), dimMember.getValue());
            memberMap.put(dimMember.getKey(), member);
        }
        ChapterPreviewResult result = DisclosurePreviewService.chapterPreview(modelId, templateId, chapterId, moduleList, memberMap, userName, randFileName, urlPrefix, OpenWordEnum.WPSPLUGIN.getType(), null);
        return result.getPreviewUrl();
    }

    public static boolean hasWritePermissionForTempalte(long modelId, long chapterId) {
        DynamicObject chapter = BusinessDataServiceHelper.loadSingleFromCache((Object)chapterId, (String)"fidm_chapter");
        if (chapter != null) {
            boolean result = PermissionHelper.hasWritePerm(modelId, "fidm_chapter", chapterId);
            if (result) {
                result = DisclosureTemplateHelper.hasWritePermission(modelId, chapter.getLong(FIELD_TEMPLATE_ID));
            }
            return result;
        }
        return false;
    }

    public static boolean hasWritePermissionForReport(long modelId, long chapterId, long reportId) {
        boolean result = PermissionHelper.hasWritePerm(modelId, "fidm_chapter", chapterId);
        if (result || reportId == 0L) {
            result = DisclosureReportHelper.hasWritePermission(modelId, reportId);
        }
        return result;
    }
}

