/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.chapter;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.ChapterCommitStatusEnum;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.design.preview.DisclosurePreviewHelper;
import kd.epm.far.business.fidm.module.DisclosureModuleHelper;
import kd.epm.far.business.fidm.template.DisclosureTemplateHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import org.apache.commons.collections4.CollectionUtils;

public class DisclosureChapterHelper {
    public static final String PARAM_TEMPLATEID = "templateId";
    public static final String PARAM_SAVEWORDTYPE = "savewordtype";
    public static final String ENABLE = "1";
    public static final String DISABLE = "0";
    private static final String MODEL = "model";
    private static final String TEMPLATE = "template";
    private static final String COMMITSTATUS = "commitstatus";
    private static final String GROUP = "group";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ModuleServiceHelper.class);

    public static DynamicObject getChapter(Long chapterId) {
        return DisclosureChapterHelper.getChapter(chapterId, true);
    }

    public static DynamicObject getChapter(Long chapterId, boolean showException) {
        DynamicObject chapterDy = QueryServiceHelper.queryOne((String)"fidm_chapter", (String)"id,number,name,url,previewurl,template.id,template.number,template.name,modifytime,savewordtype,sequence,commitstatus,group", (QFilter[])new QFilter("id", "=", (Object)chapterId).toArray());
        if (showException && chapterDy == null) {
            logger.error("dm chapter id not exist:" + chapterId);
            throw new KDBizException(ResManager.loadKDString((String)"\u7ae0\u8282\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DisclosureServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return chapterDy;
    }

    public static DynamicObject getChapterInfo(Long chapterId) {
        QFilter filter = new QFilter("id", "=", (Object)chapterId);
        return QueryServiceHelper.queryOne((String)"fidm_chapter", (String)"id,number,name,sequence,commitstatus,commitor,committime,url,template", (QFilter[])new QFilter[]{filter});
    }

    public static String getNodeName(int index, String number, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("#").append(index).append(" ").append(number).append(".").append(name);
        return sb.toString();
    }

    public static void openAdd(IFormView view, IFormPlugin plugin, Long modelId, Long templateId, int saveWordType) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fidm_chapter");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        formShowParameter.setCustomParam(PARAM_TEMPLATEID, (Object)templateId);
        formShowParameter.setCustomParam(PARAM_SAVEWORDTYPE, (Object)saveWordType);
        formShowParameter.setParentPageId(view.getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack(plugin, "fidm_chapter"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7ae0\u8282\u65b0\u589e", (String)"DesignChapterHelper_12", (String)"epm-far-business", (Object[])new Object[0]));
        view.showForm(formShowParameter);
    }

    public static void openEdit(IFormView view, IFormPlugin plugin, Long chapterId) {
        if (Objects.isNull(chapterId)) {
            return;
        }
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("fidm_chapter");
        formShowParameter.setPkId((Object)chapterId);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setBillStatus(BillOperationStatus.EDIT);
        formShowParameter.setParentPageId(view.getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack(plugin, "fidm_chapter_edit"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7ae0\u8282\u4fe1\u606f", (String)"DesignChapterHelper_13", (String)"epm-far-business", (Object[])new Object[0]));
        view.showForm((FormShowParameter)formShowParameter);
    }

    public static boolean delete(IFormView view, IFormPlugin plugin, Long dmModelId, Long chapterId) {
        boolean succ;
        if (!DisclosureChapterHelper.checkDelete(view, plugin, chapterId)) {
            return false;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        DynamicObject chapter = DisclosureChapterHelper.getChapter(chapterId);
        DynamicObject template = DisclosureTemplateHelper.getTemplate(chapter.getLong("template.id"));
        try (TXHandle tx = TX.required();){
            try {
                QFilter filter = new QFilter("id", "=", (Object)chapterId);
                DeleteServiceHelper.delete((String)"fidm_chapter", (QFilter[])new QFilter[]{filter});
                filter = new QFilter("chapterid", "=", (Object)chapterId);
                BusinessDataWriter.delete((String)"fidm_disc_variable", (QFilter[])new QFilter[]{filter});
                QFilter permFilter = new QFilter("entityid", "=", (Object)chapterId);
                permFilter.and("fidmmodel", "=", (Object)dmModelId);
                BusinessDataWriter.delete((String)"bcm_permclass_entity", (QFilter[])new QFilter[]{permFilter});
                succ = DatasetServiceHelper.deleteDataSetByChapter(chapterId);
            }
            catch (Exception e) {
                logger.error("deleteChapterInfo fail", (Throwable)e);
                tx.markRollback();
                DisclosureLogHelper.writeTemplateChapter(OperationResult.FAILURE, OperationName.DELETE, modelStrategyEx.getModel().getModelInfo(), template, chapter);
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        DisclosureLogHelper.writeTemplateChapter(OperationResult.SUCCESS, OperationName.DELETE, modelStrategyEx.getModel().getModelInfo(), template, chapter);
        return succ;
    }

    public static boolean checkDelete(IFormView view, IFormPlugin plugin, Long chapterId) {
        if (Objects.isNull(chapterId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u7ae0\u8282\u3002", (String)"DesignChapterHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
            return false;
        }
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        String curCommitStatus = dynObj.getString(COMMITSTATUS);
        if (Objects.equals(ChapterCommitStatusEnum.COMMIT.getType(), curCommitStatus)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u63d0\u4ea4\uff0c\u9700\u6253\u56de\u624d\u80fd\u5220\u9664\u3002", (String)"DesignChapterHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static Boolean commit(IFormView view, Long templateId, Long chapterId) {
        if (Objects.isNull(chapterId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u63d0\u4ea4\u7684\u7ae0\u8282\u3002", (String)"DesignChapterHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return DisclosureChapterHelper.updateCommitStatus(view, templateId, chapterId, "B");
    }

    public static Boolean sendback(IFormView view, Long templateId, Long chapterId) {
        if (Objects.isNull(chapterId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6253\u56de\u7684\u7ae0\u8282\u3002", (String)"DesignChapterHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return DisclosureChapterHelper.updateCommitStatus(view, templateId, chapterId, "C");
    }

    public static boolean updateSequence(Map<String, Integer> chapters) {
        if (chapters == null) {
            return false;
        }
        ArrayList<DynamicObject> chapterDys = new ArrayList<DynamicObject>(chapters.size());
        for (Map.Entry<String, Integer> item : chapters.entrySet()) {
            DynamicObject chapterDy = BusinessDataServiceHelper.loadSingle((Object)LongUtil.toLong((Object)item.getKey()), (String)"fidm_chapter");
            chapterDy.set("sequence", (Object)item.getValue());
            chapterDys.add(chapterDy);
        }
        SaveServiceHelper.save((IDataEntityType)((DynamicObject)chapterDys.get(0)).getDataEntityType(), (Object[])chapterDys.toArray());
        return true;
    }

    public static boolean up(IFormView view, IFormPlugin plugin, Long chapterId) {
        DynamicObject fromObj = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        int fromSeq = fromObj.getInt("sequence");
        if (fromSeq == 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u662f\u7b2c\u4e00\u7ae0\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"DesignChapterHelper_5", (String)"epm-far-business", (Object[])new Object[0]));
            return false;
        }
        Long modelId = Objects.nonNull(fromObj.getDynamicObject(MODEL)) ? fromObj.getDynamicObject(MODEL).getLong("id") : 0L;
        Long templateId = Objects.nonNull(fromObj.getDynamicObject(TEMPLATE)) ? fromObj.getDynamicObject(TEMPLATE).getLong("id") : 0L;
        QFilter filter = new QFilter(MODEL, "=", (Object)modelId);
        filter.and(TEMPLATE, "=", (Object)templateId);
        filter.and("sequence", "<", (Object)fromSeq);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"fidm_chapter", (String)"id,sequence", (QFilter[])new QFilter[]{filter}, (String)"sequence desc", (int)1);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return false;
        }
        DynamicObject toObj = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)list.get(0)).getLong("id"), (String)"fidm_chapter");
        fromObj.set("sequence", (Object)toObj.getInt("sequence"));
        toObj.set("sequence", (Object)fromSeq);
        SaveServiceHelper.save((IDataEntityType)fromObj.getDataEntityType(), (Object[])new Object[]{fromObj, toObj});
        return true;
    }

    public static boolean down(IFormView view, IFormPlugin plugin, Long chapterId) {
        DynamicObject fromObj = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        int fromSeq = fromObj.getInt("sequence");
        Long modelId = Objects.nonNull(fromObj.getDynamicObject(MODEL)) ? fromObj.getDynamicObject(MODEL).getLong("id") : 0L;
        Long templateId = Objects.nonNull(fromObj.getDynamicObject(TEMPLATE)) ? fromObj.getDynamicObject(TEMPLATE).getLong("id") : 0L;
        QFilter filter = new QFilter(MODEL, "=", (Object)modelId);
        filter.and(TEMPLATE, "=", (Object)templateId);
        filter.and("sequence", ">", (Object)fromSeq);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"fidm_chapter", (String)"id,sequence", (QFilter[])new QFilter[]{filter}, (String)"sequence asc", (int)1);
        if (CollectionUtils.isEmpty((Collection)list)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u662f\u6700\u540e\u4e00\u7ae0\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"DesignChapterHelper_6", (String)"epm-far-business", (Object[])new Object[0]));
            return false;
        }
        DynamicObject toObj = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)list.get(0)).getLong("id"), (String)"fidm_chapter");
        fromObj.set("sequence", (Object)toObj.getInt("sequence"));
        toObj.set("sequence", (Object)fromSeq);
        SaveServiceHelper.save((IDataEntityType)fromObj.getDataEntityType(), (Object[])new Object[]{fromObj, toObj});
        return true;
    }

    private static DynamicObject[] drogDown(DynamicObject fromObj, int start, int end, int toSeq) {
        Long modelId = Objects.nonNull(fromObj.getDynamicObject(MODEL)) ? fromObj.getDynamicObject(MODEL).getLong("id") : 0L;
        Long templateId = Objects.nonNull(fromObj.getDynamicObject(TEMPLATE)) ? fromObj.getDynamicObject(TEMPLATE).getLong("id") : 0L;
        QFilter filter = new QFilter(MODEL, "=", (Object)modelId);
        filter.and(TEMPLATE, "=", (Object)templateId);
        filter.and("sequence", ">=", (Object)start);
        filter.and("sequence", "<=", (Object)end);
        DynamicObject[] list = BusinessDataServiceHelper.load((String)"fidm_chapter", (String)"id,name,sequence", (QFilter[])new QFilter[]{filter}, (String)"sequence asc");
        int tempSeq = 0;
        int lastSeq = list[0].getInt("sequence");
        for (DynamicObject dyn : list) {
            if (Objects.equals(fromObj.getLong("id"), dyn.getLong("id"))) {
                dyn.set("sequence", (Object)toSeq);
                continue;
            }
            tempSeq = dyn.getInt("sequence");
            dyn.set("sequence", (Object)lastSeq);
            lastSeq = tempSeq;
        }
        return list;
    }

    private static DynamicObject[] drogUp(DynamicObject fromObj, int start, int end, int toSeq) {
        Long modelId = Objects.nonNull(fromObj.getDynamicObject(MODEL)) ? fromObj.getDynamicObject(MODEL).getLong("id") : 0L;
        Long templateId = Objects.nonNull(fromObj.getDynamicObject(TEMPLATE)) ? fromObj.getDynamicObject(TEMPLATE).getLong("id") : 0L;
        QFilter filter = new QFilter(MODEL, "=", (Object)modelId);
        filter.and(TEMPLATE, "=", (Object)templateId);
        filter.and("sequence", ">", (Object)start);
        filter.and("sequence", "<=", (Object)end);
        DynamicObject[] list = BusinessDataServiceHelper.load((String)"fidm_chapter", (String)"id,name,sequence", (QFilter[])new QFilter[]{filter}, (String)"sequence desc");
        int tempSeq = 0;
        int lastSeq = list[0].getInt("sequence");
        for (DynamicObject dyn : list) {
            if (Objects.equals(fromObj.getLong("id"), dyn.getLong("id"))) {
                dyn.set("sequence", (Object)toSeq);
                continue;
            }
            tempSeq = dyn.getInt("sequence");
            dyn.set("sequence", (Object)lastSeq);
            lastSeq = tempSeq;
        }
        return list;
    }

    private static Boolean updateCommitStatus(IFormView view, Long templateId, Long chapterId, String commitStatus) {
        DynamicObject template = DisclosureTemplateHelper.getTemplate(templateId);
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(template.getLong("model.id"));
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        String curCommitStatus = chapter.getString(COMMITSTATUS);
        if (Objects.equals(ChapterCommitStatusEnum.COMMIT.getType(), commitStatus) && Objects.equals(ChapterCommitStatusEnum.COMMIT.getType(), curCommitStatus)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u518d\u6b21\u63d0\u4ea4\u3002", (String)"DesignChapterHelper_7", (String)"epm-far-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (Objects.equals(ChapterCommitStatusEnum.SENDBACK.getType(), commitStatus) && Objects.equals(ChapterCommitStatusEnum.SENDBACK.getType(), curCommitStatus)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u6253\u56de\uff0c\u4e0d\u80fd\u518d\u6b21\u6253\u56de\u3002", (String)"DesignChapterHelper_8", (String)"epm-far-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (Objects.equals(ChapterCommitStatusEnum.SENDBACK.getType(), commitStatus) && Objects.equals(ChapterCommitStatusEnum.INIT.getType(), curCommitStatus)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u672a\u63d0\u4ea4\uff0c\u65e0\u9700\u6253\u56de\u3002", (String)"DesignChapterHelper_9", (String)"epm-far-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        chapter.set(COMMITSTATUS, (Object)commitStatus);
        if (Objects.equals(ChapterCommitStatusEnum.COMMIT.getType(), commitStatus)) {
            chapter.set("commitor", (Object)RequestContext.get().getCurrUserId());
            chapter.set("committime", (Object)new Date());
        } else {
            chapter.set("sendbacker", (Object)RequestContext.get().getCurrUserId());
            chapter.set("sendbacktime", (Object)new Date());
        }
        OperationName operationName = Objects.equals(ChapterCommitStatusEnum.COMMIT.getType(), commitStatus) ? OperationName.COMMIT : OperationName.BACKED;
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
        }
        catch (Exception ex) {
            DisclosureLogHelper.writeTemplateChapter(OperationResult.FAILURE, operationName, modelStrategyEx.getModel().getModelInfo(), template, chapter);
            throw ex;
        }
        if (Objects.equals(ChapterCommitStatusEnum.COMMIT.getType(), commitStatus)) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"DesignChapterHelper_10", (String)"epm-far-business", (Object[])new Object[0]));
        } else if (Objects.equals(ChapterCommitStatusEnum.SENDBACK.getType(), commitStatus)) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u6253\u56de\u6210\u529f\u3002", (String)"DesignChapterHelper_11", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DisclosureLogHelper.writeTemplateChapter(OperationResult.SUCCESS, operationName, modelStrategyEx.getModel().getModelInfo(), template, chapter);
        return Boolean.TRUE;
    }

    public static void enable(IFormView view, Long templateId, Long chapterId) {
        if (Objects.isNull(chapterId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u542f\u7528\u7684\u7ae0\u8282\u3002", (String)"DesignChapterHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject template = DisclosureTemplateHelper.getTemplate(templateId);
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(template.getLong("model.id"));
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        String curEnable = chapter.getString("enable");
        if (Objects.equals(ENABLE, curEnable)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u542f\u7528\uff0c\u4e0d\u80fd\u518d\u6b21\u542f\u7528\u3002", (String)"DesignChapterHelper_15", (String)"epm-far-business", (Object[])new Object[0]));
            return;
        }
        chapter.set("enable", (Object)ENABLE);
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
        }
        catch (Exception ex) {
            DisclosureLogHelper.writeTemplateChapter(OperationResult.FAILURE, OperationName.ENABLE, modelStrategyEx.getModel().getModelInfo(), template, chapter);
            throw ex;
        }
        DisclosureLogHelper.writeTemplateChapter(OperationResult.SUCCESS, OperationName.ENABLE, modelStrategyEx.getModel().getModelInfo(), template, chapter);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"DesignChapterHelper_16", (String)"epm-far-business", (Object[])new Object[0]));
    }

    public static void disable(IFormView view, Long templateId, Long chapterId) {
        if (Objects.isNull(chapterId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7981\u7528\u7684\u7ae0\u8282\u3002", (String)"DesignChapterHelper_17", (String)"epm-far-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject template = DisclosureTemplateHelper.getTemplate(templateId);
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(template.getLong("model.id"));
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        String curEnable = chapter.getString("enable");
        if (Objects.equals(DISABLE, curEnable)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u518d\u6b21\u7981\u7528\u3002", (String)"DesignChapterHelper_18", (String)"epm-far-business", (Object[])new Object[0]));
            return;
        }
        chapter.set("enable", (Object)DISABLE);
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
        }
        catch (Exception ex) {
            DisclosureLogHelper.writeTemplateChapter(OperationResult.FAILURE, OperationName.DISABLE, modelStrategyEx.getModel().getModelInfo(), template, chapter);
            throw ex;
        }
        DisclosureLogHelper.writeTemplateChapter(OperationResult.SUCCESS, OperationName.DISABLE, modelStrategyEx.getModel().getModelInfo(), template, chapter);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"DesignChapterHelper_19", (String)"epm-far-business", (Object[])new Object[0]));
    }

    public static List<DimensionInfo> getPreviewVars(Long dmModelId, Long chapterId) {
        ArrayList<DimensionInfo> filterDims = new ArrayList<DimensionInfo>(100);
        DynamicObject chapter = DisclosurePreviewHelper.getChapter(chapterId);
        List<JSONObject> modulePropertieList = DisclosurePreviewHelper.getModuleList(dmModelId, chapter);
        for (JSONObject moduleProperties : modulePropertieList) {
            Long datasetId = DisclosureJsonHelper.getValue(moduleProperties, "dataset", "id", 0L);
            if (datasetId != null && datasetId > 0L) {
                DisclosureModuleHelper.previewModuleForDimsAndMembers(dmModelId, datasetId, moduleProperties, filterDims);
            }
            String moduleType = DisclosureJsonHelper.getValue(moduleProperties, "type", "");
            if (!ModuleEnum.REPORT_SECTION.getType().equals(moduleType) && !ModuleEnum.EB_REPORT_SECTION.getType().equals(moduleType)) continue;
            DisclosureModuleHelper.previewModuleByReportSection(dmModelId, moduleProperties, filterDims);
        }
        return filterDims;
    }

    public static DynamicObject getAndCreateChapterCatalogRoot(Long dmModelId) {
        QFilter qFilter = new QFilter(MODEL, "=", (Object)dmModelId);
        qFilter.and("number", "=", (Object)"root");
        DynamicObject dy = QueryServiceHelper.queryOne((String)"fidm_chaptergroup", (String)"id,name,number,level,status,parent,model", (QFilter[])qFilter.toArray());
        if (dy == null) {
            String rootName = ResManager.loadKDString((String)"\u7ae0\u8282\u5206\u7c7b", (String)"ChapterRepoChapterCategory_0", (String)"epm-far-business", (Object[])new Object[0]);
            dy = BusinessDataServiceHelper.newDynamicObject((String)"fidm_chaptergroup");
            dy.set("number", (Object)"root");
            dy.set("name", (Object)rootName);
            dy.set("longnumber", (Object)"root");
            dy.set("level", (Object)0);
            dy.set("isleaf", (Object)Character.valueOf('1'));
            dy.set("sequence", (Object)DISABLE);
            dy.set("catalogtype", (Object)ENABLE);
            Date date = new Date();
            dy.set("createtime", (Object)date.getTime());
            dy.set("modifytime", (Object)date.getTime());
            dy.set("status", (Object)"C");
            dy.set("enable", (Object)ENABLE);
            dy.set("parent", (Object)DISABLE);
            dy.set(MODEL, (Object)dmModelId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
        }
        return dy;
    }
}

