/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.chapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.WordDataType;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.ICopyOperation;
import kd.epm.far.business.fidm.chapter.dto.ChapterModuleCopyResult;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.web.WebHtmlService;
import kd.epm.far.business.fidm.word.WordConvert;
import kd.epm.far.business.fidm.word.dto.IWordOperation;
import kd.epm.far.business.fidm.word.helper.WordBookmarkHelper;
import kd.epm.far.business.fidm.word.helper.WordNodeHelper;
import kd.epm.far.business.fidm.word.helper.WordRepairHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.GlobalIdUtil;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;

public class DisclosureCopyHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosureCopyHelper.class);

    public static void copyChapter(Long oldChapterId, Long newChapterId) {
        DynamicObject oldChapterDy = BusinessDataServiceHelper.loadSingle((Object)oldChapterId, (String)"fidm_chapter");
        if (oldChapterDy == null) {
            return;
        }
        DynamicObject newChapterDy = BusinessDataServiceHelper.loadSingle((Object)newChapterId, (String)"fidm_chapter");
        if (newChapterDy == null) {
            return;
        }
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)RequestContext.get().getCurrUserId());
        Date date = new Date();
        newChapterDy.set("url", (Object)oldChapterDy.getString("url"));
        try (TXHandle tx = TX.required();){
            try {
                DisclosureCopyHelper.copyVariable(cloneUtils, oldChapterId, newChapterId, user, date);
                DisclosureCopyHelper.copyDataSet(cloneUtils, oldChapterId, newChapterId, user, date);
                List<ChapterModuleCopyResult> moduleMap = DisclosureCopyHelper.copyChapterModule(cloneUtils, oldChapterId, newChapterDy, user, date, null);
                DisclosureCopyHelper.copyChapterHtml(oldChapterId, newChapterId, user, date, moduleMap);
                DisclosureCopyHelper.copyChapterFile(oldChapterId, newChapterId, newChapterDy, moduleMap);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newChapterDy});
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("dm copyChapter fail", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public static Long copyVariable(Long oldValId, String newNumber, String newName) {
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)RequestContext.get().getCurrUserId());
        Date date = new Date();
        DynamicObject oldVariable = BusinessDataServiceHelper.loadSingle((Object)oldValId, (String)"fidm_disc_variable");
        DynamicObject newVariable = (DynamicObject)cloneUtils.clone((IDataEntityBase)oldVariable);
        Long newId = GlobalIdUtil.genGlobalLongId();
        newVariable.set("id", (Object)newId);
        newVariable.set("number", (Object)newNumber);
        newVariable.set("name", (Object)newName);
        newVariable.set("chapterid", (Object)0L);
        newVariable.set("creator", (Object)user);
        newVariable.set("createdate", (Object)date);
        newVariable.set("modifier", (Object)user);
        newVariable.set("modifydate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newVariable});
        return newId;
    }

    public static void copyChapterFile(Long oldChapterId, Long newChapterId, DynamicObject newChapter, List<ChapterModuleCopyResult> moduleMap) {
        String docUrl = newChapter.getString("url");
        String docName = newChapter.getString("name");
        if (StringUtils.isEmpty((String)docUrl)) {
            return;
        }
        DynamicObject oldChapter = BusinessDataServiceHelper.loadSingle((Object)oldChapterId, (String)"fidm_chapter");
        DynamicObjectCollection oldChapterModules = oldChapter.getDynamicObjectCollection("entryentity");
        if (oldChapterModules.size() == 0) {
            return;
        }
        try (InputStream inputStream = DisclosureFileHelper.getFileInputStream(docUrl, false);
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String url = "";
            if (moduleMap != null && moduleMap.size() > 0) {
                IWordOperation wordOperation = paragraph -> DisclosureCopyHelper.changeParagraph(paragraph, moduleMap);
                WordConvert convert = new WordConvert();
                NiceXWPFDocument newDoc = convert.changeWordCotnent(inputStream, wordOperation);
                WordRepairHelper.repair(newDoc);
                newDoc.write((OutputStream)outputStream);
                byte[] fileData = outputStream.toByteArray();
                ByteArrayInputStream newFileIns = new ByteArrayInputStream(fileData);
                url = DisclosureFileHelper.saveAsNew(newFileIns, "fidm", "fidm_webpreview", newChapterId, docName);
            } else {
                url = DisclosureFileHelper.saveAsNew(inputStream, "fidm", "fidm_webpreview", newChapterId, docName);
            }
            newChapter.set("url", (Object)url);
        }
        catch (KDBizException e1) {
            throw e1;
        }
        catch (IOException e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u52a0\u8f7d\u6587\u4ef6\u5931\u8d25\u3002", (String)"ReportGenerateService_0", (String)"epm-far-business", (Object[])new Object[0]), e);
        }
    }

    public static void changeParagraph(XWPFParagraph paragraph, List<ChapterModuleCopyResult> moduleMap) {
        String bookStartId;
        if (paragraph == null || moduleMap == null || moduleMap.size() == 0) {
            return;
        }
        for (CTBookmark cTBookmark : paragraph.getCTP().getBookmarkStartArray()) {
            ChapterModuleCopyResult find;
            bookStartId = cTBookmark.getId().toString();
            String bookKey = WordNodeHelper.getNodeValue(cTBookmark.getDomNode(), "w:name");
            if (StringUtils.isEmpty((String)bookStartId) || StringUtils.isEmpty((String)bookKey) || (find = (ChapterModuleCopyResult)moduleMap.stream().filter(m -> bookKey.equalsIgnoreCase(m.getOldBookmarkKey())).findFirst().orElse(null)) == null || StringUtils.isEmpty((String)find.getNewBookmarkKey())) continue;
            BigInteger newBookStartId = BigInteger.valueOf(GlobalIdUtil.genGlobalLongId());
            cTBookmark.setId(newBookStartId);
            cTBookmark.setName(find.getNewBookmarkKey());
            if (!StringUtils.isEmpty((String)find.getOldWordBookmarkId())) continue;
            find.setOldWordBookmarkId(bookStartId);
            find.setNewWordBookmarkId(newBookStartId.toString());
        }
        for (CTBookmark cTBookmark : paragraph.getCTP().getBookmarkEndArray()) {
            ChapterModuleCopyResult find;
            if (cTBookmark == null || StringUtils.isEmpty((String)(bookStartId = String.valueOf(cTBookmark.getId()))) || (find = (ChapterModuleCopyResult)moduleMap.stream().filter(m -> bookStartId.equalsIgnoreCase(m.getOldWordBookmarkId())).findFirst().orElse(null)) == null) continue;
            cTBookmark.setId(BigInteger.valueOf(TypeUtils.convertToLong(find.getNewWordBookmarkId())));
        }
    }

    public static void copyVariable(CloneUtils cloneUtils, long oldChapterId, long newChapterId, DynamicObject user, Date date) {
        DynamicObject[] oldVariables = BusinessDataServiceHelper.load((Object[])QueryServiceHelper.query((String)"fidm_disc_variable", (String)"id", (QFilter[])new QFilter("chapterid", "=", (Object)oldChapterId).toArray()).stream().map(c -> c.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_disc_variable"));
        ArrayList<DynamicObject> newValues = new ArrayList<DynamicObject>(oldVariables.length);
        for (DynamicObject dy : oldVariables) {
            DynamicObject newVariable = (DynamicObject)cloneUtils.clone((IDataEntityBase)dy);
            Long newId = GlobalIdUtil.genGlobalLongId();
            newVariable.set("id", (Object)newId);
            newVariable.set("chapterid", (Object)newChapterId);
            newVariable.set("creator", (Object)user);
            newVariable.set("createdate", (Object)date);
            newVariable.set("modifier", (Object)user);
            newVariable.set("modifydate", (Object)date);
            newValues.add(newVariable);
        }
        SaveServiceHelper.save((DynamicObject[])newValues.toArray(new DynamicObject[0]));
    }

    public static void copyDataSet(CloneUtils cloneUtils, long oldChapterId, long newChapterId, DynamicObject user, Date date) {
        DynamicObject[] oldDataSets = BusinessDataServiceHelper.load((Object[])QueryServiceHelper.query((String)"fidm_dataset", (String)"id", (QFilter[])new QFilter("chapterid", "=", (Object)oldChapterId).toArray()).stream().map(c -> c.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_dataset"));
        HashMap<Long, DynamicObject> oldDataSetId2new = new HashMap<Long, DynamicObject>(oldDataSets.length);
        for (DynamicObject dy : oldDataSets) {
            DynamicObject newDataSet = (DynamicObject)cloneUtils.clone((IDataEntityBase)dy);
            Long newId = GlobalIdUtil.genGlobalLongId();
            newDataSet.set("id", (Object)newId);
            newDataSet.set("chapterid", (Object)newChapterId);
            newDataSet.set("creator", (Object)user);
            newDataSet.set("createtime", (Object)date);
            newDataSet.set("modifier", (Object)user);
            newDataSet.set("modifytime", (Object)date);
            oldDataSetId2new.put(dy.getLong("id"), newDataSet);
        }
        SaveServiceHelper.save((DynamicObject[])oldDataSetId2new.values().toArray(new DynamicObject[0]));
        DynamicObject[] oldDataSetSingles = BusinessDataServiceHelper.load((Object[])QueryServiceHelper.query((String)"fidm_dataset_single", (String)"id", (QFilter[])new QFilter("dataset", "in", oldDataSetId2new.keySet()).toArray()).stream().map(c -> c.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_dataset_single"));
        ArrayList<DynamicObject> newDataSetSingles = new ArrayList<DynamicObject>(oldDataSetSingles.length);
        for (DynamicObject dy : oldDataSetSingles) {
            DynamicObject newDataSetSingle = (DynamicObject)cloneUtils.clone((IDataEntityBase)dy);
            Long newId = GlobalIdUtil.genGlobalLongId();
            newDataSetSingle.set("id", (Object)newId);
            newDataSetSingle.set("dataset", oldDataSetId2new.get(dy.getLong("dataset.id")));
            newDataSetSingles.add(newDataSetSingle);
        }
        SaveServiceHelper.save((DynamicObject[])newDataSetSingles.toArray(new DynamicObject[0]));
        DynamicObject[] oldDataSetVars = BusinessDataServiceHelper.load((Object[])QueryServiceHelper.query((String)"fidm_dataset_variable", (String)"id", (QFilter[])new QFilter("dataset", "in", oldDataSetId2new.keySet()).toArray()).stream().map(c -> c.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_dataset_variable"));
        ArrayList<DynamicObject> newDataSetVars = new ArrayList<DynamicObject>(oldDataSetSingles.length);
        for (DynamicObject dy : oldDataSetVars) {
            DynamicObject newDataSetVar = (DynamicObject)cloneUtils.clone((IDataEntityBase)dy);
            Long newId = GlobalIdUtil.genGlobalLongId();
            newDataSetVar.set("id", (Object)newId);
            newDataSetVar.set("dataset", oldDataSetId2new.get(dy.getLong("dataset.id")));
            newDataSetVars.add(newDataSetVar);
        }
        SaveServiceHelper.save((DynamicObject[])newDataSetVars.toArray(new DynamicObject[0]));
        DynamicObject[] oldDataSetMultivalues = BusinessDataServiceHelper.load((Object[])QueryServiceHelper.query((String)"fidm_dataset_multivalue", (String)"id", (QFilter[])new QFilter("dataset", "in", oldDataSetId2new.keySet()).toArray()).stream().map(c -> c.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_dataset_multivalue"));
        ArrayList<DynamicObject> newDataSetMultivalues = new ArrayList<DynamicObject>(oldDataSetSingles.length);
        for (DynamicObject dy : oldDataSetMultivalues) {
            DynamicObject newDataSetVar = (DynamicObject)cloneUtils.clone((IDataEntityBase)dy);
            Long newId = GlobalIdUtil.genGlobalLongId();
            newDataSetVar.set("id", (Object)newId);
            newDataSetVar.set("dataset", oldDataSetId2new.get(dy.getLong("dataset.id")));
            newDataSetMultivalues.add(newDataSetVar);
        }
        SaveServiceHelper.save((DynamicObject[])newDataSetMultivalues.toArray(new DynamicObject[0]));
    }

    public static List<ChapterModuleCopyResult> copyChapterModule(CloneUtils cloneUtils, long oldChapterId, DynamicObject newChapter, DynamicObject user, Date date, ICopyOperation copyOperation) {
        ArrayList<ChapterModuleCopyResult> moduleMap = new ArrayList<ChapterModuleCopyResult>(100);
        DynamicObject oldChapter = BusinessDataServiceHelper.loadSingle((Object)oldChapterId, (String)"fidm_chapter");
        DynamicObjectCollection oldChapterModules = oldChapter.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection newChapterModules = newChapter.getDynamicObjectCollection("entryentity");
        List moduleIds = oldChapterModules.stream().map(e -> e.getLong("module.id")).filter(e -> !e.equals(0L)).distinct().collect(Collectors.toList());
        if (moduleIds.size() > 0) {
            DynamicObject[] oldModuleList;
            newChapterModules.clear();
            ArrayList<DynamicObject> saveNewModules = new ArrayList<DynamicObject>(10);
            for (DynamicObject oldModule : oldModuleList = BusinessDataServiceHelper.load((Object[])moduleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fidm_modulerepository"))) {
                JSONObject itemObject;
                DynamicObject newModule = (DynamicObject)cloneUtils.clone((IDataEntityBase)oldModule);
                Long newId = GlobalIdUtil.genGlobalLongId();
                String newBookmarkKey = WordBookmarkHelper.createBookmarName(newId);
                String oldBookmarkKey = "";
                DynamicObject oldChapterModule = oldChapterModules.stream().filter(x -> Objects.equals(x.getString("module.id"), oldModule.getString("id"))).findAny().orElse(null);
                if (oldChapterModule != null) {
                    oldBookmarkKey = oldChapterModule.getString("key");
                }
                newModule.set("id", (Object)newId);
                newModule.set("creator", (Object)user);
                newModule.set("createtime", (Object)date);
                newModule.set("modifier", (Object)user);
                newModule.set("modifytime", (Object)date);
                String propertiesStr = newModule.getString("properties");
                if (StringUtils.isNotEmpty((String)propertiesStr) && !propertiesStr.equals("null") && (itemObject = JSON.parseObject((String)propertiesStr)) != null) {
                    itemObject.put("id", (Object)newId.toString());
                    WordBookmarkHelper.createBookmarkNode(itemObject, newBookmarkKey);
                    if (copyOperation != null) {
                        copyOperation.changeModule(newChapter.getLong("id"), itemObject);
                    }
                    newModule.set("properties", (Object)itemObject.toJSONString());
                }
                saveNewModules.add(newModule);
                DynamicObject dyn = new DynamicObject(newChapterModules.getDynamicObjectType());
                dyn.set("module", (Object)newId);
                dyn.set("key", (Object)newBookmarkKey);
                dyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                newChapterModules.add((Object)dyn);
                ChapterModuleCopyResult copyResult = new ChapterModuleCopyResult();
                copyResult.setNewModuleId(newId);
                copyResult.setNewBookmarkKey(newBookmarkKey);
                copyResult.setOldModuleId(oldModule.getLong("id"));
                copyResult.setOldBookmarkKey(oldBookmarkKey);
                moduleMap.add(copyResult);
            }
            SaveServiceHelper.save((DynamicObject[])saveNewModules.toArray(new DynamicObject[0]));
        }
        return moduleMap;
    }

    public static void copyChapterHtml(Long oldChapterId, Long newChapterId, DynamicObject user, Date date, List<ChapterModuleCopyResult> moduleMap) {
        try {
            WebHtmlService webHtmlService = new WebHtmlService();
            DynamicObject oldHtmlDy = webHtmlService.getChapterDesginHtmlObject(oldChapterId, null);
            if (oldHtmlDy == null) {
                return;
            }
            oldHtmlDy = BusinessDataServiceHelper.loadSingle((Object)oldHtmlDy.getLong("id"), (String)"fidm_word_history");
            String htmlJson = oldHtmlDy.getString("content");
            for (ChapterModuleCopyResult entry : moduleMap) {
                htmlJson = htmlJson.replace(entry.getOldModuleId().toString(), entry.getNewModuleId().toString());
                if (!StringUtils.isNotEmpty((String)entry.getOldBookmarkKey())) continue;
                htmlJson = htmlJson.replace(entry.getOldBookmarkKey(), entry.getNewBookmarkKey());
            }
            DynamicObject newhtmlDy = BusinessDataServiceHelper.newDynamicObject((String)"fidm_word_history");
            newhtmlDy.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            newhtmlDy.set("model", (Object)oldHtmlDy.getLong("model.id"));
            newhtmlDy.set("remark", (Object)oldHtmlDy.getString("remark"));
            newhtmlDy.set("docid", (Object)oldHtmlDy.getString("docid"));
            newhtmlDy.set("type", (Object)WordDataType.ChapterDeginJson.getType());
            newhtmlDy.set("reportId", (Object)0L);
            newhtmlDy.set("chapterid", (Object)newChapterId);
            newhtmlDy.set("creator", (Object)user);
            newhtmlDy.set("createtime", (Object)new Date());
            newhtmlDy.set("modifier", (Object)user);
            newhtmlDy.set("modifytime", (Object)date);
            newhtmlDy.set("downloadurl", (Object)oldHtmlDy.getString("downloadurl"));
            newhtmlDy.set("content", (Object)htmlJson);
            newhtmlDy.set("name", (Object)oldHtmlDy.getString("name"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newhtmlDy});
        }
        catch (Exception ex) {
            logger.error("dm copyChapterHtml eroor", (Throwable)ex);
        }
    }
}

