/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.chapter;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.mutex.MutexServiceHelper;

public class LockChapterHelper {
    public static final String CURLOCKEDCHAPTER = "curlockedchapter";
    public static final String MODIFYOPERATE = "modify";
    public static final String USERID = "userid";
    public static final String NAME = "name";

    public static int lockChapter(String entityKey, IPageCache pageCache, String selectChapterIdStr, List<String> tips) {
        String curLockedChapter = pageCache.get(CURLOCKEDCHAPTER);
        boolean isPageLock = selectChapterIdStr.equalsIgnoreCase(curLockedChapter);
        int reuslt = LockChapterHelper.lockChapter(entityKey, selectChapterIdStr, isPageLock, tips);
        if (reuslt == 1) {
            pageCache.put(CURLOCKEDCHAPTER, selectChapterIdStr);
        }
        return reuslt;
    }

    public static int lockChapter(String entityKey, String selectChapterIdStr, boolean isPageLock, List<String> tips) {
        Map<String, String> lockInfo = LockChapterHelper.getLockInfo(entityKey, selectChapterIdStr);
        if (lockInfo == null || lockInfo.isEmpty()) {
            boolean isLocked = LockChapterHelper.addLockInfo(entityKey, selectChapterIdStr);
            if (isLocked) {
                return 1;
            }
            return -1;
        }
        if (isPageLock) {
            return 1;
        }
        String lockedUserId = lockInfo.get(USERID);
        Map userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(lockedUserId));
        String currentUserName = (String)userInfo.get(NAME);
        if (StringUtils.isNotEmpty((String)currentUserName)) {
            tips.add(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ae0\u8282\u5df2\u88ab%s\u9501\u5b9a\uff0c\u4ec5\u652f\u6301\u67e5\u770b\u3002", (String)"LockChapterHelper_0", (String)"epm-far-business", (Object[])new Object[0]), currentUserName));
        } else {
            tips.add(ResManager.loadKDString((String)"\u5f53\u524d\u7ae0\u8282\u5df2\u9501\u5b9a\uff0c\u8bf7\u4f7f\u7528\u67e5\u770b\u65b9\u5f0f\u67e5\u770b\u3002", (String)"LockChapterHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return 2;
    }

    public static int getLockStatus(String entityKey, IPageCache pageCache, String selectChapterIdStr) {
        String curLockedChapter = pageCache.get(CURLOCKEDCHAPTER);
        boolean isPageLock = selectChapterIdStr.equalsIgnoreCase(curLockedChapter);
        return LockChapterHelper.getLockStatus(entityKey, selectChapterIdStr, isPageLock);
    }

    public static int getLockStatus(String entityKey, String selectChapterIdStr, boolean isPageLock) {
        Map<String, String> lockInfo = LockChapterHelper.getLockInfo(entityKey, selectChapterIdStr);
        if (lockInfo == null || lockInfo.isEmpty()) {
            return -1;
        }
        if (isPageLock) {
            return 1;
        }
        return 2;
    }

    public static void releaseChapter(String entityKey, IPageCache pageCache, String selectChapterIdStr) {
        String curLockedChapter = pageCache.get(CURLOCKEDCHAPTER);
        boolean isPageLock = selectChapterIdStr.equalsIgnoreCase(curLockedChapter);
        LockChapterHelper.releaseChapter(entityKey, selectChapterIdStr, isPageLock);
        if (isPageLock) {
            pageCache.remove(CURLOCKEDCHAPTER);
        }
    }

    public static void releaseChapter(String entityKey, String selectChapterIdStr, boolean isPageLock) {
        int status;
        QFilter lockedChapterFilter = new QFilter("objectid", "=", (Object)selectChapterIdStr);
        boolean lockedChapterExist = QueryServiceHelper.exists((String)"bos_datalock", (QFilter[])new QFilter[]{lockedChapterFilter});
        if (lockedChapterExist && (status = LockChapterHelper.getLockStatus(entityKey, selectChapterIdStr, isPageLock)) == 1) {
            LockChapterHelper.releaseLock(entityKey, selectChapterIdStr);
        }
    }

    private static Map<String, String> getLockInfo(String entityKey, String selectChapterIdStr) {
        return MutexServiceHelper.getLockInfo(selectChapterIdStr, entityKey, MODIFYOPERATE);
    }

    private static boolean addLockInfo(String entityKey, String selectChapterIdStr) {
        return MutexServiceHelper.request(selectChapterIdStr, entityKey, MODIFYOPERATE);
    }

    private static boolean releaseLock(String entityKey, String selectChapterIdStr) {
        return MutexServiceHelper.release(selectChapterIdStr, entityKey, MODIFYOPERATE);
    }
}

