/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.design;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.filter.DatasetFilterHelper;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.ChapterCommitStatusEnum;
import kd.epm.far.business.common.enums.ComeFromEnum;
import kd.epm.far.business.common.enums.DmVariableTypeEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.module.ModuleMiddleHelper;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.common.module.middle.base.MiddleModuleResult;
import kd.epm.far.business.common.variable.VariableService;
import kd.epm.far.business.far.enums.ModuleEnum;
import kd.epm.far.business.far.enums.VariableTypeEnum;
import kd.epm.far.business.fidm.base.DisclosureConstants;
import kd.epm.far.business.fidm.base.DisclosureExceptionHelper;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.base.DisclosureVueHelper;
import kd.epm.far.business.fidm.base.ISaveOperation;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.module.DisclosureModuleHelper;
import kd.epm.far.business.fidm.module.DisclosureOldModuleHelper;
import kd.epm.far.business.fidm.module.ReportSectionHelper;
import kd.epm.far.business.fidm.module.calculate.VarHelper;
import kd.epm.far.business.fidm.module.dto.ModuleSaveInput;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;

public class DisclosureDesignHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosureDesignHelper.class);

    public static JSONObject dataInfo(String message) {
        return DisclosureVueHelper.dataInfo(message, DisclosureDesignHelper.getI18n());
    }

    public static JSONObject dataInit(Long dmModelId, Long chapterId, boolean isReset, List<String> strTips, Map<Long, String> chapterPermMap) {
        Map<String, Object> dataInit = DisclosureDesignHelper.getDataInit(dmModelId, chapterId, isReset, strTips);
        List<Map<String, String>> localVarList = VariableService.getChapterTreeList(dmModelId, chapterId);
        List<Map<String, String>> gbVarList = VariableService.getVariableTreeList(dmModelId);
        List<Map<String, String>> localDatasetList = DatasetServiceHelper.getChapterTreeList(dmModelId, chapterId, ApplicationTypeEnum.FIDM.getAppnum());
        List<Map<String, String>> gbDatasetList = DatasetServiceHelper.getTreeList(dmModelId, ApplicationTypeEnum.FIDM.getAppnum());
        List<Map<String, Object>> dimList = DimensionUtils.dimConvertToMap(new ModelStrategyEx(dmModelId).getDim().getDimList());
        List<Map<String, Object>> moduleList = DisclosureModuleHelper.getModuleList(dmModelId);
        DynamicObject chapter = DisclosureChapterHelper.getChapter(chapterId);
        Long templateId = chapter.getLong("template.id");
        Map<String, String> template = DisclosureDesignHelper.getTempalteInfo(templateId);
        List<Map<String, String>> chapters = DisclosureDesignHelper.getChapterInfoByTemplateAndPerm(templateId, chapterPermMap);
        return DisclosureVueHelper.dataInit(dataInit.get("itemList"), dataInit.get("bookmarkList"), null, template, chapters, gbVarList, localVarList, gbDatasetList, localDatasetList, dimList, moduleList, DisclosureDesignHelper.getI18n(), isReset);
    }

    public static List<Map<String, String>> getChapterInfoByTemplateAndPerm(Long templateId, Map<Long, String> chapterPermMap) {
        List<Map<String, String>> chapters = DisclosureDesignHelper.getChapterInfoByTemplate(templateId);
        if (chapterPermMap != null) {
            ArrayList<Map<String, String>> newChapters = new ArrayList<Map<String, String>>(chapters.size());
            for (Map<String, String> chapterItem : chapters) {
                String perm = chapterPermMap.get(LongUtil.toLong((Object)chapterItem.get("id")));
                if (StringUtils.isEmpty((String)perm)) {
                    perm = DataTypeEnum.WRITEIN.getIndex();
                }
                if (PermClassBaseHelper.isNoPerm(perm)) continue;
                chapterItem.put("perm", perm);
                newChapters.add(chapterItem);
            }
            chapters = newChapters;
        } else {
            for (Map<String, String> chapterItem : chapters) {
                chapterItem.put("perm", DataTypeEnum.WRITEIN.getIndex());
            }
        }
        return chapters;
    }

    public static Map<String, Object> getDataInit(Long dmModelId, Long chapterId, boolean isReset, List<String> strTips) {
        DynamicObject dynamicObject;
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        DisclosureChapterHelper.getChapter(chapterId);
        ArrayList<JSONObject> realModules = new ArrayList<JSONObject>(2);
        ArrayList bookmarkList = new ArrayList(2);
        if (!isReset && (dynamicObject = BusinessDataServiceHelper.loadSingle((String)"fidm_chapter", (String)"entryentity.key, entryentity.module,entryentity.module.type,entryentity.module.number,entryentity.module.name,entryentity.module.properties", (QFilter[])new QFilter("id", "=", (Object)chapterId).toArray())) != null) {
            DynamicObjectCollection modules = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject m : modules) {
                HashMap<String, Object> moduleMap = new HashMap<String, Object>(2);
                moduleMap.put("id", m.getString("module.id"));
                moduleMap.put("number", m.getString("module.number"));
                moduleMap.put("name", m.getString("module.name"));
                moduleMap.put("properties", m.getString("module.properties"));
                JSONObject newModule = DisclosureOldModuleHelper.converToNewVersion(dmModelId, chapterId, moduleMap);
                if (newModule != null) {
                    DisclosureDesignHelper.resetDatasetNode(dmModelId, chapterId, newModule, strTips);
                    realModules.add(newModule);
                }
                HashMap<String, String> bookmark = new HashMap<String, String>(2);
                bookmark.put("itemId", m.getString("module.id"));
                bookmark.put("key", m.getString("key"));
                bookmarkList.add(bookmark);
            }
        }
        result.put("itemList", realModules);
        result.put("bookmarkList", bookmarkList);
        return result;
    }

    private static boolean resetDatasetNode(Long dmModelId, Long chapterId, JSONObject newModule, List<String> strTips) {
        if (newModule == null) {
            return false;
        }
        JSONObject oldDataSet = newModule.getJSONObject("dataset");
        if (oldDataSet == null) {
            return false;
        }
        String msg = "";
        JSONArray oldVarParamsObject = oldDataSet.getJSONArray("varParams");
        JSONArray oldDimParamsObject = oldDataSet.getJSONArray("dimParams");
        JSONObject newDataSet = null;
        JSONArray varParamsObject = null;
        JSONArray dimParamsObject = null;
        Long datasetId = oldDataSet.getLong("id");
        String moduleName = newModule.getString("name");
        try {
            JSONObject findObject;
            Object find;
            newDataSet = DisclosureDesignHelper.createDataSouceNode(dmModelId, chapterId, datasetId);
            if (newDataSet == null) {
                return false;
            }
            varParamsObject = newDataSet.getJSONArray("varParams");
            if (oldVarParamsObject != null && varParamsObject != null) {
                for (Object object : varParamsObject) {
                    JSONObject varJsonObject = (JSONObject)object;
                    find = oldVarParamsObject.stream().filter(m -> ((JSONObject)m).getString("number").equals(varJsonObject.getString("number"))).findAny().orElse(null);
                    if (find == null || (findObject = (JSONObject)find) == null || !StringUtils.isNotEmpty((String)findObject.getString("modifyvalue"))) continue;
                    varJsonObject.put("modifyvalue", (Object)findObject.getString("modifyvalue"));
                }
            }
            dimParamsObject = newDataSet.getJSONArray("dimParams");
            if (oldDimParamsObject != null && dimParamsObject != null) {
                for (Object object : dimParamsObject) {
                    JSONObject dimJsonObject = (JSONObject)object;
                    find = oldDimParamsObject.stream().filter(m -> ((JSONObject)m).getString("number").equals(dimJsonObject.getString("number"))).findAny().orElse(null);
                    if (find == null) continue;
                    findObject = find;
                    String isDim = DisclosureJsonHelper.getValue(dimJsonObject, "isDim", null);
                    if ("2".equalsIgnoreCase(isDim)) {
                        JSONArray oldMembers = findObject.getJSONArray("members");
                        if (oldMembers == null || oldMembers.size() <= 0) continue;
                        dimJsonObject.put("members", (Object)oldMembers);
                        dimJsonObject.put("member", new LinkedHashMap(1));
                        dimJsonObject.put("dislapyText", (Object)String.join((CharSequence)",", oldMembers.stream().map(m -> ((JSONObject)m).getString("name")).collect(Collectors.toList())));
                        dimJsonObject.put("isDim", (Object)"2");
                        continue;
                    }
                    JSONObject oldMemberOject = findObject.getJSONObject("member");
                    if (oldMemberOject == null) continue;
                    dimJsonObject.put("member", (Object)oldMemberOject);
                    dimJsonObject.put("dislapyText", (Object)oldMemberOject.getString("name"));
                }
            }
            if (!DisclosureDesignHelper.checkDatasetChange(oldDataSet, newDataSet)) {
                msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u4ef6\u7684\u6570\u636e\u96c6\u516c\u5f0f\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u6ce8\u610f\u3002", (String)"DisclosureServiceHelper_6", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
                strTips.add(msg);
            }
        }
        catch (KDBizException kdEx) {
            logger.error("resetDatasetNode fail:" + (Object)((Object)kdEx));
            msg = moduleName + ":" + kdEx.getMessage();
            strTips.add(msg);
        }
        if (varParamsObject != null) {
            oldDataSet.put("varParams", (Object)varParamsObject);
        }
        if (dimParamsObject != null) {
            oldDataSet.put("dimParams", (Object)dimParamsObject);
        }
        oldDataSet.put("detail", (Object)DisclosureJsonHelper.getJSONArray(newDataSet, "columns"));
        return true;
    }

    private static boolean checkDatasetChange(JSONObject oldDataSet, JSONObject newDataSet) {
        Object find;
        JSONArray oldColumns = DisclosureJsonHelper.getJSONArray(oldDataSet, "detail");
        JSONArray newColumns = DisclosureJsonHelper.getJSONArray(newDataSet, "columns");
        if (oldColumns == null || newColumns == null) {
            return false;
        }
        for (Object old : oldColumns) {
            JSONObject oldColumn = (JSONObject)old;
            find = newColumns.stream().filter(m -> ((JSONObject)m).getString("number").equals(oldColumn.getString("number"))).findAny().orElse(null);
            if (find != null) continue;
            return false;
        }
        for (Object newC : newColumns) {
            JSONObject newColumn = (JSONObject)newC;
            find = oldColumns.stream().filter(m -> ((JSONObject)m).getString("number").equals(newColumn.getString("number"))).findAny().orElse(null);
            if (find != null) continue;
            return false;
        }
        return true;
    }

    public static Tuple<Boolean, String> save(Long dmModelId, Long chapterId, ISaveOperation saveOperation, String eventArgs, int saveWordType) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONArray bookmarkList = jsonObject.getJSONArray("bookmarkList");
        JSONArray itemList = jsonObject.getJSONArray("itemList");
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        if (chapter == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ae0\u8282\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DisclosureServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        DynamicObjectCollection chapterModules = chapter.getDynamicObjectCollection("entryentity");
        List moduleIds = chapterModules.stream().map(e -> e.getLong("module.id")).filter(e -> !e.equals(0L)).distinct().collect(Collectors.toList());
        List<Map<String, Object>> oldBookmarkList = chapterModules.stream().map(e -> {
            HashMap<String, Object> bookmark = new HashMap<String, Object>(2);
            bookmark.put("itemId", e.getLong("module.id"));
            bookmark.put("key", e.getString("key"));
            return bookmark;
        }).collect(Collectors.toList());
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)chapter.getLong("template.id"), (String)"fidm_template");
        ArrayList<Long> deleteModules = new ArrayList<Long>(10);
        ArrayList<DynamicObject> saveModules = new ArrayList<DynamicObject>(10);
        int seq = 1;
        chapterModules.clear();
        for (Object item : itemList) {
            JSONObject itemObject = (JSONObject)item;
            DisclosureDesignHelper.checkItemObject(dmModelId, itemObject);
            DisclosureDesignHelper.saveToModule(dmModelId, template.getLong("id"), deleteModules, chapterModules, saveModules, itemObject, bookmarkList, oldBookmarkList, seq);
            ++seq;
        }
        template.set("modifytime", (Object)TimeServiceHelper.now());
        if (saveModules.size() > 0) {
            moduleIds.addAll(saveModules.stream().map(e -> e.getLong("id")).filter(e -> !e.equals(0L)).distinct().collect(Collectors.toList()));
            moduleIds = moduleIds.stream().distinct().collect(Collectors.toList());
        }
        String newFileUrl = saveOperation.getUrl(chapter);
        chapter.set("url", (Object)newFileUrl);
        chapter.set("savewordtype", (Object)saveWordType);
        chapter.set("comefrom", (Object)OpenWordEnum.getComefromByType(String.valueOf(saveWordType)).getType());
        chapter.set("modifytime", (Object)TimeServiceHelper.now());
        try (TXHandle tx = TX.required();){
            try {
                if (moduleIds.size() > 0) {
                    DeleteServiceHelper.delete((String)"fidm_modulerepository", (QFilter[])new QFilter[]{new QFilter("id", "in", moduleIds)});
                }
                SaveServiceHelper.save((DynamicObject[])saveModules.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{template});
            }
            catch (Exception e2) {
                tx.markRollback();
                DisclosureLogHelper.writeTemplateChapter(OperationResult.FAILURE, OperationName.SAVE, modelStrategyEx.getModel().getModelInfo(), template, chapter);
                throw new KDBizException((Throwable)e2, new ErrorCode("", e2.getMessage()), new Object[0]);
            }
        }
        DisclosureLogHelper.writeTemplateChapter(OperationResult.SUCCESS, OperationName.SAVE, modelStrategyEx.getModel().getModelInfo(), template, chapter);
        return new Tuple((Object)true, (Object)newFileUrl);
    }

    private static void saveToModule(Long dmModelId, Long templateId, List<Long> deleteModules, DynamicObjectCollection chapterModules, List<DynamicObject> saveModules, JSONObject itemObject, JSONArray bookmarkList, List<Map<String, Object>> oldBookmarkList, int seq) {
        Map findBookmark;
        logger.info("saveToModule itemObject:" + itemObject == null ? "null" : itemObject.toJSONString());
        Long itemId = itemObject.getLong("id");
        String bookmarkKey = "";
        if (bookmarkList != null) {
            for (Object bookmark : bookmarkList) {
                JSONObject bookmarkObject = (JSONObject)bookmark;
                if (!itemId.toString().equals(bookmarkObject.getString("itemId"))) continue;
                bookmarkKey = bookmarkObject.getString("key");
                break;
            }
        }
        if (StringUtils.isEmpty((String)bookmarkKey) && (findBookmark = (Map)oldBookmarkList.stream().filter(m -> m.get("itemId").toString().equals(itemId.toString())).findAny().orElse(null)) != null) {
            bookmarkKey = findBookmark.get("key").toString();
        }
        DynamicObject module = BusinessDataServiceHelper.newDynamicObject((String)"fidm_modulerepository");
        module.set("id", (Object)itemId);
        module.set("model", (Object)dmModelId);
        module.set("template", (Object)templateId);
        module.set("status", (Object)"1");
        module.set("creator", (Object)RequestContext.get().getCurrUserId());
        module.set("createtime", (Object)TimeServiceHelper.now());
        module.set("modifier", (Object)RequestContext.get().getCurrUserId());
        module.set("modifytime", (Object)TimeServiceHelper.now());
        module.set("number", (Object)itemObject.getString("number"));
        module.set("name", (Object)ModuleServiceHelper.converToModuleName(itemObject.getString("name")));
        module.set("type", (Object)itemObject.getString("type"));
        module.set("datasetid", (Object)DisclosureJsonHelper.getValue(itemObject, "dataset", "id", 0L));
        module.set("scope", (Object)"1");
        module.set("properties", (Object)itemObject.toJSONString());
        Long copyfrom = DisclosureJsonHelper.getValue(itemObject, "copyfrom", "id", 0L);
        if (copyfrom != null && copyfrom > 0L) {
            module.set("copyfrom", (Object)copyfrom);
        }
        deleteModules.add(itemId);
        DynamicObject dyn = new DynamicObject(chapterModules.getDynamicObjectType());
        dyn.set("module", (Object)itemId);
        dyn.set("key", (Object)bookmarkKey);
        dyn.set("seq", (Object)seq);
        dyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        chapterModules.add((Object)dyn);
        saveModules.add(module);
    }

    private static void checkItemObject(Long dmModelId, JSONObject itemObject) {
        if (itemObject == null) {
            return;
        }
        String moduleName = itemObject.getString("name");
        try {
            Long datasetId;
            JSONObject dataset = itemObject.getJSONObject("dataset");
            if (dataset != null && (datasetId = dataset.getLong("id")) != null && datasetId > 0L) {
                Map<String, Object> varParams = DisclosureDesignHelper.getVarParams(dmModelId, datasetId, dataset.getJSONArray("varParams"));
                long datasetMutId = 0L;
                if (dataset.getJSONObject("formula") != null && dataset.getJSONObject("formula").containsKey((Object)"id")) {
                    datasetMutId = dataset.getJSONObject("formula").getLong("id");
                }
                if (datasetMutId > 0L) {
                    DatasetExpressionHelper.checkExpression(dmModelId, datasetId, datasetMutId, varParams);
                } else {
                    DatasetExpressionHelper.checkExpression(dmModelId, datasetId, varParams);
                }
            }
            VarHelper.checkExpression(itemObject);
        }
        catch (KDBizException kdBizException) {
            String tips = moduleName + ":";
            tips = tips + kdBizException.getMessage();
            throw new KDBizException(tips);
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    private static Map<String, Object> getVarParams(Long dmModelId, Long datasetId, JSONArray varParamsObject) {
        Map<String, Object> varAndDimResult;
        List varSourceList;
        HashMap<String, Object> varParams = new HashMap<String, Object>(2);
        if (Objects.isNull(varParamsObject)) {
            return varParams;
        }
        boolean isNeedRepalce = false;
        for (Object varObject : varParamsObject) {
            JSONObject varJsonObject = (JSONObject)varObject;
            Object modifyvalue = varJsonObject.get((Object)"modifyvalue");
            if (!Objects.nonNull(modifyvalue) || StringUtils.isEmpty((String)modifyvalue.toString())) continue;
            isNeedRepalce = true;
            break;
        }
        if (!isNeedRepalce) {
            return varParams;
        }
        Long chapterId = 0L;
        DynamicObject dataset = DatasetDataReader.getDataSet(datasetId, false);
        if (Objects.nonNull(dataset)) {
            chapterId = dataset.getLong("chapterId");
        }
        if ((varSourceList = (List)(varAndDimResult = DatasetServiceHelper.getVarAndDimVars(dmModelId, datasetId, chapterId, false)).get("variableList")).size() == 0) {
            return varParams;
        }
        List<DimensionInfo> allDimList = new ModelStrategyEx(dmModelId).getDim().getDimList();
        for (Map varObject : varSourceList) {
            String valuetype;
            String number = varObject.get("number").toString();
            Object defaultvalue = varObject.get("defaultvalue");
            String string = valuetype = varObject.get("valuetype") == null ? String.valueOf(VariableTypeEnum.TEXT.getCode()) : varObject.get("valuetype").toString();
            if (StringUtils.isEmpty((String)number)) continue;
            JSONObject findDim = null;
            for (Object object : varParamsObject) {
                JSONObject varJsonObject = (JSONObject)object;
                if (!number.equals(varJsonObject.get((Object)"number"))) continue;
                findDim = varJsonObject;
                break;
            }
            if (findDim != null) {
                Object modifyvalue = findDim.get((Object)"modifyvalue");
                if (modifyvalue != null && !StringUtils.isEmpty((String)modifyvalue.toString())) {
                    if (String.valueOf(VariableTypeEnum.DIM.getCode()).equalsIgnoreCase(valuetype)) {
                        DimensionInfo dimensionInfo = DimensionUtils.getDimById(allDimList, TypeUtils.convertToLong(varObject.get("disc_dim")));
                        if (dimensionInfo == null) continue;
                        varParams.put(number, dimensionInfo.getShortNumber() + "." + defaultvalue);
                        continue;
                    }
                    varParams.put(number, modifyvalue);
                    continue;
                }
                varParams.put(number, defaultvalue);
                continue;
            }
            varParams.put(number, defaultvalue);
        }
        return varParams;
    }

    public static Object dsF7Result(Long dmModelId, Long chapterId, DynamicObject newVaule, String primaryKey) {
        if (!Objects.nonNull(newVaule)) {
            return null;
        }
        Long datasetId = newVaule.getLong("id");
        JSONObject dataObj = DisclosureDesignHelper.createDataSouceNode(dmModelId, chapterId, datasetId);
        return DisclosureVueHelper.getPropsDataResult(DisclosureConstants.PropsDataType.DATA_DS_F7_RESULT, dataObj, primaryKey);
    }

    public static JSONObject createDataSouceNode(Long dmModelId, Long chapterId, Long datasetId) {
        Map<String, Object> newDim;
        DimensionInfo findDim;
        DynamicObject dataset = DatasetDataReader.getDataSet(datasetId, false);
        if (dataset == null) {
            return null;
        }
        String type = dataset.getString("type");
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        DatasetExpressionHelper.checkExpression(dmModelId, datasetId);
        List<Map<String, Object>> columnList = DisclosureDesignHelper.getDatasetColumns(modelStrategyEx, datasetId, type);
        List<DimensionInfo> dimList = modelStrategyEx.getDim().getDimList();
        Map<String, Object> varAndDimResult = DatasetServiceHelper.getVarAndDimVars(dmModelId, datasetId, chapterId, false);
        List varSourceList = (List)varAndDimResult.get("variableList");
        List shortNumberList = (List)varAndDimResult.get("curShortNumberList");
        List cursShortNumberList = (List)varAndDimResult.get("cursShortNumberList");
        ArrayList variableList = new ArrayList(varSourceList.size());
        for (Iterator varObject : varSourceList) {
            varObject.put("modifyvalue", null);
            if (varObject.get("valuetype").equals(DmVariableTypeEnum.DIM.getIndex())) {
                DimensionInfo findDim2 = dimList.stream().filter(m -> m.getId().toString().equals(varObject.get("disc_dim"))).findAny().orElse(null);
                if (Objects.nonNull(findDim2)) {
                    varObject.put("dim", DimensionUtils.dimConvertToMap(findDim2));
                    varObject.put("disc_dim", findDim2.getId().toString());
                } else {
                    varObject.put("dim", dimList.get(0).getId().toString());
                }
            }
            ArrayList entryentity = new ArrayList();
            if (Objects.nonNull(varObject.get("entryentity"))) {
                for (DynamicObject entry : (DynamicObjectCollection)varObject.get("entryentity")) {
                    HashMap<String, String> newItem = new HashMap<String, String>(3);
                    newItem.put("id", entry.getString("id"));
                    newItem.put("enum_number", new LocaleString(entry.getString("enum_number")).getLocaleValue());
                    newItem.put("enum_name", new LocaleString(entry.getString("enum_name")).getLocaleValue());
                    entryentity.add(newItem);
                }
                varObject.put("entryentity", entryentity);
            }
            variableList.add(varObject);
        }
        ArrayList<Map<String, Object>> dimParamList = new ArrayList<Map<String, Object>>(shortNumberList.size());
        for (String shortNumber : shortNumberList) {
            findDim = dimList.stream().filter(m -> m.getShortNumber().equals(shortNumber)).findAny().orElse(null);
            if (!Objects.nonNull(findDim)) continue;
            newDim = DimensionUtils.dimConvertToMap(findDim);
            newDim.put("member", new LinkedHashMap(1));
            dimParamList.add(newDim);
        }
        for (String shortNumber : cursShortNumberList) {
            findDim = dimList.stream().filter(m -> m.getShortNumber().equals(shortNumber)).findAny().orElse(null);
            if (findDim == null) continue;
            newDim = DimensionUtils.dimConvertToMap(findDim);
            newDim.put("member", new LinkedHashMap(1));
            newDim.put("members", new ArrayList(0));
            newDim.put("isDim", "2");
            dimParamList.add(newDim);
        }
        JSONObject dataObj = new JSONObject();
        dataObj.put("id", (Object)dataset.getString("id"));
        dataObj.put("name", (Object)dataset.getString("name"));
        dataObj.put("number", (Object)dataset.getString("number"));
        dataObj.put("type", (Object)type);
        dataObj.put("columns", columnList);
        dataObj.put("varParams", variableList);
        dataObj.put("dimParams", dimParamList);
        dataObj.put("datesetFilterItems", new ArrayList());
        return JSONObject.parseObject((String)dataObj.toJSONString());
    }

    private static List<Map<String, Object>> getDatasetColumns(ModelStrategyEx modelStrategyEx, Long datasetId, String datasetType) {
        Map find;
        List<Object> columnList = new ArrayList(10);
        if ("2".equals(datasetType)) {
            try {
                columnList = DatasetFilterHelper.invokeDatasetFilterColumn(modelStrategyEx.getModel().getModelInfo().getId(), datasetId);
                columnList.forEach(m -> m.put("id", m.get("number").toString()));
            }
            catch (Exception dsEx) {
                logger.error((Throwable)dsEx);
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5217\u89e3\u6790\u5931\u8d25\u3002", (String)"DisclosureServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
            }
        }
        ArrayList<Map<String, Object>> newColumnList = new ArrayList<Map<String, Object>>(columnList.size());
        List<DimensionInfo> dimensionInfos = modelStrategyEx.getDim().getDimList(false);
        for (DimensionInfo dimensionInfo : dimensionInfos) {
            find = columnList.stream().filter(m -> dimensionInfo.getNumber().equalsIgnoreCase(TypeUtils.getMapValueString(m, "number"))).findFirst().orElse(null);
            if (find == null) continue;
            newColumnList.add(find);
        }
        if (newColumnList.size() == 0) {
            return columnList;
        }
        for (Map map : columnList) {
            find = newColumnList.stream().filter(m -> TypeUtils.getMapValueString(itemMap, "number").equalsIgnoreCase(TypeUtils.getMapValueString(m, "number"))).findFirst().orElse(null);
            if (find != null) continue;
            newColumnList.add(map);
        }
        return newColumnList;
    }

    public static Object datasetFormulaResult(DynamicObject newVaule, String primaryKey) {
        if (!Objects.nonNull(newVaule)) {
            return null;
        }
        JSONObject dataObj = new JSONObject();
        dataObj.put("id", (Object)newVaule.getString("id"));
        dataObj.put("name", (Object)newVaule.getString("name"));
        dataObj.put("number", (Object)newVaule.getString("number"));
        return DisclosureVueHelper.getPropsDataResult(DisclosureConstants.PropsDataType.DATA_DATASET_FORMULA_RESULT, dataObj, primaryKey);
    }

    public static void saveModule(IFormView view, IFormPlugin plugin, Long dmModelId, String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject itemObject = jsonObject.getJSONObject("item");
        ModuleSaveInput saveInput = new ModuleSaveInput();
        saveInput.setDmModelId(dmModelId);
        saveInput.setNumber(itemObject.getString("number"));
        saveInput.setName(ModuleServiceHelper.converToModuleName(itemObject.getString("name")));
        saveInput.setType(itemObject.getString("type"));
        saveInput.setDescription("");
        saveInput.setApplytype("1");
        saveInput.setStatus("1");
        saveInput.setScope("1");
        saveInput.setComefrom(ComeFromEnum.FIDM.getType());
        saveInput.setProperties(itemObject.toJSONString());
        saveInput.setDatasetid(DisclosureJsonHelper.getValue(itemObject, "dataset", "id", 0L));
        FormShowParameter formShowParameter = DisclosureFormHelper.createFormParam(saveInput);
        formShowParameter.setFormId("fidm_modulesave");
        formShowParameter.setParentPageId(view.getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack(plugin, "fidm_modulerepository"));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)dmModelId);
        formShowParameter.setCustomParam("dmmodelid", (Object)dmModelId);
        view.showForm(formShowParameter);
    }

    public static JSONObject moduleAddItem(Long dmModelId, Long chapterId, String eventArgs, String openWordEnum) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        Long moduleId = LongUtil.toLong((Object)jsonObject.getString("id"));
        Map<String, Object> moduleDy = ModuleServiceHelper.getModule(dmModelId, moduleId);
        if (moduleDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u4ef6\u4e0d\u5b58\u5728", (String)"DisclosureServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        JSONObject itemObject = null;
        String moduleType = moduleDy.get("type").toString();
        if (kd.epm.far.business.common.enums.ModuleEnum.containsType(moduleType).booleanValue()) {
            itemObject = DisclosureDesignHelper.moduleAddItemByDisclouse(dmModelId, chapterId, moduleDy, openWordEnum);
        } else if (ModuleEnum.containsType(moduleType).booleanValue()) {
            itemObject = DisclosureDesignHelper.moduleAddItemByOther(dmModelId, moduleDy);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u4ef6\u4e0d\u5b58\u5728\u6216\u8005\u8f6c\u6362\u5931\u8d25\u3002", (String)"DisclosureServiceHelper_19", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return itemObject;
    }

    private static JSONObject moduleAddItemByOther(Long dmModelId, Map<String, Object> moduleDy) {
        JSONObject itemObject = null;
        Long moduleId = LongUtil.toLong((Object)moduleDy.get("id"));
        String moduleName = TypeUtils.getMapValueString(moduleDy, "name");
        MiddleModuleResult moduleResult = ModuleMiddleHelper.convertToThird(dmModelId, moduleId, ModuleMiddleHelper.ModuleConvertEnum.Fidm, false);
        if (!moduleResult.isSuccess()) {
            String msg = ResManager.loadKDString((String)"\u7ec4\u4ef6\u4e0d\u5b58\u5728\u6216\u8005\u8f6c\u6362\u5931\u8d25\u3002", (String)"DisclosureServiceHelper_19", (String)"epm-far-business", (Object[])new Object[0]);
            if (moduleResult.getTips().size() > 0) {
                msg = moduleResult.getTips().get(0);
            }
            throw new KDBizException(msg);
        }
        itemObject = (JSONObject)moduleResult.getResult();
        if (itemObject != null) {
            LinkedHashMap<String, String> copyfrom = new LinkedHashMap<String, String>(2);
            copyfrom.put("id", moduleId.toString());
            copyfrom.put("type", "module");
            itemObject.put("id", (Object)String.valueOf(GlobalIdUtil.genGlobalLongId()));
            itemObject.put("name", (Object)moduleName);
            itemObject.put("copyfrom", copyfrom);
        }
        return itemObject;
    }

    private static JSONObject moduleAddItemByDisclouse(Long dmModelId, Long chapterId, Map<String, Object> moduleDy, String openWordEnum) {
        Long moduleId = LongUtil.toLong((Object)moduleDy.get("id"));
        String moduleNumber = moduleDy.get("number").toString();
        String moduleType = moduleDy.get("type").toString();
        JSONObject itemObject = null;
        if (kd.epm.far.business.common.enums.ModuleEnum.containsType(moduleType).booleanValue()) {
            long datasetId;
            JSONObject datasetObject;
            itemObject = DisclosureOldModuleHelper.converToNewVersion(dmModelId, chapterId, moduleDy);
            if (itemObject != null && (datasetObject = itemObject.getJSONObject("dataset")) != null && (datasetId = LongUtil.toLong((Object)datasetObject.get((Object)"id")).longValue()) > 0L) {
                long[] dsList = DatasetServiceHelper.copyChapterDataset(datasetId, chapterId);
                if (Objects.isNull(dsList)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u590d\u5236\u5931\u8d25\u3002", (String)"DisclosureServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]));
                }
                if (dsList.length > 0) {
                    itemObject.getJSONObject("dataset").put("id", (Object)Long.valueOf(dsList[0]).toString());
                }
            }
            if (itemObject != null) {
                LinkedHashMap<String, String> copyfrom = new LinkedHashMap<String, String>(2);
                copyfrom.put("id", moduleId.toString());
                copyfrom.put("type", "module");
                itemObject.put("id", (Object)String.valueOf(GlobalIdUtil.genGlobalLongId()));
                itemObject.put("name", (Object)TypeUtils.getMapValueString(moduleDy, "name"));
                itemObject.put("number", (Object)moduleNumber);
                itemObject.put("copyfrom", copyfrom);
                if (OpenWordEnum.WEB.getType().equalsIgnoreCase(openWordEnum)) {
                    JSONObject web = new JSONObject();
                    String html = "";
                    try {
                        if (kd.epm.far.business.common.enums.ModuleEnum.REPORT_SECTION.getType().equals(moduleType)) {
                            html = ReportSectionHelper.getDesigStyle(itemObject);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Throwable)ex);
                        html = "";
                    }
                    if (StringUtils.isNotEmpty((String)html)) {
                        web.put("html", (Object)html);
                        itemObject.put("web", (Object)web);
                    }
                }
            }
        }
        return itemObject;
    }

    public static Object getI18n() {
        Lang lang = Lang.get();
        JSONObject dataObj = new JSONObject();
        dataObj.put("lang", (Object)lang.getLangTag());
        return dataObj;
    }

    public static Object dataError(Throwable ex) {
        String title = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25", (String)"DisclosureServiceHelper_15", (String)"epm-far-business", (Object[])new Object[0]);
        logger.error(title, ex);
        String errorMsg = DisclosureExceptionHelper.buildExceptionMsg(title, ex, 30);
        return DisclosureDesignHelper.dataError(errorMsg);
    }

    public static Object dataError(String errorMsg) {
        HashMap data = new HashMap(2);
        HashMap<String, String> error = new HashMap<String, String>(2);
        error.put("msg", errorMsg);
        data.put("error", error);
        if (RequestContext.get() != null && RequestContext.get().getClientFullContextPath() != null) {
            JSONObject result = DisclosureVueHelper.getPropsDataResult(DisclosureConstants.PropsDataType.DATA_ERROR, data, "");
            return result;
        }
        throw new KDBizException(errorMsg);
    }

    public static void setPageConfigForChapterInfo(JSONObject pageConfig, Long chapterId) {
        if (pageConfig == null || !LongUtil.isvalidLong((Object)chapterId)) {
            return;
        }
        List<Map<String, String>> json = DisclosureDesignHelper.getChapterInfo(Collections.singletonList(chapterId));
        if (json.size() == 0) {
            return;
        }
        Map<String, String> chapter = json.get(0);
        for (Map.Entry<String, String> item : chapter.entrySet()) {
            pageConfig.put(item.getKey(), (Object)item.getValue());
        }
    }

    public static Map<String, String> getTempalteInfo(Long templateId) {
        if (!LongUtil.isvalidLong((Object)templateId)) {
            return null;
        }
        String selectedFiled = "id,number,name";
        DynamicObject templateDy = QueryServiceHelper.queryOne((String)"fidm_template", (String)selectedFiled, (QFilter[])new QFilter("id", "=", (Object)templateId).toArray());
        if (templateDy == null) {
            return null;
        }
        LinkedHashMap<String, String> tempalte = new LinkedHashMap<String, String>(20);
        tempalte.put("id", templateDy.getString("id"));
        tempalte.put("number", templateDy.getString("number"));
        tempalte.put("name", templateDy.getString("name"));
        return tempalte;
    }

    private static List<Map<String, String>> getChapterInfoByTemplate(Long templateId) {
        if (!LongUtil.isvalidLong((Object)templateId)) {
            return new ArrayList<Map<String, String>>(100);
        }
        DynamicObjectCollection chapters = QueryServiceHelper.query((String)"fidm_chapter", (String)"id", (QFilter[])new QFilter("template", "=", (Object)templateId).toArray());
        return DisclosureDesignHelper.getChapterInfo(chapters.stream().map(m -> m.getLong("id")).collect(Collectors.toList()));
    }

    public static List<Map<String, String>> getChapterInfo(List<Long> chapterIds) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(100);
        if (chapterIds == null) {
            return list;
        }
        String disableMsg = ResManager.loadKDString((String)"\u7981\u7528", (String)"DisclosureServiceHelper_23", (String)"epm-far-business", (Object[])new Object[0]);
        String enableMsg = ResManager.loadKDString((String)"\u542f\u7528", (String)"DisclosureServiceHelper_24", (String)"epm-far-business", (Object[])new Object[0]);
        String selectedFiled = "id,number,name,permclass.id,permclass.number,commitstatus,description,modifytime,modifier.name,sendbacktime,sendbacker.name,committime,commitor.name,sequence,enable";
        DynamicObjectCollection chapters = QueryServiceHelper.query((String)"fidm_chapter", (String)selectedFiled, (QFilter[])new QFilter("id", "in", chapterIds).toArray(), (String)"sequence");
        for (DynamicObject chapterDy : chapters) {
            LinkedHashMap<String, String> chapter = new LinkedHashMap<String, String>(20);
            chapter.put("id", chapterDy.getString("id"));
            chapter.put("number", chapterDy.getString("number"));
            chapter.put("name", chapterDy.getString("name"));
            chapter.put("permClassId", chapterDy.getString("permclass.id"));
            chapter.put("permClassName", chapterDy.getString("permclass.number"));
            chapter.put("commitStatus", chapterDy.getString("commitstatus"));
            chapter.put("commitStatusName", ChapterCommitStatusEnum.getNameByType(chapterDy.getString("commitstatus")));
            chapter.put("status", chapterDy.getString("enable"));
            chapter.put("statusName", "1".equalsIgnoreCase(chapterDy.getString("enable")) ? enableMsg : disableMsg);
            chapter.put("description", chapterDy.getString("description"));
            chapter.put("modifyTime", chapterDy.getString("modifytime"));
            chapter.put("modifier", chapterDy.getString("modifier.name"));
            chapter.put("sendbackTime", chapterDy.getString("sendbacktime"));
            chapter.put("sendbacker", chapterDy.getString("sendbacker.name"));
            chapter.put("commitTime", chapterDy.getString("committime"));
            chapter.put("commitor", chapterDy.getString("commitor.name"));
            chapter.put("sequence", chapterDy.getString("sequence"));
            list.add(chapter);
        }
        return list;
    }

    public static void initTemplateDefaultChapter(Long templateId, OpenWordEnum openWordEnum) {
        boolean isExists;
        DynamicObject template = QueryServiceHelper.queryOne((String)"fidm_template", (String)"id,name,model.id", (QFilter[])new QFilter("id", "=", (Object)templateId).toArray());
        if (template != null && !(isExists = QueryServiceHelper.exists((String)"fidm_chapter", (QFilter[])new QFilter("template", "=", (Object)templateId).toArray()))) {
            DynamicObject chapter = BusinessDataServiceHelper.newDynamicObject((String)"fidm_chapter");
            chapter.set("model", (Object)template.getLong("model.id"));
            chapter.set("template", (Object)templateId);
            chapter.set("number", (Object)"01");
            chapter.set("name", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u7ae0\u8282", (String)"DisclosureServiceHelper_9", (String)"epm-far-business", (Object[])new Object[0]));
            chapter.set("status", (Object)"A");
            chapter.set("enable", (Object)"1");
            chapter.set("commitstatus", (Object)"A");
            chapter.set("sequence", (Object)1);
            chapter.set("createtime", (Object)new Date());
            chapter.set("creator", (Object)RequestContext.get().getUserId());
            chapter.set("masterid", (Object)GlobalIdUtil.genGlobalLongId());
            chapter.set("savewordtype", (Object)openWordEnum.getTypeToInt());
            chapter.set("comefrom", (Object)OpenWordEnum.getComefromByType(chapter.getString("savewordtype")).getType());
            SaveServiceHelper.save((IDataEntityType)chapter.getDynamicObjectType(), (Object[])new Object[]{chapter});
        }
    }

    public static List<String> checkChapter(Long chapterId, int openWordEnum) {
        ArrayList<String> tips = new ArrayList<String>(10);
        DynamicObject chapterDy = DisclosureChapterHelper.getChapter(chapterId);
        if (StringUtils.isEmpty((String)chapterDy.getString("url"))) {
            return tips;
        }
        Long savewordtype = chapterDy.getLong("savewordtype");
        if (savewordtype == (long)openWordEnum) {
            return tips;
        }
        OpenWordEnum curEdit = OpenWordEnum.getByType(String.valueOf(openWordEnum));
        OpenWordEnum saveEdit = OpenWordEnum.getByType(String.valueOf(savewordtype));
        String tip = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u4e0a\u4e00\u6b21\u4fdd\u5b58\u7684\u6587\u4ef6\u7684\u7f16\u8f91\u65b9\u5f0f\u201c%1$s\u201d\u548c\u5f53\u524d\u6587\u4ef6\u7f16\u8f91\u65b9\u5f0f\u201c%2$s\u201d\u4e0d\u4e00\u81f4,\u8bf7\u6ce8\u610f\u6587\u6863\u5185\u5bb9\u53ef\u80fd\u4f1a\u5b58\u5728\u6837\u5f0f\u4e0d\u4e00\u81f4\u60c5\u51b5\u3002", (String)"DisclosureServiceHelper_13", (String)"epm-far-business", (Object[])new Object[0]);
        String noNametip = ResManager.loadKDString((String)"\u672a\u77e5", (String)"DisclosureServiceHelper_14", (String)"epm-far-business", (Object[])new Object[0]);
        tips.add(String.format(tip, saveEdit == null ? noNametip : saveEdit.getName(), curEdit == null ? noNametip : curEdit.getName()));
        return tips;
    }

    public static List<Map<String, Object>> convertToBookList(JSONArray itemList) {
        ArrayList<Map<String, Object>> bookmarkList = new ArrayList<Map<String, Object>>(2);
        for (Object item : itemList) {
            Map bookmarkMap;
            Map itemMap = (Map)item;
            if (itemMap == null) continue;
            String bookKey = "";
            if (itemMap.get("bookmark") != null && itemMap.get("bookmark") instanceof Map && (bookmarkMap = (Map)itemMap.get("bookmark")) != null) {
                bookKey = bookmarkMap.get("key") == null ? "" : bookmarkMap.get("key").toString();
            }
            HashMap<String, String> bookmark = new HashMap<String, String>(2);
            bookmark.put("itemId", itemMap.get("id") == null ? "" : itemMap.get("id").toString());
            bookmark.put("key", bookKey);
            bookmarkList.add(bookmark);
        }
        return bookmarkList;
    }

    public static JSONArray getItemListByNoDataResult(JSONArray itemList) {
        return itemList;
    }

    public static JSONObject convertVueToFile(JSONObject dataObj) {
        if (dataObj == null) {
            return null;
        }
        try {
            String fileName = String.valueOf(GlobalIdUtil.genGlobalLongId());
            ByteArrayInputStream byteIns = new ByteArrayInputStream(JSON.toJSONString((Object)dataObj).getBytes(StandardCharsets.UTF_8));
            String tempUrl = DisclosureFileHelper.uploadTempFile(byteIns, fileName, DisclosureFileHelper.getUrlPrefix(), ".json", 3600);
            tempUrl = DisclosureFileHelper.addTicket(tempUrl);
            return DisclosureVueHelper.convertToFile(dataObj.getString("dataType"), dataObj.getBoolean("designMode"), DisclosureDesignHelper.getI18n(), tempUrl);
        }
        catch (Exception ex) {
            logger.error("dm convertVueToFile fail", (Throwable)ex);
            return dataObj;
        }
    }
}

