/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.design;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.config.DMConfigServiceHelper;
import kd.epm.far.business.common.enums.DocumentFormType;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.design.DisclosureDesignHelper;
import kd.epm.far.business.fidm.design.dto.ChapterPreviewResult;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.perm.PermClassTemplateHelper;
import kd.epm.far.business.fidm.web.WebServiceHelper;
import kd.epm.far.business.fidm.wpsplugin.WpsPluginServiceHelper;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.cache.GlobalCacheServiceHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class DisclosurePageJumpHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosurePageJumpHelper.class);

    public static void openReportPage(IFormView view, Long reportId, Long modelId) {
        String openType = DMConfigServiceHelper.getAndCheckOpenWordEnum();
        if (openType.equals(OpenWordEnum.WPSPLUGIN.getType())) {
            DisclosurePageJumpHelper.openReportPageByWpsPlugin(view, reportId, modelId);
        } else {
            DisclosurePageJumpHelper.openReportPageByWeb(view, reportId, modelId);
        }
    }

    private static void openReportPageByWeb(IFormView view, Long reportId, Long modelId) {
        IFormView parentView = view.getParentView();
        String formId = "fidm_cat_webreport";
        String pageId = reportId + formId + GlobalIdUtil.genGlobalLongId();
        DynamicObject report = QueryServiceHelper.queryOne((String)"fidm_report", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)reportId).toArray());
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("reportId", reportId);
        customParams.put("appId", "fidm");
        customParams.put("KEY_MODEL_ID", modelId);
        customParams.put("dmmodelid", modelId);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCaption(report == null ? "" : report.getString("name"));
        formShowParameter.setPageId(pageId);
        if (parentView != null) {
            parentView.showForm(formShowParameter);
            view.sendFormAction(parentView);
        }
    }

    private static void openReportPageByWpsPlugin(IFormView view, Long reportId, Long modelId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("reportId", reportId);
        customParams.put("appId", "fidm");
        customParams.put("KEY_MODEL_ID", modelId);
        customParams.put("dmmodelid", modelId);
        customParams.put("documentFormType", DocumentFormType.RpeortPreview.getType());
        customParams.put("middlePagefields", String.join((CharSequence)",", customParams.keySet()));
        customParams.put("documentFormId", "fidm_cat_wpspluginreport");
        IFormView parentView = view.getParentView();
        String formId = "fidm_wpsplugin_middle";
        String pageId = formId + GlobalIdUtil.genGlobalLongId();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.ToolTips);
        formShowParameter.setPageId(pageId);
        if (parentView != null) {
            parentView.showForm(formShowParameter);
            view.sendFormAction(parentView);
        } else {
            formShowParameter.getOpenStyle().setShowType(ShowType.ToolTips);
            view.showForm(formShowParameter);
        }
    }

    public static void openEditPage(IFormView view, Long reportId, Long modelId) {
        String openType = DMConfigServiceHelper.getAndCheckOpenWordEnum();
        if (openType.equals(OpenWordEnum.WPSPLUGIN.getType())) {
            DisclosurePageJumpHelper.openEditPageByWpsPlugin(view, reportId, modelId);
        } else {
            DisclosurePageJumpHelper.openEditPageByWeb(view, reportId, modelId);
        }
    }

    private static void openEditPageByWeb(IFormView view, Long reportId, Long modelId) {
        IFormView parentView = view.getParentView();
        String formId = "fidm_webreport_edit";
        String pageId = reportId + formId + GlobalIdUtil.genGlobalLongId();
        String titleTips = ResManager.loadKDString((String)"\u7f16\u8f91", (String)"ReportListPlugin_25", (String)"epm-far-business", (Object[])new Object[0]);
        DynamicObject report = QueryServiceHelper.queryOne((String)"fidm_report", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)reportId).toArray());
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("reportId", reportId);
        customParams.put("appId", "fidm");
        customParams.put("KEY_MODEL_ID", modelId);
        customParams.put("dmmodelid", modelId);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCaption(report == null ? "" : report.getString("name") + "-" + titleTips);
        formShowParameter.setPageId(pageId);
        if (parentView != null) {
            parentView.showForm(formShowParameter);
            view.sendFormAction(parentView);
        } else {
            formShowParameter.getOpenStyle().setShowType(ShowType.NewWindow);
            view.showForm(formShowParameter);
        }
    }

    private static void openEditPageByWpsPlugin(IFormView view, Long reportId, Long modelId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("reportId", reportId);
        customParams.put("appId", "fidm");
        customParams.put("KEY_MODEL_ID", modelId);
        customParams.put("dmmodelid", modelId);
        customParams.put("documentFormType", DocumentFormType.RpeortEdit.getType());
        customParams.put("middlePagefields", String.join((CharSequence)",", customParams.keySet()));
        customParams.put("documentFormId", "fidm_wpspluginreport_edit");
        IFormView parentView = view.getParentView();
        String formId = "fidm_wpsplugin_middle";
        String pageId = formId + GlobalIdUtil.genGlobalLongId();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.ToolTips);
        formShowParameter.setPageId(pageId);
        if (parentView != null) {
            parentView.showForm(formShowParameter);
            view.sendFormAction(parentView);
        } else {
            formShowParameter.getOpenStyle().setShowType(ShowType.ToolTips);
            view.showForm(formShowParameter);
        }
    }

    public static void showTemplateEdit(IFormView view, Long modelId, Long templateId) {
        String opentemplate = (String)GlobalCacheServiceHelper.getCommonCache().getIfPresent(CacheKey.BasePrefixString + "_opentemplate_" + templateId);
        if ("0".equalsIgnoreCase(opentemplate)) {
            GlobalCacheServiceHelper.getCommonCache().invalidateStartsWithKey(CacheKey.BasePrefixString + "_opentemplate_" + templateId);
            return;
        }
        String msg = "";
        String permClass = PermClassTemplateHelper.getTemplatePerm(templateId);
        if (PermClassBaseHelper.isNoPerm(permClass)) {
            msg = ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u677f\u65e0\u6743\u9650\u6216\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u9000\u51fa\u91cd\u8fdb\u3002", (String)"DisclosurePermClass_0", (String)"epm-far-business", (Object[])new Object[0]);
            view.showTipNotification(msg);
            return;
        }
        String openType = DMConfigServiceHelper.getAndCheckOpenWordEnum();
        if (openType.equals(OpenWordEnum.WPSPLUGIN.getType())) {
            DisclosurePageJumpHelper.showTemplateEditByWpsPlugin(view, modelId, templateId);
        } else {
            DisclosurePageJumpHelper.showTemplateEditByWeb(view, modelId, templateId);
        }
    }

    public static void showTemplateEditByWeb(IFormView view, Long modelId, Long templateId) {
        DynamicObject templateDy = QueryServiceHelper.queryOne((String)"fidm_template", (String)"id, name, number", (QFilter[])new QFilter("id", "=", (Object)templateId).toArray());
        if (templateDy == null) {
            return;
        }
        IFormView parentView = view.getParentView();
        String formId = "fidm_webdesign";
        String pageId = templateId + formId + GlobalIdUtil.genGlobalLongId();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("templateId", templateDy.get("id"));
        customParams.put("KEY_MODEL_ID", modelId);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCaption(templateDy.getString("name"));
        formShowParameter.setPageId(pageId);
        if (parentView != null) {
            parentView.showForm(formShowParameter);
            view.sendFormAction(parentView);
        } else {
            formShowParameter.getOpenStyle().setShowType(ShowType.NewWindow);
            view.showForm(formShowParameter);
        }
    }

    private static void showTemplateEditByWpsPlugin(IFormView view, Long modelId, Long templateId) {
        DynamicObject templateDy = QueryServiceHelper.queryOne((String)"fidm_template", (String)"id, name, number", (QFilter[])new QFilter("id", "=", (Object)templateId).toArray());
        if (templateDy == null) {
            return;
        }
        DisclosureDesignHelper.initTemplateDefaultChapter(templateId, OpenWordEnum.WPSPLUGIN);
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("templateId", templateDy.get("id"));
        customParams.put("number", templateDy.getString("number"));
        customParams.put("fileName", templateDy.getString("name"));
        customParams.put("appId", "fidm");
        customParams.put("KEY_MODEL_ID", modelId);
        customParams.put("documentFormType", DocumentFormType.DesginEdit.getType());
        customParams.put("middlePagefields", String.join((CharSequence)",", customParams.keySet()));
        customParams.put("documentFormId", "fidm_wpsplugindesign");
        IFormView parentView = view.getParentView();
        String formId = "fidm_wpsplugin_middle";
        String pageId = formId + GlobalIdUtil.genGlobalLongId();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.ToolTips);
        formShowParameter.setPageId(pageId);
        if (parentView != null) {
            parentView.showForm(formShowParameter);
            view.sendFormAction(parentView);
        } else {
            formShowParameter.getOpenStyle().setShowType(ShowType.ToolTips);
            view.showForm(formShowParameter);
        }
    }

    public static void preview(IFormView view, Long dmModelId, ChapterPreviewResult previewResult) {
        if (previewResult == null) {
            return;
        }
        String openType = DMConfigServiceHelper.getAndCheckOpenWordEnum();
        if (openType.equals(OpenWordEnum.WPSPLUGIN.getType())) {
            String docUrl = previewResult.getPreviewUrl();
            if (StringUtils.isEmpty((String)docUrl)) {
                return;
            }
            String url = DisclosureFileHelper.addToken(docUrl);
            WpsPluginServiceHelper.previewByUrl(view, dmModelId, previewResult.getTitle(), url);
        } else {
            WebServiceHelper.previewByUrl(view, "fidm", dmModelId, previewResult);
        }
    }
}

