/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.design;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.enums.PreviewFormType;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.thread.ThreadPoolService;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.design.dto.ChapterPreviewResult;
import kd.epm.far.business.fidm.design.dto.PreviewInput;
import kd.epm.far.business.fidm.design.dto.PreviewResult;
import kd.epm.far.business.fidm.design.preview.DisclosurePreviewExpressionHelper;
import kd.epm.far.business.fidm.design.preview.DisclosurePreviewHelper;
import kd.epm.far.business.fidm.design.preview.DisclosurePreviewModuleHelper;
import kd.epm.far.business.fidm.html.dto.HtmlNode;
import kd.epm.far.business.fidm.html.dto.HtmlPreviewNode;
import kd.epm.far.business.fidm.perm.PermClassTemplateHelper;
import kd.epm.far.business.fidm.task.dto.TaskMessage;
import kd.epm.far.business.fidm.template.DisclosureTemplateHelper;
import kd.epm.far.business.fidm.web.WebPluginExpressionHelper;
import kd.epm.far.business.fidm.web.WebPluginModuleReplaceHelper;
import kd.epm.far.business.fidm.word.MergeDocUtils;
import kd.epm.far.business.fidm.word.dto.MergeDocFileItem;
import kd.epm.far.business.fidm.word.helper.WordBookmarkHelper;
import kd.epm.far.business.fidm.wpsplugin.WpsPluginModuleReplaceHelper;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.cache.GlobalCacheServiceHelper;
import kd.epm.far.common.common.lock.LockKeyFactory;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class DisclosurePreviewService {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosurePreviewService.class);
    private static final String ChapterSelectFieldString = "id,number,url,name,previewurl,entryentity.key,entryentity.module,entryentity.module.type,entryentity.module.number,entryentity.module.name,entryentity.module.properties";
    private static final Double MaxProcessValue = 10000.0;

    private static String createCacheStartKey() {
        StringBuilder cacheStartKey = new StringBuilder();
        cacheStartKey.append(CacheKey.PreviewPrefixString);
        cacheStartKey.append(GlobalIdUtil.genGlobalLongId());
        return cacheStartKey.toString();
    }

    private static void clearCacheStartKey(String cacheStartKey) {
        if (StringUtils.isEmpty((String)cacheStartKey)) {
            return;
        }
        try {
            LockKeyFactory.getLocalLock().invalidateStartsWithKey(cacheStartKey);
        }
        catch (Exception ex) {
            logger.error("dm LocalLock clear fail", (Throwable)ex);
        }
        try {
            GlobalCacheServiceHelper.getCommonCache().invalidateStartsWithKey(cacheStartKey);
        }
        catch (Exception ex) {
            logger.error("dm CommonCache clear fail", (Throwable)ex);
        }
    }

    private static PreviewResult preview(PreviewInput previewInput, boolean createWord, boolean createHtml, Consumer<TaskMessage> taskConsumer, Double taskAllIns) {
        Tuple<String, HtmlNode> epressionResult;
        HtmlNode sourceHtmlNode = null;
        if (createHtml) {
            sourceHtmlNode = WebPluginExpressionHelper.getHtmlNode(previewInput);
        }
        if ((epressionResult = DisclosurePreviewExpressionHelper.excute(previewInput, createWord, sourceHtmlNode, taskConsumer, taskAllIns * 0.4)) != null) {
            if (StringUtils.isNotEmpty((String)((String)epressionResult.item1))) {
                previewInput.setDocUrl((String)epressionResult.item1);
                previewInput.setDocUrlIsTempFile(true);
            }
            if (epressionResult.item2 != null) {
                sourceHtmlNode = (HtmlNode)epressionResult.item2;
            }
        }
        Map<String, JSONObject> moduleCalResult = DisclosurePreviewModuleHelper.excute(previewInput, taskConsumer, taskAllIns * 0.4);
        PreviewResult previewResult = new PreviewResult();
        previewResult.setInput(previewInput);
        if (createWord) {
            Tuple<String, Boolean> urlResult = WpsPluginModuleReplaceHelper.excute(previewInput, moduleCalResult, taskConsumer, taskAllIns * 0.1);
            previewResult.setPreviewUrl((String)urlResult.item1);
            previewResult.setTempFile((Boolean)urlResult.item2);
        }
        if (sourceHtmlNode != null) {
            HtmlPreviewNode htmlPreviewNode = WebPluginModuleReplaceHelper.excute(previewInput, sourceHtmlNode, taskConsumer, taskAllIns * 0.1);
            previewResult.setHtmlPreviewNode(htmlPreviewNode);
        }
        return previewResult;
    }

    private static boolean needCreateHtml(String openWordEnumType) {
        OpenWordEnum openWordEnum = OpenWordEnum.getByType(openWordEnumType);
        return openWordEnum == null || OpenWordEnum.WEB.getType().equals(openWordEnum.getType());
    }

    public static ChapterPreviewResult chapterPreview(Long dmModelId, Long templateId, Long chapterId, List<JSONObject> moduleList, Map<String, DimMemberInfo> memberMap, String userName, boolean randFileName, String urlPrefix, String openWordEnumType, Consumer<TaskMessage> taskConsumer) {
        List<DimensionInfo> dimList = DisclosurePreviewHelper.getDimList(dmModelId, memberMap);
        DynamicObject templateDy = DisclosureTemplateHelper.getTemplate(templateId);
        DisclosurePreviewHelper.setTemplateDimDefaultMember(dmModelId, templateId, dimList);
        DynamicObject chapter = DisclosurePreviewHelper.getChapter(chapterId);
        String docUrl = chapter.getString("url");
        String chapterName = chapter.getString("name");
        String tilte = templateDy.getString("name") + "-" + chapterName;
        String fileName = chapterName;
        if (randFileName) {
            fileName = DisclosureFileHelper.getRandFileName(tilte, null, false);
        }
        PreviewInput reportPreviewDto = new PreviewInput();
        reportPreviewDto.setPreviewFormType(PreviewFormType.ChapterRepository.getType());
        reportPreviewDto.setPreview(true);
        reportPreviewDto.setDmModelId(dmModelId);
        reportPreviewDto.setTemplateId(templateId);
        reportPreviewDto.setChapterId(chapterId);
        reportPreviewDto.setDimensionInfos(dimList);
        reportPreviewDto.setModuleList(moduleList);
        reportPreviewDto.setDocUrl(docUrl);
        reportPreviewDto.setDocUrlIsTempFile(false);
        reportPreviewDto.setFileName(fileName);
        reportPreviewDto.setUrlPrefix(urlPrefix);
        reportPreviewDto.setModifyName(userName);
        reportPreviewDto.setOpenWordEnumType(openWordEnumType);
        reportPreviewDto.setCacheStartKey(DisclosurePreviewService.createCacheStartKey());
        boolean isNeedHtml = DisclosurePreviewService.needCreateHtml(openWordEnumType);
        PreviewResult previewResult = DisclosurePreviewService.preview(reportPreviewDto, !isNeedHtml, isNeedHtml, taskConsumer, MaxProcessValue);
        ChapterPreviewResult chapterPreviewResult = DisclosurePreviewHelper.convertToReportResult(previewResult);
        chapterPreviewResult.setTitle(tilte);
        DisclosurePreviewHelper.savePreviewResult(chapterPreviewResult, chapterPreviewResult.getId());
        DisclosurePreviewService.clearCacheStartKey(reportPreviewDto.getCacheStartKey());
        return chapterPreviewResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChapterPreviewResult templatePreview(Long dmModelId, Long templateId, Map<String, DimMemberInfo> memberMap, String userName, boolean randFileName, String urlPrefix, String openWordEnumType, Consumer<TaskMessage> taskConsumer) {
        ChapterPreviewResult result = new ChapterPreviewResult();
        ArrayList<MergeDocFileItem> fileItems = new ArrayList<MergeDocFileItem>(result.getPreviewResults().size());
        DynamicObject templateDy = DisclosureTemplateHelper.getTemplate(templateId);
        String tilte = templateDy.getString("name");
        List<Long> chapterIds = PermClassTemplateHelper.getValiadChaptersByTemplate(dmModelId, templateId);
        QFBuilder qf = new QFBuilder("model", "=", (Object)dmModelId);
        qf.and("template", "=", (Object)templateId);
        qf.and("id", "in", chapterIds);
        DynamicObject[] chapters = BusinessDataServiceHelper.load((String)"fidm_chapter", (String)ChapterSelectFieldString, (QFilter[])qf.toArray(), (String)"sequence");
        List<DimensionInfo> dimList = DisclosurePreviewHelper.getDimList(dmModelId, memberMap);
        DisclosurePreviewHelper.setTemplateDimDefaultMember(dmModelId, templateId, dimList);
        String cacheStartKey = DisclosurePreviewService.createCacheStartKey();
        boolean isNeedHtml = DisclosurePreviewService.needCreateHtml(openWordEnumType);
        Double processValue = MaxProcessValue;
        if (chapters.length > 0) {
            Double chapterProcessValue = processValue / (double)chapters.length;
            int index = 0;
            CountDownLatch latch = new CountDownLatch(chapters.length);
            for (DynamicObject chapter : chapters) {
                ++index;
                String docUrl = chapter.getString("url");
                if (StringUtils.isEmpty((String)docUrl)) {
                    DisclosurePreviewHelper.addProgressIns(taskConsumer, chapterProcessValue);
                    latch.countDown();
                    continue;
                }
                int finalIndex = index;
                ThreadPoolService.runInChapterPreviewThread(() -> {
                    try {
                        Long chapterId = chapter.getLong("id");
                        String chapterName = chapter.getString("name");
                        List<JSONObject> moduleList = DisclosurePreviewHelper.getModuleList(dmModelId, chapter);
                        PreviewInput reportPreviewDto = new PreviewInput();
                        reportPreviewDto.setPreviewFormType(PreviewFormType.Template.getType());
                        reportPreviewDto.setPreview(true);
                        reportPreviewDto.setDmModelId(dmModelId);
                        reportPreviewDto.setTemplateId(templateId);
                        reportPreviewDto.setChapterId(chapterId);
                        reportPreviewDto.setDimensionInfos(dimList);
                        reportPreviewDto.setModuleList(moduleList);
                        reportPreviewDto.setDocUrl(docUrl);
                        reportPreviewDto.setDocUrlIsTempFile(false);
                        reportPreviewDto.setFileName(chapterName + "_Preview");
                        reportPreviewDto.setUrlPrefix(urlPrefix);
                        reportPreviewDto.setModifyName(userName);
                        reportPreviewDto.setOpenWordEnumType(openWordEnumType);
                        reportPreviewDto.setCacheStartKey(cacheStartKey);
                        PreviewResult item = DisclosurePreviewService.preview(reportPreviewDto, !isNeedHtml, isNeedHtml, taskConsumer, chapterProcessValue);
                        item.setSeq(finalIndex);
                        result.getPreviewResults().add(item);
                        MergeDocFileItem fileItem = new MergeDocFileItem();
                        fileItem.setTempFile(item.getTempFile());
                        fileItem.setUrl(item.getPreviewUrl());
                        fileItem.setName(chapterName);
                        fileItem.setSeq(finalIndex);
                        fileItems.add(fileItem);
                        latch.countDown();
                    }
                    catch (Exception e) {
                        latch.countDown();
                        logger.error("DM ThreadPoolService.runInChapterPreviewThread error", (Throwable)e);
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                logger.error("DM ThreadPoolService.runInChapterPreviewThread Interrupted", (Throwable)e);
            }
        }
        if (result.getPreviewResults().size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ae0\u8282\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u5148\u4fdd\u5b58\u7ae0\u8282\u3002", (String)"AbstractDesignPlugin_8", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DisclosurePreviewHelper.savePreviewResult(result, result.getId());
        DisclosurePreviewService.clearCacheStartKey(cacheStartKey);
        if (result.getPreviewResults().size() == 1) {
            ChapterPreviewResult singgleResult = DisclosurePreviewHelper.convertToReportResult(result.getPreviewResults().get(0));
            singgleResult.setTitle(tilte);
            return singgleResult;
        }
        try {
            if (!isNeedHtml) {
                String fileName = templateDy.getString("name");
                if (randFileName) {
                    fileName = DisclosureFileHelper.getRandFileName(tilte, null, false);
                }
                ArrayList<String> tips = new ArrayList<String>(16);
                byte[] fileData = MergeDocUtils.merge(fileItems, tips);
                ByteArrayInputStream finalInputStream = new ByteArrayInputStream(fileData);
                String url = DisclosureFileHelper.uploadTempFile(finalInputStream, fileName, urlPrefix);
                result.setTempFile(true);
                result.setPreviewUrl(url);
                result.setTips(tips);
            }
            result.setTitle(tilte);
        }
        catch (KDBizException kdEx) {
            throw kdEx;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return result;
    }

    public static ChapterPreviewResult chapterRepositoryPreview(Long dmModelId, Long chapterId, Map<String, DimMemberInfo> memberMap, String userName, boolean randFileName, String urlPrefix, String openWordEnumType, Consumer<TaskMessage> taskConsumer) {
        List<DimensionInfo> dimList = DisclosurePreviewHelper.getDimList(dmModelId, memberMap);
        DynamicObject chapter = DisclosurePreviewHelper.getChapter(chapterId);
        String docUrl = chapter.getString("url");
        String chapterName = chapter.getString("name");
        List<JSONObject> moduleList = DisclosurePreviewHelper.getModuleList(dmModelId, chapter);
        String fileName = chapterName;
        if (randFileName) {
            fileName = DisclosureFileHelper.getRandFileName(fileName, null, false);
        }
        PreviewInput reportPreviewDto = new PreviewInput();
        reportPreviewDto.setPreviewFormType(PreviewFormType.ChapterRepository.getType());
        reportPreviewDto.setPreview(true);
        reportPreviewDto.setDmModelId(dmModelId);
        reportPreviewDto.setChapterId(chapterId);
        reportPreviewDto.setDimensionInfos(dimList);
        reportPreviewDto.setModuleList(moduleList);
        reportPreviewDto.setDocUrl(docUrl);
        reportPreviewDto.setDocUrlIsTempFile(false);
        reportPreviewDto.setFileName(fileName);
        reportPreviewDto.setUrlPrefix(urlPrefix);
        reportPreviewDto.setModifyName(userName);
        reportPreviewDto.setOpenWordEnumType(openWordEnumType);
        reportPreviewDto.setCacheStartKey(DisclosurePreviewService.createCacheStartKey());
        boolean isNeedHtml = DisclosurePreviewService.needCreateHtml(openWordEnumType);
        PreviewResult previewResult = DisclosurePreviewService.preview(reportPreviewDto, !isNeedHtml, isNeedHtml, taskConsumer, MaxProcessValue);
        ChapterPreviewResult result = DisclosurePreviewHelper.convertToReportResult(previewResult);
        result.setTitle(chapterName);
        DisclosurePreviewHelper.savePreviewResult(result, result.getId());
        DisclosurePreviewService.clearCacheStartKey(reportPreviewDto.getCacheStartKey());
        return result;
    }

    public static ChapterPreviewResult modulePreview(Long dmModelId, JSONObject module, Map<String, DimMemberInfo> memberMap, String userName, boolean randFileName, String urlPrefix, String openWordEnumType, Consumer<TaskMessage> taskConsumer) {
        List<DimensionInfo> dimList = DisclosurePreviewHelper.getDimList(dmModelId, memberMap);
        if (module == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u4ef6\u4e0d\u5b58\u5728", (String)"DisclosureServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        Long moduleId = module.getLong("id");
        String moduleName = module.getString("name");
        module.put("name", (Object)"component01");
        if (module != null && module.getJSONObject("bookmark") == null) {
            WordBookmarkHelper.createBookmarkNode(module, "module01");
        }
        String fileName = moduleId.toString();
        if (randFileName) {
            fileName = DisclosureFileHelper.getRandFileName(fileName, null, false);
        }
        String docUrl = DisclosureFileHelper.uploadModuleTempFile(fileName, urlPrefix);
        List<JSONObject> moduleList = Collections.singletonList(module);
        PreviewInput reportPreviewDto = new PreviewInput();
        reportPreviewDto.setPreviewFormType(PreviewFormType.ModuleRepository.getType());
        reportPreviewDto.setPreview(true);
        reportPreviewDto.setDmModelId(dmModelId);
        reportPreviewDto.setChapterId(0L);
        reportPreviewDto.setModuleId(moduleId);
        reportPreviewDto.setDimensionInfos(dimList);
        reportPreviewDto.setModuleList(moduleList);
        reportPreviewDto.setDocUrl(docUrl);
        reportPreviewDto.setDocUrlIsTempFile(true);
        reportPreviewDto.setFileName(fileName);
        reportPreviewDto.setUrlPrefix(urlPrefix);
        reportPreviewDto.setModifyName(userName);
        reportPreviewDto.setOpenWordEnumType(openWordEnumType);
        reportPreviewDto.setCacheStartKey(DisclosurePreviewService.createCacheStartKey());
        boolean isNeedHtml = DisclosurePreviewService.needCreateHtml(openWordEnumType);
        PreviewResult previewResult = DisclosurePreviewService.preview(reportPreviewDto, !isNeedHtml, isNeedHtml, taskConsumer, MaxProcessValue);
        ChapterPreviewResult result = DisclosurePreviewHelper.convertToReportResult(previewResult);
        result.setTitle(moduleName);
        DisclosurePreviewHelper.savePreviewResult(result, result.getId());
        DisclosurePreviewService.clearCacheStartKey(reportPreviewDto.getCacheStartKey());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChapterPreviewResult reportGeneral(Long dmModelId, Long reportId, Map<String, DimMemberInfo> memberMap, Consumer<TaskMessage> taskConsumer, int reportCount) {
        ChapterPreviewResult result = new ChapterPreviewResult();
        ArrayList<MergeDocFileItem> fileItems = new ArrayList<MergeDocFileItem>(result.getPreviewResults().size());
        ArrayList<Long> chapterIds = new ArrayList<Long>(100);
        DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        if (report == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6211\u7684\u62a5\u544a\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DisclosureServiceHelper_8", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String tilte = report.getString("name");
        String creatorName = report.getString("creator.name");
        DynamicObjectCollection entryEntitys = report.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntitys) {
            chapterIds.add(entry.getLong("chapter.id"));
        }
        if (chapterIds.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ae0\u8282\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u5148\u4fdd\u5b58\u7ae0\u8282\u3002", (String)"AbstractDesignPlugin_8", (String)"epm-far-business", (Object[])new Object[0]));
        }
        QFBuilder qf = new QFBuilder("model", "=", (Object)dmModelId);
        qf.and("id", "in", chapterIds);
        DynamicObject[] chapters = BusinessDataServiceHelper.load((String)"fidm_chapter", (String)ChapterSelectFieldString, (QFilter[])qf.toArray(), (String)"sequence");
        List<DimensionInfo> dimList = DisclosurePreviewHelper.getDimList(dmModelId, memberMap);
        DisclosurePreviewHelper.setTemplateDimDefaultMember(dmModelId, report.getLong("template.id"), dimList);
        String cacheStartKey = DisclosurePreviewService.createCacheStartKey();
        Double processValue = reportCount <= 1 ? MaxProcessValue : MaxProcessValue / (double)reportCount;
        if (chapters.length > 0) {
            Double chapterProcessValue = processValue / (double)chapters.length;
            CountDownLatch latch = new CountDownLatch(chapters.length);
            int index = 0;
            for (DynamicObject chapter : chapters) {
                ++index;
                String docUrl = chapter.getString("url");
                if (StringUtils.isEmpty((String)docUrl)) {
                    DisclosurePreviewHelper.addProgressIns(taskConsumer, chapterProcessValue);
                    latch.countDown();
                    continue;
                }
                int finalIndex = index;
                ThreadPoolService.runInChapterPreviewThread(() -> {
                    try {
                        Long chapterId = chapter.getLong("id");
                        String chapterName = chapter.getString("name");
                        List<JSONObject> moduleList = DisclosurePreviewHelper.getModuleList(dmModelId, chapter);
                        PreviewInput reportPreviewDto = new PreviewInput();
                        reportPreviewDto.setPreviewFormType(PreviewFormType.ReportGeneral.getType());
                        reportPreviewDto.setPreview(false);
                        reportPreviewDto.setDmModelId(dmModelId);
                        reportPreviewDto.setReportId(reportId);
                        reportPreviewDto.setChapterId(chapterId);
                        reportPreviewDto.setDimensionInfos(dimList);
                        reportPreviewDto.setModuleList(moduleList);
                        reportPreviewDto.setDocUrl(docUrl);
                        reportPreviewDto.setDocUrlIsTempFile(false);
                        reportPreviewDto.setFileName(chapterName + "_Preview");
                        reportPreviewDto.setUrlPrefix("");
                        reportPreviewDto.setModifyName(creatorName);
                        reportPreviewDto.setOpenWordEnumType(OpenWordEnum.WEB.getType());
                        reportPreviewDto.setCacheStartKey(cacheStartKey);
                        PreviewResult item = DisclosurePreviewService.preview(reportPreviewDto, true, true, taskConsumer, chapterProcessValue);
                        item.setSeq(finalIndex);
                        result.getPreviewResults().add(item);
                        MergeDocFileItem fileItem = new MergeDocFileItem();
                        fileItem.setTempFile(item.getTempFile());
                        fileItem.setUrl(item.getPreviewUrl());
                        fileItem.setName(chapterName);
                        fileItem.setSeq(finalIndex);
                        fileItems.add(fileItem);
                        latch.countDown();
                    }
                    catch (Exception e) {
                        latch.countDown();
                        logger.error("DM ThreadPoolService.runInChapterPreviewThread2 error", (Throwable)e);
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                logger.error("DM ThreadPoolService.runInChapterPreviewThread2 Interrupted", (Throwable)e);
            }
        }
        if (result.getPreviewResults().size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ae0\u8282\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u5148\u4fdd\u5b58\u7ae0\u8282\u3002", (String)"AbstractDesignPlugin_8", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DisclosurePreviewHelper.savePreviewResult(result, reportId);
        DisclosurePreviewService.clearCacheStartKey(cacheStartKey);
        if (result.getPreviewResults().size() == 1) {
            return DisclosurePreviewHelper.convertToReportResult(result.getPreviewResults().get(0));
        }
        try {
            ArrayList<String> tips = new ArrayList<String>(16);
            byte[] fileData = MergeDocUtils.merge(fileItems, tips);
            ByteArrayInputStream finalInputStream = new ByteArrayInputStream(fileData);
            String url = DisclosureFileHelper.saveAsNew(finalInputStream, "fidm", "fidm_webpreview", reportId, tilte);
            result.setTempFile(false);
            result.setPreviewUrl(url);
            result.setTips(tips);
            result.setTitle(tilte);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return result;
    }
}

