/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.design.preview;

import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.expression.base.ExpressionDsFlagEnum;
import kd.epm.far.business.common.expression.calculate.ExpressionCalculateService;
import kd.epm.far.business.common.expression.dto.ExpressionInput;
import kd.epm.far.business.common.expression.dto.ExpressionResult;
import kd.epm.far.business.common.thread.ThreadPoolService;
import kd.epm.far.business.fidm.design.dto.PreviewInput;
import kd.epm.far.business.fidm.design.dto.expression.PreviewExpressionGroup;
import kd.epm.far.business.fidm.design.dto.expression.PreviewExpressionItem;
import kd.epm.far.business.fidm.design.preview.DisclosurePreviewHelper;
import kd.epm.far.business.fidm.html.dto.HtmlNode;
import kd.epm.far.business.fidm.task.dto.TaskMessage;
import kd.epm.far.business.fidm.web.WebPluginExpressionHelper;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordRootNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellNode;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTableRowNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import kd.epm.far.business.fidm.wpsplugin.WpsPluginExpressionHelper;
import kd.epm.far.business.fidm.wpsplugin.dto.WpsPluginExpressionResetInput;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class DisclosurePreviewExpressionHelper {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosurePreviewExpressionHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static kd.bos.dataentity.Tuple<String, HtmlNode> excute(PreviewInput previewInput, boolean createWord, HtmlNode sourceHtmlNode, Consumer<TaskMessage> taskConsumer, Double taskAllIns) {
        Object rootNode;
        ArrayList<PreviewExpressionGroup> expressionGroups = new ArrayList<PreviewExpressionGroup>(100);
        NiceXWPFDocument wordDocumemnt = null;
        ArrayList<Object> rootNodeList = new ArrayList<Object>(2);
        if (createWord) {
            Tuple<WordRootNode, NiceXWPFDocument, String> wordData = WpsPluginExpressionHelper.getWordData(previewInput);
            wordDocumemnt = (NiceXWPFDocument)wordData.p2;
            WordRootNode wordRootNode = (WordRootNode)wordData.p1;
            if (wordRootNode != null) {
                rootNodeList.add(wordRootNode);
            }
        }
        if (sourceHtmlNode != null && (rootNode = WebPluginExpressionHelper.getHtmlData(sourceHtmlNode)) != null) {
            rootNodeList.add(rootNode);
        }
        for (WordRootNode wordRootNode : rootNodeList) {
            for (WordNode wordNode : wordRootNode.getChilds()) {
                PreviewExpressionGroup expressionInput;
                if (wordNode instanceof WordTableNode) {
                    expressionInput = DisclosurePreviewExpressionHelper.getTableInput(wordNode);
                    if (expressionInput == null || expressionInput.getItems().size() <= 0) continue;
                    expressionGroups.add(expressionInput);
                    continue;
                }
                if (!(wordNode instanceof WordParagraphNode) || (expressionInput = DisclosurePreviewExpressionHelper.getWordInput(wordNode)) == null || expressionInput.getItems().size() <= 0) continue;
                expressionGroups.add(expressionInput);
            }
        }
        Set<String> expressionStrList = DisclosurePreviewExpressionHelper.getExpressionList(expressionGroups);
        if (expressionGroups.isEmpty()) {
            DisclosurePreviewHelper.addProgressIns(taskConsumer, taskAllIns);
            return null;
        }
        Double d = taskAllIns / (double)expressionStrList.size();
        HashMap<String, ExpressionResult> expressionMap = new HashMap<String, ExpressionResult>(expressionStrList.size());
        String cacheStartKeyStr = previewInput.getCacheStartKey();
        CountDownLatch latch = new CountDownLatch(expressionStrList.size());
        for (String expression : expressionStrList) {
            ThreadPoolService.runInExpressionCalculateThread(() -> {
                try {
                    ExpressionInput expressionInput = new ExpressionInput();
                    expressionInput.setDmModelId(previewInput.getDmModelId());
                    expressionInput.setChapterId(previewInput.getChapterId());
                    expressionInput.setDimensionInfos(previewInput.getDimensionInfos());
                    expressionInput.setSource(expression);
                    expressionInput.setCacheStartKey(cacheStartKeyStr);
                    ExpressionCalculateService expressionCalculateService = new ExpressionCalculateService();
                    ExpressionResult result = expressionCalculateService.getResult(expressionInput);
                    if (result != null && result.getResult() != null) {
                        expressionMap.put(expression, result);
                    }
                    DisclosurePreviewHelper.addProgressIns(taskConsumer, taskIns);
                    latch.countDown();
                }
                catch (Exception e) {
                    latch.countDown();
                    logger.error("DM ThreadPoolService.runInExpressionCalculateThread error", (Throwable)e);
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.error("DM ThreadPoolService.runInExpressionCalculateThread Interrupted", (Throwable)e);
        }
        if (expressionMap.size() == 0) {
            return null;
        }
        String newDocTempUrl = null;
        if (createWord) {
            WpsPluginExpressionResetInput expressionResetInput = new WpsPluginExpressionResetInput();
            expressionResetInput.setFileName(previewInput.getFileName());
            expressionResetInput.setUrlPrefix(previewInput.getUrlPrefix());
            expressionResetInput.setWordDocumemnt(wordDocumemnt);
            expressionResetInput.setExpressionMap(expressionMap);
            newDocTempUrl = WpsPluginExpressionHelper.resetWordData(expressionResetInput);
        }
        HtmlNode newSourceHtmlNode = null;
        if (sourceHtmlNode != null) {
            newSourceHtmlNode = WebPluginExpressionHelper.resetHtmlData(sourceHtmlNode, expressionMap);
        }
        return new kd.bos.dataentity.Tuple(newDocTempUrl, (Object)newSourceHtmlNode);
    }

    private static Set<String> getExpressionList(List<PreviewExpressionGroup> expressionGroups) {
        HashSet<String> expressionList = new HashSet<String>(1000);
        for (PreviewExpressionGroup group : expressionGroups) {
            for (PreviewExpressionItem item : group.getItems()) {
                expressionList.add(item.getExpresstion());
            }
        }
        return expressionList;
    }

    private static PreviewExpressionGroup getTableInput(WordNode wordNode) {
        WordTableNode tableNode = (WordTableNode)wordNode;
        if (tableNode == null) {
            return null;
        }
        ArrayList<PreviewExpressionItem> allItemList = new ArrayList<PreviewExpressionItem>(100);
        for (WordNode wordRowNode : tableNode.getChilds()) {
            WordTableRowNode rowNode = (WordTableRowNode)wordRowNode;
            for (WordNode wordCellNode : rowNode.getChilds()) {
                WordTableCellNode cellNode = (WordTableCellNode)wordCellNode;
                ArrayList<String> expresstionStrs = new ArrayList<String>(10);
                StringBuilder cellContent = new StringBuilder();
                int sum = 0;
                for (WordNode wordParagraphNode : cellNode.getChilds()) {
                    WordParagraphNode paragraphNode = (WordParagraphNode)wordParagraphNode;
                    for (WordNode wordTextNode : paragraphNode.getChilds()) {
                        WordTextNode textNode;
                        if (!(wordTextNode instanceof WordTextNode) || !StringUtils.isNotEmpty((String)(textNode = (WordTextNode)wordTextNode).getContent())) continue;
                        if (ExpressionDsFlagEnum.containsDs(textNode.getContent()) != null) {
                            expresstionStrs.add(textNode.getContent());
                        }
                        cellContent.append(textNode.getContent());
                        ++sum;
                    }
                }
                List<PreviewExpressionItem> items = DisclosurePreviewExpressionHelper.createPreviewExpressionItems(expresstionStrs, cellContent.toString(), sum);
                if (items.size() <= 0) continue;
                allItemList.addAll(items);
            }
        }
        PreviewExpressionGroup tableItem = new PreviewExpressionGroup();
        tableItem.setType("1");
        tableItem.setItems(allItemList);
        return tableItem;
    }

    private static List<PreviewExpressionItem> createPreviewExpressionItems(List<String> expressionStrs, String allContent, int sum) {
        PreviewExpressionItem item;
        ArrayList<PreviewExpressionItem> items = new ArrayList<PreviewExpressionItem>(10);
        if (expressionStrs.size() == 0 && StringUtils.isEmpty((String)allContent)) {
            return items;
        }
        if (expressionStrs.size() == 1 && sum == 1 && (item = DisclosurePreviewExpressionHelper.createPreviewExpressionItem(expressionStrs.get(0))) != null) {
            item.setIndex(0);
            items.add(item);
            return items;
        }
        PreviewExpressionItem parent = DisclosurePreviewExpressionHelper.createPreviewExpressionItem(allContent);
        if (parent != null) {
            parent.setIndex(0);
            items.add(parent);
        }
        int index = 1;
        for (String expression : expressionStrs) {
            PreviewExpressionItem item2 = DisclosurePreviewExpressionHelper.createPreviewExpressionItem(expression);
            if (item2 == null) continue;
            item2.setIndex(index);
            if (parent != null) {
                item2.setParentId(parent.getId());
            }
            items.add(item2);
            ++index;
        }
        return items;
    }

    private static PreviewExpressionItem createPreviewExpressionItem(String content) {
        if (ExpressionDsFlagEnum.containsDs(content) == null) {
            return null;
        }
        PreviewExpressionItem item = new PreviewExpressionItem();
        item.setIndex(0);
        item.setExpresstion(content);
        return item;
    }

    private static PreviewExpressionGroup getWordInput(WordNode wordNode) {
        WordParagraphNode paragraphNode = (WordParagraphNode)wordNode;
        if (paragraphNode == null) {
            return null;
        }
        ArrayList<String> expresstionStrs = new ArrayList<String>(10);
        StringBuilder cellContent = new StringBuilder();
        int sum = 0;
        for (WordNode wordTextNode : paragraphNode.getChilds()) {
            WordTextNode textNode;
            if (!(wordTextNode instanceof WordTextNode) || !StringUtils.isNotEmpty((String)(textNode = (WordTextNode)wordTextNode).getContent())) continue;
            if (ExpressionDsFlagEnum.containsDs(textNode.getContent()) != null) {
                expresstionStrs.add(textNode.getContent());
            }
            cellContent.append(textNode.getContent());
            ++sum;
        }
        List<PreviewExpressionItem> items = DisclosurePreviewExpressionHelper.createPreviewExpressionItems(expresstionStrs, cellContent.toString(), sum);
        PreviewExpressionGroup tableItem = new PreviewExpressionGroup();
        tableItem.setType("0");
        tableItem.setItems(items);
        return tableItem;
    }
}

