/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.design.preview;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.WordDataType;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.design.dto.ChapterPreviewResult;
import kd.epm.far.business.fidm.design.dto.PreviewResult;
import kd.epm.far.business.fidm.design.dto.PreviewSaveResult;
import kd.epm.far.business.fidm.module.DisclosureOldModuleHelper;
import kd.epm.far.business.fidm.task.dto.TaskMessage;
import kd.epm.far.business.fidm.template.dto.DefaultDimensionEntry;
import kd.epm.far.business.fidm.template.dto.DiscTemplateModel;
import kd.epm.far.business.fidm.word.helper.WordBookmarkHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;

public class DisclosurePreviewHelper {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosurePreviewHelper.class);
    private static final String ChapterSelectFieldString = "id,number,url,name,previewurl,entryentity.key,entryentity.module,entryentity.module.type,entryentity.module.number,entryentity.module.name,entryentity.module.properties";
    private static final String ModuleSelectFieldString = "id,number,name,template.id,scope,copyfrom,properties,type";

    public static void savePreviewResult(ChapterPreviewResult previewResult, Long reportId) {
        if (previewResult == null || previewResult.getPreviewResults().size() == 0) {
            return;
        }
        Date date = new Date();
        List<PreviewResult> previewResults = previewResult.getPreviewResults();
        if (previewResults.size() > 1) {
            previewResults.sort(new Comparator<PreviewResult>(){

                @Override
                public int compare(PreviewResult o1, PreviewResult o2) {
                    return o1.getSeq() - o2.getSeq();
                }
            });
        }
        for (PreviewResult chapterResult : previewResults) {
            Long dmModelId = chapterResult.getInput().getDmModelId();
            Long chapterId = chapterResult.getInput().getChapterId();
            ArrayList<JSONObject> saveNewModules = new ArrayList<JSONObject>(2);
            Long moduleId = chapterResult.getInput().getModuleId();
            try {
                for (JSONObject module : chapterResult.getInput().getModuleList()) {
                    JSONObject formular = DisclosureJsonHelper.getJsonObject(module, "dataResult", "data", "formular");
                    if (formular != null) {
                        JSONObject dataResult = module.getJSONObject("dataResult");
                        if (dataResult != null && dataResult.getJSONObject("data") != null) {
                            dataResult.getJSONObject("data").remove((Object)"formular");
                        }
                        DisclosureJsonHelper.convertLongToStringFromJson(formular);
                        module.put("formular", (Object)formular);
                    }
                    saveNewModules.add(module);
                }
                PreviewSaveResult saveResult = new PreviewSaveResult();
                saveResult.setItemList(saveNewModules);
                saveResult.setDimensionInfos(chapterResult.getInput().getDimensionInfos());
                DynamicObject newHistory = BusinessDataServiceHelper.newDynamicObject((String)"fidm_word_history");
                newHistory.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                newHistory.set("model", (Object)dmModelId);
                newHistory.set("remark", (Object)"");
                newHistory.set("docid", (Object)"");
                newHistory.set("type", (Object)WordDataType.ReportResultJson.getType());
                newHistory.set("reportid", (Object)reportId);
                newHistory.set("chapterid", (Object)chapterId);
                newHistory.set("moduleid", (Object)moduleId);
                newHistory.set("creator", (Object)RequestContext.get().getCurrUserId());
                newHistory.set("createtime", (Object)date);
                newHistory.set("modifier", (Object)RequestContext.get().getCurrUserId());
                newHistory.set("modifytime", (Object)date);
                newHistory.set("downloadurl", (Object)chapterResult.getPreviewUrl());
                newHistory.set("content", (Object)JSONObject.toJSONString((Object)saveResult));
                newHistory.set("name", (Object)String.valueOf(GlobalIdUtil.genGlobalLongId()));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newHistory});
            }
            catch (Exception ex) {
                logger.error("saveReportResultToHistory fail", (Throwable)ex);
            }
        }
    }

    public static List<DimensionInfo> getDimList(Long dmModelId, Map<String, DimMemberInfo> memberMap) {
        List<DimensionInfo> dimList = new ModelStrategyEx(dmModelId).getDim().getDimList();
        ArrayList<DimensionInfo> result = new ArrayList<DimensionInfo>(dimList.size());
        for (Map.Entry<String, DimMemberInfo> item : memberMap.entrySet()) {
            DimensionInfo find = DimensionUtils.getDimByNumber(dimList, item.getKey());
            if (find == null) continue;
            find.setMembers(Collections.singletonList(item.getValue()));
            result.add(find);
        }
        return result;
    }

    public static void setTemplateDimDefaultMember(Long dmModelId, Long templateId, List<DimensionInfo> dimDefaultList) {
        if (!LongUtil.isvalidLong((Object)templateId) || dimDefaultList == null) {
            return;
        }
        DiscTemplateModel discTemplateModel = DiscTemplateModel.genTemplateModelById(templateId);
        if (discTemplateModel == null) {
            return;
        }
        List<DimensionInfo> dimList = new ModelStrategyEx(dmModelId).getDim().getDimList();
        for (DefaultDimensionEntry p : discTemplateModel.getDefaultDimensionEntries()) {
            DimensionInfo dimensionInfo;
            DimensionInfo find;
            if (p.getMember() == null || p.getMember().getId() <= 0L || (find = DimensionUtils.getDimByNumber(dimDefaultList, p.getDimension().getNumber())) != null || (dimensionInfo = DimensionUtils.getDimByNumber(dimList, p.getDimension().getNumber())) == null) continue;
            DimMemberInfo memberInfo = new DimMemberInfo();
            memberInfo.setId(p.getMember().getId());
            memberInfo.setNumber(p.getMember().getNumber());
            memberInfo.setName(p.getMember().getName());
            dimensionInfo.setMembers(Collections.singletonList(memberInfo));
            dimDefaultList.add(dimensionInfo);
        }
    }

    public static DynamicObject getChapter(Long chapterId) {
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter", (String)ChapterSelectFieldString);
        if (chapter == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ae0\u8282\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DisclosureServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String docUrl = chapter.getString("url");
        if (StringUtils.isEmpty((String)docUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ae0\u8282\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u5148\u4fdd\u5b58\u7ae0\u8282\u3002", (String)"AbstractDesignPlugin_8", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return chapter;
    }

    public static List<JSONObject> getModuleList(Long dmModelId, DynamicObject chapter) {
        ArrayList<JSONObject> moduleList = new ArrayList<JSONObject>(1000);
        DynamicObjectCollection entryentity = chapter.getDynamicObjectCollection("entryentity");
        List moduleIds = entryentity.stream().map(m -> m.getLong("module.id")).collect(Collectors.toList());
        DynamicObjectCollection modules = QueryServiceHelper.query((String)"fidm_modulerepository", (String)ModuleSelectFieldString, (QFilter[])new QFilter("id", "in", (Object)moduleIds.toArray()).toArray());
        for (DynamicObject moduleDy : modules) {
            String moduleId = moduleDy.getString("id");
            String moduleNumber = moduleDy.getString("number");
            String moduleName = moduleDy.getString("name");
            String modulePropertiesStr = moduleDy.getString("properties");
            HashMap<String, Object> moduleMap = new HashMap<String, Object>(2);
            moduleMap.put("id", moduleId);
            moduleMap.put("number", moduleNumber);
            moduleMap.put("name", moduleName);
            moduleMap.put("properties", modulePropertiesStr);
            DynamicObject entry = entryentity.stream().filter(m -> m.getString("module.id").equals(moduleId)).findAny().orElse(null);
            if (entry == null) continue;
            String bookmarkKey = entry.getString("key");
            JSONObject moduleProperties = DisclosureOldModuleHelper.converToNewVersion(dmModelId, chapter.getLong("id"), moduleMap);
            if (moduleProperties != null && moduleProperties.getJSONObject("bookmark") == null) {
                WordBookmarkHelper.createBookmarkNode(moduleProperties, bookmarkKey);
                moduleDy.set("properties", (Object)moduleProperties.toJSONString());
            }
            moduleList.add(moduleProperties);
        }
        return moduleList;
    }

    public static ChapterPreviewResult convertToReportResult(PreviewResult item) {
        ChapterPreviewResult result = new ChapterPreviewResult();
        result.getPreviewResults().add(item);
        result.setTempFile(item.getTempFile());
        result.setPreviewUrl(item.getPreviewUrl());
        return result;
    }

    public static void addProgressIns(Consumer<TaskMessage> taskConsumer, Double taskIns) {
        if (taskConsumer != null && taskIns != null) {
            taskConsumer.accept(new TaskMessage(taskIns, ""));
        }
    }
}

