/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.design.preview;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.thread.ThreadPoolService;
import kd.epm.far.business.fidm.design.dto.PreviewInput;
import kd.epm.far.business.fidm.design.preview.DisclosurePreviewHelper;
import kd.epm.far.business.fidm.module.calculate.ModuleDataGeneralHelper;
import kd.epm.far.business.fidm.task.dto.TaskMessage;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class DisclosurePreviewModuleHelper {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosurePreviewModuleHelper.class);
    private static final Integer MaxRestartTimes = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, JSONObject> excute(PreviewInput reportPreview, Consumer<TaskMessage> taskConsumer, Double taskAllIns) {
        HashMap<String, JSONObject> moduleCalResult = new HashMap<String, JSONObject>(reportPreview.getModuleList().size());
        long start = System.currentTimeMillis();
        if (reportPreview.getModuleList().size() > 0) {
            Double moduleTaskIns = taskAllIns / (double)reportPreview.getModuleList().size();
            CountDownLatch latch = new CountDownLatch(reportPreview.getModuleList().size());
            for (JSONObject module : reportPreview.getModuleList()) {
                ThreadPoolService.runInModuleCalculateThread(() -> {
                    try {
                        JSONObject moduleResult = ModuleDataGeneralHelper.getData(reportPreview.getDmModelId(), reportPreview.getChapterId(), reportPreview.getDimensionInfos(), reportPreview.getModifyName(), module);
                        moduleCalResult.put(moduleResult.getString("name"), moduleResult);
                        DisclosurePreviewHelper.addProgressIns(taskConsumer, moduleTaskIns);
                        latch.countDown();
                    }
                    catch (Exception e) {
                        latch.countDown();
                        logger.error("DM ThreadPoolService.runInModuleCalculateThread error", (Throwable)e);
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                logger.error("DM ThreadPoolService.runInModuleCalculateThread Interrupted", (Throwable)e);
            }
        } else {
            DisclosurePreviewHelper.addProgressIns(taskConsumer, taskAllIns);
        }
        int restartTimes = MaxRestartTimes;
        while (restartTimes > 0) {
            try {
                List<JSONObject> restartModules = DisclosurePreviewModuleHelper.getErrorTask(moduleCalResult);
                logger.info("fidm-errorTaskRestart restartTimes:" + restartTimes + ",restartModules.size=" + restartModules.size());
                if (restartModules.size() == 0) break;
                DisclosurePreviewModuleHelper.errorTaskRestart(reportPreview, moduleCalResult, restartModules);
            }
            catch (Exception ex) {
                logger.error("fidm-errorTaskRestart error restartTimes:" + restartTimes, (Throwable)ex);
            }
            finally {
                --restartTimes;
            }
        }
        logger.info(String.format("%s--fidm--moduledatacreate--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        return moduleCalResult;
    }

    private static List<JSONObject> getErrorTask(Map<String, JSONObject> buildParams) {
        ArrayList<JSONObject> modules = new ArrayList<JSONObject>(buildParams.size());
        for (Map.Entry<String, JSONObject> moduleTask : buildParams.entrySet()) {
            JSONObject moduleProperties = moduleTask.getValue();
            if (moduleProperties == null) continue;
            if (ModuleEnum.REPORT_SECTION.getType().equalsIgnoreCase(moduleProperties.getString("type"))) {
                modules.add(moduleProperties);
                continue;
            }
            if (!ModuleEnum.EB_REPORT_SECTION.getType().equalsIgnoreCase(moduleProperties.getString("type"))) continue;
            modules.add(moduleProperties);
        }
        return ModuleDataGeneralHelper.filerErrorModules(modules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void errorTaskRestart(PreviewInput reportPreview, Map<String, JSONObject> buildParams, List<JSONObject> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(list.size());
        for (JSONObject module : list) {
            ThreadPoolService.runInModuleCalculateThread(() -> {
                try {
                    JSONObject moduleResult = ModuleDataGeneralHelper.getData(reportPreview.getDmModelId(), reportPreview.getChapterId(), reportPreview.getDimensionInfos(), reportPreview.getModifyName(), module);
                    buildParams.put(moduleResult.getString("name"), moduleResult);
                    latch.countDown();
                }
                catch (Exception e) {
                    latch.countDown();
                    logger.error("DM ThreadPoolService.runInModuleCalculateThread restart error", (Throwable)e);
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.error("DM ThreadPoolService.runInModuleCalculateThread restart Interrupted", (Throwable)e);
        }
    }
}

