/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.design.preview;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.config.DMConfigServiceHelper;
import kd.epm.far.business.common.enums.PreviewFormType;
import kd.epm.far.business.common.enums.WordDataType;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.module.ModuleMiddleHelper;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.common.module.middle.base.MiddleModuleResult;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.design.dto.PreviewFormParam;
import kd.epm.far.business.fidm.design.dto.PreviewSaveResult;
import kd.epm.far.business.fidm.module.DisclosureModuleHelper;
import kd.epm.far.business.fidm.report.DisclosureReportHelper;
import kd.epm.far.business.fidm.task.DisclosureTaskHepler;
import kd.epm.far.business.fidm.task.dto.PreviewTaskInput;
import kd.epm.far.business.fidm.template.DisclosureTemplateHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;

public class DisclosurePreviewSelectHelper {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosurePreviewSelectHelper.class);

    private static PreviewSaveResult getRecentMembers(Long dmModelId, List<Long> chapterIds) {
        if (chapterIds == null || chapterIds.size() == 0) {
            return null;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model", "=", (Object)dmModelId));
        qFilters.add(new QFilter("chapterid", "in", chapterIds));
        qFilters.add(new QFilter("type", "=", (Object)WordDataType.ReportResultJson.getType()));
        DynamicObjectCollection list = QueryServiceHelper.query((String)"fidm_word_history", (String)"id,content", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"createtime desc", (int)1);
        if (list.size() == 0) {
            return null;
        }
        PreviewSaveResult result = (PreviewSaveResult)JSON.parseObject((String)((DynamicObject)list.get(0)).getString("content"), PreviewSaveResult.class);
        return result;
    }

    public static List<DimensionInfo> getDefaultAndRecentMembers(Long dmModelId, List<Long> chapterIds) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        String defaultDataSet = "";
        List<DimensionInfo> allDimensions = modelStrategyEx.getDimMember().getDefaultMembers(defaultDataSet);
        PreviewSaveResult recent = DisclosurePreviewSelectHelper.getRecentMembers(dmModelId, chapterIds);
        if (recent != null && recent.getDimensionInfos().size() > 0) {
            for (DimensionInfo recentDim : recent.getDimensionInfos()) {
                DimensionInfo dim;
                if (recentDim.getMembers().size() == 0 || (dim = DimensionUtils.getDimByNumber(allDimensions, recentDim.getNumber())) == null || dim.getMembers().size() == 0) continue;
                dim.setMembers(recentDim.getMembers());
            }
        }
        return allDimensions;
    }

    private static List<DimensionInfo> getOldRecentMembers(Long dmModelId, Long templateId) {
        List<DimensionInfo> dimensionInfos = new ArrayList<DimensionInfo>(16);
        if (templateId == null || templateId <= 0L) {
            return dimensionInfos;
        }
        try {
            QFilter tempalteQf = new QFilter("template.id", "=", (Object)templateId);
            DynamicObjectCollection reports = QueryServiceHelper.query((String)"fidm_report", (String)"id", (QFilter[])tempalteQf.toArray(), (String)"createtime desc", (int)1);
            if (reports.size() > 0) {
                Long reportId = ((DynamicObject)reports.get(0)).getLong("id");
                dimensionInfos = DisclosureReportHelper.getOldRecentMembers(dmModelId, reportId);
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        return dimensionInfos;
    }

    private static PreviewSaveResult getRecentMembersByModule(Long dmModelId, Long moduleId) {
        if (moduleId == null || moduleId <= 0L) {
            return null;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model", "=", (Object)dmModelId));
        qFilters.add(new QFilter("moduleid", "=", (Object)moduleId));
        qFilters.add(new QFilter("type", "=", (Object)WordDataType.ReportResultJson.getType()));
        DynamicObjectCollection list = QueryServiceHelper.query((String)"fidm_word_history", (String)"id,content", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"createtime desc", (int)1);
        if (list.size() == 0) {
            return null;
        }
        PreviewSaveResult result = (PreviewSaveResult)JSON.parseObject((String)((DynamicObject)list.get(0)).getString("content"), PreviewSaveResult.class);
        return result;
    }

    private static List<DimensionInfo> getDefaultAndRecentMembersByModule(Long dmModelId, JSONObject module) {
        if (module == null) {
            return new ArrayList<DimensionInfo>(10);
        }
        Long moduleId = module.getLong("id");
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        String defaultDataSet = DisclosureModuleHelper.getEBDataset(dmModelId, module);
        List<DimensionInfo> allDimensions = modelStrategyEx.getDimMember().getDefaultMembers(defaultDataSet);
        PreviewSaveResult recent = DisclosurePreviewSelectHelper.getRecentMembersByModule(dmModelId, moduleId);
        if (recent != null && recent.getDimensionInfos().size() > 0) {
            for (DimensionInfo recentDim : recent.getDimensionInfos()) {
                DimensionInfo dim;
                if (recentDim.getMembers().size() == 0 || (dim = DimensionUtils.getDimByNumber(allDimensions, recentDim.getNumber())) == null || dim.getMembers().size() == 0) continue;
                dim.setMembers(recentDim.getMembers());
            }
        }
        return allDimensions;
    }

    private static void openWindow(IFormPlugin pugin, IFormView formView, PreviewFormParam formParam) {
        String formId = "fidm_report_preview";
        FormShowParameter formShowParameter = DisclosureFormHelper.createFormParam(formParam);
        formShowParameter.setFormId(formId);
        formShowParameter.setParentPageId(formView.getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u9884\u89c8", (String)"AbstractDesignPlugin_9", (String)"epm-far-business", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack(pugin, formId);
        formShowParameter.setCloseCallBack(closeCallBack);
        formView.showForm(formShowParameter);
    }

    public static void openByChapter(IFormPlugin pugin, IFormView formView, Long dmModelId, Long templateId, Long chapterId, boolean randFileName, String openWordEnumType) {
        ArrayList<DimensionInfo> selectDims = new ArrayList<DimensionInfo>(100);
        List<String> filterDimIdList = DisclosureTemplateHelper.getTemplateDimKey(dmModelId, templateId);
        List<DimensionInfo> dimList = new ModelStrategyEx(dmModelId).getDim().getDimList();
        for (String dimId : filterDimIdList) {
            DimensionInfo dim = dimList.stream().filter(x -> x.getId().toString().equals(dimId)).findAny().orElse(null);
            if (dim == null) continue;
            selectDims.add(dim);
        }
        List<Long> chapterIds = QueryServiceHelper.query((String)"fidm_chapter", (String)"id", (QFilter[])new QFilter("template", "=", (Object)templateId).toArray()).stream().map(m -> m.getLong("id")).collect(Collectors.toList());
        PreviewSaveResult recent = DisclosurePreviewSelectHelper.getRecentMembers(dmModelId, chapterIds);
        if (recent != null && recent.getDimensionInfos().size() > 0) {
            for (DimensionInfo recentItem : recent.getDimensionInfos()) {
                DimensionInfo find;
                if (recentItem.getMembers().size() <= 0 || (find = (DimensionInfo)selectDims.stream().filter(x -> x.getNumber().equalsIgnoreCase(recentItem.getNumber())).findAny().orElse(null)) == null) continue;
                find.setMembers(recentItem.getMembers());
            }
        }
        PreviewFormParam formParam = new PreviewFormParam();
        formParam.setDmModelId(dmModelId);
        formParam.setTemplateId(templateId);
        formParam.setChapterId(chapterId);
        formParam.setDimensionInfos(selectDims);
        formParam.setPreviewFormType(PreviewFormType.ChapterDesgin.getType());
        formParam.setRandFileName(randFileName);
        formParam.setUrlPrefix(DisclosureFileHelper.getUrlPrefix());
        formParam.setUserId(LongUtil.toLong((Object)RequestContext.get().getUserId()));
        formParam.setUserName(RequestContext.get().getUserName());
        formParam.setOpenWordEnumType(openWordEnumType);
        DisclosurePreviewSelectHelper.openWindow(pugin, formView, formParam);
    }

    public static void openByTemplate(IFormPlugin pugin, IFormView formView, Long dmModelId, Long templateId) {
        ArrayList<DimensionInfo> selectDims = new ArrayList<DimensionInfo>(100);
        List<String> filterDimIdList = DisclosureTemplateHelper.getTemplateDimKey(dmModelId, templateId);
        List<DimensionInfo> dimList = new ModelStrategyEx(dmModelId).getDim().getDimList();
        for (String dimId : filterDimIdList) {
            DimensionInfo dim = dimList.stream().filter(x -> x.getId().toString().equals(dimId)).findAny().orElse(null);
            if (dim == null) continue;
            selectDims.add(dim);
        }
        List<Long> chapterIds = QueryServiceHelper.query((String)"fidm_chapter", (String)"id", (QFilter[])new QFilter("template", "=", (Object)templateId).toArray()).stream().map(m -> m.getLong("id")).collect(Collectors.toList());
        List<Object> recenList = new ArrayList(16);
        PreviewSaveResult recent = DisclosurePreviewSelectHelper.getRecentMembers(dmModelId, chapterIds);
        if (recent != null && recent.getDimensionInfos().size() > 0) {
            recenList = recent.getDimensionInfos();
        } else {
            DisclosurePreviewSelectHelper.getOldRecentMembers(dmModelId, templateId);
        }
        for (DimensionInfo recentItem : recenList) {
            DimensionInfo find;
            if (recentItem.getMembers().size() <= 0 || (find = (DimensionInfo)selectDims.stream().filter(x -> x.getNumber().equalsIgnoreCase(recentItem.getNumber())).findAny().orElse(null)) == null) continue;
            find.setMembers(recentItem.getMembers());
        }
        PreviewFormParam formParam = new PreviewFormParam();
        formParam.setDmModelId(dmModelId);
        formParam.setTemplateId(templateId);
        formParam.setDimensionInfos(selectDims);
        formParam.setPreviewFormType(PreviewFormType.Template.getType());
        formParam.setUrlPrefix(DisclosureFileHelper.getUrlPrefix());
        formParam.setUserId(LongUtil.toLong((Object)RequestContext.get().getUserId()));
        formParam.setUserName(RequestContext.get().getUserName());
        formParam.setOpenWordEnumType(DMConfigServiceHelper.getAndCheckOpenWordEnum());
        DisclosurePreviewSelectHelper.openWindow(pugin, formView, formParam);
    }

    public static void openByChapterRepository(IFormPlugin plugin, IFormView view, Long dmModelId, Long chapterId) {
        boolean isOpenPreviewDimWindow = false;
        List<DimensionInfo> selectDims = DisclosureChapterHelper.getPreviewVars(dmModelId, chapterId);
        if (selectDims.size() > 0) {
            List<DimensionInfo> recentDims = DisclosurePreviewSelectHelper.getDefaultAndRecentMembers(dmModelId, Collections.singletonList(chapterId));
            if (recentDims != null && recentDims.size() > 0) {
                for (DimensionInfo recentItem : recentDims) {
                    DimensionInfo find;
                    if (recentItem.getMembers().size() <= 0 || (find = (DimensionInfo)selectDims.stream().filter(x -> x.getNumber().equalsIgnoreCase(recentItem.getNumber())).findAny().orElse(null)) == null) continue;
                    find.setMembers(recentItem.getMembers());
                }
            }
            isOpenPreviewDimWindow = true;
        }
        PreviewFormParam formParam = new PreviewFormParam();
        formParam.setDmModelId(dmModelId);
        formParam.setChapterId(chapterId);
        formParam.setDimensionInfos(selectDims);
        formParam.setPreviewFormType(PreviewFormType.ChapterRepository.getType());
        formParam.setUrlPrefix(DisclosureFileHelper.getUrlPrefix());
        formParam.setUserId(LongUtil.toLong((Object)RequestContext.get().getUserId()));
        formParam.setUserName(RequestContext.get().getUserName());
        formParam.setOpenWordEnumType(DMConfigServiceHelper.getAndCheckOpenWordEnum());
        if (isOpenPreviewDimWindow) {
            DisclosurePreviewSelectHelper.openWindow(plugin, view, formParam);
        } else {
            PreviewTaskInput previewTaskParam = new PreviewTaskInput();
            previewTaskParam.setFormParam(formParam);
            previewTaskParam.setMemberMap(new HashMap<String, DimMemberInfo>(2));
            DisclosureTaskHepler.previewDispatch(plugin, view, previewTaskParam);
        }
    }

    public static void openByModuleRepository(IFormPlugin plugin, IFormView view, Long dmModelId, Long moduleId) {
        JSONObject realMododule = null;
        Map<String, Object> module = ModuleServiceHelper.getModule(dmModelId, moduleId);
        if (module == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u4ef6\u4e0d\u5b58\u5728\u6216\u8005\u8f6c\u6362\u5931\u8d25\u3002", (String)"DisclosureServiceHelper_19", (String)"epm-far-business", (Object[])new Object[0]));
        }
        MiddleModuleResult moduleResult = ModuleMiddleHelper.convertToThird(dmModelId, moduleId, ModuleMiddleHelper.ModuleConvertEnum.Fidm, true);
        if (!moduleResult.isSuccess()) {
            if (moduleResult.getTips() == null || moduleResult.getTips().size() == 0) {
                return;
            }
            throw new KDBizException(module.get("name") + "\uff1a" + moduleResult.getTips().get(0));
        }
        realMododule = (JSONObject)moduleResult.getResult();
        if (realMododule == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u4ef6\u4e0d\u5b58\u5728\u6216\u8005\u8f6c\u6362\u5931\u8d25\u3002", (String)"DisclosureServiceHelper_19", (String)"epm-far-business", (Object[])new Object[0]));
        }
        boolean isOpenPreviewDimWindow = false;
        List<DimensionInfo> selectDims = DisclosureModuleHelper.getPreviewVars(dmModelId, realMododule);
        if (selectDims.size() > 0) {
            List<DimensionInfo> recentDims = DisclosurePreviewSelectHelper.getDefaultAndRecentMembersByModule(dmModelId, realMododule);
            if (recentDims != null && recentDims.size() > 0) {
                for (DimensionInfo recentItem : recentDims) {
                    DimensionInfo find;
                    if (recentItem.getMembers().size() <= 0 || (find = (DimensionInfo)selectDims.stream().filter(x -> x.getNumber().equalsIgnoreCase(recentItem.getNumber())).findAny().orElse(null)) == null) continue;
                    find.setMembers(recentItem.getMembers());
                }
            }
            isOpenPreviewDimWindow = true;
        }
        PreviewFormParam formParam = new PreviewFormParam();
        formParam.setDmModelId(dmModelId);
        formParam.setModule(realMododule);
        formParam.setDimensionInfos(selectDims);
        formParam.setPreviewFormType(PreviewFormType.ModuleRepository.getType());
        formParam.setUrlPrefix(DisclosureFileHelper.getUrlPrefix());
        formParam.setUserId(LongUtil.toLong((Object)RequestContext.get().getUserId()));
        formParam.setUserName(RequestContext.get().getUserName());
        formParam.setOpenWordEnumType(DMConfigServiceHelper.getAndCheckOpenWordEnum());
        if (isOpenPreviewDimWindow) {
            DisclosurePreviewSelectHelper.openWindow(plugin, view, formParam);
        } else {
            PreviewTaskInput previewTaskParam = new PreviewTaskInput();
            previewTaskParam.setFormParam(formParam);
            previewTaskParam.setMemberMap(new HashMap<String, DimMemberInfo>(2));
            DisclosureTaskHepler.previewDispatch(plugin, view, previewTaskParam);
        }
    }
}

