/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.excel;

import com.google.common.base.Objects;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.excel.ExcelConvertHelper;
import kd.epm.far.business.fidm.excel.dto.SelectedAreaInfo;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellBorder;
import kd.epm.far.business.fidm.word.dto.WordTableCellBorders;
import kd.epm.far.business.fidm.word.dto.WordTableCellNodeEx;
import kd.epm.far.business.fidm.word.dto.WordTableRowNode;
import kd.epm.far.business.fidm.word.helper.WordNodeJsonHelper;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ExcelBorderHelper {
    public static void resetCellBorder(SelectedAreaInfo selectedAreaInfo, List<WordNode> sourceRowsNodes, List<WordNode> splitRowsNodes) {
        if (selectedAreaInfo.getIsALL()) {
            return;
        }
        for (int i = 0; i < splitRowsNodes.size(); ++i) {
            WordTableRowNode rowNode = (WordTableRowNode)splitRowsNodes.get(i);
            for (int j = 0; j < rowNode.getChilds().size(); ++j) {
                WordTableCellNodeEx cellNode = (WordTableCellNodeEx)rowNode.getChilds().get(j);
                if (cellNode.getSource().getBorders().isDefault()) continue;
                if (i == 0) {
                    ExcelBorderHelper.resetCellBorderSingle(cellNode, sourceRowsNodes, i + selectedAreaInfo.getRowStartIndex() - 1, j + selectedAreaInfo.getColumnStartIndex(), WordConstants.WordBorderAlignment.Top);
                }
                if (i == splitRowsNodes.size() - 1) {
                    ExcelBorderHelper.resetCellBorderSingle(cellNode, sourceRowsNodes, i + selectedAreaInfo.getRowStartIndex() + 1, j + selectedAreaInfo.getColumnStartIndex(), WordConstants.WordBorderAlignment.Bottom);
                }
                if (j == 0) {
                    ExcelBorderHelper.resetCellBorderSingle(cellNode, sourceRowsNodes, i + selectedAreaInfo.getRowStartIndex(), j + selectedAreaInfo.getColumnStartIndex() - 1, WordConstants.WordBorderAlignment.Left);
                }
                if (j != rowNode.getChilds().size() - 1) continue;
                ExcelBorderHelper.resetCellBorderSingle(cellNode, sourceRowsNodes, i + selectedAreaInfo.getRowStartIndex(), j + selectedAreaInfo.getColumnStartIndex() + 1, WordConstants.WordBorderAlignment.Right);
            }
        }
    }

    private static void resetCellBorderSingle(WordTableCellNodeEx splitCellNode, List<WordNode> sourceRowsNodes, int nearRowIndex, int nearColumnIndex, WordConstants.WordBorderAlignment alignment) {
        if (splitCellNode == null) {
            return;
        }
        WordTableCellNodeEx nearCellNode = ExcelBorderHelper.getCellNodeFromSource(sourceRowsNodes, nearRowIndex, nearColumnIndex);
        if (nearCellNode == null) {
            return;
        }
        WordTableCellBorders current = splitCellNode.getSource().getBorders();
        WordTableCellBorders near = nearCellNode.getSource().getBorders();
        if (alignment == WordConstants.WordBorderAlignment.Left) {
            int checkResult = ExcelBorderHelper.checkBorder(near.getRight(), current.getLeft());
            if (checkResult > 0) {
                current.setLeft(WordNodeJsonHelper.copyEx(near.getRight(), WordTableCellBorder.class));
            } else if (checkResult < 0) {
                near.setRight(WordNodeJsonHelper.copyEx(current.getLeft(), WordTableCellBorder.class));
            }
        } else if (alignment == WordConstants.WordBorderAlignment.Right) {
            int checkResult = ExcelBorderHelper.checkBorder(current.getRight(), near.getLeft());
            if (checkResult > 0) {
                near.setLeft(WordNodeJsonHelper.copyEx(current.getRight(), WordTableCellBorder.class));
            } else if (checkResult < 0) {
                current.setRight(WordNodeJsonHelper.copyEx(near.getLeft(), WordTableCellBorder.class));
            }
        } else if (alignment == WordConstants.WordBorderAlignment.Top) {
            int checkResult = ExcelBorderHelper.checkBorder(near.getBottom(), current.getTop());
            if (checkResult > 0) {
                current.setTop(WordNodeJsonHelper.copyEx(near.getBottom(), WordTableCellBorder.class));
            } else if (checkResult < 0) {
                near.setBottom(WordNodeJsonHelper.copyEx(current.getTop(), WordTableCellBorder.class));
            }
        } else if (alignment == WordConstants.WordBorderAlignment.Bottom) {
            int checkResult = ExcelBorderHelper.checkBorder(current.getBottom(), near.getTop());
            if (checkResult > 0) {
                near.setTop(WordNodeJsonHelper.copyEx(current.getBottom(), WordTableCellBorder.class));
            } else if (checkResult < 0) {
                current.setBottom(WordNodeJsonHelper.copyEx(near.getTop(), WordTableCellBorder.class));
            }
        }
    }

    private static int checkBorder(WordTableCellBorder first, WordTableCellBorder second) {
        if (ExcelBorderHelper.sameCellBorder(first, second)) {
            return 0;
        }
        if (first.getType() == WordConstants.WordBorderType.None.getType() && second.getType() == WordConstants.WordBorderType.None.getType()) {
            return 0;
        }
        if (first.getType() == WordConstants.WordBorderType.None.getType()) {
            return -1;
        }
        if (second.getType() == WordConstants.WordBorderType.None.getType()) {
            return 1;
        }
        if (first.getWidth() > second.getWidth()) {
            return 1;
        }
        if (first.getWidth() < second.getWidth()) {
            return -1;
        }
        if (first.getType() > second.getType()) {
            return -1;
        }
        if (first.getType() < second.getType()) {
            return 1;
        }
        return 1;
    }

    private static boolean sameCellBorder(WordTableCellBorder first, WordTableCellBorder second) {
        if (first == null || second == null) {
            return true;
        }
        if (second == null) {
            return false;
        }
        return first.getType() == second.getType() && Objects.equal((Object)first.getColor(), (Object)second.getColor()) && first.getWidth() == second.getWidth();
    }

    private static WordTableCellNodeEx getCellNodeFromSource(List<WordNode> sourceRowsNodes, int rowIndex, int columnIndex) {
        WordTableCellNodeEx find = null;
        if (rowIndex < 0 || sourceRowsNodes.size() <= rowIndex || columnIndex < 0) {
            return find;
        }
        WordTableRowNode rowNode = (WordTableRowNode)sourceRowsNodes.get(rowIndex);
        if (rowNode.getChilds().size() <= columnIndex) {
            return find;
        }
        return (WordTableCellNodeEx)rowNode.getChilds().get(columnIndex);
    }

    public static void resetBorder(WordTableCellBorders current, WordTableCellBorders near, WordConstants.WordBorderAlignment alignment) {
        if (alignment == WordConstants.WordBorderAlignment.Left) {
            int checkResult = ExcelBorderHelper.checkBorder(near.getRight(), current.getLeft());
            if (checkResult > 0) {
                current.setLeft(WordNodeJsonHelper.copyEx(near.getRight(), WordTableCellBorder.class));
            } else if (checkResult < 0) {
                near.setRight(WordNodeJsonHelper.copyEx(current.getLeft(), WordTableCellBorder.class));
            }
        } else if (alignment == WordConstants.WordBorderAlignment.Right) {
            int checkResult = ExcelBorderHelper.checkBorder(current.getRight(), near.getLeft());
            if (checkResult > 0) {
                near.setLeft(WordNodeJsonHelper.copyEx(current.getRight(), WordTableCellBorder.class));
            } else if (checkResult < 0) {
                current.setRight(WordNodeJsonHelper.copyEx(near.getLeft(), WordTableCellBorder.class));
            }
        } else if (alignment == WordConstants.WordBorderAlignment.Top) {
            int checkResult = ExcelBorderHelper.checkBorder(near.getBottom(), current.getTop());
            if (checkResult > 0) {
                current.setTop(WordNodeJsonHelper.copyEx(near.getBottom(), WordTableCellBorder.class));
            } else if (checkResult < 0) {
                near.setBottom(WordNodeJsonHelper.copyEx(current.getTop(), WordTableCellBorder.class));
            }
        } else if (alignment == WordConstants.WordBorderAlignment.Bottom) {
            int checkResult = ExcelBorderHelper.checkBorder(current.getBottom(), near.getTop());
            if (checkResult > 0) {
                near.setTop(WordNodeJsonHelper.copyEx(current.getBottom(), WordTableCellBorder.class));
            } else if (checkResult < 0) {
                current.setBottom(WordNodeJsonHelper.copyEx(near.getTop(), WordTableCellBorder.class));
            }
        }
    }

    public static WordTableCellBorders getCellBorder(XSSFCell cell) {
        XSSFCellStyle cellStyle = cell.getCellStyle();
        WordTableCellBorders borders = new WordTableCellBorders();
        ExcelBorderHelper.setCellBorder(cellStyle.getBorderLeft(), cellStyle.getLeftBorderXSSFColor(), borders.getLeft());
        ExcelBorderHelper.setCellBorder(cellStyle.getBorderRight(), cellStyle.getRightBorderXSSFColor(), borders.getRight());
        ExcelBorderHelper.setCellBorder(cellStyle.getBorderTop(), cellStyle.getTopBorderXSSFColor(), borders.getTop());
        ExcelBorderHelper.setCellBorder(cellStyle.getBorderBottom(), cellStyle.getBottomBorderXSSFColor(), borders.getBottom());
        ExcelBorderHelper.setCellBorder(cellStyle.getBorderLeft(), cellStyle.getLeftBorderXSSFColor(), borders.getLeft());
        return borders;
    }

    public static void setCellBorder(BorderStyle borderStyle, XSSFColor xssfColor, WordTableCellBorder wordTableCellBorder) {
        double width = 0.5;
        if (borderStyle != null) {
            wordTableCellBorder.setType(ExcelBorderHelper.getCellBorderType(borderStyle));
            if (borderStyle == BorderStyle.MEDIUM) {
                width = 1.5;
            } else if (borderStyle == BorderStyle.DOUBLE || borderStyle == BorderStyle.THICK) {
                width = 3.0;
            }
        }
        wordTableCellBorder.setType(ExcelBorderHelper.getCellBorderType(borderStyle));
        String boderColor = ExcelConvertHelper.convertColor(xssfColor);
        if (StringUtils.isNotEmpty((String)boderColor)) {
            wordTableCellBorder.setColor(boderColor);
        }
        wordTableCellBorder.setWidth(width);
    }

    private static int getCellBorderType(BorderStyle borderStyle) {
        int borderType = WordConstants.WordBorderType.None.getType();
        borderType = borderStyle != null ? (borderStyle == BorderStyle.NONE ? WordConstants.WordBorderType.None.getType() : (borderStyle == BorderStyle.MEDIUM ? WordConstants.WordBorderType.Medium.getType() : (borderStyle == BorderStyle.DOUBLE || borderStyle == BorderStyle.THICK ? WordConstants.WordBorderType.Medium.getType() : (borderStyle == BorderStyle.HAIR || borderStyle == BorderStyle.DASH_DOT || borderStyle == BorderStyle.DASH_DOT_DOT || borderStyle == BorderStyle.DASHED ? WordConstants.WordBorderType.Dashed.getType() : (borderStyle == BorderStyle.DOTTED ? WordConstants.WordBorderType.Dotted.getType() : WordConstants.WordBorderType.Solid.getType()))))) : WordConstants.WordBorderType.None.getType();
        return borderType;
    }

    public static WordTableCellBorders getCellBorderEx(XSSFSheet xssSheet, XSSFCell cell) {
        XSSFCell bottomCell;
        XSSFCell topCell;
        XSSFCell rightCell;
        WordTableCellBorders current = ExcelBorderHelper.getCellBorder(cell);
        XSSFCell leftCell = ExcelConvertHelper.getSheetCell(xssSheet, cell.getRowIndex(), cell.getColumnIndex() - 1);
        if (leftCell != null) {
            ExcelBorderHelper.resetBorder(current, ExcelBorderHelper.getCellBorder(leftCell), WordConstants.WordBorderAlignment.Left);
        }
        if ((rightCell = ExcelConvertHelper.getSheetCell(xssSheet, cell.getRowIndex(), cell.getColumnIndex() + 1)) != null) {
            ExcelBorderHelper.resetBorder(current, ExcelBorderHelper.getCellBorder(rightCell), WordConstants.WordBorderAlignment.Right);
        }
        if ((topCell = ExcelConvertHelper.getSheetCell(xssSheet, cell.getRowIndex() - 1, cell.getColumnIndex())) != null) {
            ExcelBorderHelper.resetBorder(current, ExcelBorderHelper.getCellBorder(topCell), WordConstants.WordBorderAlignment.Top);
        }
        if ((bottomCell = ExcelConvertHelper.getSheetCell(xssSheet, cell.getRowIndex() + 1, cell.getColumnIndex())) != null) {
            ExcelBorderHelper.resetBorder(current, ExcelBorderHelper.getCellBorder(bottomCell), WordConstants.WordBorderAlignment.Bottom);
        }
        return current;
    }
}

