/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.excel;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.excel.ExcelBorderHelper;
import kd.epm.far.business.fidm.excel.ExcelConstants;
import kd.epm.far.business.fidm.excel.ExcelConvertHelper;
import kd.epm.far.business.fidm.excel.dto.SelectedAreaInfo;
import kd.epm.far.business.fidm.excel.dto.TableConvertParam;
import kd.epm.far.business.fidm.excel.format.ExcelCellData;
import kd.epm.far.business.fidm.excel.format.ExcelDataFormatter;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellBorders;
import kd.epm.far.business.fidm.word.dto.WordTableCellNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellNodeEx;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTableRowNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import kd.epm.far.business.fidm.word.helper.ColorStyleHelper;
import kd.epm.far.business.fidm.word.helper.WordFontHelper;
import kd.epm.far.business.fidm.word.helper.WordNodeHelper;
import kd.epm.far.business.fidm.word.helper.WordNodeJsonHelper;
import kd.epm.far.business.fidm.word.helper.WordWidthHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;

public class ExcelConvert {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ExcelConvert.class);
    private XSSFSheet xssSheet;
    private SelectedAreaInfo selectedAreaInfo;
    private TableConvertParam tableConvertParam;
    private String accountNumberFormatStr = new String(ExcelConstants.AccountNumberFormat);

    public ExcelConvert(byte[] exceldata, TableConvertParam tableConvertParam) {
        if (exceldata == null) {
            String msg = ResManager.loadKDString((String)"\u62a5\u8868\u5207\u7247\u6765\u6e90\u7684\u62a5\u8868\u6a21\u677f\u89e3\u6790\u65e0\u6548\u3002", (String)"ModuleDataGeneralHelper_16", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        this.xssSheet = this.getXssSheet(exceldata);
        this.selectedAreaInfo = new SelectedAreaInfo(tableConvertParam.getSelectedarea());
        this.tableConvertParam = tableConvertParam;
        if (this.tableConvertParam == null) {
            this.tableConvertParam = new TableConvertParam();
        }
    }

    public WordTableNode createReportSection() {
        WordTableNode tableNode = new WordTableNode();
        double defaultRowHeight = (double)this.xssSheet.getDefaultRowHeightInPoints() * 20.0;
        Tuple<Integer, Integer> rangMax = this.getMaxRange(this.xssSheet);
        int coumnCount = (Integer)rangMax.item2;
        for (int i = 0; i < (Integer)rangMax.item1; ++i) {
            int j;
            XSSFRow row = this.xssSheet.getRow(i);
            WordTableRowNode rowNode = new WordTableRowNode();
            rowNode.setHeight(defaultRowHeight);
            if (row != null) {
                rowNode.setHeight(row.getZeroHeight() ? 0.0 : (double)row.getHeightInPoints() * 20.0);
                for (j = 0; j < coumnCount; ++j) {
                    XSSFCell cell = row.getCell(j);
                    WordTableCellNodeEx cellNodeEx = this.createWordTableCellNode(cell);
                    if (cellNodeEx == null) {
                        cellNodeEx = WordNodeHelper.createDefaultCellNode();
                    }
                    cellNodeEx.getSource().setWidth((double)this.xssSheet.getColumnWidthInPixels(j) * 14.0);
                    rowNode.getChilds().add(cellNodeEx);
                }
            } else {
                for (j = 0; j < coumnCount; ++j) {
                    WordTableCellNodeEx cellNodeEx = WordNodeHelper.createDefaultCellNode();
                    cellNodeEx.getSource().setWidth((double)this.xssSheet.getColumnWidthInPixels(j) * 14.0);
                    rowNode.getChilds().add(cellNodeEx);
                }
            }
            tableNode.getChilds().add(rowNode);
        }
        this.resetCellMerged(tableNode);
        this.splitWordTableNode(tableNode);
        this.removeHiddenRowsAndCol(tableNode);
        this.removeEmptyRowsAndCol(tableNode);
        this.validWordTableNode(tableNode);
        this.resetTableWidth(tableNode);
        this.resetCellFont(tableNode);
        return tableNode;
    }

    private void resetCellFont(WordTableNode tableNode) {
        if ("1".equalsIgnoreCase(this.tableConvertParam.getColumnType()) && this.tableConvertParam.getCellFontFit()) {
            WordFontHelper.resetCellFont(tableNode);
        }
    }

    private void resetCellMerged(WordTableNode tableNode) {
        WordTableRowNode rowNode;
        int i;
        for (i = 0; i < tableNode.getChilds().size(); ++i) {
            rowNode = (WordTableRowNode)tableNode.getChilds().get(i);
            for (int j = 0; j < rowNode.getChilds().size(); ++j) {
                WordTableCellNodeEx cellNode = (WordTableCellNodeEx)rowNode.getChilds().get(j);
                if (cellNode == null || !cellNode.getBing().contains("Begin") || cellNode.getSource().getColumnSpan() <= 1 && cellNode.getSource().getRowSpan() <= 1) continue;
                this.setCellMergedEmpty(tableNode, cellNode.getSource(), i, i + cellNode.getSource().getRowSpan() - 1, j, j + cellNode.getSource().getColumnSpan() - 1);
            }
        }
        for (i = tableNode.getChilds().size() - 1; i >= 0; --i) {
            rowNode = (WordTableRowNode)tableNode.getChilds().get(i);
            int middleCellCount = 0;
            for (int j = 0; j < rowNode.getChilds().size(); ++j) {
                WordTableCellNodeEx cellNode = (WordTableCellNodeEx)rowNode.getChilds().get(j);
                if (cellNode == null || !cellNode.getBing().contains("Middle")) continue;
                ++middleCellCount;
            }
            if (middleCellCount != rowNode.getChilds().size() || i <= 0) continue;
            WordTableRowNode preRowNode = (WordTableRowNode)tableNode.getChilds().get(i - 1);
            preRowNode.setHeight(rowNode.getHeight() + preRowNode.getHeight());
            rowNode.setHeight(0.0);
        }
    }

    private void setCellMergedEmpty(WordTableNode tableNode, WordTableCellNode firstCellNode, int startRowIndex, int endRowIndex, int startColIndex, int endColIndex) {
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(i);
            for (int j = startColIndex; j <= endColIndex; ++j) {
                XSSFCell mergedCell;
                WordTableCellNodeEx cellNode;
                if (rowNode.getChilds().size() <= j || (cellNode = (WordTableCellNodeEx)rowNode.getChilds().get(j)) == null || i == startRowIndex && j == startColIndex) continue;
                cellNode.setSource(firstCellNode);
                if (startColIndex == j) {
                    cellNode.setBing("RowSpan.Middle");
                } else if (startRowIndex == i) {
                    cellNode.setBing("ColumnSpan.Middle");
                } else {
                    cellNode.setBing("RowSpan.Middle;ColumnSpan.Middle");
                }
                if (i != endRowIndex || j != endColIndex || this.xssSheet.getRow(endRowIndex) == null || (mergedCell = this.xssSheet.getRow(endRowIndex).getCell(endColIndex)) == null || mergedCell.getCellStyle() == null) continue;
                ExcelBorderHelper.setCellBorder(mergedCell.getCellStyle().getBorderRight(), mergedCell.getCellStyle().getRightBorderXSSFColor(), firstCellNode.getBorders().getRight());
                ExcelBorderHelper.setCellBorder(mergedCell.getCellStyle().getBorderBottom(), mergedCell.getCellStyle().getBottomBorderXSSFColor(), firstCellNode.getBorders().getBottom());
            }
        }
    }

    private Tuple<Integer, Integer> getMaxRange(XSSFSheet sheet) {
        int maxRowIndex = sheet.getLastRowNum();
        int maxColumnCount = 0;
        boolean rowContinue = true;
        for (int i = sheet.getLastRowNum(); i >= 0; --i) {
            XSSFRow row = sheet.getRow(i);
            if (rowContinue) {
                if (this.isEmptyRow(row)) {
                    maxRowIndex = i;
                } else {
                    rowContinue = false;
                }
            }
            if (rowContinue || row == null || maxColumnCount >= row.getLastCellNum()) continue;
            maxColumnCount = row.getLastCellNum();
        }
        boolean columnContinue = true;
        for (CellRangeAddress address : this.xssSheet.getMergedRegions()) {
            if (maxColumnCount >= address.getLastColumn() + 1) continue;
            maxColumnCount = address.getLastColumn() + 1;
            columnContinue = false;
        }
        int maxColumnCountEx = maxColumnCount;
        for (int columnIndex = maxColumnCountEx - 1; columnIndex >= 0; --columnIndex) {
            if (!columnContinue) continue;
            if (this.isEmptyColumn(sheet, maxRowIndex, columnIndex)) {
                maxColumnCount = columnIndex;
                continue;
            }
            columnContinue = false;
        }
        for (CellRangeAddress address : this.xssSheet.getMergedRegions()) {
            if (maxColumnCount >= address.getLastColumn() + 1) continue;
            maxColumnCount = address.getLastColumn() + 1;
        }
        if (!this.selectedAreaInfo.getIsALL()) {
            if (this.selectedAreaInfo.getRowEndIndex() >= 0 && this.selectedAreaInfo.getRowEndIndex() > maxRowIndex) {
                maxRowIndex = this.selectedAreaInfo.getRowEndIndex();
            }
            if (this.selectedAreaInfo.getColumnEndIndex() >= 0 && this.selectedAreaInfo.getColumnEndIndex() + 1 > maxColumnCount) {
                maxColumnCount = this.selectedAreaInfo.getColumnEndIndex() + 1;
            }
        }
        return new Tuple((Object)(maxRowIndex + 1), (Object)maxColumnCount);
    }

    private boolean isEmptyRow(XSSFRow row) {
        if (row != null) {
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                XSSFCell cell = row.getCell(j);
                if (cell == null || this.isEmptyCell(cell)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isEmptyCell(XSSFCell cell) {
        String backColor;
        if (cell == null) {
            return true;
        }
        if (cell.getCellStyle() == null) {
            return true;
        }
        if (StringUtils.isNotEmpty((String)cell.toString())) {
            return false;
        }
        if (cell.getCellStyle().getBorderTop() != BorderStyle.NONE || cell.getCellStyle().getBorderBottom() != BorderStyle.NONE || cell.getCellStyle().getBorderLeft() != BorderStyle.NONE || cell.getCellStyle().getBorderRight() != BorderStyle.NONE) {
            return false;
        }
        return cell.getCellStyle().getFillBackgroundColorColor() == null || !StringUtils.isNotEmpty((String)(backColor = ExcelConvertHelper.convertColor(cell.getCellStyle().getFillBackgroundXSSFColor())));
    }

    private boolean isEmptyColumn(XSSFSheet sheet, int maxRowIndex, int columnIndex) {
        for (int i = 0; i < maxRowIndex + 1; ++i) {
            XSSFCell cell;
            XSSFRow row = sheet.getRow(i);
            if (row == null || (cell = row.getCell(columnIndex)) == null || this.isEmptyCell(cell)) continue;
            return false;
        }
        return true;
    }

    private void resetTableWidth(WordTableNode tableNode) {
        WordConstants.WordWidthType wordLengthType = WordConstants.WordWidthType.Absolute;
        double widthRate = 1.0;
        if ("2".equals(this.tableConvertParam.getColumnType())) {
            wordLengthType = WordConstants.WordWidthType.Percentage;
        } else {
            widthRate = this.tableConvertParam.getWidthRate();
        }
        WordWidthHelper.resetTableWidth(tableNode, wordLengthType, widthRate);
    }

    private void splitWordTableNode(WordTableNode tableNode) {
        ArrayList<WordNode> splitRowsNodes = new ArrayList<WordNode>(tableNode.getChilds().size());
        for (int i = 0; i < tableNode.getChilds().size(); ++i) {
            WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(i);
            if (this.selectedAreaInfo.getRowStartIndex() >= 0 && i < this.selectedAreaInfo.getRowStartIndex() || this.selectedAreaInfo.getRowEndIndex() >= 0 && i > this.selectedAreaInfo.getRowEndIndex()) continue;
            ArrayList<WordNode> cellNodes = new ArrayList<WordNode>(rowNode.getChilds().size());
            for (int j = 0; j < rowNode.getChilds().size(); ++j) {
                WordTableCellNodeEx cellNode = (WordTableCellNodeEx)rowNode.getChilds().get(j);
                if (cellNode == null || this.selectedAreaInfo.getColumnStartIndex() >= 0 && j < this.selectedAreaInfo.getColumnStartIndex() || this.selectedAreaInfo.getColumnEndIndex() >= 0 && j > this.selectedAreaInfo.getColumnEndIndex()) continue;
                cellNodes.add(cellNode);
            }
            WordTableRowNode splitRowsNode = WordNodeJsonHelper.copyEx(rowNode, WordTableRowNode.class);
            splitRowsNode.setChilds(cellNodes);
            splitRowsNodes.add(splitRowsNode);
        }
        ExcelBorderHelper.resetCellBorder(this.selectedAreaInfo, tableNode.getChilds(), splitRowsNodes);
        tableNode.setChilds(splitRowsNodes);
    }

    private void removeHiddenRowsAndCol(WordTableNode tableNode) {
        Integer rowStartIndex = this.selectedAreaInfo.getRowStartIndex() >= 0 ? this.selectedAreaInfo.getRowStartIndex() : 0;
        int columnStartIndex = this.selectedAreaInfo.getColumnStartIndex() >= 0 ? this.selectedAreaInfo.getColumnStartIndex() : 0;
        ArrayList<Integer> needDeleteRowList = new ArrayList<Integer>(tableNode.getChilds().size());
        int columMax = 0;
        if (tableNode.getChilds().size() > 0) {
            columMax = tableNode.getChilds().get(0).getChilds().size();
        }
        ArrayList<Integer> needDeleteColumnList = new ArrayList<Integer>(columMax > 0 ? columMax : 100);
        for (int rowIndex = tableNode.getChilds().size() - 1; rowIndex >= 0; --rowIndex) {
            XSSFRow row = this.xssSheet.getRow(rowStartIndex + rowIndex);
            boolean hidden = false;
            hidden = row == null ? false : row.getZeroHeight() || row.getHeight() <= 0;
            if (!hidden) continue;
            needDeleteRowList.add(rowIndex);
        }
        for (int cellIndex = columMax - 1; cellIndex >= 0; --cellIndex) {
            boolean hidden = false;
            if (this.xssSheet.isColumnHidden(columnStartIndex + cellIndex)) {
                hidden = true;
            }
            if (this.xssSheet.getColumnWidth(columnStartIndex + cellIndex) <= 0) {
                hidden = true;
            }
            if (!hidden) continue;
            needDeleteColumnList.add(cellIndex);
        }
        this.removeHiddenRows(tableNode, needDeleteRowList);
        this.removeHiddenColumn(tableNode, needDeleteColumnList);
    }

    private void removeEmptyRowsAndCol(WordTableNode tableNode) {
        WordTableCellNodeEx cellNodeEx;
        if (!this.tableConvertParam.getRemoveEmptyCell()) {
            return;
        }
        ArrayList<Integer> needDeleteRowList = new ArrayList<Integer>(tableNode.getChilds().size());
        int columMax = 0;
        if (tableNode.getChilds().size() > 0) {
            columMax = tableNode.getChilds().get(0).getChilds().size();
        }
        ArrayList<Integer> needDeleteColumnList = new ArrayList<Integer>(columMax > 0 ? columMax : 100);
        for (int rowIndex = tableNode.getChilds().size() - 1; rowIndex >= 0; --rowIndex) {
            WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(rowIndex);
            boolean needDelete = true;
            for (int j = 0; j < rowNode.getChilds().size(); ++j) {
                cellNodeEx = (WordTableCellNodeEx)rowNode.getChilds().get(j);
                if (this.isEmptyWordCellNode(cellNodeEx)) continue;
                needDelete = false;
                break;
            }
            if (!needDelete) continue;
            needDeleteRowList.add(rowIndex);
        }
        for (int cellIndex = columMax - 1; cellIndex >= 0; --cellIndex) {
            boolean needDelete = true;
            for (int rowIndex = tableNode.getChilds().size() - 1; rowIndex >= 0; --rowIndex) {
                WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(rowIndex);
                cellNodeEx = (WordTableCellNodeEx)rowNode.getChilds().get(cellIndex);
                if (this.isEmptyWordCellNode(cellNodeEx)) continue;
                needDelete = false;
                break;
            }
            if (!needDelete) continue;
            needDeleteColumnList.add(cellIndex);
        }
        this.removeHiddenRows(tableNode, needDeleteRowList);
        this.removeHiddenColumn(tableNode, needDeleteColumnList);
    }

    private boolean isEmptyWordCellNode(WordTableCellNodeEx cellNodeEx) {
        if (cellNodeEx == null) {
            return true;
        }
        if (StringUtils.isNotEmpty((String)cellNodeEx.getBing()) && cellNodeEx.getBing().contains("Middle")) {
            return false;
        }
        for (WordNode paragraph : cellNodeEx.getSource().getChilds()) {
            for (WordNode node : paragraph.getChilds()) {
                WordTextNode text;
                if (node instanceof WordTextNode && StringUtils.isNotEmpty((String)(text = (WordTextNode)node).getContent())) {
                    return false;
                }
                if (node.getChilds().size() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    private void removeHiddenRows(WordTableNode tableNode, List<Integer> needDeleteRowList) {
        ArrayList<WordTableRowNode> rowsNodes = new ArrayList<WordTableRowNode>(tableNode.getChilds().size());
        int lastVaildRowIndex = -1;
        LinkedHashMap<WordTableCellNode, Integer> hadRowsSpan = new LinkedHashMap<WordTableCellNode, Integer>(100);
        for (int rowIndex = tableNode.getChilds().size() - 1; rowIndex >= 0; --rowIndex) {
            WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(rowIndex);
            if (!needDeleteRowList.contains(rowIndex)) {
                rowsNodes.add(rowNode);
                lastVaildRowIndex = rowIndex;
                continue;
            }
            for (int j = 0; j < rowNode.getChilds().size(); ++j) {
                WordTableCellNodeEx lastVaildCellNodeEx;
                WordTableRowNode lastVaildRow;
                WordTableCellNodeEx cellNodeEx = (WordTableCellNodeEx)rowNode.getChilds().get(j);
                if (cellNodeEx == null) continue;
                if (cellNodeEx.getBing().contains("RowSpan.Middle")) {
                    int rowSpan = cellNodeEx.getSource().getRowSpan() - 1;
                    cellNodeEx.getSource().setRowSpan(rowSpan > 1 ? rowSpan : 1);
                    j += cellNodeEx.getSource().getColumnSpan() - 1;
                    hadRowsSpan.put(cellNodeEx.getSource(), hadRowsSpan.get(cellNodeEx.getSource()) == null ? 1 : (Integer)hadRowsSpan.get(cellNodeEx.getSource()) + 1);
                }
                if (!cellNodeEx.getBing().contains("RowSpan.Begin") || lastVaildRowIndex < 0 || lastVaildRowIndex > rowIndex + cellNodeEx.getSource().getRowSpan() || (lastVaildRow = (WordTableRowNode)tableNode.getChilds().get(lastVaildRowIndex)) == null || (lastVaildCellNodeEx = (WordTableCellNodeEx)lastVaildRow.getChilds().get(j)) == null || !lastVaildCellNodeEx.getBing().contains("RowSpan.Middle")) continue;
                int offsetValue = 0;
                if (hadRowsSpan.get(lastVaildCellNodeEx.getSource()) != null && hadRowsSpan.get(cellNodeEx.getSource()) != null) {
                    offsetValue = (Integer)hadRowsSpan.get(cellNodeEx.getSource());
                }
                int newRowSpan = rowIndex + cellNodeEx.getSource().getRowSpan() - lastVaildRowIndex + offsetValue;
                lastVaildCellNodeEx.getSource().setRowSpan(newRowSpan);
                if (lastVaildCellNodeEx.getSource().getRowSpan() > 1) {
                    lastVaildCellNodeEx.setBing(cellNodeEx.getBing());
                } else if (cellNodeEx.getSource().getColumnSpan() > 1) {
                    lastVaildCellNodeEx.setBing(cellNodeEx.getBing());
                } else {
                    lastVaildCellNodeEx.setBing(cellNodeEx.getBing().replace("RowSpan.Begin", ""));
                }
                if (lastVaildRow.getHeight() == 0.0) {
                    lastVaildRow.setHeight(rowNode.getHeight());
                }
                j += cellNodeEx.getSource().getColumnSpan() - 1;
            }
        }
        ArrayList<WordNode> newRowNodes = new ArrayList<WordNode>(tableNode.getChilds().size());
        for (int rowIndex = rowsNodes.size() - 1; rowIndex >= 0; --rowIndex) {
            newRowNodes.add((WordNode)rowsNodes.get(rowIndex));
        }
        tableNode.setChilds(newRowNodes);
    }

    private void removeHiddenColumn(WordTableNode tableNode, List<Integer> needDeleteColumnList) {
        if (tableNode.getChilds().size() == 0) {
            return;
        }
        int columMax = tableNode.getChilds().get(0).getChilds().size();
        if (columMax == 0) {
            return;
        }
        int lastVaildColIndex = -1;
        for (int cellIndex = columMax - 1; cellIndex >= 0; --cellIndex) {
            boolean hidden = needDeleteColumnList.contains(cellIndex);
            if (hidden) {
                HashMap<WordTableCellNode, Integer> hadReduceMap = new HashMap<WordTableCellNode, Integer>(columMax);
                for (int rowIndex = tableNode.getChilds().size() - 1; rowIndex >= 0; --rowIndex) {
                    WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(rowIndex);
                    WordTableCellNodeEx cellNodeEx = (WordTableCellNodeEx)rowNode.getChilds().get(cellIndex);
                    if (cellNodeEx == null) continue;
                    if (cellNodeEx.getBing().contains("ColumnSpan.Middle") && !hadReduceMap.containsKey(cellNodeEx.getSource())) {
                        int columnSpan = cellNodeEx.getSource().getColumnSpan() - 1;
                        cellNodeEx.getSource().setColumnSpan(columnSpan > 1 ? columnSpan : 1);
                        hadReduceMap.put(cellNodeEx.getSource(), cellNodeEx.getSource().getColumnSpan());
                    }
                    if (cellNodeEx.getBing().contains("ColumnSpan.Begin") && lastVaildColIndex >= 0 && lastVaildColIndex <= cellIndex + cellNodeEx.getSource().getColumnSpan()) {
                        WordTableCellNodeEx lastVaildCellNodeEx = (WordTableCellNodeEx)rowNode.getChilds().get(lastVaildColIndex);
                        if (lastVaildCellNodeEx == null) continue;
                        if (lastVaildCellNodeEx.getBing().contains("ColumnSpan.Middle")) {
                            lastVaildCellNodeEx.getSource().setColumnSpan(cellIndex + cellNodeEx.getSource().getColumnSpan() - lastVaildColIndex);
                            if (lastVaildCellNodeEx.getSource().getColumnSpan() > 1) {
                                lastVaildCellNodeEx.setBing(cellNodeEx.getBing());
                            } else {
                                lastVaildCellNodeEx.setBing(cellNodeEx.getBing().replace("ColumnSpan.Middle;", "").replace("ColumnSpan.Middle", ""));
                            }
                        }
                    }
                    rowNode.getChilds().remove(cellNodeEx);
                }
                continue;
            }
            lastVaildColIndex = cellIndex;
        }
    }

    private void validWordTableNode(WordTableNode tableNode) {
        ArrayList<WordNode> rowsNodes = new ArrayList<WordNode>(tableNode.getChilds().size());
        for (int i = 0; i < tableNode.getChilds().size(); ++i) {
            WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(i);
            ArrayList<WordNode> cellNodes = new ArrayList<WordNode>(rowNode.getChilds().size());
            for (int j = 0; j < rowNode.getChilds().size(); ++j) {
                WordTableCellNodeEx cellNode = (WordTableCellNodeEx)rowNode.getChilds().get(j);
                if (cellNode == null || !"".equals(cellNode.getBing()) && !cellNode.getBing().contains("RowSpan.Begin") && !cellNode.getBing().contains("ColumnSpan.Begin")) continue;
                cellNodes.add(cellNode.getSource());
            }
            rowNode.setChilds(cellNodes);
            rowsNodes.add(rowNode);
        }
        tableNode.setChilds(rowsNodes);
    }

    private WordTableCellNodeEx createWordTableCellNode(XSSFCell cell) {
        String bing = "";
        WordTableCellNode cellNode = new WordTableCellNode();
        WordParagraphNode paragraphNode = new WordParagraphNode();
        cellNode.getChilds().add(paragraphNode);
        if (cell != null) {
            XSSFCellStyle cellStyle = cell.getCellStyle();
            String hightlightColor = ExcelConvertHelper.convertColor(cellStyle.getFillBackgroundXSSFColor());
            if (StringUtils.isNotEmpty((String)hightlightColor)) {
                cellNode.setHightlightColor(ColorStyleHelper.getHexadecimalColor(hightlightColor));
            }
            kd.epm.far.common.common.Tuple<Integer, CellRangeAddress, Integer> cellMerged = this.getCellMerged(cell.getRowIndex(), cell.getColumnIndex());
            if ((Integer)cellMerged.p1 == 0) {
                return null;
            }
            if ((Integer)cellMerged.p1 == 1) {
                int columnSpan;
                int rowSpan = ((CellRangeAddress)cellMerged.p2).getLastRow() - ((CellRangeAddress)cellMerged.p2).getFirstRow() + 1;
                if (rowSpan > 0) {
                    cellNode.setRowSpan(rowSpan);
                    if (rowSpan > 1) {
                        bing = bing + (!Objects.equals(bing, "") ? ";" : "") + "RowSpan.Begin";
                    }
                }
                if ((columnSpan = ((CellRangeAddress)cellMerged.p2).getLastColumn() - ((CellRangeAddress)cellMerged.p2).getFirstColumn() + 1) > 0) {
                    cellNode.setColumnSpan(columnSpan);
                    if (columnSpan > 1) {
                        bing = bing + (!Objects.equals(bing, "") ? ";" : "") + "ColumnSpan.Begin";
                    }
                }
            }
            cellNode.setBorders(ExcelBorderHelper.getCellBorderEx(this.xssSheet, cell));
            ParagraphAlignment paragraphAlignment = this.getAlignment(cell.getCellType(), cellStyle.getAlignment());
            paragraphNode.setAlignment(paragraphAlignment);
            paragraphNode.setLeftChars(cellStyle.getIndention());
        } else {
            WordTableCellBorders headCellBorders = new WordTableCellBorders();
            headCellBorders.getLeft().setType(WordConstants.WordBorderType.None.getType());
            headCellBorders.getRight().setType(WordConstants.WordBorderType.None.getType());
            headCellBorders.getTop().setType(WordConstants.WordBorderType.None.getType());
            headCellBorders.getBottom().setType(WordConstants.WordBorderType.None.getType());
            cellNode.setBorders(headCellBorders);
        }
        WordTextNode textNode = this.createWordTextNode(cell, paragraphNode);
        if (textNode != null) {
            paragraphNode.getChilds().add(textNode);
        }
        this.splitWordTextNode(cellNode, paragraphNode, textNode);
        return new WordTableCellNodeEx(cellNode, bing);
    }

    private void splitWordTextNode(WordTableCellNode cellNode, WordParagraphNode paragraphNode, WordTextNode textNode) {
        if (cellNode == null || paragraphNode == null || textNode == null) {
            return;
        }
        String soucreContent = textNode.getContent();
        if (StringUtils.isEmpty((String)soucreContent)) {
            return;
        }
        String[] strSplits = soucreContent.split("\n");
        if (strSplits.length <= 1) {
            return;
        }
        ArrayList<String> contents = new ArrayList<String>(strSplits.length);
        for (String content : strSplits) {
            if (StringUtils.isEmpty((String)content) || StringUtils.isEmpty((String)(content = content.trim()))) continue;
            contents.add(content);
        }
        if (contents.size() <= 1) {
            return;
        }
        textNode.setContent((String)contents.get(0));
        for (int i = 1; i < contents.size(); ++i) {
            WordParagraphNode newParagraphNode = (WordParagraphNode)WordNodeJsonHelper.copy(paragraphNode);
            WordTextNode newTextNode = (WordTextNode)WordNodeJsonHelper.copy(textNode);
            newTextNode.setContent((String)contents.get(i));
            newParagraphNode.getChilds().clear();
            newParagraphNode.getChilds().add(newTextNode);
            cellNode.getChilds().add(newParagraphNode);
        }
    }

    private WordTextNode createWordTextNode(XSSFCell cell, WordParagraphNode paragraphNode) {
        WordTextNode textNode = new WordTextNode();
        if (cell != null) {
            String fontColor;
            XSSFCellStyle cellStyle = cell.getCellStyle();
            if (StringUtils.isNotEmpty((String)cellStyle.getFont().getFontName())) {
                textNode.setFontFamily(cellStyle.getFont().getFontName());
            }
            if (cellStyle.getFont().getFontHeightInPoints() > 0) {
                textNode.setFontSize((double)cellStyle.getFont().getFontHeight() / 20.0);
            }
            if (StringUtils.isNotEmpty((String)(fontColor = ExcelConvertHelper.convertColor(cellStyle.getFont().getXSSFColor())))) {
                textNode.setFontColor(ColorStyleHelper.getHexadecimalColor(fontColor));
            }
            textNode.setBold(cellStyle.getFont().getBold());
            textNode.setItalic(cellStyle.getFont().getItalic());
            textNode.setStrikeThrough(cellStyle.getFont().getStrikeout());
            textNode.setUnderline(cellStyle.getFont().getUnderline() == 1);
            this.setCellValue(cell, textNode, paragraphNode);
        }
        return textNode;
    }

    private void setCellValue(XSSFCell cell, WordTextNode textNode, WordParagraphNode paragraphNode) {
        try {
            String content = null;
            switch (cell.getCellType()) {
                case STRING: {
                    content = cell.getStringCellValue();
                    break;
                }
                case NUMERIC: {
                    ExcelCellData cellData = this.getCellContentString(cell.getCellStyle(), cell.getNumericCellValue(), cell.getRawValue());
                    content = cellData.getDataString();
                    this.retsetCellFontColor(cell.getCellStyle(), textNode, cellData, paragraphNode);
                    break;
                }
                case FORMULA: {
                    content = "";
                    content = this.setCellValueByFormula(textNode, cell, content, paragraphNode);
                    break;
                }
            }
            if (StringUtils.isNotEmpty((String)content)) {
                textNode.setContent(content);
            }
        }
        catch (Exception ex) {
            logger.error("dm wordconvert reportsection setCellValue eroor", (Throwable)ex);
        }
    }

    private String setCellValueByFormula(WordTextNode textNode, XSSFCell cell, String content, WordParagraphNode paragraphNode) {
        try {
            CellValue cellVal = this.xssSheet.getWorkbook().getCreationHelper().createFormulaEvaluator().evaluate((Cell)cell);
            if (cellVal == null) {
                return content;
            }
            switch (cellVal.getCellType()) {
                case STRING: {
                    content = cellVal.getStringValue();
                    break;
                }
                case NUMERIC: {
                    ExcelCellData cellData = this.getCellContentString(cell.getCellStyle(), cellVal.getNumberValue(), "");
                    content = cellData.getDataString();
                    this.retsetCellFontColor(cell.getCellStyle(), textNode, cellData, paragraphNode);
                    break;
                }
            }
        }
        catch (Exception ex) {
            logger.error("dm wordconvert reportsection setCellValueByFormula eroor", (Throwable)ex);
        }
        return content;
    }

    private void retsetCellFontColor(XSSFCellStyle cellStyle, WordTextNode textNode, ExcelCellData cellData, WordParagraphNode paragraphNode) {
        if (cellData != null && cellData.getType() == 1 && cellData.getColorList().size() > 0 && cellData.getData().compareTo(BigDecimal.ZERO) < 0) {
            textNode.setFontColor("#ff0000");
        }
        if (cellStyle != null && StringUtils.isNotEmpty((String)cellStyle.getDataFormatString()) && cellStyle.getDataFormatString().contains(this.accountNumberFormatStr)) {
            paragraphNode.setAlignment(ParagraphAlignment.RIGHT);
        }
    }

    private ExcelCellData getCellContentString(XSSFCellStyle cellStyle, double realValue, String defaultContent) {
        ExcelCellData cellData = new ExcelCellData(BigDecimal.valueOf(realValue), defaultContent, 0);
        try {
            if (cellStyle == null) {
                return cellData;
            }
            ExcelDataFormatter dataFormatter = new ExcelDataFormatter();
            cellData = dataFormatter.format(BigDecimal.valueOf(realValue), cellStyle.getDataFormat(), cellStyle.getDataFormatString());
        }
        catch (Exception ex) {
            logger.error("dm wordconvert reportsection getCellContentString eroor", (Throwable)ex);
        }
        return cellData;
    }

    private kd.epm.far.common.common.Tuple<Integer, CellRangeAddress, Integer> getCellMerged(int row, int column) {
        for (CellRangeAddress address : this.xssSheet.getMergedRegions()) {
            if (row == address.getFirstRow() && column == address.getFirstColumn()) {
                return new kd.epm.far.common.common.Tuple((Object)1, (Object)address, (Object)1);
            }
            boolean result = address.isInRange(row, column);
            if (!result) continue;
            return new kd.epm.far.common.common.Tuple((Object)0, (Object)address, (Object)1);
        }
        return new kd.epm.far.common.common.Tuple((Object)-1, null, (Object)1);
    }

    private ParagraphAlignment getAlignment(CellType cellType, HorizontalAlignment horizontalAlignment) {
        ParagraphAlignment alignment = ParagraphAlignment.LEFT;
        switch (horizontalAlignment) {
            case CENTER: 
            case CENTER_SELECTION: {
                alignment = ParagraphAlignment.CENTER;
                break;
            }
            case RIGHT: {
                alignment = ParagraphAlignment.RIGHT;
                break;
            }
            case JUSTIFY: 
            case FILL: {
                alignment = ParagraphAlignment.BOTH;
                break;
            }
            case DISTRIBUTED: {
                alignment = ParagraphAlignment.DISTRIBUTE;
                break;
            }
            case GENERAL: {
                if (!cellType.equals((Object)CellType.NUMERIC)) break;
                alignment = ParagraphAlignment.RIGHT;
            }
        }
        return alignment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XSSFSheet getXssSheet(byte[] exceldata) {
        if (exceldata == null) {
            return null;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(exceldata);){
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)in);
            XSSFSheet xSSFSheet = workbook.getSheetAt(0);
            return xSSFSheet;
        }
        catch (Exception ex) {
            logger.error("dm reportsection read word eroor", (Throwable)ex);
            return null;
        }
    }
}

